"""Add model Allocation

Revision ID: 235757c5bc34
Revises: 9f766facc4ab
Create Date: 2021-01-11 10:23:37.587900

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "235757c5bc34"
down_revision = "9f766facc4ab"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "allocations",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("arm_id", sa.Integer(), nullable=False),
        sa.Column("user_id", sa.String(), nullable=False),
        sa.Column(
            "time_created",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.Column(
            "time_updated",
            sa.DateTime(timezone=True),
            server_default=sa.text("now()"),
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["arm_id"],
            ["arms.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_allocations_id"), "allocations", ["id"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_allocations_id"), table_name="allocations")
    op.drop_table("allocations")
    # ### end Alembic commands ###
