"""First migration

Revision ID: 16bd2982f46e
Revises: 
Create Date: 2020-12-04 12:37:43.821990

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "16bd2982f46e"
down_revision = None
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "experiments",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(length=200), nullable=True),
        sa.Column("is_running", sa.Boolean(), nullable=True),
        sa.Column("description", sa.String(), nullable=True),
        sa.Column("start_date", sa.DateTime(), nullable=True),
        sa.Column("end_date", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_experiments_id"), "experiments", ["id"], unique=False)
    op.create_index(op.f("ix_experiments_name"), "experiments", ["name"], unique=False)
    op.create_table(
        "arms",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(length=150), nullable=True),
        sa.Column("experiment_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(
            ["experiment_id"],
            ["experiments.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index(op.f("ix_arms_id"), "arms", ["id"], unique=False)
    op.create_index(op.f("ix_arms_name"), "arms", ["name"], unique=False)
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f("ix_arms_name"), table_name="arms")
    op.drop_index(op.f("ix_arms_id"), table_name="arms")
    op.drop_table("arms")
    op.drop_index(op.f("ix_experiments_name"), table_name="experiments")
    op.drop_index(op.f("ix_experiments_id"), table_name="experiments")
    op.drop_table("experiments")
    # ### end Alembic commands ###
