"use strict";
const assert_1 = require("@aws-cdk/assert");
const codecommit = require("@aws-cdk/aws-codecommit");
const codepipeline = require("@aws-cdk/aws-codepipeline");
const core_1 = require("@aws-cdk/core");
const cpactions = require("../../lib");
/**
 * A test stack with a half-prepared pipeline ready to add CloudFormation actions to
 */
class TestFixture extends core_1.Stack {
    constructor() {
        super();
        this.pipeline = new codepipeline.Pipeline(this, 'Pipeline');
        this.sourceStage = this.pipeline.addStage({ stageName: 'Source' });
        this.deployStage = this.pipeline.addStage({ stageName: 'Deploy' });
        this.repo = new codecommit.Repository(this, 'MyVeryImportantRepo', {
            repositoryName: 'my-very-important-repo',
        });
        this.sourceOutput = new codepipeline.Artifact('SourceArtifact');
        const source = new cpactions.CodeCommitSourceAction({
            actionName: 'Source',
            output: this.sourceOutput,
            repository: this.repo,
        });
        this.sourceStage.addAction(source);
    }
}
module.exports = {
    'addAction succesfully leads to creation of codepipeline service catalog action with properly formatted TemplateFilePath'(test) {
        // GIVEN
        const stack = new TestFixture();
        // WHEN
        stack.deployStage.addAction(new cpactions.ServiceCatalogDeployAction({
            actionName: 'ServiceCatalogTest',
            templatePath: stack.sourceOutput.atPath('template.yaml'),
            productVersionDescription: 'This is a description of the version.',
            productVersionName: 'VersionName',
            productId: 'prod-xxxxxxxxx',
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CodePipeline::Pipeline', {
            'Stages': [
                { 'Name': 'Source' /* don't care about the rest */ },
                {
                    'Name': 'Deploy',
                    'Actions': [
                        {
                            'ActionTypeId': {
                                'Category': 'Deploy',
                                'Owner': 'AWS',
                                'Provider': 'ServiceCatalog',
                                'Version': '1',
                            },
                            'Configuration': {
                                'TemplateFilePath': 'template.yaml',
                                'ProductVersionDescription': 'This is a description of the version.',
                                'ProductVersionName': 'VersionName',
                                'ProductType': 'CLOUD_FORMATION_TEMPLATE',
                                'ProductId': 'prod-xxxxxxxxx',
                            },
                            'InputArtifacts': [
                                {
                                    'Name': 'SourceArtifact',
                                },
                            ],
                            'Name': 'ServiceCatalogTest',
                        },
                    ],
                },
            ],
        }));
        test.done();
    },
    'deployment without a description works successfully'(test) {
        // GIVEN
        const stack = new TestFixture();
        // WHEN
        stack.deployStage.addAction(new cpactions.ServiceCatalogDeployAction({
            actionName: 'ServiceCatalogTest',
            templatePath: stack.sourceOutput.atPath('template.yaml'),
            productVersionName: 'VersionName',
            productId: 'prod-xxxxxxxxx',
        }));
        // THEN
        assert_1.expect(stack).to(assert_1.haveResourceLike('AWS::CodePipeline::Pipeline', {
            'Stages': [
                { 'Name': 'Source' /* don't care about the rest */ },
                {
                    'Name': 'Deploy',
                    'Actions': [
                        {
                            'ActionTypeId': {
                                'Category': 'Deploy',
                                'Owner': 'AWS',
                                'Provider': 'ServiceCatalog',
                                'Version': '1',
                            },
                            'Configuration': {
                                'TemplateFilePath': 'template.yaml',
                                'ProductVersionName': 'VersionName',
                                'ProductType': 'CLOUD_FORMATION_TEMPLATE',
                                'ProductId': 'prod-xxxxxxxxx',
                            },
                            'InputArtifacts': [
                                {
                                    'Name': 'SourceArtifact',
                                },
                            ],
                            'Name': 'ServiceCatalogTest',
                        },
                    ],
                },
            ],
        }));
        test.done();
    },
};
//# sourceMappingURL=data:application/json;base64,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