"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceCatalogDeployAction = void 0;
const codepipeline = require("@aws-cdk/aws-codepipeline");
const iam = require("@aws-cdk/aws-iam");
const action_1 = require("../action");
/**
 * CodePipeline action to connect to an existing ServiceCatalog product.
 *
 * **Note**: this class is still experimental, and may have breaking changes in the future!
 *
 * @experimental
 */
class ServiceCatalogDeployAction extends action_1.Action {
    constructor(props) {
        super({
            ...props,
            provider: 'ServiceCatalog',
            category: codepipeline.ActionCategory.DEPLOY,
            artifactBounds: {
                minInputs: 1,
                maxInputs: 1,
                minOutputs: 0,
                maxOutputs: 0,
            },
            inputs: [props.templatePath.artifact],
        });
        this.templatePath = props.templatePath.fileName;
        this.productVersionName = props.productVersionName;
        this.productVersionDescription = props.productVersionDescription;
        this.productId = props.productId;
        this.productType = 'CLOUD_FORMATION_TEMPLATE';
    }
    bound(_scope, _stage, options) {
        options.role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('AWSServiceCatalogAdminFullAccess'));
        // Attempt at least privilege; using this alone fails with "invalid template".
        // Should construct ARN: 'arn:aws:catalog:<region>:<accountID>:product/' + this.scProductId
        // options.role.addToPolicy(new PolicyStatement({
        //   resources: ['*'],
        //   actions: ['servicecatalog:UpdateProduct', 'servicecatalog:ListProvisioningArtifacts', 'servicecatalog:CreateProvisioningArtifact'],
        // }));
        // the Action's Role needs to read from the Bucket to get artifacts
        options.bucket.grantRead(options.role);
        return {
            configuration: {
                TemplateFilePath: this.templatePath,
                ProductVersionName: this.productVersionName,
                ProductVersionDescription: this.productVersionDescription,
                ProductType: this.productType,
                ProductId: this.productId,
            },
        };
    }
}
exports.ServiceCatalogDeployAction = ServiceCatalogDeployAction;
//# sourceMappingURL=data:application/json;base64,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