import lambda = require('@aws-cdk/aws-lambda');
import cdk = require('@aws-cdk/core');
/**
 * An SSM document parameter.
 *
 * @stability stable
 */
export interface DocumentParameter {
    /**
     * Allowed values include the following: String, StringList, Boolean, Integer, MapList, and StringMap.
     *
     * To view examples of each type, see https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#top-level-properties-type
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * A description of the parameter.
     *
     * @stability stable
     */
    readonly description: string;
    /**
     * The default value of the parameter or a reference to a parameter in Parameter Store.
     *
     * @stability stable
     */
    readonly default?: any;
    /**
     * Allowed values for the parameter.
     *
     * @stability stable
     */
    readonly allowedValues?: string[];
    /**
     * The regular expression the parameter must match.
     *
     * @stability stable
     */
    readonly allowedPattern?: string;
    /**
     * Used to display either a textfield or a textarea in the AWS console.
     *
     * textfield is a single-line text box. textarea is a multi-line text area
     *
     * @stability stable
     */
    readonly displayType?: string;
    /**
     * The minimum number of items allowed.
     *
     * @stability stable
     */
    readonly minItems?: number;
    /**
     * The maximum number of items allowed.
     *
     * @stability stable
     */
    readonly maxItems?: number;
    /**
     * The minimum number of parameter characters allowed.
     *
     * @stability stable
     */
    readonly minChars?: number;
    /**
     * The maximum number of parameter characters allowed.
     *
     * @stability stable
     */
    readonly maxChars?: number;
}
/**
 * Steps include one or more actions, an optional precondition, a unique name of the action, and inputs (parameters) for those actions.
 *
 * For more information about documents, including information about creating documents and the differences between schema versions, see https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html
 *
 * @stability stable
 */
export interface DocumentMainStep {
    [key: string]: any;
}
/**
 * The content of the SSM document.
 *
 * The syntax of your document is defined by the schema version used to create it.
 *
 * This module only supports schema version 2.2
 *
 * For details see https://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-doc-syntax.html
 *
 * @stability stable
 */
export interface DocumentContent {
    /**
     * The schema version to use.
     *
     * Currently only version 2.2 is supported
     *
     * @stability stable
     */
    readonly schemaVersion: string;
    /**
     * Information you provide to describe the purpose of the document.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * An object that can include multiple steps (plugins).
     *
     * Steps include one or more actions, an optional precondition, a unique name of the action, and inputs (parameters) for those actions.
     *
     * For more information about documents, including information about creating documents and the differences between schema versions, see https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html
     *
     * @stability stable
     */
    readonly mainSteps: DocumentMainStep[];
    /**
     * The parameters the document accepts.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: DocumentParameter;
    };
}
/**
 * Definition of the SSM document.
 *
 * @stability stable
 */
export interface DocumentProps extends cdk.StackProps {
    /**
     * Defines if the default version should be updated to the latest version on document updates.
     *
     * @default true
     * @stability stable
     */
    readonly updateDefaultVersion?: boolean;
    /**
     * Name of the document.
     *
     * The name must be between 3 and 128 characters. Valid characters are a-z, A-Z, 0-9, and _, -, and . only
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Document type based on the service that you want to use.
     *
     * @default Command
     * @stability stable
     */
    readonly documentType?: string;
    /**
     * Types of resources the document can run on.
     *
     * For example, `/AWS::EC2::Instance` or `/` for all resource types
     *
     * @default /
     * @stability stable
     */
    readonly targetType?: string;
    /**
     * Content of the SSM document.
     *
     * Can be passed as string or as object
     *
     * @stability stable
     */
    readonly content: string | DocumentContent;
}
/**
 * An SSM document.
 *
 * @stability stable
 */
export declare class Document extends cdk.Construct implements cdk.ITaggable {
    /**
     * Name of the document.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Resource tags.
     *
     * @stability stable
     */
    readonly tags: cdk.TagManager;
    /**
     * The lambda function that is created.
     *
     * @stability stable
     */
    readonly lambda: lambda.IFunction;
    /**
     * Defines a new SSM document.
     *
     * @stability stable
     */
    constructor(scope: cdk.Construct, id: string, props: DocumentProps);
    private ensureLambda;
    private fixDocumentName;
}
