# Copyright 2016 The TensorFlow Authors. All Rights Reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# ==============================================================================
"""Keras Applications are premade architectures with pre-trained weights."""
# pylint: disable=g-bad-import-order

from keras.applications.densenet import DenseNet121
from keras.applications.densenet import DenseNet169
from keras.applications.densenet import DenseNet201

from keras.applications.efficientnet import EfficientNetB0
from keras.applications.efficientnet import EfficientNetB1
from keras.applications.efficientnet import EfficientNetB2
from keras.applications.efficientnet import EfficientNetB3
from keras.applications.efficientnet import EfficientNetB4
from keras.applications.efficientnet import EfficientNetB5
from keras.applications.efficientnet import EfficientNetB6
from keras.applications.efficientnet import EfficientNetB7

from keras.applications.efficientnet_v2 import EfficientNetV2B0
from keras.applications.efficientnet_v2 import EfficientNetV2B1
from keras.applications.efficientnet_v2 import EfficientNetV2B2
from keras.applications.efficientnet_v2 import EfficientNetV2B3
from keras.applications.efficientnet_v2 import EfficientNetV2L
from keras.applications.efficientnet_v2 import EfficientNetV2M
from keras.applications.efficientnet_v2 import EfficientNetV2S

from keras.applications.inception_resnet_v2 import InceptionResNetV2
from keras.applications.inception_v3 import InceptionV3

from keras.applications.mobilenet import MobileNet
from keras.applications.mobilenet_v2 import MobileNetV2
from keras.applications.mobilenet_v3 import MobileNetV3Small
from keras.applications.mobilenet_v3 import MobileNetV3Large

from keras.applications.nasnet import NASNetLarge
from keras.applications.nasnet import NASNetMobile

from keras.applications.resnet import ResNet50
from keras.applications.resnet import ResNet101
from keras.applications.resnet import ResNet152
from keras.applications.resnet_v2 import ResNet50V2
from keras.applications.resnet_v2 import ResNet101V2
from keras.applications.resnet_v2 import ResNet152V2

from keras.applications.resnet_rs import ResNetRS50
from keras.applications.resnet_rs import ResNetRS101
from keras.applications.resnet_rs import ResNetRS152
from keras.applications.resnet_rs import ResNetRS200
from keras.applications.resnet_rs import ResNetRS270
from keras.applications.resnet_rs import ResNetRS350
from keras.applications.resnet_rs import ResNetRS420

from keras.applications.vgg16 import VGG16
from keras.applications.vgg19 import VGG19

from keras.applications.xception import Xception
