# Generated by Django 3.0.3 on 2021-06-20 19:31
import logging

from django.db import migrations
from core.models import RoleRight, Role
from policy_notification.utils import get_default_notification_data

logger = logging.getLogger(__name__)

defaults = get_default_notification_data()


logger = logging.getLogger(__name__)

ROLE_RIGHT_ID = 131224
ENROLLMENT_OFFICER_ROLE_IS_SYSTEM = 1  # By default right for report is assigned to Manager role
ACCOUNTANT_ROLE_IS_SYSTEM = 4  # By default right for report is assigned to Manager role


def __get_role(system_id) -> Role:
    return Role.objects.get(is_system=system_id, validity_to=None)


def __role_already_exists(system_id):
    sc = RoleRight.objects.filter(role__uuid=__get_role(system_id).uuid, right_id=ROLE_RIGHT_ID)
    return sc.count() > 0


def add_report_role_rights(apps, schema_editor):
    # Users authorised to view report are accountant and enrollment officer
    for role in [ACCOUNTANT_ROLE_IS_SYSTEM, ENROLLMENT_OFFICER_ROLE_IS_SYSTEM]:
        if __role_already_exists(role):
            logger.warning(F"Role right {ROLE_RIGHT_ID} already assigned for role "
                           F"{__get_role(role).name}, skipping")
            continue

        role = Role.objects.get(is_system=role, validity_to=None)
        new_role = RoleRight(
            role=role,
            right_id=ROLE_RIGHT_ID,
            audit_user_id=None,
        )
        new_role.save()


class Migration(migrations.Migration):

    dependencies = [
        ('policy_notification', '0004_add_default_notification_approval')
    ]

    operations = [
        migrations.RunPython(add_report_role_rights, reverse_code=migrations.RunPython.noop)
    ]

