## What's `sciPyFoam`

**sciPyFoam** is a python package for OpenFOAM 2D simulation results visualization. Although paraview, tecplot, ... provide a convenient way to visualize OpenFOAM results and do some post-processing, but Paraview can not generate high quality figures for publication purpose, tecplot sometimes is not so convenient to make figures. So sciPyFoam could help to generate very nice and complex figures. The main logics of sciPyFoam is using python to read native OpenFOAM polyMesh and results files (e.g. points, faces, ..., T, p) and then using VTK to convert polygonal cell data to triangle point data, finally using matplotlib to plot it.

**Here I provide a demo to illustrate how to use it.**

## Install

```bash
pip install sciPyFoam
```

## Example

1. Plot 2D regular mesh generated by blockMesh

```bash
cd example
python plotField.py cases/blockMesh latestTime 
```
![sciPyFoam plot blockMesh](./example/Mesh_blockMesh.jpg)

![sciPyFoam plot blockMesh](./example/T_blockMesh_1.jpg)

2. Plot 2D unstructured mesh generated by Gmsh

```bash
cd example
python plotField.py cases/triMesh latestTime 
```
![sciPyFoam plot blockMesh](./example/Mesh_triMesh.jpg)

![sciPyFoam plot blockMesh](./example/T_triMesh_1.jpg)

3. Plot 2D hybrid mesh generated by Gmsh

```bash
cd example
python plotField.py cases/hybridMesh latestTime 
```
![sciPyFoam plot blockMesh](./example/Mesh_hybridMesh.jpg)

![sciPyFoam plot blockMesh](./example/T_hybridMesh_1.jpg)