"use strict";
var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k, _l;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Service = exports.Secret = exports.GitHubConnection = exports.ConfigurationSourceType = exports.AssetSource = exports.EcrPublicSource = exports.EcrSource = exports.GithubSource = exports.Source = exports.Runtime = exports.Memory = exports.Cpu = exports.ImageRepositoryType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("aws-cdk-lib/aws-iam");
const cdk = require("aws-cdk-lib");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_apprunner_1 = require("aws-cdk-lib/aws-apprunner");
/**
 * The image repository types
 */
var ImageRepositoryType;
(function (ImageRepositoryType) {
    /**
     * Amazon ECR Public
     */
    ImageRepositoryType["ECR_PUBLIC"] = "ECR_PUBLIC";
    /**
     * Amazon ECR
     */
    ImageRepositoryType["ECR"] = "ECR";
})(ImageRepositoryType = exports.ImageRepositoryType || (exports.ImageRepositoryType = {}));
/**
 * The number of CPU units reserved for each instance of your App Runner service.
 *
 */
class Cpu {
    /**
     * Custom CPU unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-cpu
     *
     * @param unit custom CPU unit
     */
    static of(unit) { return new Cpu(unit); }
    /**
     *
     * @param unit The unit of CPU.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
_a = JSII_RTTI_SYMBOL_1;
Cpu[_a] = { fqn: "@aws-cdk/aws-apprunner-alpha.Cpu", version: "2.73.0-alpha.0" };
/**
 * 1 vCPU
 */
Cpu.ONE_VCPU = Cpu.of('1 vCPU');
/**
 * 2 vCPU
 */
Cpu.TWO_VCPU = Cpu.of('2 vCPU');
exports.Cpu = Cpu;
/**
 * The amount of memory reserved for each instance of your App Runner service.
 */
class Memory {
    /**
     * Custom Memory unit
     *
     * @param unit custom Memory unit
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-instanceconfiguration.html#cfn-apprunner-service-instanceconfiguration-memory
     */
    static of(unit) { return new Memory(unit); }
    /**
     *
     * @param unit The unit of memory.
     */
    constructor(unit) {
        this.unit = unit;
    }
}
_b = JSII_RTTI_SYMBOL_1;
Memory[_b] = { fqn: "@aws-cdk/aws-apprunner-alpha.Memory", version: "2.73.0-alpha.0" };
/**
 * 2 GB(for 1 vCPU)
 */
Memory.TWO_GB = Memory.of('2 GB');
/**
 * 3 GB(for 1 vCPU)
 */
Memory.THREE_GB = Memory.of('3 GB');
/**
 * 4 GB(for 1 or 2 vCPU)
 */
Memory.FOUR_GB = Memory.of('4 GB');
exports.Memory = Memory;
/**
 * The code runtimes
 */
class Runtime {
    /**
     * Other runtimes
     *
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apprunner-service-codeconfigurationvalues.html#cfn-apprunner-service-codeconfigurationvalues-runtime for all available runtimes.
     *
     * @param name runtime name
     *
     */
    static of(name) { return new Runtime(name); }
    /**
     *
     * @param name The runtime name.
     */
    constructor(name) {
        this.name = name;
    }
}
_c = JSII_RTTI_SYMBOL_1;
Runtime[_c] = { fqn: "@aws-cdk/aws-apprunner-alpha.Runtime", version: "2.73.0-alpha.0" };
/**
 * CORRETTO 8
 */
Runtime.CORRETTO_8 = Runtime.of('CORRETTO_8');
/**
 * CORRETTO 11
 */
Runtime.CORRETTO_11 = Runtime.of('CORRETTO_11');
/**
 * .NET 6
 */
Runtime.DOTNET_6 = Runtime.of('DOTNET_6');
/**
 * Go 1.18
 */
Runtime.GO_1 = Runtime.of('GO_1');
/**
 * NodeJS 12
 */
Runtime.NODEJS_12 = Runtime.of('NODEJS_12');
/**
 * NodeJS 14
 */
Runtime.NODEJS_14 = Runtime.of('NODEJS_14');
/**
 * NodeJS 16
 */
Runtime.NODEJS_16 = Runtime.of('NODEJS_16');
/**
 * PHP 8.1
 */
Runtime.PHP_81 = Runtime.of('PHP_81');
/**
 * Python 3
 */
Runtime.PYTHON_3 = Runtime.of('PYTHON_3');
/**
 * Ruby 3.1
 */
Runtime.RUBY_31 = Runtime.of('RUBY_31');
exports.Runtime = Runtime;
/**
 * Represents the App Runner service source.
 */
class Source {
    /**
     * Source from the GitHub repository.
     */
    static fromGitHub(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromGitHub);
            }
            throw error;
        }
        return new GithubSource(props);
    }
    /**
     * Source from the ECR repository.
     */
    static fromEcr(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcr);
            }
            throw error;
        }
        return new EcrSource(props);
    }
    /**
     * Source from the ECR Public repository.
     */
    static fromEcrPublic(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromEcrPublic);
            }
            throw error;
        }
        return new EcrPublicSource(props);
    }
    /**
     * Source from local assets.
     */
    static fromAsset(props) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromAsset);
            }
            throw error;
        }
        return new AssetSource(props);
    }
}
_d = JSII_RTTI_SYMBOL_1;
Source[_d] = { fqn: "@aws-cdk/aws-apprunner-alpha.Source", version: "2.73.0-alpha.0" };
exports.Source = Source;
/**
 * Represents the service source from a Github repository.
 */
class GithubSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_GithubRepositoryProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, GithubSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            codeRepository: {
                codeConfiguration: {
                    configurationSource: this.props.configurationSource,
                    configurationValues: this.props.codeConfigurationValues,
                },
                repositoryUrl: this.props.repositoryUrl,
                sourceCodeVersion: {
                    type: 'BRANCH',
                    value: this.props.branch ?? 'main',
                },
                connection: this.props.connection,
            },
        };
    }
}
_e = JSII_RTTI_SYMBOL_1;
GithubSource[_e] = { fqn: "@aws-cdk/aws-apprunner-alpha.GithubSource", version: "2.73.0-alpha.0" };
exports.GithubSource = GithubSource;
/**
 * Represents the service source from ECR.
 */
class EcrSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.repository.repositoryUriForTagOrDigest(this.props.tagOrDigest || this.props.tag || 'latest'),
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.repository,
        };
    }
}
_f = JSII_RTTI_SYMBOL_1;
EcrSource[_f] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrSource", version: "2.73.0-alpha.0" };
exports.EcrSource = EcrSource;
/**
 * Represents the service source from ECR Public.
 */
class EcrPublicSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_EcrPublicProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, EcrPublicSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.imageIdentifier,
                imageRepositoryType: ImageRepositoryType.ECR_PUBLIC,
            },
        };
    }
}
_g = JSII_RTTI_SYMBOL_1;
EcrPublicSource[_g] = { fqn: "@aws-cdk/aws-apprunner-alpha.EcrPublicSource", version: "2.73.0-alpha.0" };
exports.EcrPublicSource = EcrPublicSource;
/**
 * Represents the source from local assets.
 */
class AssetSource extends Source {
    constructor(props) {
        super();
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_AssetProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, AssetSource);
            }
            throw error;
        }
        this.props = props;
    }
    bind(_scope) {
        return {
            imageRepository: {
                imageConfiguration: this.props.imageConfiguration,
                imageIdentifier: this.props.asset.imageUri,
                imageRepositoryType: ImageRepositoryType.ECR,
            },
            ecrRepository: this.props.asset.repository,
        };
    }
}
_h = JSII_RTTI_SYMBOL_1;
AssetSource[_h] = { fqn: "@aws-cdk/aws-apprunner-alpha.AssetSource", version: "2.73.0-alpha.0" };
exports.AssetSource = AssetSource;
/**
 * The source of the App Runner configuration.
 */
var ConfigurationSourceType;
(function (ConfigurationSourceType) {
    /**
     * App Runner reads configuration values from `the apprunner.yaml` file in the source code repository
     * and ignores `configurationValues`.
     */
    ConfigurationSourceType["REPOSITORY"] = "REPOSITORY";
    /**
     * App Runner uses configuration values provided in `configurationValues` and ignores the `apprunner.yaml`
     * file in the source code repository.
     */
    ConfigurationSourceType["API"] = "API";
})(ConfigurationSourceType = exports.ConfigurationSourceType || (exports.ConfigurationSourceType = {}));
/**
 * Represents the App Runner connection that enables the App Runner service to connect
 * to a source repository. It's required for GitHub code repositories.
 */
class GitHubConnection {
    /**
     * Using existing App Runner connection by specifying the connection ARN.
     * @param arn connection ARN
     * @returns Connection
     */
    static fromConnectionArn(arn) {
        return new GitHubConnection(arn);
    }
    constructor(arn) {
        this.connectionArn = arn;
    }
}
_j = JSII_RTTI_SYMBOL_1;
GitHubConnection[_j] = { fqn: "@aws-cdk/aws-apprunner-alpha.GitHubConnection", version: "2.73.0-alpha.0" };
exports.GitHubConnection = GitHubConnection;
/**
 * A secret environment variable.
 */
class Secret {
    /**
     * Creates an environment variable value from a parameter stored in AWS
     * Systems Manager Parameter Store.
     */
    static fromSsmParameter(parameter) {
        return {
            arn: parameter.parameterArn,
            grantRead: grantee => parameter.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManager(secret, field) {
        return {
            arn: field ? `${secret.secretArn}:${field}::` : secret.secretArn,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
    /**
     * Creates a environment variable value from a secret stored in AWS Secrets
     * Manager.
     *
     * @param secret the secret stored in AWS Secrets Manager
     * @param versionInfo the version information to reference the secret
     * @param field the name of the field with the value that you want to set as
     * the environment variable value. Only values in JSON format are supported.
     * If you do not specify a JSON field, then the full content of the secret is
     * used.
     */
    static fromSecretsManagerVersion(secret, versionInfo, field) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_SecretVersionInfo(versionInfo);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromSecretsManagerVersion);
            }
            throw error;
        }
        return {
            arn: `${secret.secretArn}:${field ?? ''}:${versionInfo.versionStage ?? ''}:${versionInfo.versionId ?? ''}`,
            hasField: !!field,
            grantRead: grantee => secret.grantRead(grantee),
        };
    }
}
_k = JSII_RTTI_SYMBOL_1;
Secret[_k] = { fqn: "@aws-cdk/aws-apprunner-alpha.Secret", version: "2.73.0-alpha.0" };
exports.Secret = Secret;
/**
 * The App Runner Service.
 */
class Service extends cdk.Resource {
    /**
     * Import from service name.
     */
    static fromServiceName(scope, id, serviceName) {
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceName = serviceName;
                this.serviceArn = cdk.Stack.of(this).formatArn({
                    resource: 'service',
                    service: 'apprunner',
                    resourceName: serviceName,
                });
            }
        }
        return new Import(scope, id);
    }
    /**
     * Import from service attributes.
     */
    static fromServiceAttributes(scope, id, attrs) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceAttributes(attrs);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.fromServiceAttributes);
            }
            throw error;
        }
        const serviceArn = attrs.serviceArn;
        const serviceName = attrs.serviceName;
        const serviceUrl = attrs.serviceUrl;
        const serviceStatus = attrs.serviceStatus;
        class Import extends cdk.Resource {
            constructor() {
                super(...arguments);
                this.serviceArn = serviceArn;
                this.serviceName = serviceName;
                this.serviceUrl = serviceUrl;
                this.serviceStatus = serviceStatus;
            }
        }
        return new Import(scope, id);
    }
    constructor(scope, id, props) {
        super(scope, id);
        /**
         * Environment variables for this service.
         *
         * @deprecated use environmentVariables.
         */
        this.environment = {};
        /**
         * Environment secrets for this service.
         */
        this.secrets = [];
        /**
         * Environment variables for this service.
         */
        this.variables = [];
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_ServiceProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, Service);
            }
            throw error;
        }
        const source = props.source.bind(this);
        this.source = source;
        this.props = props;
        this.instanceRole = this.props.instanceRole;
        const environmentVariables = this.getEnvironmentVariables();
        const environmentSecrets = this.getEnvironmentSecrets();
        for (const [key, value] of Object.entries(environmentVariables)) {
            this.addEnvironmentVariable(key, value);
        }
        for (const [key, value] of Object.entries(environmentSecrets)) {
            this.addSecret(key, value);
        }
        // generate an IAM role only when ImageRepositoryType is ECR and props.accessRole is undefined
        this.accessRole = (this.source.imageRepository?.imageRepositoryType == ImageRepositoryType.ECR) ?
            this.props.accessRole ?? this.generateDefaultRole() : undefined;
        if (this.source.codeRepository?.codeConfiguration.configurationSource == ConfigurationSourceType.REPOSITORY &&
            this.source.codeRepository?.codeConfiguration.configurationValues) {
            throw new Error('configurationValues cannot be provided if the ConfigurationSource is Repository');
        }
        const resource = new aws_apprunner_1.CfnService(this, 'Resource', {
            instanceConfiguration: {
                cpu: this.props.cpu?.unit,
                memory: this.props.memory?.unit,
                instanceRoleArn: aws_cdk_lib_1.Lazy.string({ produce: () => this.instanceRole?.roleArn }),
            },
            sourceConfiguration: {
                authenticationConfiguration: this.renderAuthenticationConfiguration(),
                autoDeploymentsEnabled: this.props.autoDeploymentsEnabled,
                imageRepository: this.source.imageRepository ?
                    this.renderImageRepository(this.source.imageRepository) :
                    undefined,
                codeRepository: this.source.codeRepository ?
                    this.renderCodeConfiguration(this.source.codeRepository.codeConfiguration.configurationValues) :
                    undefined,
            },
            networkConfiguration: {
                egressConfiguration: {
                    egressType: this.props.vpcConnector ? 'VPC' : 'DEFAULT',
                    vpcConnectorArn: this.props.vpcConnector?.vpcConnectorArn,
                },
            },
        });
        // grant required privileges for the role
        if (this.source.ecrRepository && this.accessRole) {
            this.source.ecrRepository.grantPull(this.accessRole);
        }
        this.serviceArn = resource.attrServiceArn;
        this.serviceId = resource.attrServiceId;
        this.serviceUrl = resource.attrServiceUrl;
        this.serviceStatus = resource.attrStatus;
        this.serviceName = resource.ref;
    }
    /**
     * This method adds an environment variable to the App Runner service.
     */
    addEnvironmentVariable(name, value) {
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new Error(`Environment variable key ${name} with a prefix of AWSAPPRUNNER is not allowed`);
        }
        this.variables.push({ name: name, value: value });
    }
    /**
     * This method adds a secret as environment variable to the App Runner service.
     */
    addSecret(name, secret) {
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apprunner_alpha_Secret(secret);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.addSecret);
            }
            throw error;
        }
        if (name.startsWith('AWSAPPRUNNER')) {
            throw new Error(`Environment secret key ${name} with a prefix of AWSAPPRUNNER is not allowed`);
        }
        if (!this.instanceRole) {
            this.instanceRole = this.createInstanceRole();
        }
        secret.grantRead(this.instanceRole);
        this.secrets.push({ name: name, value: secret.arn });
    }
    /**
     * This method generates an Instance Role. Needed if using secrets and props.instanceRole is undefined
     * @returns iam.IRole
     */
    createInstanceRole() {
        return new iam.Role(this, 'InstanceRole', {
            assumedBy: new iam.ServicePrincipal('tasks.apprunner.amazonaws.com'),
            roleName: cdk.PhysicalName.GENERATE_IF_NEEDED,
        });
    }
    /**
     * This method generates an Access Role only when ImageRepositoryType is ECR and props.accessRole is undefined
     * @returns iam.IRole
     */
    generateDefaultRole() {
        const accessRole = new iam.Role(this, 'AccessRole', {
            assumedBy: new iam.ServicePrincipal('build.apprunner.amazonaws.com'),
        });
        accessRole.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['ecr:GetAuthorizationToken'],
            resources: ['*'],
        }));
        this.accessRole = accessRole;
        return accessRole;
    }
    getEnvironmentSecrets() {
        let secrets = this.source.codeRepository?.codeConfiguration.configurationValues?.environmentSecrets ??
            this.source.imageRepository?.imageConfiguration?.environmentSecrets;
        return secrets || {};
    }
    getEnvironmentVariables() {
        let codeEnv = [
            this.source.codeRepository?.codeConfiguration.configurationValues?.environmentVariables,
            this.source.codeRepository?.codeConfiguration.configurationValues?.environment,
        ];
        let imageEnv = [
            this.source.imageRepository?.imageConfiguration?.environmentVariables,
            this.source.imageRepository?.imageConfiguration?.environment,
        ];
        if (codeEnv.every(el => el !== undefined) || imageEnv.every(el => el !== undefined)) {
            throw new Error([
                'You cannot set both \'environmentVariables\' and \'environment\' properties.',
                'Please only use environmentVariables, as environment is deprecated.',
            ].join(' '));
        }
        return codeEnv.find(el => el !== undefined) || imageEnv.find(el => el !== undefined) || {};
    }
    renderAuthenticationConfiguration() {
        return {
            accessRoleArn: this.accessRole?.roleArn,
            connectionArn: this.source.codeRepository?.connection?.connectionArn,
        };
    }
    renderCodeConfiguration(props) {
        return {
            codeConfiguration: {
                configurationSource: this.source.codeRepository.codeConfiguration.configurationSource,
                // codeConfigurationValues will be ignored if configurationSource is REPOSITORY
                codeConfigurationValues: this.source.codeRepository.codeConfiguration.configurationValues ?
                    this.renderCodeConfigurationValues(props) :
                    undefined,
            },
            repositoryUrl: this.source.codeRepository.repositoryUrl,
            sourceCodeVersion: this.source.codeRepository.sourceCodeVersion,
        };
    }
    renderCodeConfigurationValues(props) {
        return {
            port: props.port,
            buildCommand: props.buildCommand,
            runtime: props.runtime.name,
            runtimeEnvironmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
            runtimeEnvironmentSecrets: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            startCommand: props.startCommand,
        };
    }
    renderEnvironmentVariables() {
        if (this.variables.length > 0) {
            return this.variables;
        }
        else {
            return undefined;
        }
    }
    renderEnvironmentSecrets() {
        if (this.secrets.length > 0 && this.instanceRole) {
            return this.secrets;
        }
        else {
            return undefined;
        }
    }
    renderImageRepository(repo) {
        return Object.assign(repo, {
            imageConfiguration: {
                port: repo.imageConfiguration?.port?.toString(),
                startCommand: repo.imageConfiguration?.startCommand,
                runtimeEnvironmentVariables: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderEnvironmentVariables() }),
                runtimeEnvironmentSecrets: aws_cdk_lib_1.Lazy.any({ produce: () => this.renderEnvironmentSecrets() }),
            },
        });
    }
}
_l = JSII_RTTI_SYMBOL_1;
Service[_l] = { fqn: "@aws-cdk/aws-apprunner-alpha.Service", version: "2.73.0-alpha.0" };
exports.Service = Service;
//# sourceMappingURL=data:application/json;base64,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