"""
A base module with all the core classes and functions.
"""

from returns.pipeline import is_successful
from returns.result import Failure, Result, Success

from .architecture import Architecture
from .environment_definitions import DockerImage, ShellExecution
from .experiment import Experiment, ExperimentExecutionInformation, ExperimentStatus
from .nodes import Node
from .pipeline import Pipeline
from .task import Task, TaskDispatcher
from .types import FlagValues

__all__ = [
    "Experiment",
    "ExperimentStatus",
    "ExperimentExecutionInformation",
    "Pipeline",
    "Task",
    "TaskDispatcher",
    "Result",
    "Success",
    "Failure",
    "is_successful",
    "FlagValues",
    "ShellExecution",
    "DockerImage",
    "Node",
    "Architecture",
]
