# NosTale-Auth
Simple library that lets you generate "magic" value for the NoS0577 login packet

# The packet
New login packet `NoS0577` is used when you login with Gameforge launcher

That's how it looks like:
`"NoS0577 " + SESSION_TOKEN + "  " + INSTALLATION_GUID + " 003662BF" + " " + REGION_CODE + char(0xB) + "0.9.3.3126" + " 0 " + MD5_STR(MD5_FILE("NostaleClientX.exe") + MD5_FILE("NostaleClient.exe"))`

* `NoS0577` - The header of the packet, const value
* `SESSION_TOKEN` - Value generated by this library, after the value there are two spaces in the login packet
* `INSTALLATION_GUID` - Id that is generated during installation, for login purposes it probably may be random, stored in the windows registry under key name `InstallationId` in `SOFTWARE\\WOW6432Node\\Gameforge4d\\TNTClient\\MainApp`
* `003662BF` - Random value converted to HEX
* `REGION_CODE` - GF code of your region - `4` for PL
* `char(0xB)` - Single character with ASCII code `0xB`
* `0.9.3.3114` - Current version of client, may be obtained from the NostaleClientX.exe file version
* `0` - const value
* `MD5_STR(MD5_FILE("NostaleClientX.exe") + MD5_FILE("NostaleClient.exe"))` - MD5 generated from concatenation of MD5 uppercase strings of NostaleClientX.exe and NostaleClient.exe 

# The useless stuff

The client makes some useless stuff (at least - for us) like

1. When you press "Start" The launcher generates mostly like pseudo-random GUID and saves it to the environment variable called `_TNT_SESSION_ID`
2. Launcher launches the client with `gf` parameter
3. Client reads the `_TNT_SESSION_ID` value from the system environment variables, the value is further used to identify the client in the launcher (in case you run multiple NosTale clients)
4. Now the client and the launcher talk over newly created [pipe](https://docs.microsoft.com/en-us/windows/desktop/ipc/pipes) using JSON-RPC protocol.
5. The client queries the launcher using the `_TNT_SESSION_ID` value, the client requests info such as `USERNAME` and `code`, then it translates the `code` into `SESSION_TOKEN` using simple algorithm and sends it along with login packet

# Core part

## Auth

To obtain the token first you need to auth yourself. To do so you need to send `POST` request to `https://spark.gameforge.com/api/v1/auth/sessions`, you send it `only once`.

In the request header you need to specify `TNT-Installation-Id` from the windows registry.
In the body of the request you need to specify `JSON` content:
* `email` - your email
* `locale` - example: `pl_PL`
* `password` - your password

In the response you will get `JSON` content:
* `token` - value that is used later in API requests, it is NOT that one to use in login packet

## Accounts

Since some time you may bind multiple game accounts to your GF account. To handle it you need to make `GET` request to `https://spark.gameforge.com/api/v1/user/accounts`

In the request header you need to specify:
* `TNT-Installation-Id` - value from windows registry
* `User-Agent` - Eg. `Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/72.0.3626.121 Safari/537.36`
* `Authorization` - `Bearer ` + `TOKEN_FROM_AUTH_REQUEST`

In the response you get `JSON` array of all the accounts. Top level keys in the list are `account ids`.

## Almost done

To obtain the right token you need to make `POST` request to `https://spark.gameforge.com/api/v1/auth/thin/codes`
In the request header you need to specify:
* `TNT-Installation-Id` - value from windows registry
* `User-Agent` - Changes over time, eg. `GameforgeClient/2.0.48`
* `Authorization` - `Bearer ` + `TOKEN_FROM_AUTH_REQUEST`

In the request `JSON` body you need to specify:
* `platformGameAccountId` - the id of selected account from previous section

In the response you get `JSON` content with:
* `code` - The value you are looking for 

You may call the `api/v1/auth/thin/codes` multiple times with the auth token obtained from `api/v1/auth/thin/sessions`

## Finally, the SESSION_TOKEN

To use the `code` in login packet you need to convert it to `SESSION_TOKEN`. The conversion is very simple. It changes the `code` into hex string.

Lets say you got `code` equal to `a857263a-3fc1-4c60-ad78-9b6d9a2a0691`, after the conversion it will look like `61383537323633612D336663312D346336302D616437382D396236643961326130363931` because you convert characters from `code` element by element into hexstring, so:
* `a` -> 97 -> 0x61 -> `61`
* `8` -> 56 -> 0x38 -> `38`

and so on, so the string will look like `6138...`
