# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['jupyter_compare_view']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=3.1.2', 'Pillow>=9.1.0', 'ipykernel>=5.0.0', 'ipython>=6.0.0']

setup_kwargs = {
    'name': 'jupyter-compare-view',
    'version': '0.1.1',
    'description': 'Blend Between Multiple Images in JupyterLab.',
    'long_description': '# Jupyter compare_view\n\n<p align="center">\n    <br />\n    <br />\n    <a href="https://mybinder.org/v2/gh/kolibril13/jupyter-splitview/HEAD?labpath=example_notebook.ipynb">\n        <img src="https://mybinder.org/badge_logo.svg" alt="Binder">\n    </a>\n    <a href="https://kolibril13.github.io/jupyter-splitview/">\n        <img src="https://jupyterlite.rtfd.io/en/latest/_static/badge.svg" alt="JupyterLight">\n    </a>\n    <a href="https://github.com/Octoframes/jupyter_compare_view/blob/main/LICENSE">\n        <img src="https://img.shields.io/badge/license-MIT-blue.svg" alt="MIT license" />\n    </a>\n    <br />\n    <br />\n    <i>Blend Between Multiple Images using a cell magic in JupyterLab.</i>\n</p>\n<hr />\n\n## Installation\n```py\npip install jupyter_compare_view\n```\n## Example\n```py\nimport jupyter_compare_view\n```\n\n```py\n%%splity\nfrom skimage import data\nfrom skimage.color import rgb2gray\nimport matplotlib.pyplot as plt\n\nimg = data.chelsea()\ngrayscale_img = rgb2gray(img)\n\nfig, ax1 = plt.subplots()\nax1.axis("off")\nax1.imshow(img)\n\nfig, ax2 = plt.subplots()\nax2.axis("off")\nax2.imshow(grayscale_img, cmap="gray")\n```\n\n<img src="https://user-images.githubusercontent.com/44469195/175052654-c6c06908-746b-4bcb-819f-c81c0e8dd521.png" style="width: 300px;"/>\n\nNote: The split view widget is still responsive after closing and reopening the notebook without running the cell again.\n\nAnother example:\n```py\n%%splity --position 73% --height auto\n\nimport matplotlib.pyplot as plt\nimport numpy as np\n\narray1 = np.full((15, 30), 10)\narray2 = np.random.randint(0, 10, size=(15, 30))\nfig, ax1 = plt.subplots(figsize=(5, 10))\nax1.imshow(array1)\nfig, ax2 = plt.subplots(figsize=(5, 10))\nax2.imshow(array2)\n```\n<img src="https://user-images.githubusercontent.com/44469195/173763087-e76be74b-57e4-4861-ae0a-6c307021b785.png" style="width: 300px;"/>\n\n\n## Notebook arguments\n(Might still change in future)\n* `--config \'{"start_mode": "horizontal"}\'` will init the compare-view in horizontal slider mode.\n* `--config \'{"circle_size": 30}\'`  the circle size is now 30 pixel in circle mode.\n* `--config \'{"show_slider": false}\'` will hide the slider bar.\n* `--config \'{"start_slider_pos": 0.73}\'` will set the slider start position to 73%. \n\n    * *Removed in 0.1.1: `--position 73%` will no longer the slider start position to 73%.*\n* `--config \'{"start_mode": "horizontal","start_slider_pos": 0.73}\'` will both set the start mode to horizontal and set the slider position\n* `--height 220` will set the height to 220 pixel. \n* When `--height`is not provided, the default height of the widget is 300 pixel.\n* `--height auto` will set the height by the value of the first image\'s resolution in vertical direction.\n* The widget\'s width will always be adjusted automatically. \n\n## Notebook formatting\nFormatting with black can be done this way: \n1. `pip install \'black[jupyter]\'`\n2. `black --python-cell-magics splity compare_view_magic.ipynb`\n\n\n## Developer Installation\n\n1. `git clone --recurse https://github.com/Octoframes/jupyter_compare_view`\n(Note: In case that the repo was already cloned e.g. with the GitHub Desktop client, the  GitHub submodule has to be loaded via `git submodule update --init --recursive`)\n2. `poetry install`\n\n## Changelog\n\n## Milestones / Wishlist\n\n* implement tests, find out how to test a magic class\n\n* Idea: Second option without using cell magic:\n```python\nfrom jupyter_compare_view import Splity # (does not yet exist)\nmy_splity = Splity(left_layer=img1, right_layer=img2)\ndisplay(my_splity)\n```\n\n* Make this work also in VSCode notebooks, [see this issue](https://github.com/NUKnightLab/juxtapose/issues/178).\n\n* Some other nice views, like these:\n\nRound Mask:  \n<img src="https://user-images.githubusercontent.com/44469195/175031002-0f94c143-0145-4254-88ec-a8e450faa6af.png" style="width: 300px;"/>\n\nDouble Round Mask, Second one with 50% opacity:  \n<img src="https://user-images.githubusercontent.com/44469195/175031014-81e78b3a-9e74-4d21-b516-2c5a0cc7f869.png" style="width: 300px;"/>\n\nGaussian Mask (no priority):  \n<img src="https://user-images.githubusercontent.com/44469195/175031027-ef5da1f8-9c32-454f-aa1a-40d10eb086d6.png" style="width: 300px;"/>\n\n# 0.1.1\n\n* Drop the [github.com/NUKnightLab/juxtapose](https://github.com/NUKnightLab/juxtapose) backend and replace it with [github.com/Octoframes/compare_view](https://github.com/Octoframes/compare_view).  \n\n* Implement Round Mask\n## 0.1.0\n\n* Update dependencies\n* Update JupyterLite version\n* Fix: in JupyterLite, a figure has to be explicitly called by plt.show()\n* Better installation workflow\n\n## 0.0.8\n\n* Fixing problem with cell id and notebook reloading\n* Experimentally lowering the dependencies to\n`ipython = ">=6.0.0"` and `ipykernel = ">=5.0.0"` so that  jupyterlite will work hopefully.\n\n## 0.0.7\n\n* Rewrite of the import of JavaScript and CSS to make it more robust when closing and opening the notebook\n* First attempt to add a JupyterLite example.\n## 0.0.6 \n\nFix poetry workflow\n\n## 0.0.5 \n\n* Ship the javascript directly with the package, so no internet connection is required\n* use jinja2 to save HTML in separate file\n* load stylesheet and javascript only once in the beginning, and not in every cell that contains the splitview widget.\n\n## 0.0.4 \n\n* New `--height` parameter\n\n## 0.0.3\n\n* default slider position\n* updated minimal example\n* internal code restructuring and formatting\n* Handle import in non jupyter context\n\n### 0.0.2 \n* save images in base64 strings and don\'t load images to disk (increases package security).\n### 0.0.1\n\n* First release\n\n\n',
    'author': 'Octoframes',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<3.11',
}


setup(**setup_kwargs)
