# Generated by Django 1.11.17 on 2019-01-03 21:15
from django.db import migrations, models
import django.db.models.deletion
import misago.themes.uploadto
import mptt.fields


class Migration(migrations.Migration):
    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Css",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                ("url", models.URLField(blank=True, max_length=255, null=True)),
                (
                    "source_file",
                    models.FileField(
                        blank=True,
                        max_length=255,
                        null=True,
                        upload_to=misago.themes.uploadto.upload_source_css_to,
                    ),
                ),
                ("source_hash", models.CharField(blank=True, max_length=8, null=True)),
                ("source_needs_building", models.BooleanField(default=False)),
                (
                    "build_file",
                    models.FileField(
                        blank=True,
                        max_length=255,
                        null=True,
                        upload_to=misago.themes.uploadto.upload_build_css_to,
                    ),
                ),
                ("build_hash", models.CharField(blank=True, max_length=8, null=True)),
                ("size", models.PositiveIntegerField(default=0)),
                ("order", models.IntegerField(default=0)),
                ("modified_on", models.DateTimeField(auto_now=True)),
            ],
            options={"ordering": ["order"]},
        ),
        migrations.CreateModel(
            name="Media",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "file",
                    models.ImageField(
                        max_length=255, upload_to=misago.themes.uploadto.upload_media_to
                    ),
                ),
                ("hash", models.CharField(max_length=8)),
                ("type", models.CharField(max_length=255)),
                ("width", models.PositiveIntegerField(default=0)),
                ("height", models.PositiveIntegerField(default=0)),
                ("size", models.PositiveIntegerField()),
                (
                    "thumbnail",
                    models.ImageField(
                        blank=True,
                        max_length=255,
                        null=True,
                        upload_to=misago.themes.uploadto.upload_media_thumbnail_to,
                    ),
                ),
                ("modified_on", models.DateTimeField(auto_now=True)),
            ],
            options={"ordering": ["name"]},
        ),
        migrations.CreateModel(
            name="Theme",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255)),
                (
                    "dirname",
                    models.CharField(
                        default=misago.themes.uploadto.generate_theme_dirname,
                        max_length=8,
                    ),
                ),
                ("is_default", models.BooleanField(default=False)),
                ("is_active", models.BooleanField(default=False)),
                ("version", models.CharField(blank=True, max_length=255, null=True)),
                ("author", models.CharField(blank=True, max_length=255, null=True)),
                ("url", models.URLField(blank=True, max_length=255, null=True)),
                ("lft", models.PositiveIntegerField(db_index=True, editable=False)),
                ("rght", models.PositiveIntegerField(db_index=True, editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(db_index=True, editable=False)),
                (
                    "parent",
                    mptt.fields.TreeForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="children",
                        to="misago_themes.Theme",
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.AddField(
            model_name="media",
            name="theme",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="media",
                to="misago_themes.Theme",
            ),
        ),
        migrations.AddField(
            model_name="css",
            name="theme",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="css",
                to="misago_themes.Theme",
            ),
        ),
    ]
