# Generated by Django 2.2.1 on 2019-05-19 00:16

from django.db import migrations

from ..hydrators import dehydrate_value

settings = [
    {
        "setting": "enable_sso",
        "python_type": "bool",
        "wet_value": False,
        "is_public": True,
    },
    {"setting": "sso_public_key", "is_public": False},
    {"setting": "sso_private_key", "is_public": False},
    {"setting": "sso_url", "is_public": False},
]


def create_settings(apps, _):
    Setting = apps.get_model("misago_conf", "Setting")
    for setting in settings:
        data = setting.copy()
        if "python_type" in data and "wet_value" in data:
            data["dry_value"] = dehydrate_value(
                data["python_type"], data.pop("wet_value")
            )

        Setting.objects.create(**data)


class Migration(migrations.Migration):
    dependencies = [("misago_conf", "0004_create_settings")]

    operations = [migrations.RunPython(create_settings)]
