"""empty message

Revision ID: roc_dingo_0024_add_invalidpacketlog
Revises: roc_dingo_0023_add_hfrtimelog
Create Date: 2022-06-23 08:00:55.957574

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

from poppy.pop.alembic.helpers import \
    create_table, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0024_add_invalidpacketlog'
down_revision = 'roc_dingo_0023_add_hfrtimelog'
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    create_table('invalid_packet_log',
    sa.Column('id', sa.BIGINT(), nullable=False),
    sa.Column('sha', sa.String(), nullable=False),
     sa.Column('apid', sa.SMALLINT(), nullable=True),
     sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=True),
     sa.Column('srdb_id', sa.String(length=16), nullable=True),
     sa.Column('palisade_id', sa.String(length=256), nullable=True),
    sa.Column('data', postgresql.JSONB(astext_type=sa.Text()), nullable=True),
    sa.Column('status', sa.SMALLINT(), nullable=False),
    sa.Column('comment', sa.String(), nullable=True),
    sa.Column('insert_time', postgresql.TIMESTAMP(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('sha'),
    schema='pipeline'
    )
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('invalid_packet_log', schema='pipeline')
    # ### end Alembic commands ###
