# -*- coding: utf-8 -*-
"""empty message

Revision ID: roc_dingo_0001_initial
Revises: poppy_pop_0001_initial
Create Date: 2020-02-10 13:59:42.454002

"""
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql
from alembic import op

from poppy.pop.alembic.helpers import \
    create_table, create_schema, execute, user, drop_table

# revision identifiers, used by Alembic.
revision = 'roc_dingo_0001_initial'
down_revision = None
branch_labels = None
depends_on = 'poppy_pop_0002_version_num'


def upgrade():

    create_schema('pipeline')  # added by hand

    ## delete the types if they exist
    execute('DROP TYPE IF EXISTS file_state_type')
    execute('DROP TYPE IF EXISTS file_status_type')

    # ### commands auto generated by Alembic - please adjust! ###
    create_table(
        'file_log',
        sa.Column('id_file_log', sa.BIGINT(), nullable=False),
        sa.Column('file_sha', sa.String(length=64), nullable=True),
        sa.Column('file_id', sa.String(length=48), nullable=False),
        sa.Column('file_basename', sa.String(length=512), nullable=False),
        sa.Column('file_version', sa.String(length=16), nullable=False),
        sa.Column(
            'file_state',
            postgresql.ENUM('OK', 'WARNING', 'ERROR',
                            name='file_state_type'),
            nullable=False),
        sa.Column(
            'file_status',
            postgresql.ENUM(
                'Pended', 'Terminated', 'InProgress', 'Locked', 'Failed',
                name='file_status_type'),
            nullable=False),
        sa.Column('file_creation_date', postgresql.TIMESTAMP(), nullable=True),
        sa.Column('file_insert_date', postgresql.TIMESTAMP(), nullable=True),
        sa.Column('file_descr', sa.String(length=512), nullable=True),
        sa.Column('file_name', sa.String(length=512), nullable=True),
        sa.Column('file_author', sa.String(length=512), nullable=True),
        sa.Column('file_dir', sa.String(length=512), nullable=True),
        sa.Column('file_url', sa.String(length=512), nullable=True),
        sa.Column('file_size', sa.BIGINT(), nullable=True),
        sa.Column('file_level', sa.String(length=8), nullable=True),
        sa.Column('file_date', sa.DATE(), nullable=True),
        sa.Column('file_starttime', postgresql.TIMESTAMP(), nullable=False),
        sa.Column('file_endtime', postgresql.TIMESTAMP(), nullable=False),
        sa.Column('file_dataset_id', sa.String(length=512), nullable=True),
        sa.Column('is_archived', sa.BOOLEAN(), nullable=False),
        sa.Column('is_test', sa.BOOLEAN(), nullable=False),
        sa.Column('file_parents', sa.String(length=512), nullable=True),
        sa.PrimaryKeyConstraint('id_file_log'),
        sa.UniqueConstraint('file_basename'),
        schema='pipeline'
    )
    create_table(
        'packet_log',
        sa.Column('id_packet_log', sa.BIGINT(), nullable=False),
        sa.Column('length', sa.SMALLINT(), nullable=False),
        sa.Column('type', sa.String(length=8), nullable=False),
        sa.Column('category', sa.String(length=512), nullable=False),
        sa.Column('apid', sa.SMALLINT(), nullable=True),
        sa.Column('sync_flag', sa.BOOLEAN(), nullable=True),
        sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=False),
        sa.Column('srdb_id', sa.String(length=16), nullable=False),
        sa.Column('palisade_id', sa.String(length=256), nullable=False),
        sa.Column('binary', sa.String(), nullable=False),
        sa.Column('sha', sa.String(), nullable=True),
        sa.Column('idb_version', sa.String(length=128), nullable=True),
        sa.Column('idb_source', sa.String(length=128), nullable=True),
        sa.Column('creation_time', sa.String(length=1024), nullable=True),
        sa.Column('ack_exe_state', sa.String(length=16), nullable=True),
        sa.Column('ack_acc_state', sa.String(length=16), nullable=True),
        sa.Column('sequence_name', sa.String(length=16), nullable=True),
        sa.Column('unique_id', sa.String(length=256), nullable=True),
        sa.Column('insertion_time', postgresql.TIMESTAMP(), nullable=False),
        sa.PrimaryKeyConstraint('id_packet_log'),
        sa.UniqueConstraint('utc_time', 'srdb_id'),
        schema='pipeline'
    )
    create_table(
        'invalid_packet_log',
        sa.Column('id_invalid_packet_log', sa.BIGINT(), nullable=False),
        sa.Column('binary', sa.String(), nullable=False),
        sa.Column('insertion_time', postgresql.TIMESTAMP(), nullable=False),
        sa.Column('apid', sa.SMALLINT(), nullable=True),
        sa.Column('srdb_id', sa.String(length=16), nullable=True),
        sa.Column('sha', sa.String(), nullable=True),
        sa.Column('utc_time', postgresql.TIMESTAMP(), nullable=True),
        sa.Column('idb_version', sa.String(length=128), nullable=True),
        sa.Column('idb_source', sa.String(length=128), nullable=True),
        sa.Column('comment', sa.String(), nullable=True),
        sa.PrimaryKeyConstraint('id_invalid_packet_log'),
        sa.UniqueConstraint('binary'),
        schema='pipeline'
    )
    # ### end Alembic commands ###

    # added by hand
    # fix table permissions
    grant_user_seq = (
        """GRANT USAGE, SELECT
        ON ALL SEQUENCES IN SCHEMA pipeline TO {0}""".format(user)
    )
    execute(grant_user_seq)


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    drop_table('packet_log', schema='pipeline')
    drop_table('file_log', schema='pipeline')
    drop_table('invalid_packet_log', schema='pipeline')
    # ### end Alembic commands ###

    ## delete the types if they exist
    execute('DROP TYPE IF EXISTS file_state_type')
    execute('DROP TYPE IF EXISTS file_status_type')

    # Delete pipeline schema
    execute('DROP SCHEMA pipeline')

