<p align="center">
  <a href="https://obsidion-dev.com.com">
    <img alt="Obsidion-dev" src="https://discord.obsidion-dev.com/img/Bot%20Profile.png" width="60" />
  </a>
</p>
<h1 align="center">
  Aiomcstats
</h1>

<h3 align="center">
  Get information about minecraft servers.
</h3>
<p align="center">
  Asyncpixel is an open source asyncronous python wrapper for the hypixel api with 100% of all endpoints.
</p>

<h3 align="center">
 🤖 🎨 🚀
</h3>

<p align="center">
  <a href="https://github.com/Obsidion-dev/asyncpixel/releases">
    <img alt="GitHub all releases" src="https://img.shields.io/github/downloads/Obsidion-dev/asyncpixel/total">
  </a>
  <a href="https://github.com/Obsidion-dev/asyncpixel/releases">
    <img alt="GitHub release (latest by date)" src="https://img.shields.io/github/v/release/Obsidion-dev/asyncpixel">
  </a>
  <a href="https://github.com/Obsidion-dev/asyncpixel/actions?workflow=Tests">
  <img src="https://github.com/Obsidion-dev/asyncpixel/workflows/Tests/badge.svg" alt="Test status" />
  </a>
  <a href="https://discord.gg/rnAtymZnzH">
    <img alt="Discord" src="https://img.shields.io/discord/695008516590534758">
  </a href="#contributors-">
   <img src="https://img.shields.io/badge/Contributor%20Covenant-v2.0%20adopted-ff69b4.svg" alt="Code of conduct" />
</p>

<h3 align="center">
  <a href="https://asyncpixel.readthedocs.org">Docs</a>
  <span> · </span>
  <a href="https://github.com/Obsidion-dev/asyncpixel/discussions?discussions_q=category%3AIdeas">Feature request</a>
  <span> · </span>
  <a href="https://github.com/Obsidion-dev/asyncpixel/issues">Report a bug</a>
  <span> · </span>
  Support: <a href="https://github.com/Obsidion-dev/asyncpixel/discussions">Discussions</a>
  <span> & </span>
  <a href="https://discord.gg/fWxtKFVmaW">Discord</a>
</h3>

## ✨ Features

- **Asyncronous.** Unlike other libraries Asyncpixel is fully asyncronous. This makes it perfect to use in your next discord bot or powerful website without having to worry about blocking.

- **100% API coverage.** Asyncpixel is currently the only python library with full coverage of the hypixel API meaning that no endpoints are left untouched and outof your reach.

- **Pydantic models.** All models are checked and validated by [Pydantic](https://github.com/samuelcolvin/pydantic) meaning that the data is always in the correct format perfect for you to use.

- **Available on pypi.** Asyncpixel is available on pypi meaning no building from source just use `pip install asyncpixel` to use it in your project.

## 🏁 Getting Started with Asyncpixel

To get started check out the documentation which [lives here](https://asyncpixel.readthedocs.org) and is generously hosted by readthedocs.

### Installation

Use the package manager [pip](https://pip.pypa.io/en/stable/) or your favourite tool to install asyncpixel.

```bash
pip install asyncpixel
```

### Example

```python
import asyncpixel
import asyncio

async def main():
    hypixel = asyncpixel.Hypixel("hypixel_api_key")
    profile = await hypixel.profile("405dcf08b80f4e23b97d943ad93d14fd")
    print(profile)
    await hypixel.close()


asyncio.run(main())
```

## ❗ Code of Conduct

Obsidion-dev is dedicated to providing a welcoming, diverse, and harrassment-free experience for everyone. We expect everyone in the Obsidion-dev community to abide by our [**Code of Conduct**](https://github.com/Obsidion-dev/asyncpixel/blob/master/CODE_OF_CONDUCT.rst). Please read it.

## 🙌 Contributing to Asyncpixel

From opening a bug report to creating a pull request: every contribution is appreciated and welcomed. If you're planning to implement a new feature or change the library please create an issue first. This way we can ensure your work is not in vain.

### Not Sure Where to Start?

A good place to start contributing, are the [Good first issues](https://github.com/Obsidion-dev/asyncpixel/labels/good%20first%20issue).

## 📝 License

Asyncpixel is open-source. The library is licensed [GPL v3](https://www.gnu.org/licenses/gpl-3.0.en.html).

## 💬 Get in touch

If you have a question or would like to talk with other Asyncpixel users, please hop over to [Github discussions](https://github.com/Obsidion-dev/asyncpixel/discussions) or join our Discord server:

[Discord chatroom](https://discord.gg/rnAtymZnzH)

![Discord Shield](https://discordapp.com/api/guilds/695008516590534758/widget.png?style=shield)

## Contributors ✨

Thanks goes to these wonderful people ([emoji key](https://allcontributors.org/docs/en/emoji-key)):

<!-- ALL-CONTRIBUTORS-LIST:START - Do not remove or modify this section -->
<!-- prettier-ignore-start -->
<!-- markdownlint-disable -->
<table>
  <tr>
    <td align="center"><a href="https://quirky.codes/"><img src="https://avatars2.githubusercontent.com/u/35202521?v=4?s=100" width="100px;" alt=""/><br /><sub><b>AjayACST</b></sub></a><br /><a href="#maintenance-AjayACST" title="Maintenance">🚧</a></td>
    <td align="center"><a href="https://github.com/aiexz"><img src="https://avatars3.githubusercontent.com/u/42418433?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Alex</b></sub></a><br /><a href="https://github.com/Obsidion-dev/asyncpixel/commits?author=aiexz" title="Code">💻</a> <a href="https://github.com/Obsidion-dev/asyncpixel/issues?q=author%3Aaiexz" title="Bug reports">🐛</a></td>
    <td align="center"><a href="https://github.com/magicaltoast"><img src="https://avatars.githubusercontent.com/u/68669235?v=4?s=100" width="100px;" alt=""/><br /><sub><b>Damian Grzanka</b></sub></a><br /><a href="https://github.com/Obsidion-dev/asyncpixel/commits?author=magicaltoast" title="Code">💻</a></td>
  </tr>
</table>

<!-- markdownlint-restore -->
<!-- prettier-ignore-end -->

<!-- ALL-CONTRIBUTORS-LIST:END -->

This project follows the [all-contributors](https://github.com/all-contributors/all-contributors) specification. Contributions of any kind welcome!
