# Wacky

Wacca DataTable files loading + dumping lib

Specifically geared towards files :

- created by / for UE 4.19
- split in `.uasset` + `.uexp` pairs
- only containing DataTable exports

## Installing

```shell-session
pip install wacky
```

## Unpacking and Repacking

### Unpacking

```shell-session
$ wacky unpack [OPTIONS] UASSET UEXP
```

This converts the useful data inside `UASSET` and `UEXP` to a yaml (or json) file you can edit and then use to repack

Options:
  - `--json` : Output json instead of yaml
  - `-o FILENAME`, `--output FILENAME` : Output to a specific file (instead of to stdout)
  - `--help`: Show a help message and exit.

### Modifying

Just use a text editor to change the file you've created with the previous command

### Repacking

```shell-session
$ wacky repack [OPTIONS] SRC_UASSET SRC_UEXP NEW_DATA DST_UASSET DST_UEXP
```

This creates new modified `.uasset` and `.uexp` files by using `SRC_UASSET` and `SRC_UEXP` as templates and applying the changes specified by `NEW_DATA`

Options:
  - `--help`: Show a help message and exit.

## Using the default loader and dumper

```python
>>> from wacky import load, dump
>>> package = load(uasset=Path(...), uexp=Path(...))
>>> ... # Do stuff with `package`
>>> dump(package, uasset=Path(...), uexp=Path(...))
```

## Using the loader based on pyUE4parse

Only does loading, no dumping.

```python
>>> from wacky.load_with_pyUE4Parse import load
>>> load(uasset=Path(...), uexp=Path(...))
[{...}]
```


## Folder Contents

| File / Folder | Description |
|---------------|-------------|
| src/ | Sources |
| tests/ | unit tests, with example `.uasset` and `.uexp` files |
| utils/ | Things worth keeping around |
| .gitignore | list of file patterns git ignores |
| poetry.lock | Precise info about every dependency or sub-dependency, generated by [poetry](https://python-poetry.org/), don't modify yourself |
| pyproject.toml | Projet description file, mostly managed by [poetry](https://python-poetry.org/) |
| README.md | The file you are reading right now |
| UE4.ksy | Definition of the .uasset + .uexp file structure using [Kaitai Struct](https://kaitai.io/), for documentation and preservation purposes |