# -*- coding: utf-8 -*-
# Generated by Django 1.9 on 2017-05-08 23:42
from __future__ import unicode_literals

import django.db.models.deletion
import django.utils.timezone
from django.db import migrations
from django.db import models

import morango.models.fields.crypto
import morango.models.fields.uuids


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Buffer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("serialized", models.TextField(blank=True)),
                ("deleted", models.BooleanField(default=False)),
                ("last_saved_instance", models.UUIDField()),
                ("last_saved_counter", models.IntegerField()),
                ("model_name", models.CharField(max_length=40)),
                ("profile", models.CharField(max_length=40)),
                ("partition", models.TextField()),
                ("model_uuid", morango.models.fields.uuids.UUIDField()),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="Certificate",
            fields=[
                (
                    "id",
                    morango.models.fields.uuids.UUIDField(primary_key=True, serialize=False),
                ),
                ("profile", models.CharField(max_length=20)),
                ("scope_version", models.IntegerField()),
                ("scope_params", models.TextField()),
                ("public_key", morango.models.fields.crypto.PublicKeyField()),
                ("serialized", models.TextField()),
                ("signature", models.TextField()),
                ("private_key", morango.models.fields.crypto.PrivateKeyField(blank=True, null=True)),
                ("lft", models.PositiveIntegerField(db_index=True, editable=False)),
                ("rght", models.PositiveIntegerField(db_index=True, editable=False)),
                ("tree_id", models.PositiveIntegerField(db_index=True, editable=False)),
                ("level", models.PositiveIntegerField(db_index=True, editable=False)),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="morango.Certificate",
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="CertificateModel",
            fields=[
                (
                    "signature",
                    models.CharField(max_length=64, primary_key=True, serialize=False),
                ),
                ("certificate", models.TextField()),
                (
                    "issuer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="morango.CertificateModel",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="DatabaseIDModel",
            fields=[
                (
                    "id",
                    morango.models.fields.uuids.UUIDField(primary_key=True, serialize=False),
                ),
                ("current", models.BooleanField(default=True)),
                (
                    "date_generated",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("initial_instance_id", models.CharField(blank=True, max_length=32)),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="DatabaseMaxCounter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("instance_id", morango.models.fields.uuids.UUIDField()),
                ("counter", models.IntegerField()),
                ("filter", models.TextField()),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="DeletedModels",
            fields=[
                (
                    "id",
                    morango.models.fields.uuids.UUIDField(primary_key=True, serialize=False),
                ),
                ("profile", models.CharField(max_length=40)),
            ],
        ),
        migrations.CreateModel(
            name="InstanceIDModel",
            fields=[
                (
                    "id",
                    morango.models.fields.uuids.UUIDField(primary_key=True, serialize=False),
                ),
                ("platform", models.TextField()),
                ("hostname", models.TextField()),
                ("sysversion", models.TextField()),
                ("macaddress", models.CharField(blank=True, max_length=20)),
                ("counter", models.IntegerField(default=0)),
                ("current", models.BooleanField(default=True)),
                ("db_path", models.CharField(max_length=1000)),
                (
                    "database",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="morango.DatabaseIDModel",
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="RecordMaxCounter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("instance_id", morango.models.fields.uuids.UUIDField()),
                ("counter", models.IntegerField()),
            ],
        ),
        migrations.CreateModel(
            name="RecordMaxCounterBuffer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("instance_id", morango.models.fields.uuids.UUIDField()),
                ("counter", models.IntegerField()),
                ("model_uuid", morango.models.fields.uuids.UUIDField()),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="ScopeDefinition",
            fields=[
                ("profile", models.CharField(max_length=20)),
                ("version", models.IntegerField()),
                (
                    "scope_id",
                    models.CharField(max_length=20, primary_key=True, serialize=False),
                ),
                ("description", models.TextField()),
                ("read_scope_def", models.TextField()),
                ("write_scope_def", models.TextField()),
                ("read_write_scope_def", models.TextField()),
                ("serialized", models.TextField()),
                ("signature", models.TextField()),
            ],
        ),
        migrations.CreateModel(
            name="Store",
            fields=[
                ("serialized", models.TextField(blank=True)),
                ("deleted", models.BooleanField(default=False)),
                ("last_saved_instance", models.UUIDField()),
                ("last_saved_counter", models.IntegerField()),
                ("model_name", models.CharField(max_length=40)),
                ("profile", models.CharField(max_length=40)),
                ("partition", models.TextField()),
                (
                    "id",
                    morango.models.fields.uuids.UUIDField(primary_key=True, serialize=False),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="SyncSession",
            fields=[
                ("id", models.UUIDField(primary_key=True, serialize=False)),
                (
                    "start_timestamp",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("last_activity_timestamp", models.DateTimeField(blank=True)),
                ("local_scope", models.TextField()),
                ("remote_scope", models.TextField()),
                ("host", models.CharField(max_length=255)),
            ],
        ),
        migrations.CreateModel(
            name="TransferSession",
            fields=[
                ("id", models.UUIDField(primary_key=True, serialize=False)),
                ("filter", models.TextField()),
                ("incoming", models.BooleanField()),
                ("active", models.BooleanField(default=True)),
                ("chunksize", models.IntegerField(default=500)),
                ("records_remaining", models.IntegerField()),
                ("records_total", models.IntegerField()),
                (
                    "sync_session",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="morango.SyncSession",
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="TrustedKey",
            fields=[
                (
                    "id",
                    morango.models.fields.uuids.UUIDField(primary_key=True, serialize=False),
                ),
                ("public_key", morango.models.fields.crypto.PublicKeyField()),
                ("notes", models.TextField(blank=True)),
                ("revoked", models.BooleanField(default=False)),
            ],
            options={"abstract": False},
        ),
        migrations.AddField(
            model_name="scopedefinition",
            name="key",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="morango.TrustedKey"
            ),
        ),
        migrations.AddField(
            model_name="recordmaxcounterbuffer",
            name="transfer_session",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="morango.TransferSession",
            ),
        ),
        migrations.AddField(
            model_name="recordmaxcounter",
            name="store_model",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE, to="morango.Store"
            ),
        ),
        migrations.AddField(
            model_name="certificate",
            name="scope_definition",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="morango.ScopeDefinition",
            ),
        ),
        migrations.AddField(
            model_name="buffer",
            name="transfer_session",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="morango.TransferSession",
            ),
        ),
        migrations.AlterUniqueTogether(
            name="recordmaxcounter",
            unique_together=set([("store_model", "instance_id")]),
        ),
    ]
