# coding: utf-8

"""
    EmbedOps API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 1.0.0
    Contact: support@embedops.com
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from embedops_cli.api.api_client import ApiClient


class DefaultApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_ci_run_from_ci(self, body, **kwargs):  # noqa: E501
        """create_ci_run_from_ci  # noqa: E501

        Create a ci run, used by CI processes   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ci_run_from_ci(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIRunCreateProps body: Data to create the CIRun (required)
        :return: CIRun
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_ci_run_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_ci_run_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def create_ci_run_from_ci_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_ci_run_from_ci  # noqa: E501

        Create a ci run, used by CI processes   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_ci_run_from_ci_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIRunCreateProps body: Data to create the CIRun (required)
        :return: CIRun
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_ci_run_from_ci" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_ci_run_from_ci`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApikeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/ci-runs",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CIRun",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_gitlab_access_token_for_org(self, org_id, **kwargs):  # noqa: E501
        """create_gitlab_access_token_for_org  # noqa: E501

        Create a gitlab access token only if one doesn't already exist. Always returns the access token.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_gitlab_access_token_for_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: GitlabAccessToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_gitlab_access_token_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_gitlab_access_token_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
            return data

    def create_gitlab_access_token_for_org_with_http_info(
        self, org_id, **kwargs
    ):  # noqa: E501
        """create_gitlab_access_token_for_org  # noqa: E501

        Create a gitlab access token only if one doesn't already exist. Always returns the access token.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_gitlab_access_token_for_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: GitlabAccessToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_gitlab_access_token_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `create_gitlab_access_token_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/gitlab-token",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="GitlabAccessToken",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_group_for_org(self, body, org_id, **kwargs):  # noqa: E501
        """create_group_for_org  # noqa: E501

        Create a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_group_for_org(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupCreateProps body: Data to create the Group (required)
        :param str org_id: UUID of org (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_group_for_org_with_http_info(
                body, org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_group_for_org_with_http_info(
                body, org_id, **kwargs
            )  # noqa: E501
            return data

    def create_group_for_org_with_http_info(self, body, org_id, **kwargs):  # noqa: E501
        """create_group_for_org  # noqa: E501

        Create a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_group_for_org_with_http_info(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param GroupCreateProps body: Data to create the Group (required)
        :param str org_id: UUID of org (required)
        :return: Group
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_group_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_group_for_org`"
            )  # noqa: E501
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `create_group_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/groups",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Group",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_metric_from_ci(self, body, **kwargs):  # noqa: E501
        """create_metric_from_ci  # noqa: E501

        Create a metric for a cirun, used by CI processes   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_metric_from_ci(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetricCreateProps body: Data to create the CIRun (required)
        :return: Metric
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_metric_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_metric_from_ci_with_http_info(
                body, **kwargs
            )  # noqa: E501
            return data

    def create_metric_from_ci_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_metric_from_ci  # noqa: E501

        Create a metric for a cirun, used by CI processes   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_metric_from_ci_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param MetricCreateProps body: Data to create the CIRun (required)
        :return: Metric
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_metric_from_ci" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_metric_from_ci`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApikeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/metrics",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Metric",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_org(self, body, **kwargs):  # noqa: E501
        """create_org  # noqa: E501

        Creates an Org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_org(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrgCreateProps body: Data to create the Org (required)
        :return: Org
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_org_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.create_org_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def create_org_with_http_info(self, body, **kwargs):  # noqa: E501
        """create_org  # noqa: E501

        Creates an Org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_org_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param OrgCreateProps body: Data to create the Org (required)
        :return: Org
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Org",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_project(self, body, group_id, **kwargs):  # noqa: E501
        """create_project  # noqa: E501

        Add a project to a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectGroupCreateProps body: Data for the project (required)
        :param str group_id: UUID of group (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_project_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_project_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
            return data

    def create_project_with_http_info(self, body, group_id, **kwargs):  # noqa: E501
        """create_project  # noqa: E501

        Add a project to a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_with_http_info(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectGroupCreateProps body: Data for the project (required)
        :param str group_id: UUID of group (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_project`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `create_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/projects",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_project_for_org(self, body, org_id, **kwargs):  # noqa: E501
        """create_project_for_org  # noqa: E501

        Create a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_for_org(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectCreateProps body: Data to create the Project (required)
        :param str org_id: UUID of org (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_project_for_org_with_http_info(
                body, org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_project_for_org_with_http_info(
                body, org_id, **kwargs
            )  # noqa: E501
            return data

    def create_project_for_org_with_http_info(
        self, body, org_id, **kwargs
    ):  # noqa: E501
        """create_project_for_org  # noqa: E501

        Create a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_project_for_org_with_http_info(body, org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectCreateProps body: Data to create the Project (required)
        :param str org_id: UUID of org (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_project_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_project_for_org`"
            )  # noqa: E501
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `create_project_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/projects",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Project",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def create_repo_for_project(self, body, org_id, project_id, **kwargs):  # noqa: E501
        """create_repo_for_project  # noqa: E501

        Create a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_repo_for_project(body, org_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepoCreateProps body: Data to create the Repo (required)
        :param str org_id: UUID of org (required)
        :param str project_id: UUID of project (required)
        :return: list[CIRun]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.create_repo_for_project_with_http_info(
                body, org_id, project_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.create_repo_for_project_with_http_info(
                body, org_id, project_id, **kwargs
            )  # noqa: E501
            return data

    def create_repo_for_project_with_http_info(
        self, body, org_id, project_id, **kwargs
    ):  # noqa: E501
        """create_repo_for_project  # noqa: E501

        Create a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_repo_for_project_with_http_info(body, org_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RepoCreateProps body: Data to create the Repo (required)
        :param str org_id: UUID of org (required)
        :param str project_id: UUID of project (required)
        :return: list[CIRun]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "org_id", "project_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_repo_for_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `create_repo_for_project`"
            )  # noqa: E501
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `create_repo_for_project`"
            )  # noqa: E501
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `create_repo_for_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/projects/{projectId}/repos",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CIRun]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_project(self, group_id, project_id, **kwargs):  # noqa: E501
        """delete_project  # noqa: E501

        Remove a project from a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project(group_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: UUID of group (required)
        :param str project_id: UUID of project (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_project_with_http_info(
                group_id, project_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_project_with_http_info(
                group_id, project_id, **kwargs
            )  # noqa: E501
            return data

    def delete_project_with_http_info(
        self, group_id, project_id, **kwargs
    ):  # noqa: E501
        """delete_project  # noqa: E501

        Remove a project from a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_project_with_http_info(group_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: UUID of group (required)
        :param str project_id: UUID of project (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["group_id", "project_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `delete_project`"
            )  # noqa: E501
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `delete_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/projects/{projectId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def delete_user(self, group_id, user_id, **kwargs):  # noqa: E501
        """delete_user  # noqa: E501

        Remove a user from a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user(group_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: UUID of group (required)
        :param str user_id: UUID of user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.delete_user_with_http_info(
                group_id, user_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.delete_user_with_http_info(
                group_id, user_id, **kwargs
            )  # noqa: E501
            return data

    def delete_user_with_http_info(self, group_id, user_id, **kwargs):  # noqa: E501
        """delete_user  # noqa: E501

        Remove a user from a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_user_with_http_info(group_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str group_id: UUID of group (required)
        :param str user_id: UUID of user (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["group_id", "user_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_user" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `delete_user`"
            )  # noqa: E501
        # verify the required parameter 'user_id' is set
        if "user_id" not in params or params["user_id"] is None:
            raise ValueError(
                "Missing the required parameter `user_id` when calling `delete_user`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501
        if "user_id" in params:
            path_params["userId"] = params["user_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/users/{userId}",
            "DELETE",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_ci_runs(self, org_id, project_id, repo_id, **kwargs):  # noqa: E501
        """find_ci_runs  # noqa: E501

        Returns all ci runs in an repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ci_runs(org_id, project_id, repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :param str project_id: UUID of project (required)
        :param str repo_id: UUID of repo (required)
        :return: list[CIRun]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_ci_runs_with_http_info(
                org_id, project_id, repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.find_ci_runs_with_http_info(
                org_id, project_id, repo_id, **kwargs
            )  # noqa: E501
            return data

    def find_ci_runs_with_http_info(
        self, org_id, project_id, repo_id, **kwargs
    ):  # noqa: E501
        """find_ci_runs  # noqa: E501

        Returns all ci runs in an repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_ci_runs_with_http_info(org_id, project_id, repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :param str project_id: UUID of project (required)
        :param str repo_id: UUID of repo (required)
        :return: list[CIRun]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id", "project_id", "repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_ci_runs" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `find_ci_runs`"
            )  # noqa: E501
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `find_ci_runs`"
            )  # noqa: E501
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `find_ci_runs`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/projects/{projectId}/repos/{repoId}/ci-runs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[CIRun]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_metrics(self, **kwargs):  # noqa: E501
        """find_metrics  # noqa: E501

        Get metrics matching query   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_metrics(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id:
        :param str project_id:
        :param str repo_id:
        :param str ci_run_type:
        :return: list[MetricResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_metrics_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_metrics_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_metrics_with_http_info(self, **kwargs):  # noqa: E501
        """find_metrics  # noqa: E501

        Get metrics matching query   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_metrics_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id:
        :param str project_id:
        :param str repo_id:
        :param str ci_run_type:
        :return: list[MetricResult]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id", "project_id", "repo_id", "ci_run_type"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_metrics" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []
        if "org_id" in params:
            query_params.append(("orgId", params["org_id"]))  # noqa: E501
        if "project_id" in params:
            query_params.append(("projectId", params["project_id"]))  # noqa: E501
        if "repo_id" in params:
            query_params.append(("repoId", params["repo_id"]))  # noqa: E501
        if "ci_run_type" in params:
            query_params.append(("ciRunType", params["ci_run_type"]))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/metrics",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[MetricResult]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_orgs(self, **kwargs):  # noqa: E501
        """find_orgs  # noqa: E501

        Returns all orgs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_orgs(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Org]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_orgs_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.find_orgs_with_http_info(**kwargs)  # noqa: E501
            return data

    def find_orgs_with_http_info(self, **kwargs):  # noqa: E501
        """find_orgs  # noqa: E501

        Returns all orgs   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_orgs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: list[Org]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_orgs" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[Org]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_projects_in_org(self, org_id, **kwargs):  # noqa: E501
        """find_projects_in_org  # noqa: E501

        Returns all projects in an org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_projects_in_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: list[Project]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_projects_in_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.find_projects_in_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
            return data

    def find_projects_in_org_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """find_projects_in_org  # noqa: E501

        Returns all projects in an org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_projects_in_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: list[Project]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_projects_in_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `find_projects_in_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/projects",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[Project]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def find_repo_api_keys(self, repo_id, **kwargs):  # noqa: E501
        """find_repo_api_keys  # noqa: E501

        Returns all apikeys for the repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_repo_api_keys(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: list[RepoApiKey]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.find_repo_api_keys_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.find_repo_api_keys_with_http_info(
                repo_id, **kwargs
            )  # noqa: E501
            return data

    def find_repo_api_keys_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """find_repo_api_keys  # noqa: E501

        Returns all apikeys for the repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.find_repo_api_keys_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: list[RepoApiKey]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method find_repo_api_keys" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `find_repo_api_keys`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}/api-keys",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[RepoApiKey]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_gitlab_access_token_for_org(self, org_id, **kwargs):  # noqa: E501
        """get_gitlab_access_token_for_org  # noqa: E501

        Returns the gitlab access token for the org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_gitlab_access_token_for_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: GitlabAccessToken
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_gitlab_access_token_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_gitlab_access_token_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
            return data

    def get_gitlab_access_token_for_org_with_http_info(
        self, org_id, **kwargs
    ):  # noqa: E501
        """get_gitlab_access_token_for_org  # noqa: E501

        Returns the gitlab access token for the org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_gitlab_access_token_for_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: GitlabAccessToken
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_gitlab_access_token_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `get_gitlab_access_token_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/gitlab-token",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="GitlabAccessToken",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_groups_for_org(self, org_id, **kwargs):  # noqa: E501
        """get_groups_for_org  # noqa: E501

        Returns all groups for the org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_groups_for_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_groups_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.get_groups_for_org_with_http_info(
                org_id, **kwargs
            )  # noqa: E501
            return data

    def get_groups_for_org_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """get_groups_for_org  # noqa: E501

        Returns all groups for the org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_groups_for_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: list[Group]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_groups_for_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `get_groups_for_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}/groups",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="list[Group]",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_my_user(self, **kwargs):  # noqa: E501
        """get_my_user  # noqa: E501

        Return the user model for the currently authenticated user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_user(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_my_user_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_my_user_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_my_user_with_http_info(self, **kwargs):  # noqa: E501
        """get_my_user  # noqa: E501

        Return the user model for the currently authenticated user   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_my_user_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_my_user" % key
                )
            params[key] = val
        del params["kwargs"]

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/users/myself",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="User",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_org(self, org_id, **kwargs):  # noqa: E501
        """get_org  # noqa: E501

        Returns an Org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_org(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: Org
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_org_with_http_info(org_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_org_with_http_info(org_id, **kwargs)  # noqa: E501
            return data

    def get_org_with_http_info(self, org_id, **kwargs):  # noqa: E501
        """get_org  # noqa: E501

        Returns an Org   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_org_with_http_info(org_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str org_id: UUID of org (required)
        :return: Org
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["org_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'" " to method get_org" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'org_id' is set
        if "org_id" not in params or params["org_id"] is None:
            raise ValueError(
                "Missing the required parameter `org_id` when calling `get_org`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "org_id" in params:
            path_params["orgId"] = params["org_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/orgs/{orgId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Org",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_project(self, project_id, **kwargs):  # noqa: E501
        """get_project  # noqa: E501

        Returns a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: UUID of project (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_project_with_http_info(project_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_project_with_http_info(project_id, **kwargs)  # noqa: E501
            return data

    def get_project_with_http_info(self, project_id, **kwargs):  # noqa: E501
        """get_project  # noqa: E501

        Returns a project   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_project_with_http_info(project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_id: UUID of project (required)
        :return: Project
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["project_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `get_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/projects/{projectId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Project",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def get_repo(self, repo_id, **kwargs):  # noqa: E501
        """get_repo  # noqa: E501

        Returns a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.get_repo_with_http_info(repo_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_repo_with_http_info(repo_id, **kwargs)  # noqa: E501
            return data

    def get_repo_with_http_info(self, repo_id, **kwargs):  # noqa: E501
        """get_repo  # noqa: E501

        Returns a repo   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_repo_with_http_info(repo_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str repo_id: UUID of repo (required)
        :return: Repo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["repo_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_repo" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'repo_id' is set
        if "repo_id" not in params or params["repo_id"] is None:
            raise ValueError(
                "Missing the required parameter `repo_id` when calling `get_repo`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "repo_id" in params:
            path_params["repoId"] = params["repo_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/repos/{repoId}",
            "GET",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="Repo",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def invite_user(self, body, group_id, **kwargs):  # noqa: E501
        """invite_user  # noqa: E501

        Invite a user to a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invite_user(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserGroupInviteProps body: Data for the user (required)
        :param str group_id: UUID of group (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.invite_user_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.invite_user_with_http_info(
                body, group_id, **kwargs
            )  # noqa: E501
            return data

    def invite_user_with_http_info(self, body, group_id, **kwargs):  # noqa: E501
        """invite_user  # noqa: E501

        Invite a user to a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.invite_user_with_http_info(body, group_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserGroupInviteProps body: Data for the user (required)
        :param str group_id: UUID of group (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method invite_user" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `invite_user`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `invite_user`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/invite-user",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="User",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_ci_run_from_ci(self, body, ci_run_id, **kwargs):  # noqa: E501
        """update_ci_run_from_ci  # noqa: E501

        Update a CIRun   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ci_run_from_ci(body, ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIRunUpdateProps body: Data to update the CIRun (required)
        :param str ci_run_id: UUID of ciRun (required)
        :return: CIRun
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_ci_run_from_ci_with_http_info(
                body, ci_run_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_ci_run_from_ci_with_http_info(
                body, ci_run_id, **kwargs
            )  # noqa: E501
            return data

    def update_ci_run_from_ci_with_http_info(
        self, body, ci_run_id, **kwargs
    ):  # noqa: E501
        """update_ci_run_from_ci  # noqa: E501

        Update a CIRun   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_ci_run_from_ci_with_http_info(body, ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param CIRunUpdateProps body: Data to update the CIRun (required)
        :param str ci_run_id: UUID of ciRun (required)
        :return: CIRun
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "ci_run_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_ci_run_from_ci" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_ci_run_from_ci`"
            )  # noqa: E501
        # verify the required parameter 'ci_run_id' is set
        if "ci_run_id" not in params or params["ci_run_id"] is None:
            raise ValueError(
                "Missing the required parameter `ci_run_id` when calling `update_ci_run_from_ci`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ci_run_id" in params:
            path_params["ciRunId"] = params["ci_run_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApikeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/ci-runs/{ciRunId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CIRun",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_project(self, body, group_id, project_id, **kwargs):  # noqa: E501
        """update_project  # noqa: E501

        Edit a projects's permissions in a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project(body, group_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectGroupUpdateProps body: Data for the project (required)
        :param str group_id: UUID of group (required)
        :param str project_id: UUID of project (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_project_with_http_info(
                body, group_id, project_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_project_with_http_info(
                body, group_id, project_id, **kwargs
            )  # noqa: E501
            return data

    def update_project_with_http_info(
        self, body, group_id, project_id, **kwargs
    ):  # noqa: E501
        """update_project  # noqa: E501

        Edit a projects's permissions in a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_project_with_http_info(body, group_id, project_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param ProjectGroupUpdateProps body: Data for the project (required)
        :param str group_id: UUID of group (required)
        :param str project_id: UUID of project (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id", "project_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_project" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_project`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `update_project`"
            )  # noqa: E501
        # verify the required parameter 'project_id' is set
        if "project_id" not in params or params["project_id"] is None:
            raise ValueError(
                "Missing the required parameter `project_id` when calling `update_project`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501
        if "project_id" in params:
            path_params["projectId"] = params["project_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/projects/{projectId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def update_user(self, body, group_id, user_id, **kwargs):  # noqa: E501
        """update_user  # noqa: E501

        Edit a user's permissions in a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user(body, group_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserGroupUpdateProps body: Data for the user (required)
        :param str group_id: UUID of group (required)
        :param str user_id: UUID of user (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.update_user_with_http_info(
                body, group_id, user_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.update_user_with_http_info(
                body, group_id, user_id, **kwargs
            )  # noqa: E501
            return data

    def update_user_with_http_info(
        self, body, group_id, user_id, **kwargs
    ):  # noqa: E501
        """update_user  # noqa: E501

        Edit a user's permissions in a group   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_user_with_http_info(body, group_id, user_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param UserGroupUpdateProps body: Data for the user (required)
        :param str group_id: UUID of group (required)
        :param str user_id: UUID of user (required)
        :return: User
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["body", "group_id", "user_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_user" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'body' is set
        if "body" not in params or params["body"] is None:
            raise ValueError(
                "Missing the required parameter `body` when calling `update_user`"
            )  # noqa: E501
        # verify the required parameter 'group_id' is set
        if "group_id" not in params or params["group_id"] is None:
            raise ValueError(
                "Missing the required parameter `group_id` when calling `update_user`"
            )  # noqa: E501
        # verify the required parameter 'user_id' is set
        if "user_id" not in params or params["user_id"] is None:
            raise ValueError(
                "Missing the required parameter `user_id` when calling `update_user`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "group_id" in params:
            path_params["groupId"] = params["group_id"]  # noqa: E501
        if "user_id" in params:
            path_params["userId"] = params["user_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if "body" in params:
            body_params = params["body"]
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["application/json"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["Auth0Auth"]  # noqa: E501

        return self.api_client.call_api(
            "/groups/{groupId}/users/{userId}",
            "PUT",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="User",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )

    def upload_ci_run_artifact(self, type, data, ci_run_id, **kwargs):  # noqa: E501
        """upload_ci_run_artifact  # noqa: E501

        Upload a file to a ciRun   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ci_run_artifact(type, data, ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str data: (required)
        :param str ci_run_id: UUID of ciRun (required)
        :return: CIRunArtifact
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs["_return_http_data_only"] = True
        if kwargs.get("async_req"):
            return self.upload_ci_run_artifact_with_http_info(
                type, data, ci_run_id, **kwargs
            )  # noqa: E501
        else:
            (data) = self.upload_ci_run_artifact_with_http_info(
                type, data, ci_run_id, **kwargs
            )  # noqa: E501
            return data

    def upload_ci_run_artifact_with_http_info(
        self, type, data, ci_run_id, **kwargs
    ):  # noqa: E501
        """upload_ci_run_artifact  # noqa: E501

        Upload a file to a ciRun   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.upload_ci_run_artifact_with_http_info(type, data, ci_run_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str type: (required)
        :param str data: (required)
        :param str ci_run_id: UUID of ciRun (required)
        :return: CIRunArtifact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ["type", "data", "ci_run_id"]  # noqa: E501
        all_params.append("async_req")
        all_params.append("_return_http_data_only")
        all_params.append("_preload_content")
        all_params.append("_request_timeout")

        params = locals()
        for key, val in six.iteritems(params["kwargs"]):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_ci_run_artifact" % key
                )
            params[key] = val
        del params["kwargs"]
        # verify the required parameter 'type' is set
        if "type" not in params or params["type"] is None:
            raise ValueError(
                "Missing the required parameter `type` when calling `upload_ci_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'data' is set
        if "data" not in params or params["data"] is None:
            raise ValueError(
                "Missing the required parameter `data` when calling `upload_ci_run_artifact`"
            )  # noqa: E501
        # verify the required parameter 'ci_run_id' is set
        if "ci_run_id" not in params or params["ci_run_id"] is None:
            raise ValueError(
                "Missing the required parameter `ci_run_id` when calling `upload_ci_run_artifact`"
            )  # noqa: E501

        collection_formats = {}

        path_params = {}
        if "ci_run_id" in params:
            path_params["ciRunId"] = params["ci_run_id"]  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}
        if "type" in params:
            form_params.append(("type", params["type"]))  # noqa: E501
        if "data" in params:
            local_var_files["data"] = params["data"]  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params["Accept"] = self.api_client.select_header_accept(
            ["application/json"]
        )  # noqa: E501

        # HTTP header `Content-Type`
        header_params[
            "Content-Type"
        ] = self.api_client.select_header_content_type(  # noqa: E501
            ["multipart/form-data"]
        )  # noqa: E501

        # Authentication setting
        auth_settings = ["ApikeyAuth"]  # noqa: E501

        return self.api_client.call_api(
            "/ci/ci-runs/{ciRunId}/artifacts",
            "POST",
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type="CIRunArtifact",  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get("async_req"),
            _return_http_data_only=params.get("_return_http_data_only"),
            _preload_content=params.get("_preload_content", True),
            _request_timeout=params.get("_request_timeout"),
            collection_formats=collection_formats,
        )
