import pathlib
import setuptools
from setuptools import setup

# The directory containing this file
HERE = pathlib.Path(__file__).parent

# The text of the README file
README = (HERE / "README.md").read_text()

setup(name='smsru_sender',
      version='1.0.0',
      url='https://github.com/egorgvo/smsru_sender.git',
      long_description=README,
      description='SMS.RU library',
      long_description_content_type="text/markdown",
      packages=setuptools.find_packages(),
      author="Egor Gvo",
      author_email="work.egvo@ya.ru",
      classifiers=[
          "Development Status :: 3 - Alpha",
          "Programming Language :: Python :: 3.8",
          "Intended Audience :: Developers",
          'Topic :: Software Development',
          "License :: OSI Approved :: MIT License",
          "Operating System :: OS Independent",
      ],
      python_requires='>=3.6',
      zip_safe=False,
      install_requires=[
          "python-dotenv~=0.14.0",
      ])
