"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GitHubResource = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const github_resource_1 = require("../handler/github-resource");
class GitHubResource extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { createRequestEndpoint, createRequestPayload, updateRequestEndpoint, updateRequestPayload, deleteRequestEndpoint, deleteRequestPayload, githubTokenSecret, createRequestResultParameter, writeResponseToSSMParameter, } = props;
        const stack = aws_cdk_lib_1.Stack.of(this);
        const awsRegion = stack.region;
        const shortId = aws_cdk_lib_1.Names.uniqueId(this).slice(-8);
        const handler = new github_resource_1.GithubResourceHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubResourceCustomResourceHandler' + shortId,
            description: 'Handles the creation/deletion of a custom GitHub Resource - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        writeResponseToSSMParameter?.grantWrite(handler);
        const provider = new custom_resources_1.Provider(this, 'Provider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubResourceEventProps = {
            githubTokenSecret: githubTokenSecret.secretArn,
            createRequestEndpoint,
            createRequestPayload,
            createRequestResultParameter,
            updateRequestEndpoint,
            updateRequestPayload,
            deleteRequestEndpoint,
            deleteRequestPayload,
            responseBodySSMParameterName: writeResponseToSSMParameter?.parameterName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubResource',
            properties: githubResourceEventProps,
        });
    }
}
exports.GitHubResource = GitHubResource;
_a = JSII_RTTI_SYMBOL_1;
GitHubResource[_a] = { fqn: "cdk-github.GitHubResource", version: "0.0.33" };
//# sourceMappingURL=data:application/json;base64,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