"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_secrets_1 = require("../handler/secrets/action-secrets");
class ActionSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repositoryName, repositoryOwner, sourceSecret } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const shortId = aws_cdk_lib_1.Names.uniqueId(this).slice(-8);
        const handler = new action_secrets_1.ActionSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionSecretCustomResourceHandler' + shortId,
            description: 'Handles the creation/deletion of a GitHub Action (repository) secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'SecretProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner,
            repositoryName,
            sourceSecretArn: sourceSecret.secretArn,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionSecret = ActionSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionSecret[_a] = { fqn: "cdk-github.ActionSecret", version: "0.0.33" };
//# sourceMappingURL=data:application/json;base64,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