"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionEnvironmentSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_1 = require("aws-cdk-lib/aws-lambda");
const aws_logs_1 = require("aws-cdk-lib/aws-logs");
const custom_resources_1 = require("aws-cdk-lib/custom-resources");
const constructs_1 = require("constructs");
const action_environment_secrets_1 = require("../handler/secrets/action-environment-secrets");
class ActionEnvironmentSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const { githubTokenSecret, repositorySecretName, repositoryName, repositoryOwner, sourceSecret, environment } = props;
        const awsRegion = aws_cdk_lib_1.Stack.of(this).region;
        const shortId = aws_cdk_lib_1.Names.uniqueId(this).slice(-8);
        const handler = new action_environment_secrets_1.ActionEnvironmentSecretHandlerFunction(this, 'CustomResourceHandler', {
            functionName: 'GitHubActionEnvironmentSecretCustomResourceHandler' + shortId,
            description: 'Handles the creation/deletion of a GitHub Action environment secret - created by cdk-github',
            architecture: aws_lambda_1.Architecture.ARM_64,
            timeout: aws_cdk_lib_1.Duration.minutes(10),
        });
        githubTokenSecret.grantRead(handler);
        sourceSecret.grantRead(handler);
        const provider = new custom_resources_1.Provider(this, 'CustomResourceProvider', {
            onEventHandler: handler,
            logRetention: aws_logs_1.RetentionDays.ONE_WEEK,
        });
        const githubRepositorySecretEventProps = {
            environment,
            githubTokenSecret: githubTokenSecret.secretArn,
            repositoryOwner,
            repositoryName,
            sourceSecretArn: sourceSecret.secretArn,
            repositorySecretName,
            awsRegion,
        };
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: provider.serviceToken,
            resourceType: 'Custom::GitHubActionEnvironmentSecret',
            properties: githubRepositorySecretEventProps,
        });
    }
}
exports.ActionEnvironmentSecret = ActionEnvironmentSecret;
_a = JSII_RTTI_SYMBOL_1;
ActionEnvironmentSecret[_a] = { fqn: "cdk-github.ActionEnvironmentSecret", version: "0.0.33" };
//# sourceMappingURL=data:application/json;base64,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