# Contributing 

First off, thanks for taking the time to contribute 🎉

## Reporting Bugs/Feature Requests
Use the GitHub issue tracker to report bugs 🐛 or suggest features ✨.

When filing an issue, please check existing open, or recently closed, issues to make sure somebody else hasn't already
reported the issue. Please try to include as much information as you can. Details like these are incredibly useful:

* A reproducible test case or series of steps
* The version of code being used
* Any modifications you've made relevant to the bug
* Anything unusual about your environment or deployment

## Contributing via Pull Requests
Pull requests are much appreciated 🙌. Before sending a pull request, please ensure that:

1. You are working against the latest source on the *main* branch.
2. You check existing open, and recently merged, pull requests to make sure someone else hasn't addressed the problem already.
3. You open an issue to discuss any significant work - would be a bummer for everyone if your time to be wasted.

To send a pull request, please:

1. Fork the repository.
2. Modify the source; please focus on the specific change you are contributing. If you also reformat all the code, it will be hard to review your change.
3. Ensure local tests pass.
4. Commit to your fork using clear commit messages, this project follows [conventional commits spec](https://www.conventionalcommits.org/en/v1.0.0/) for commit messages.
5. Open up a pull request.
6. Pay attention to any automated CI failures reported in the pull request, and stay involved in the conversation.

GitHub provides additional document on [forking a repository](https://help.github.com/articles/fork-a-repo/) and
[creating a pull request](https://help.github.com/articles/creating-a-pull-request/).