# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['jumpscale',
 'jumpscale.clients._bcdb',
 'jumpscale.clients.currencylayer',
 'jumpscale.clients.digitalocean',
 'jumpscale.clients.explorer',
 'jumpscale.clients.github',
 'jumpscale.clients.gogs',
 'jumpscale.clients.kraken',
 'jumpscale.clients.liquid',
 'jumpscale.clients.mail',
 'jumpscale.clients.s3',
 'jumpscale.clients.sendgrid',
 'jumpscale.clients.stellar',
 'jumpscale.clients.syncthing',
 'jumpscale.clients.taiga',
 'jumpscale.clients.zerotier',
 'jumpscale.core.identity',
 'jumpscale.data.countries',
 'jumpscale.data.treemanager',
 'jumpscale.entry_points',
 'jumpscale.install',
 'jumpscale.packages.admin',
 'jumpscale.packages.admin.actors',
 'jumpscale.packages.auth',
 'jumpscale.packages.auth.bottle',
 'jumpscale.packages.backup',
 'jumpscale.packages.backup.actors',
 'jumpscale.packages.chatflows',
 'jumpscale.packages.chatflows.actors',
 'jumpscale.packages.chatflows.bottle',
 'jumpscale.packages.codeserver',
 'jumpscale.packages.farmmanagement',
 'jumpscale.packages.farmmanagement.actors',
 'jumpscale.packages.kyc',
 'jumpscale.packages.kyc.actors',
 'jumpscale.packages.kyc.bottle',
 'jumpscale.packages.marketplace',
 'jumpscale.packages.marketplace.actors',
 'jumpscale.packages.marketplace.bottle',
 'jumpscale.packages.marketplace.chats',
 'jumpscale.packages.notebooks',
 'jumpscale.packages.polls',
 'jumpscale.packages.polls.bottle',
 'jumpscale.packages.polls.chats',
 'jumpscale.packages.stellar_stats',
 'jumpscale.packages.stellar_stats.bottle',
 'jumpscale.packages.tfgrid_solutions',
 'jumpscale.packages.tfgrid_solutions.actors',
 'jumpscale.packages.tfgrid_solutions.chats',
 'jumpscale.packages.tfgrid_solutions.scripts.threebot',
 'jumpscale.packages.weblibs',
 'jumpscale.sals.chatflows',
 'jumpscale.sals.chatflows.models',
 'jumpscale.sals.marketplace',
 'jumpscale.sals.nginx',
 'jumpscale.sals.reservation_chatflow',
 'jumpscale.sals.zos',
 'jumpscale.servers.threebot',
 'jumpscale.tools.dnstool',
 'jumpscale.tools.imagelib',
 'jumpscale.tools.nginx',
 'jumpscale.tools.poolexecutor',
 'jumpscale.tools.qrcode',
 'jumpscale.tools.redis',
 'jumpscale.tools.restic',
 'jumpscale.tools.tfgateway',
 'jumpscale.tools.wireguard']

package_data = \
{'': ['*'],
 'jumpscale.packages.admin': ['frontend/*',
                              'frontend/assets/*',
                              'frontend/components/alerts/*',
                              'frontend/components/backup/*',
                              'frontend/components/backup/marketplace/*',
                              'frontend/components/backup/minio/*',
                              'frontend/components/base/*',
                              'frontend/components/dashboard/*',
                              'frontend/components/external/*',
                              'frontend/components/logs/*',
                              'frontend/components/packages/*',
                              'frontend/components/settings/*',
                              'frontend/components/solutions/*',
                              'frontend/components/wallets/*',
                              'frontend/components/wikis/*',
                              'frontend/mixins/*'],
 'jumpscale.packages.auth': ['static/css/*', 'static/img/*'],
 'jumpscale.packages.auth.bottle': ['templates/*'],
 'jumpscale.packages.backup': ['frontend/*'],
 'jumpscale.packages.chatflows': ['frontend/*',
                                  'frontend/assets/images/*',
                                  'frontend/components/*',
                                  'frontend/home/css/*',
                                  'frontend/home/img/*',
                                  'frontend/images/*',
                                  'frontend/mixins/*'],
 'jumpscale.packages.farmmanagement': ['frontend/*',
                                       'frontend/App/*',
                                       'frontend/components/nodeinfo/*',
                                       'frontend/components/nodestable/*',
                                       'frontend/config/*',
                                       'frontend/plugins/*',
                                       'frontend/router/*',
                                       'frontend/services/*',
                                       'frontend/store/*',
                                       'frontend/views/farmmanagement/*'],
 'jumpscale.packages.kyc': ['frontend/*'],
 'jumpscale.packages.marketplace': ['frontend/*',
                                    'frontend/assets/*',
                                    'frontend/components/*',
                                    'frontend/components/base/*',
                                    'frontend/components/solutions/*',
                                    'frontend/mixins/*'],
 'jumpscale.packages.polls': ['images/*'],
 'jumpscale.sals.nginx': ['resources/*', 'templates/*'],
 'jumpscale.servers.threebot': ['templates/*']}

install_requires = \
['PyGithub>=1.43,<2.0',
 'beaker>=1.11.0,<2.0.0',
 'certbot-nginx==1.5.0',
 'dnspython>=1.16,<2.0',
 'js-ng==11.0.0-a1',
 'minio>=4.0,<5.0',
 'pillow>=6.1,<7.0',
 'protobuf>=3.12.2,<4.0.0',
 'pycountry>=19.8,<20.0',
 'pypng>=0.0.20,<0.0.21',
 'pyqrcode>=1.2.1,<2.0.0',
 'python-digitalocean>=1.15.0,<2.0.0',
 'python-taiga>=1.0.0,<2.0.0',
 'requests_unixsocket>=0.2.0,<0.3.0',
 'sendgrid>=6.0,<7.0',
 'stellar-sdk==2.4.1']

entry_points = \
{'console_scripts': ['threebot = jumpscale.entry_points.threebot:cli']}

setup_kwargs = {
    'name': 'js-sdk',
    'version': '11.0.0a1.dev3',
    'description': 'SDK for threefold grid',
    'long_description': None,
    'author': 'xmonader',
    'author_email': 'xmonader@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.6,<4.0',
}


setup(**setup_kwargs)
