"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpLambdaIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_iam_1 = require("aws-cdk-lib/aws-iam");
const aws_cdk_lib_1 = require("aws-cdk-lib");
/**
 * The Lambda Proxy integration resource for HTTP API
 */
class HttpLambdaIntegration extends aws_apigatewayv2_alpha_1.HttpRouteIntegration {
    /**
     * @param id id of the underlying integration construct
     * @param handler the Lambda handler to integrate with
     * @param props properties to configure the integration
     */
    constructor(id, handler, props = {}) {
        super(id);
        this.handler = handler;
        this.props = props;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigatewayv2_integrations_alpha_HttpLambdaIntegrationProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, HttpLambdaIntegration);
            }
            throw error;
        }
        this._id = id;
    }
    completeBind(options) {
        const route = options.route;
        this.handler.addPermission(`${this._id}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: aws_cdk_lib_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.apiId,
                resourceName: `*/*${route.path ?? ''}`,
            }),
        });
    }
    bind(_) {
        return {
            type: aws_apigatewayv2_alpha_1.HttpIntegrationType.AWS_PROXY,
            uri: this.handler.functionArn,
            payloadFormatVersion: this.props.payloadFormatVersion ?? aws_apigatewayv2_alpha_1.PayloadFormatVersion.VERSION_2_0,
            parameterMapping: this.props.parameterMapping,
        };
    }
}
exports.HttpLambdaIntegration = HttpLambdaIntegration;
_a = JSII_RTTI_SYMBOL_1;
HttpLambdaIntegration[_a] = { fqn: "@aws-cdk/aws-apigatewayv2-integrations-alpha.HttpLambdaIntegration", version: "2.43.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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