"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExposedSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Exposed secret for log configuration
 */
class ExposedSecret {
    /**
     * Use Secrets Manager Secret
     * @param optionName - The name of the option
     * @param secret - A secret from secrets manager
     */
    static fromSecretsManager(optionName, secret) {
        return new ExposedSecret(optionName, secret.secretArn);
    }
    /**
     * User Parameters Store Parameter
     * @param optionName - The name of the option
     * @param parameter - A parameter from parameters store
     */
    static fromParametersStore(optionName, parameter) {
        return new ExposedSecret(optionName, parameter.parameterArn);
    }
    constructor(optionName, secretArn) {
        this.optionName = optionName;
        this.secretArn = secretArn;
    }
}
_a = JSII_RTTI_SYMBOL_1;
ExposedSecret[_a] = { fqn: "@aws-cdk/aws-batch-alpha.ExposedSecret", version: "2.72.1-alpha.0" };
exports.ExposedSecret = ExposedSecret;
//# sourceMappingURL=data:application/json;base64,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