# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['neural_semigroups']

package_data = \
{'': ['*']}

install_requires = \
['numpy==1.18.1',
 'pandas==1.0.2',
 'pytorch-ignite==0.3.0',
 'sphinx_rtd_theme==0.4.3',
 'tensorboard==2.1.1',
 'torch==1.4.0',
 'tqdm==4.43.0']

setup_kwargs = {
    'name': 'neural-semigroups',
    'version': '0.2.1',
    'description': 'Neural networks powered research of semigroups',
    'long_description': "# Neural Semigroups\n\nHere we try to learn Cayley tables of semigroups using neural\nnetworks. The supposed workflow:\n\n* install the package\n* get the data\n* build a model\n* print a model testing report\n\nMore documentation can be found [here](https://neural-semigroups.readthedocs.io).\n\n## Motivation\n\nThis work was inspired by [a sudoku\nsolver](https://github.com/Kyubyong/sudoku). A solved Sudoku puzzle\nis nothing more than a Cayley table of a quasigroup from 9 items with\nsome well-known additional properties. So, one can imagine a puzzle\nmade from a Cayley table of any other magma, e. g. a semigroup, by\nhiding part of its cells.\n\nThere are two major differences between sudoku and puzzles based on\nsemigroups:\n\n1) it's easy to take a glance on a table to understand whether it is\na sudoku or not. That's why it was possible to encode numbers in a\ntable cells as colour intensities. Sudoku is a picture, and a\nsemigroup is not. It's difficult to check a Cayley table's\nassociativity with a naked eye;\n\n2) sudoku puzzles are solved by humans for fun and thus catalogued.\nWhen solving a sudoku one knows for sure that there is a unique\nsolution. On the contrary, nobody guesses values in a partially\nfilled Cayley table of a semigroup as a form of amuzement. As a\nresult, one can create a puzzle from a full Cayley table of a\nsemigroup but there may be many distinct solutions.\n\n## Package Installation\n\nFirst, get Python 3.8\n\nThen run several commands in a terminal:\n\n```bash\ngit clone git@bitbucket.org:inpefess/neural-semigroups.git\ncd neural-semigroups\npython -m venv venv\nsource ./venv/bin/activate\npip install -U pip poetry\npoetry install\n```\n\nThis could take some time (mostly downloading `torch`).\n\nAfter that you can go to the project's directory and `source\n./venv/bin/activate` to start a virtual environment there.\n\n## Getting Data\n\nThis package uses data included into a `smallsemi` package for GAP\nsystem. One can download it from [the GAP\npage](https://www.gap-system.org/pub/gap/gap4/tar.gz/packages/smallsemi-0.6.11.tar.gz).\n\nYou can get the data by running a script from a `scripts` folder:\n```bash\ncd scripts\n./download_smallsemi.sh\n```\n\n## Training a Model\n\nHere are several examples of commands to train a model depending on\nsemigroup's cardinality:\n\n```bash\npython train_denoising_autoencoder.py --cardinality 4 --epochs 100 \\\n--learning_rate 0.1 --batch_size 32 --train_size 10 --validation_size 10\n```\n```bash\npython train_denoising_autoencoder.py --cardinality 5 --epochs 100 \\\n--learning_rate 0.01 --batch_size 256 --train_size 100 --validation_size 100\n```\n```bash\npython train_denoising_autoencoder.py --cardinality 6 --epochs 100 \\\n--learning_rate 0.001 --batch_size 2048 --train_size 1000 --validation_size 100\n```\n```bash\npython train_denoising_autoencoder.py --cardinality 7 --epochs 100 \\\n--learning_rate 0.001 --batch_size 2048 --train_size 1000 --validation_size 100\n```\n\n## Printing a Testing Report\n\nOne can print a model quality report using the following command:\n\n```bash\npython test_model.py --cardinality 4\n```\n",
    'author': 'Boris Shminke',
    'author_email': 'boris@shminke.ml',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/inpefess/neural-semigroups',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
