# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['nested_rimraf']

package_data = \
{'': ['*']}

install_requires = \
['click-spinner>=0.1.10,<0.2.0', 'typer[all]>=0.4.0,<0.5.0']

entry_points = \
{'console_scripts': ['nested-rimraf = nested_rimraf.main:app']}

setup_kwargs = {
    'name': 'nested-rimraf',
    'version': '1.0.1',
    'description': 'Use it to clear your junk in nested directories Looks for target file/directory through specified tree and then removes everything',
    'long_description': '# `nested-rimraf`\n\nNested rimraf CLI app.\n\nUse it to clear your junk in nested directories\nLooks for target file/directory through specified tree and then removes everything\n\n<a href="https://pypi.org/project/nested-rimraf" target="_blank">\n    <img src="https://img.shields.io/pypi/v/nested-rimraf?color=%2334D058&label=pypi%20package" alt="Package version">\n</a>\n\n## Practice\n\n**Imaginary folder structure:**\n\n```bash\n/subject\n  → /file\n    → /node_modules // file, not directory\n  → /node_modules\n    → /enemy.txt\n  → /sub\n    → /2\n      → /1\n        → /4\n          → /node_modules\n            → /enemy.txt\n    → /3\n      → /node_modules\n        → /enemy.txt\n  → /sub2\n    → /node_modules\n      → /enemy.txt\n  → /symlink\n    → /example\n      → /enemy.txt\n    → /node_modules // symlink to /subject/symlink/example\n```\n\n**Tasks:**\n\n1. Find all `node_modules`\n2. Find and remove all `node_modules`\n3. Find and remove all **directories** named `node_modules`\n4. Find and remove all `node_modules`, but do not remove symlinks\n5. `[Ultimate]` Find all `node_modules`, except files and symlinks, save them to file, correct file and remove the\n   remaining\n\n### 1. Find all `node_modules`\n\nWe need to run `scan` command with `target=node_modules` and `directory=./subject`\n\n```bash\n$> nested-rimraf scan node_modules ./subject\n\nFiles and directories (include symlinks):\n        → subject/node_modules\n        → subject/symlink/node_modules\n        → subject/file/node_modules\n        → subject/sub/node_modules\n        → subject/sub/3/node_modules\n        → subject/sub/2/1/4/node_modules\n        → subject/sub2/node_modules\n\n```\n\n### 2. Find and remove all `node_modules`\n\nAs easy, as previous one. Just use `rm` instead of `scan`\n```bash\n$> nested-rimraf rm node_modules ./subject\n\nFiles and directories (include symlinks):\n        → subject/node_modules\n        → subject/symlink/node_modules\n        → subject/file/node_modules\n        → subject/sub/node_modules\n        → subject/sub/3/node_modules\n        → subject/sub/2/1/4/node_modules\n        → subject/sub2/node_modules\nAre you sure you want to delete it? [y/N]: y\nDone flawlessly!\n```\n\n_Note:_ Question `Are you sure you want to delete it? [y/N]: y` may be avoided with `--agree/-y` option. Like that:\n```bash\n$> nested-rimraf rm -y node_modules ./subject\n\nFiles and directories (include symlinks):\n        → subject/node_modules\n        → subject/symlink/node_modules\n        → subject/file/node_modules\n        → subject/sub/node_modules\n        → subject/sub/3/node_modules\n        → subject/sub/2/1/4/node_modules\n        → subject/sub2/node_modules\nDone flawlessly!\n```\n\n### 3. Find and remove all **directories** named `node_modules`\n\nOk, lets add option `--dir-only/-d`\n\n```bash\n$> nested-rimraf rm -y node_modules ./subject --dir-only \n\nDirectories (include symlinks):\n        → subject/node_modules\n        → subject/symlink/node_modules\n        → subject/sub/node_modules\n        → subject/sub/3/node_modules\n        → subject/sub/2/1/4/node_modules\n        → subject/sub2/node_modules\nDone flawlessly!\n```\n\nAs you can see, there is no `subject/file/node_modules` in the list (because it\'s file, not a directory).\n\nLet\'s run something similar\n\n### 4. Find and remove all `node_modules`, but do not remove symlinks\n\nSame pattern:\n\n```bash\n$> nested-rimraf rm -y node_modules ./subject --without-symlinks\n\nDirectories (include symlinks):\n        → subject/node_modules\n        → subject/file/node_modules\n        → subject/sub/node_modules\n        → subject/sub/3/node_modules\n        → subject/sub/2/1/4/node_modules\n        → subject/sub2/node_modules\nDone flawlessly!\n```\n\nLet\'s try the hardest one, shall we?\n\n### 5. `[Ultimate]` Find all `node_modules`, except files and symlinks, save them to file, correct file and remove the\n   remaining\n\nHuman control, eh?\n\n```bash\n$>  nested-rimraf scan -dsL node_modules ./subject --save-path ./subject/to_correct.txt \nDirectories (exclude symlinks):\n        → subject/node_modules\n        → subject/sub/node_modules\n        → subject/sub/3/node_modules\n        → subject/sub/2/1/4/node_modules\n        → subject/sub2/node_modules\nSuccessfully saved list to "subject/to_correct.txt"\n```\n\nA lot of params:\n- `-d` - same as `--dir-only`. Includes only directories\n- `-s` - same as `--without-symlinks`.  Excludes symlinks\n- `-L` - same as `--save-list`. Saves list of matches to file\n- `--save-path` - path to save matches\n\nWhat does this file contain? Nothing special, just list of files\n```bash\n$> cat ./subject/to_correct.txt\n\nsubject/node_modules\nsubject/sub/node_modules\nsubject/sub/3/node_modules\nsubject/sub/2/1/4/node_modules\nsubject/sub2/node_modules\n```\n\nLet\'s take it easy and save `subject/sub/node_modules` by removing it from the file.\n\nAnd, 3, 2, 1, clear!\n```bash\n$> nested-rimraf rmf -yds ./subject/to_correct.txt\n\nDirectories (enclude symlinks):\n        → subject/node_modules\n        → subject/sub/3/node_modules\n        → subject/sub/2/1/4/node_modules\n        → subject/sub2/node_modules\nDone flawlessly!\n```\n\nGood job! \n\n**Usage**:\n\n```console\n$ nested-rimraf [OPTIONS] COMMAND [ARGS]...\n```\n\n**Options**:\n\n* `--install-completion`: Install completion for the current shell.\n* `--show-completion`: Show completion for the current shell, to copy it or customize the installation.\n* `--help`: Show this message and exit.\n\n**Commands**:\n\n* `rm`: Scan and remove targets inside directory and...\n* `rmf`: Took file, generated by "nested-rimraf scan"...\n* `scan`: Scan directory and child-directories to find...\n\n## `nested-rimraf rm`\n\nScan and remove targets inside directory and sub-directories\n\n**Usage**:\n\n```console\n$ nested-rimraf rm [OPTIONS] TARGET [DIRECTORY]\n```\n\n**Arguments**:\n\n* `TARGET`: Target name to find inside of directory  [required]\n* `[DIRECTORY]`: Directory to scan in  [default: .]\n\n**Options**:\n\n* `-d, --dir-only`: Target only directories  [default: False]\n* `-s, --without-symlinks`: Do not process symlinks as targets  [default: False]\n* `-y, --agree`: Remove without any questions  [default: False]\n* `-I, --ignore-errors`: Ignore errors and delete until possible  [default: False]\n* `-v, --verbose`: Talk a lot  [default: False]\n* `--help`: Show this message and exit.\n\n## `nested-rimraf rmf`\n\nTook file, generated by "nested-rimraf scan" and remove everything from it\n\n**Usage**:\n\n```console\n$ nested-rimraf rmf [OPTIONS] [SAVE_PATH]\n```\n\n**Arguments**:\n\n* `[SAVE_PATH]`: Remove list from passed file or ".nr-todo" inside passed directory  [default: .nr-todo]\n\n**Options**:\n\n* `-d, --dir-only`: Target only directories  [default: False]\n* `-s, --without-symlinks`: Do not process symlinks as targets  [default: False]\n* `-y, --agree`: Remove without any questions  [default: False]\n* `-I, --ignore-errors`: Ignore errors and delete until possible  [default: False]\n* `-v, --verbose`: Talk a lot  [default: False]\n* `--help`: Show this message and exit.\n\n## `nested-rimraf scan`\n\nScan directory and child-directories to find targets\n\nUsage:\n\n> nested-rimraf scan <target> <directory>\n\n**Usage**:\n\n```console\n$ nested-rimraf scan [OPTIONS] TARGET [DIRECTORY]\n```\n\n**Arguments**:\n\n* `TARGET`: Target name to find inside of directory  [required]\n* `[DIRECTORY]`: Directory to scan in  [default: .]\n\n**Options**:\n\n* `-d, --dir-only`: Target only directories  [default: False]\n* `-s, --without-symlinks`: Do not process symlinks as targets  [default: False]\n* `-L, --save-list`: Save list of targets for further use  [default: False]\n* `--save-path TEXT`: File to save list of targets  [default: .nr-todo]\n* `-v, --verbose`: Talk a lot  [default: False]\n* `--help`: Show this message and exit.\n',
    'author': 'Vladimir Levin',
    'author_email': 'opaozhub@gmail.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/opa-oz/nested-rimraf',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
