# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator (autorest: 3.0.6365, generator: {generator})
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import IO, List, Optional, Union

import msrest.serialization

from ._smart_diagnostics_api_enums import *


class AlarmDefinitionChild(msrest.serialization.Model):
    """AlarmDefinitionChild.

    :param low_alarm_value:
    :type low_alarm_value: float
    :param low_warning_value:
    :type low_warning_value: float
    :param high_alarm_value:
    :type high_alarm_value: float
    :param high_warning_value:
    :type high_warning_value: float
    :param off_threshold_value:
    :type off_threshold_value: float
    :param classification:
    :type classification: str
    """

    _attribute_map = {
        'low_alarm_value': {'key': 'LowAlarmValue', 'type': 'float'},
        'low_warning_value': {'key': 'LowWarningValue', 'type': 'float'},
        'high_alarm_value': {'key': 'HighAlarmValue', 'type': 'float'},
        'high_warning_value': {'key': 'HighWarningValue', 'type': 'float'},
        'off_threshold_value': {'key': 'OffThresholdValue', 'type': 'float'},
        'classification': {'key': 'Classification', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        low_alarm_value: Optional[float] = None,
        low_warning_value: Optional[float] = None,
        high_alarm_value: Optional[float] = None,
        high_warning_value: Optional[float] = None,
        off_threshold_value: Optional[float] = None,
        classification: Optional[str] = None,
        **kwargs
    ):
        super(AlarmDefinitionChild, self).__init__(**kwargs)
        self.low_alarm_value = low_alarm_value
        self.low_warning_value = low_warning_value
        self.high_alarm_value = high_alarm_value
        self.high_warning_value = high_warning_value
        self.off_threshold_value = off_threshold_value
        self.classification = classification


class AnalyticsModelChild(msrest.serialization.Model):
    """AnalyticsModelChild.

    All required parameters must be populated in order to send to Azure.

    :param analytics_model_id: Required.
    :type analytics_model_id: int
    :param analytics_model_name: Required.
    :type analytics_model_name: str
    :param analytics_model_version: Required.
    :type analytics_model_version: str
    """

    _validation = {
        'analytics_model_id': {'required': True},
        'analytics_model_name': {'required': True},
        'analytics_model_version': {'required': True},
    }

    _attribute_map = {
        'analytics_model_id': {'key': 'AnalyticsModelId', 'type': 'int'},
        'analytics_model_name': {'key': 'AnalyticsModelName', 'type': 'str'},
        'analytics_model_version': {'key': 'AnalyticsModelVersion', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        analytics_model_id: int,
        analytics_model_name: str,
        analytics_model_version: str,
        **kwargs
    ):
        super(AnalyticsModelChild, self).__init__(**kwargs)
        self.analytics_model_id = analytics_model_id
        self.analytics_model_name = analytics_model_name
        self.analytics_model_version = analytics_model_version


class AnalyticsModelCreateRequest(msrest.serialization.Model):
    """AnalyticsModelCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param version: Required.
    :type version: str
    :param location_id:
    :type location_id: str
    :param corporation_id:
    :type corporation_id: str
    :param type: Required.  Possible values include: "SMARTIndicator", "Classifier".
    :type type: str or ~smartdiagnostics_sdk.models.AnalyticsModelCreateRequestType
    :param indicators:
    :type indicators: list[~smartdiagnostics_sdk.models.AnalyticsModelIndicatorChild]
    :param related_model_ids:
    :type related_model_ids: list[int]
    :param group_type:  Possible values include: "Asset", "MonitoringPoint", "IndicatorGroup",
     "Group", "AnalyticModel".
    :type group_type: str or ~smartdiagnostics_sdk.models.AnalyticsModelCreateRequestGroupType
    :param properties:
    :type properties: list[~smartdiagnostics_sdk.models.PropertyRequestChild]
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'version': {'required': True, 'max_length': 50, 'min_length': 0},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'indicators': {'key': 'Indicators', 'type': '[AnalyticsModelIndicatorChild]'},
        'related_model_ids': {'key': 'RelatedModelIds', 'type': '[int]'},
        'group_type': {'key': 'GroupType', 'type': 'str'},
        'properties': {'key': 'Properties', 'type': '[PropertyRequestChild]'},
    }

    def __init__(
        self,
        *,
        name: str,
        version: str,
        type: Union[str, "AnalyticsModelCreateRequestType"],
        location_id: Optional[str] = None,
        corporation_id: Optional[str] = None,
        indicators: Optional[List["AnalyticsModelIndicatorChild"]] = None,
        related_model_ids: Optional[List[int]] = None,
        group_type: Optional[Union[str, "AnalyticsModelCreateRequestGroupType"]] = None,
        properties: Optional[List["PropertyRequestChild"]] = None,
        **kwargs
    ):
        super(AnalyticsModelCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.version = version
        self.location_id = location_id
        self.corporation_id = corporation_id
        self.type = type
        self.indicators = indicators
        self.related_model_ids = related_model_ids
        self.group_type = group_type
        self.properties = properties


class AnalyticsModelIndicatorChild(msrest.serialization.Model):
    """AnalyticsModelIndicatorChild.

    All required parameters must be populated in order to send to Azure.

    :param indicator_name: Required.
    :type indicator_name: str
    :param indicator_units: Required.
    :type indicator_units: str
    """

    _validation = {
        'indicator_name': {'required': True},
        'indicator_units': {'required': True},
    }

    _attribute_map = {
        'indicator_name': {'key': 'IndicatorName', 'type': 'str'},
        'indicator_units': {'key': 'IndicatorUnits', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        indicator_name: str,
        indicator_units: str,
        **kwargs
    ):
        super(AnalyticsModelIndicatorChild, self).__init__(**kwargs)
        self.indicator_name = indicator_name
        self.indicator_units = indicator_units


class AnalyticsModelRelatedModelChild(msrest.serialization.Model):
    """AnalyticsModelRelatedModelChild.

    :param related_model_id:
    :type related_model_id: int
    :param related_model_name:
    :type related_model_name: str
    :param related_model_type:  Possible values include: "SMARTIndicator", "Classifier".
    :type related_model_type: str or
     ~smartdiagnostics_sdk.models.AnalyticsModelRelatedModelChildRelatedModelType
    """

    _attribute_map = {
        'related_model_id': {'key': 'RelatedModelId', 'type': 'int'},
        'related_model_name': {'key': 'RelatedModelName', 'type': 'str'},
        'related_model_type': {'key': 'RelatedModelType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        related_model_id: Optional[int] = None,
        related_model_name: Optional[str] = None,
        related_model_type: Optional[Union[str, "AnalyticsModelRelatedModelChildRelatedModelType"]] = None,
        **kwargs
    ):
        super(AnalyticsModelRelatedModelChild, self).__init__(**kwargs)
        self.related_model_id = related_model_id
        self.related_model_name = related_model_name
        self.related_model_type = related_model_type


class AnalyticsModelResponse(msrest.serialization.Model):
    """AnalyticsModelResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    :param version: Required.
    :type version: str
    :param type:  Possible values include: "SMARTIndicator", "Classifier".
    :type type: str or ~smartdiagnostics_sdk.models.AnalyticsModelResponseType
    :param created:
    :type created: ~datetime.datetime
    :param group_type:  Possible values include: "Asset", "MonitoringPoint", "IndicatorGroup",
     "Group", "AnalyticModel".
    :type group_type: str or ~smartdiagnostics_sdk.models.AnalyticsModelResponseGroupType
    :param is_global:
    :type is_global: bool
    :param is_deprecated:
    :type is_deprecated: bool
    :param indicators:
    :type indicators: list[~smartdiagnostics_sdk.models.AnalyticsModelIndicatorChild]
    :param properties:
    :type properties: list[~smartdiagnostics_sdk.models.PropertyChild]
    :param related_models:
    :type related_models: list[~smartdiagnostics_sdk.models.AnalyticsModelRelatedModelChild]
    :param created_by:
    :type created_by: ~smartdiagnostics_sdk.models.UserChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'version': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'version': {'key': 'Version', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'group_type': {'key': 'GroupType', 'type': 'str'},
        'is_global': {'key': 'IsGlobal', 'type': 'bool'},
        'is_deprecated': {'key': 'IsDeprecated', 'type': 'bool'},
        'indicators': {'key': 'Indicators', 'type': '[AnalyticsModelIndicatorChild]'},
        'properties': {'key': 'Properties', 'type': '[PropertyChild]'},
        'related_models': {'key': 'RelatedModels', 'type': '[AnalyticsModelRelatedModelChild]'},
        'created_by': {'key': 'CreatedBy', 'type': 'UserChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        id: int,
        name: str,
        version: str,
        type: Optional[Union[str, "AnalyticsModelResponseType"]] = None,
        created: Optional[datetime.datetime] = None,
        group_type: Optional[Union[str, "AnalyticsModelResponseGroupType"]] = None,
        is_global: Optional[bool] = None,
        is_deprecated: Optional[bool] = None,
        indicators: Optional[List["AnalyticsModelIndicatorChild"]] = None,
        properties: Optional[List["PropertyChild"]] = None,
        related_models: Optional[List["AnalyticsModelRelatedModelChild"]] = None,
        created_by: Optional["UserChild"] = None,
        corporation: Optional["CorporationChild"] = None,
        location: Optional["LocationChild"] = None,
        **kwargs
    ):
        super(AnalyticsModelResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.version = version
        self.type = type
        self.created = created
        self.group_type = group_type
        self.is_global = is_global
        self.is_deprecated = is_deprecated
        self.indicators = indicators
        self.properties = properties
        self.related_models = related_models
        self.created_by = created_by
        self.corporation = corporation
        self.location = location


class AssetCategoryChild(msrest.serialization.Model):
    """AssetCategoryChild.

    :param category_id:
    :type category_id: int
    :param category_name:
    :type category_name: str
    :param category_code:
    :type category_code: str
    :param category_marker:
    :type category_marker: ~smartdiagnostics_sdk.models.AssetCategoryMarkerChild
    """

    _attribute_map = {
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'category_name': {'key': 'CategoryName', 'type': 'str'},
        'category_code': {'key': 'CategoryCode', 'type': 'str'},
        'category_marker': {'key': 'CategoryMarker', 'type': 'AssetCategoryMarkerChild'},
    }

    def __init__(
        self,
        *,
        category_id: Optional[int] = None,
        category_name: Optional[str] = None,
        category_code: Optional[str] = None,
        category_marker: Optional["AssetCategoryMarkerChild"] = None,
        **kwargs
    ):
        super(AssetCategoryChild, self).__init__(**kwargs)
        self.category_id = category_id
        self.category_name = category_name
        self.category_code = category_code
        self.category_marker = category_marker


class AssetCategoryMarkerChild(msrest.serialization.Model):
    """AssetCategoryMarkerChild.

    :param category_marker_id:
    :type category_marker_id: int
    :param category_marker_name:
    :type category_marker_name: str
    :param category_marker_code:
    :type category_marker_code: str
    """

    _attribute_map = {
        'category_marker_id': {'key': 'CategoryMarkerId', 'type': 'int'},
        'category_marker_name': {'key': 'CategoryMarkerName', 'type': 'str'},
        'category_marker_code': {'key': 'CategoryMarkerCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        category_marker_id: Optional[int] = None,
        category_marker_name: Optional[str] = None,
        category_marker_code: Optional[str] = None,
        **kwargs
    ):
        super(AssetCategoryMarkerChild, self).__init__(**kwargs)
        self.category_marker_id = category_marker_id
        self.category_marker_name = category_marker_name
        self.category_marker_code = category_marker_code


class AssetCategoryWithSizeChild(msrest.serialization.Model):
    """AssetCategoryWithSizeChild.

    All required parameters must be populated in order to send to Azure.

    :param category_id: Required.
    :type category_id: int
    :param category_name: Required.
    :type category_name: str
    :param category_code: Required.
    :type category_code: str
    :param category_marker:
    :type category_marker: ~smartdiagnostics_sdk.models.AssetCategoryMarkerChild
    :param category_sizes:
    :type category_sizes: list[~smartdiagnostics_sdk.models.AssetSizeChild]
    """

    _validation = {
        'category_id': {'required': True},
        'category_name': {'required': True},
        'category_code': {'required': True},
    }

    _attribute_map = {
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'category_name': {'key': 'CategoryName', 'type': 'str'},
        'category_code': {'key': 'CategoryCode', 'type': 'str'},
        'category_marker': {'key': 'CategoryMarker', 'type': 'AssetCategoryMarkerChild'},
        'category_sizes': {'key': 'CategorySizes', 'type': '[AssetSizeChild]'},
    }

    def __init__(
        self,
        *,
        category_id: int,
        category_name: str,
        category_code: str,
        category_marker: Optional["AssetCategoryMarkerChild"] = None,
        category_sizes: Optional[List["AssetSizeChild"]] = None,
        **kwargs
    ):
        super(AssetCategoryWithSizeChild, self).__init__(**kwargs)
        self.category_id = category_id
        self.category_name = category_name
        self.category_code = category_code
        self.category_marker = category_marker
        self.category_sizes = category_sizes


class AssetCreateRequest(msrest.serialization.Model):
    """AssetCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param parent_id: Required.
    :type parent_id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param supplier:
    :type supplier: str
    :param manufacturer:
    :type manufacturer: str
    :param model_name:
    :type model_name: str
    :param location_notes:
    :type location_notes: str
    :param notes:
    :type notes: str
    :param generic_input:
    :type generic_input: str
    :param is_operator_view: Required.
    :type is_operator_view: bool
    :param type_id:
    :type type_id: int
    :param category_id:
    :type category_id: int
    :param size_id:
    :type size_id: int
    :param criticality_id:
    :type criticality_id: int
    :param asset_cost:
    :type asset_cost: float
    :param date_installed:
    :type date_installed: ~datetime.datetime
    :param annual_run_time:
    :type annual_run_time: float
    :param lost_production_cost:
    :type lost_production_cost: float
    :param overhaul_cost:
    :type overhaul_cost: float
    :param power_consumption:
    :type power_consumption: float
    :param life_expectancy:
    :type life_expectancy: float
    :param unscheduled_downtime:
    :type unscheduled_downtime: float
    :param running_speed_harmonic:
    :type running_speed_harmonic: float
    """

    _validation = {
        'parent_id': {'required': True},
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'supplier': {'max_length': 128, 'min_length': 0},
        'manufacturer': {'max_length': 128, 'min_length': 0},
        'model_name': {'max_length': 128, 'min_length': 0},
        'location_notes': {'max_length': 256, 'min_length': 0},
        'notes': {'max_length': 2000, 'min_length': 0},
        'generic_input': {'max_length': 2000, 'min_length': 0},
        'is_operator_view': {'required': True},
    }

    _attribute_map = {
        'parent_id': {'key': 'ParentId', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'supplier': {'key': 'Supplier', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'location_notes': {'key': 'LocationNotes', 'type': 'str'},
        'notes': {'key': 'Notes', 'type': 'str'},
        'generic_input': {'key': 'GenericInput', 'type': 'str'},
        'is_operator_view': {'key': 'IsOperatorView', 'type': 'bool'},
        'type_id': {'key': 'TypeId', 'type': 'int'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'size_id': {'key': 'SizeId', 'type': 'int'},
        'criticality_id': {'key': 'CriticalityId', 'type': 'int'},
        'asset_cost': {'key': 'AssetCost', 'type': 'float'},
        'date_installed': {'key': 'DateInstalled', 'type': 'iso-8601'},
        'annual_run_time': {'key': 'AnnualRunTime', 'type': 'float'},
        'lost_production_cost': {'key': 'LostProductionCost', 'type': 'float'},
        'overhaul_cost': {'key': 'OverhaulCost', 'type': 'float'},
        'power_consumption': {'key': 'PowerConsumption', 'type': 'float'},
        'life_expectancy': {'key': 'LifeExpectancy', 'type': 'float'},
        'unscheduled_downtime': {'key': 'UnscheduledDowntime', 'type': 'float'},
        'running_speed_harmonic': {'key': 'RunningSpeedHarmonic', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        parent_id: str,
        name: str,
        is_operator_view: bool,
        abbreviation: Optional[str] = None,
        supplier: Optional[str] = None,
        manufacturer: Optional[str] = None,
        model_name: Optional[str] = None,
        location_notes: Optional[str] = None,
        notes: Optional[str] = None,
        generic_input: Optional[str] = None,
        type_id: Optional[int] = None,
        category_id: Optional[int] = None,
        size_id: Optional[int] = None,
        criticality_id: Optional[int] = None,
        asset_cost: Optional[float] = None,
        date_installed: Optional[datetime.datetime] = None,
        annual_run_time: Optional[float] = None,
        lost_production_cost: Optional[float] = None,
        overhaul_cost: Optional[float] = None,
        power_consumption: Optional[float] = None,
        life_expectancy: Optional[float] = None,
        unscheduled_downtime: Optional[float] = None,
        running_speed_harmonic: Optional[float] = None,
        **kwargs
    ):
        super(AssetCreateRequest, self).__init__(**kwargs)
        self.parent_id = parent_id
        self.name = name
        self.abbreviation = abbreviation
        self.supplier = supplier
        self.manufacturer = manufacturer
        self.model_name = model_name
        self.location_notes = location_notes
        self.notes = notes
        self.generic_input = generic_input
        self.is_operator_view = is_operator_view
        self.type_id = type_id
        self.category_id = category_id
        self.size_id = size_id
        self.criticality_id = criticality_id
        self.asset_cost = asset_cost
        self.date_installed = date_installed
        self.annual_run_time = annual_run_time
        self.lost_production_cost = lost_production_cost
        self.overhaul_cost = overhaul_cost
        self.power_consumption = power_consumption
        self.life_expectancy = life_expectancy
        self.unscheduled_downtime = unscheduled_downtime
        self.running_speed_harmonic = running_speed_harmonic


class AssetCriticalityChild(msrest.serialization.Model):
    """AssetCriticalityChild.

    :param criticality_id:
    :type criticality_id: int
    :param criticality_name:
    :type criticality_name: str
    """

    _attribute_map = {
        'criticality_id': {'key': 'CriticalityId', 'type': 'int'},
        'criticality_name': {'key': 'CriticalityName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        criticality_id: Optional[int] = None,
        criticality_name: Optional[str] = None,
        **kwargs
    ):
        super(AssetCriticalityChild, self).__init__(**kwargs)
        self.criticality_id = criticality_id
        self.criticality_name = criticality_name


class AssetDrumRollChild(msrest.serialization.Model):
    """AssetDrumRollChild.

    :param drum_roll_diameter:
    :type drum_roll_diameter: int
    :param drum_roll_diameter_unit:
    :type drum_roll_diameter_unit: str
    """

    _attribute_map = {
        'drum_roll_diameter': {'key': 'DrumRollDiameter', 'type': 'int'},
        'drum_roll_diameter_unit': {'key': 'DrumRollDiameterUnit', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        drum_roll_diameter: Optional[int] = None,
        drum_roll_diameter_unit: Optional[str] = None,
        **kwargs
    ):
        super(AssetDrumRollChild, self).__init__(**kwargs)
        self.drum_roll_diameter = drum_roll_diameter
        self.drum_roll_diameter_unit = drum_roll_diameter_unit


class AssetEconomicsChild(msrest.serialization.Model):
    """AssetEconomicsChild.

    :param asset_cost:
    :type asset_cost: float
    :param date_installed:
    :type date_installed: ~datetime.datetime
    :param annual_run_time:
    :type annual_run_time: float
    :param lost_production_cost:
    :type lost_production_cost: float
    :param overhaul_cost:
    :type overhaul_cost: float
    :param power_consumption:
    :type power_consumption: float
    :param life_expectancy:
    :type life_expectancy: float
    :param unscheduled_downtime:
    :type unscheduled_downtime: float
    """

    _attribute_map = {
        'asset_cost': {'key': 'AssetCost', 'type': 'float'},
        'date_installed': {'key': 'DateInstalled', 'type': 'iso-8601'},
        'annual_run_time': {'key': 'AnnualRunTime', 'type': 'float'},
        'lost_production_cost': {'key': 'LostProductionCost', 'type': 'float'},
        'overhaul_cost': {'key': 'OverhaulCost', 'type': 'float'},
        'power_consumption': {'key': 'PowerConsumption', 'type': 'float'},
        'life_expectancy': {'key': 'LifeExpectancy', 'type': 'float'},
        'unscheduled_downtime': {'key': 'UnscheduledDowntime', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        asset_cost: Optional[float] = None,
        date_installed: Optional[datetime.datetime] = None,
        annual_run_time: Optional[float] = None,
        lost_production_cost: Optional[float] = None,
        overhaul_cost: Optional[float] = None,
        power_consumption: Optional[float] = None,
        life_expectancy: Optional[float] = None,
        unscheduled_downtime: Optional[float] = None,
        **kwargs
    ):
        super(AssetEconomicsChild, self).__init__(**kwargs)
        self.asset_cost = asset_cost
        self.date_installed = date_installed
        self.annual_run_time = annual_run_time
        self.lost_production_cost = lost_production_cost
        self.overhaul_cost = overhaul_cost
        self.power_consumption = power_consumption
        self.life_expectancy = life_expectancy
        self.unscheduled_downtime = unscheduled_downtime


class AssetResponse(msrest.serialization.Model):
    """AssetResponse.

    All required parameters must be populated in order to send to Azure.

    :param supplier:
    :type supplier: str
    :param manufacturer:
    :type manufacturer: str
    :param model_name:
    :type model_name: str
    :param location_notes:
    :type location_notes: str
    :param notes:
    :type notes: str
    :param generic_input:
    :type generic_input: str
    :param is_operator_view:
    :type is_operator_view: bool
    :param type:
    :type type: ~smartdiagnostics_sdk.models.AssetTypeChild
    :param category:
    :type category: ~smartdiagnostics_sdk.models.AssetCategoryChild
    :param size:
    :type size: ~smartdiagnostics_sdk.models.AssetSizeChild
    :param economics:
    :type economics: ~smartdiagnostics_sdk.models.AssetEconomicsChild
    :param running_speed:
    :type running_speed: ~smartdiagnostics_sdk.models.AssetRunningSpeedChild
    :param criticality:
    :type criticality: ~smartdiagnostics_sdk.models.AssetCriticalityChild
    :param drum_roll:
    :type drum_roll: ~smartdiagnostics_sdk.models.AssetDrumRollChild
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param tags: A set of tags.
    :type tags: list[~smartdiagnostics_sdk.models.TagChild]
    :param analytics_models:
    :type analytics_models: list[~smartdiagnostics_sdk.models.AnalyticsModelChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'supplier': {'key': 'Supplier', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'location_notes': {'key': 'LocationNotes', 'type': 'str'},
        'notes': {'key': 'Notes', 'type': 'str'},
        'generic_input': {'key': 'GenericInput', 'type': 'str'},
        'is_operator_view': {'key': 'IsOperatorView', 'type': 'bool'},
        'type': {'key': 'Type', 'type': 'AssetTypeChild'},
        'category': {'key': 'Category', 'type': 'AssetCategoryChild'},
        'size': {'key': 'Size', 'type': 'AssetSizeChild'},
        'economics': {'key': 'Economics', 'type': 'AssetEconomicsChild'},
        'running_speed': {'key': 'RunningSpeed', 'type': 'AssetRunningSpeedChild'},
        'criticality': {'key': 'Criticality', 'type': 'AssetCriticalityChild'},
        'drum_roll': {'key': 'DrumRoll', 'type': 'AssetDrumRollChild'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'tags': {'key': 'Tags', 'type': '[TagChild]'},
        'analytics_models': {'key': 'AnalyticsModels', 'type': '[AnalyticsModelChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        active: bool,
        is_paused: bool,
        is_snoozed: bool,
        created: datetime.datetime,
        corporation: "CorporationChild",
        location: "LocationChild",
        supplier: Optional[str] = None,
        manufacturer: Optional[str] = None,
        model_name: Optional[str] = None,
        location_notes: Optional[str] = None,
        notes: Optional[str] = None,
        generic_input: Optional[str] = None,
        is_operator_view: Optional[bool] = None,
        type: Optional["AssetTypeChild"] = None,
        category: Optional["AssetCategoryChild"] = None,
        size: Optional["AssetSizeChild"] = None,
        economics: Optional["AssetEconomicsChild"] = None,
        running_speed: Optional["AssetRunningSpeedChild"] = None,
        criticality: Optional["AssetCriticalityChild"] = None,
        drum_roll: Optional["AssetDrumRollChild"] = None,
        hierarchy: Optional[List["HierarchyChild"]] = None,
        parent: Optional["ParentChild"] = None,
        children: Optional[List["DescendantChild"]] = None,
        tags: Optional[List["TagChild"]] = None,
        analytics_models: Optional[List["AnalyticsModelChild"]] = None,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(AssetResponse, self).__init__(**kwargs)
        self.supplier = supplier
        self.manufacturer = manufacturer
        self.model_name = model_name
        self.location_notes = location_notes
        self.notes = notes
        self.generic_input = generic_input
        self.is_operator_view = is_operator_view
        self.type = type
        self.category = category
        self.size = size
        self.economics = economics
        self.running_speed = running_speed
        self.criticality = criticality
        self.drum_roll = drum_roll
        self.hierarchy = hierarchy
        self.parent = parent
        self.children = children
        self.tags = tags
        self.analytics_models = analytics_models
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.is_paused = is_paused
        self.is_snoozed = is_snoozed
        self.created = created
        self.corporation = corporation
        self.location = location


class AssetRunningSpeedChild(msrest.serialization.Model):
    """AssetRunningSpeedChild.

    :param running_speed_min:
    :type running_speed_min: float
    :param running_speed_max:
    :type running_speed_max: float
    :param running_speed_type:
    :type running_speed_type: str
    :param running_speed_reference_monitoring_point_id:
    :type running_speed_reference_monitoring_point_id: str
    :param running_speed_sensor_role_type:  Possible values include: "Invalid", "CurrentPhaseA",
     "PeakCurrentPhaseA", "CurrentPhaseB", "PeakCurrentPhaseB", "CurrentPhaseC",
     "PeakCurrentPhaseC", "DifferentialPressure", "Flow", "Humidity", "NodeTemperature",
     "NodeVoltage", "PeakVibration", "Pressure", "RmsVibration", "SignalStrength",
     "StandardAirVelocity", "SupplyVoltage", "Temperature", "TotalCurrent", "VibrationXAxis",
     "VibrationYAxis", "Voltage", "Current", "AtoDChannel1", "AtoDChannel2", "AtoDChannel3",
     "AtoDChannel4", "AtoDChannel5", "AtoDChannel6", "OilTemperature", "OilHumidity", "X", "Y", "Z",
     "Custom", "WirelessEfficiency", "PacketSuccessRate", "NodeHumidity", "BurstSuccessRate".
    :type running_speed_sensor_role_type: str or
     ~smartdiagnostics_sdk.models.AssetRunningSpeedChildRunningSpeedSensorRoleType
    :param running_speed_harmonic:
    :type running_speed_harmonic: float
    """

    _attribute_map = {
        'running_speed_min': {'key': 'RunningSpeedMin', 'type': 'float'},
        'running_speed_max': {'key': 'RunningSpeedMax', 'type': 'float'},
        'running_speed_type': {'key': 'RunningSpeedType', 'type': 'str'},
        'running_speed_reference_monitoring_point_id': {'key': 'RunningSpeedReferenceMonitoringPointId', 'type': 'str'},
        'running_speed_sensor_role_type': {'key': 'RunningSpeedSensorRoleType', 'type': 'str'},
        'running_speed_harmonic': {'key': 'RunningSpeedHarmonic', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        running_speed_min: Optional[float] = None,
        running_speed_max: Optional[float] = None,
        running_speed_type: Optional[str] = None,
        running_speed_reference_monitoring_point_id: Optional[str] = None,
        running_speed_sensor_role_type: Optional[Union[str, "AssetRunningSpeedChildRunningSpeedSensorRoleType"]] = None,
        running_speed_harmonic: Optional[float] = None,
        **kwargs
    ):
        super(AssetRunningSpeedChild, self).__init__(**kwargs)
        self.running_speed_min = running_speed_min
        self.running_speed_max = running_speed_max
        self.running_speed_type = running_speed_type
        self.running_speed_reference_monitoring_point_id = running_speed_reference_monitoring_point_id
        self.running_speed_sensor_role_type = running_speed_sensor_role_type
        self.running_speed_harmonic = running_speed_harmonic


class AssetSizeChild(msrest.serialization.Model):
    """AssetSizeChild.

    All required parameters must be populated in order to send to Azure.

    :param size_id: Required.
    :type size_id: int
    :param size_name: Required.
    :type size_name: str
    :param size_code: Required.
    :type size_code: str
    """

    _validation = {
        'size_id': {'required': True},
        'size_name': {'required': True},
        'size_code': {'required': True},
    }

    _attribute_map = {
        'size_id': {'key': 'SizeId', 'type': 'int'},
        'size_name': {'key': 'SizeName', 'type': 'str'},
        'size_code': {'key': 'SizeCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        size_id: int,
        size_name: str,
        size_code: str,
        **kwargs
    ):
        super(AssetSizeChild, self).__init__(**kwargs)
        self.size_id = size_id
        self.size_name = size_name
        self.size_code = size_code


class AssetsStatusCountChild(msrest.serialization.Model):
    """AssetsStatusCountChild.

    :param normal:
    :type normal: int
    :param warning:
    :type warning: int
    :param alarm:
    :type alarm: int
    """

    _attribute_map = {
        'normal': {'key': 'Normal', 'type': 'int'},
        'warning': {'key': 'Warning', 'type': 'int'},
        'alarm': {'key': 'Alarm', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        normal: Optional[int] = None,
        warning: Optional[int] = None,
        alarm: Optional[int] = None,
        **kwargs
    ):
        super(AssetsStatusCountChild, self).__init__(**kwargs)
        self.normal = normal
        self.warning = warning
        self.alarm = alarm


class AssetsStatusPercentageChild(msrest.serialization.Model):
    """AssetsStatusPercentageChild.

    :param normal:
    :type normal: int
    :param warning:
    :type warning: int
    :param alarm:
    :type alarm: int
    """

    _attribute_map = {
        'normal': {'key': 'Normal', 'type': 'int'},
        'warning': {'key': 'Warning', 'type': 'int'},
        'alarm': {'key': 'Alarm', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        normal: Optional[int] = None,
        warning: Optional[int] = None,
        alarm: Optional[int] = None,
        **kwargs
    ):
        super(AssetsStatusPercentageChild, self).__init__(**kwargs)
        self.normal = normal
        self.warning = warning
        self.alarm = alarm


class AssetTypeChild(msrest.serialization.Model):
    """AssetTypeChild.

    :param type_id:
    :type type_id: int
    :param type_name:
    :type type_name: str
    :param type_code:
    :type type_code: str
    """

    _attribute_map = {
        'type_id': {'key': 'TypeId', 'type': 'int'},
        'type_name': {'key': 'TypeName', 'type': 'str'},
        'type_code': {'key': 'TypeCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        type_id: Optional[int] = None,
        type_name: Optional[str] = None,
        type_code: Optional[str] = None,
        **kwargs
    ):
        super(AssetTypeChild, self).__init__(**kwargs)
        self.type_id = type_id
        self.type_name = type_name
        self.type_code = type_code


class AssetTypeResponse(msrest.serialization.Model):
    """AssetTypeResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    :param code: Required.
    :type code: str
    :param categories: Required.
    :type categories: list[~smartdiagnostics_sdk.models.AssetCategoryWithSizeChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'code': {'required': True},
        'categories': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'code': {'key': 'Code', 'type': 'str'},
        'categories': {'key': 'Categories', 'type': '[AssetCategoryWithSizeChild]'},
    }

    def __init__(
        self,
        *,
        id: int,
        name: str,
        code: str,
        categories: List["AssetCategoryWithSizeChild"],
        **kwargs
    ):
        super(AssetTypeResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.code = code
        self.categories = categories


class AssetUpdateRequest(msrest.serialization.Model):
    """AssetUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param is_paused: Required.
    :type is_paused: bool
    :param running_speed_min:
    :type running_speed_min: float
    :param running_speed_max:
    :type running_speed_max: float
    :param running_speed_type:  Possible values include: "Invalid", "Fixed", "Ranged", "AutoTrack".
    :type running_speed_type: str or
     ~smartdiagnostics_sdk.models.AssetUpdateRequestRunningSpeedType
    :param running_speed_reference_monitoring_point_id:
    :type running_speed_reference_monitoring_point_id: str
    :param running_speed_sensor_role_type:  Possible values include: "Invalid", "CurrentPhaseA",
     "PeakCurrentPhaseA", "CurrentPhaseB", "PeakCurrentPhaseB", "CurrentPhaseC",
     "PeakCurrentPhaseC", "DifferentialPressure", "Flow", "Humidity", "NodeTemperature",
     "NodeVoltage", "PeakVibration", "Pressure", "RmsVibration", "SignalStrength",
     "StandardAirVelocity", "SupplyVoltage", "Temperature", "TotalCurrent", "VibrationXAxis",
     "VibrationYAxis", "Voltage", "Current", "AtoDChannel1", "AtoDChannel2", "AtoDChannel3",
     "AtoDChannel4", "AtoDChannel5", "AtoDChannel6", "OilTemperature", "OilHumidity", "X", "Y", "Z",
     "Custom", "WirelessEfficiency", "PacketSuccessRate", "NodeHumidity", "BurstSuccessRate".
    :type running_speed_sensor_role_type: str or
     ~smartdiagnostics_sdk.models.AssetUpdateRequestRunningSpeedSensorRoleType
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param supplier:
    :type supplier: str
    :param manufacturer:
    :type manufacturer: str
    :param model_name:
    :type model_name: str
    :param location_notes:
    :type location_notes: str
    :param notes:
    :type notes: str
    :param generic_input:
    :type generic_input: str
    :param is_operator_view: Required.
    :type is_operator_view: bool
    :param type_id:
    :type type_id: int
    :param category_id:
    :type category_id: int
    :param size_id:
    :type size_id: int
    :param criticality_id:
    :type criticality_id: int
    :param asset_cost:
    :type asset_cost: float
    :param date_installed:
    :type date_installed: ~datetime.datetime
    :param annual_run_time:
    :type annual_run_time: float
    :param lost_production_cost:
    :type lost_production_cost: float
    :param overhaul_cost:
    :type overhaul_cost: float
    :param power_consumption:
    :type power_consumption: float
    :param life_expectancy:
    :type life_expectancy: float
    :param unscheduled_downtime:
    :type unscheduled_downtime: float
    :param running_speed_harmonic:
    :type running_speed_harmonic: float
    """

    _validation = {
        'is_paused': {'required': True},
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'supplier': {'max_length': 128, 'min_length': 0},
        'manufacturer': {'max_length': 128, 'min_length': 0},
        'model_name': {'max_length': 128, 'min_length': 0},
        'location_notes': {'max_length': 256, 'min_length': 0},
        'notes': {'max_length': 2000, 'min_length': 0},
        'generic_input': {'max_length': 2000, 'min_length': 0},
        'is_operator_view': {'required': True},
    }

    _attribute_map = {
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'running_speed_min': {'key': 'RunningSpeedMin', 'type': 'float'},
        'running_speed_max': {'key': 'RunningSpeedMax', 'type': 'float'},
        'running_speed_type': {'key': 'RunningSpeedType', 'type': 'str'},
        'running_speed_reference_monitoring_point_id': {'key': 'RunningSpeedReferenceMonitoringPointId', 'type': 'str'},
        'running_speed_sensor_role_type': {'key': 'RunningSpeedSensorRoleType', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'supplier': {'key': 'Supplier', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'model_name': {'key': 'ModelName', 'type': 'str'},
        'location_notes': {'key': 'LocationNotes', 'type': 'str'},
        'notes': {'key': 'Notes', 'type': 'str'},
        'generic_input': {'key': 'GenericInput', 'type': 'str'},
        'is_operator_view': {'key': 'IsOperatorView', 'type': 'bool'},
        'type_id': {'key': 'TypeId', 'type': 'int'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'size_id': {'key': 'SizeId', 'type': 'int'},
        'criticality_id': {'key': 'CriticalityId', 'type': 'int'},
        'asset_cost': {'key': 'AssetCost', 'type': 'float'},
        'date_installed': {'key': 'DateInstalled', 'type': 'iso-8601'},
        'annual_run_time': {'key': 'AnnualRunTime', 'type': 'float'},
        'lost_production_cost': {'key': 'LostProductionCost', 'type': 'float'},
        'overhaul_cost': {'key': 'OverhaulCost', 'type': 'float'},
        'power_consumption': {'key': 'PowerConsumption', 'type': 'float'},
        'life_expectancy': {'key': 'LifeExpectancy', 'type': 'float'},
        'unscheduled_downtime': {'key': 'UnscheduledDowntime', 'type': 'float'},
        'running_speed_harmonic': {'key': 'RunningSpeedHarmonic', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        is_paused: bool,
        name: str,
        is_operator_view: bool,
        running_speed_min: Optional[float] = None,
        running_speed_max: Optional[float] = None,
        running_speed_type: Optional[Union[str, "AssetUpdateRequestRunningSpeedType"]] = None,
        running_speed_reference_monitoring_point_id: Optional[str] = None,
        running_speed_sensor_role_type: Optional[Union[str, "AssetUpdateRequestRunningSpeedSensorRoleType"]] = None,
        abbreviation: Optional[str] = None,
        supplier: Optional[str] = None,
        manufacturer: Optional[str] = None,
        model_name: Optional[str] = None,
        location_notes: Optional[str] = None,
        notes: Optional[str] = None,
        generic_input: Optional[str] = None,
        type_id: Optional[int] = None,
        category_id: Optional[int] = None,
        size_id: Optional[int] = None,
        criticality_id: Optional[int] = None,
        asset_cost: Optional[float] = None,
        date_installed: Optional[datetime.datetime] = None,
        annual_run_time: Optional[float] = None,
        lost_production_cost: Optional[float] = None,
        overhaul_cost: Optional[float] = None,
        power_consumption: Optional[float] = None,
        life_expectancy: Optional[float] = None,
        unscheduled_downtime: Optional[float] = None,
        running_speed_harmonic: Optional[float] = None,
        **kwargs
    ):
        super(AssetUpdateRequest, self).__init__(**kwargs)
        self.is_paused = is_paused
        self.running_speed_min = running_speed_min
        self.running_speed_max = running_speed_max
        self.running_speed_type = running_speed_type
        self.running_speed_reference_monitoring_point_id = running_speed_reference_monitoring_point_id
        self.running_speed_sensor_role_type = running_speed_sensor_role_type
        self.name = name
        self.abbreviation = abbreviation
        self.supplier = supplier
        self.manufacturer = manufacturer
        self.model_name = model_name
        self.location_notes = location_notes
        self.notes = notes
        self.generic_input = generic_input
        self.is_operator_view = is_operator_view
        self.type_id = type_id
        self.category_id = category_id
        self.size_id = size_id
        self.criticality_id = criticality_id
        self.asset_cost = asset_cost
        self.date_installed = date_installed
        self.annual_run_time = annual_run_time
        self.lost_production_cost = lost_production_cost
        self.overhaul_cost = overhaul_cost
        self.power_consumption = power_consumption
        self.life_expectancy = life_expectancy
        self.unscheduled_downtime = unscheduled_downtime
        self.running_speed_harmonic = running_speed_harmonic


class AttachmentModelV3(msrest.serialization.Model):
    """AttachmentModelV3.

    All required parameters must be populated in order to send to Azure.

    :param type:  Possible values include: "Corporation", "Account", "Group", "Other", "Indicator".
    :type type: str or ~smartdiagnostics_sdk.models.AttachmentModelV3Type
    :param id: Required.
    :type id: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'id': {'key': 'Id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        type: Optional[Union[str, "AttachmentModelV3Type"]] = None,
        **kwargs
    ):
        super(AttachmentModelV3, self).__init__(**kwargs)
        self.type = type
        self.id = id


class BandDefinitionChild(msrest.serialization.Model):
    """BandDefinitionChild.

    :param high_band_frequency:
    :type high_band_frequency: float
    :param low_band_frequency:
    :type low_band_frequency: float
    """

    _attribute_map = {
        'high_band_frequency': {'key': 'HighBandFrequency', 'type': 'float'},
        'low_band_frequency': {'key': 'LowBandFrequency', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        high_band_frequency: Optional[float] = None,
        low_band_frequency: Optional[float] = None,
        **kwargs
    ):
        super(BandDefinitionChild, self).__init__(**kwargs)
        self.high_band_frequency = high_band_frequency
        self.low_band_frequency = low_band_frequency


class BaseStationCreateRequest(msrest.serialization.Model):
    """BaseStationCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param serial_number: Required.
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param location_id: Required.
    :type location_id: str
    :param release_ring_id:
    :type release_ring_id: str
    """

    _validation = {
        'serial_number': {'required': True, 'max_length': 50, 'min_length': 0},
        'nickname': {'max_length': 50, 'min_length': 0},
        'location_id': {'required': True},
    }

    _attribute_map = {
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'release_ring_id': {'key': 'ReleaseRingId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        serial_number: str,
        location_id: str,
        nickname: Optional[str] = None,
        release_ring_id: Optional[str] = None,
        **kwargs
    ):
        super(BaseStationCreateRequest, self).__init__(**kwargs)
        self.serial_number = serial_number
        self.nickname = nickname
        self.location_id = location_id
        self.release_ring_id = release_ring_id


class BaseStationResponse(msrest.serialization.Model):
    """BaseStationResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: long
    :param serial_number: Required.
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param last_status_update:
    :type last_status_update: ~datetime.datetime
    :param push_to_stage:
    :type push_to_stage: bool
    :param release_ring:
    :type release_ring: ~smartdiagnostics_sdk.models.ReleaseRingChild
    :param targeted_software_release:
    :type targeted_software_release: ~smartdiagnostics_sdk.models.TargetedSoftwareReleaseChild
    :param current_software_release:
    :type current_software_release: ~smartdiagnostics_sdk.models.CurrentSoftwareReleaseChild
    :param hardware_revision:
    :type hardware_revision: ~smartdiagnostics_sdk.models.HardwareRevisionChild
    :param receiver:
    :type receiver: ~smartdiagnostics_sdk.models.ReceiverChild
    :param last_data_update:
    :type last_data_update: ~datetime.datetime
    :param is_online:
    :type is_online: bool
    """

    _validation = {
        'id': {'required': True},
        'serial_number': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'last_status_update': {'key': 'LastStatusUpdate', 'type': 'iso-8601'},
        'push_to_stage': {'key': 'PushToStage', 'type': 'bool'},
        'release_ring': {'key': 'ReleaseRing', 'type': 'ReleaseRingChild'},
        'targeted_software_release': {'key': 'TargetedSoftwareRelease', 'type': 'TargetedSoftwareReleaseChild'},
        'current_software_release': {'key': 'CurrentSoftwareRelease', 'type': 'CurrentSoftwareReleaseChild'},
        'hardware_revision': {'key': 'HardwareRevision', 'type': 'HardwareRevisionChild'},
        'receiver': {'key': 'Receiver', 'type': 'ReceiverChild'},
        'last_data_update': {'key': 'LastDataUpdate', 'type': 'iso-8601'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: int,
        serial_number: str,
        nickname: Optional[str] = None,
        location: Optional["LocationChild"] = None,
        corporation: Optional["CorporationChild"] = None,
        last_status_update: Optional[datetime.datetime] = None,
        push_to_stage: Optional[bool] = None,
        release_ring: Optional["ReleaseRingChild"] = None,
        targeted_software_release: Optional["TargetedSoftwareReleaseChild"] = None,
        current_software_release: Optional["CurrentSoftwareReleaseChild"] = None,
        hardware_revision: Optional["HardwareRevisionChild"] = None,
        receiver: Optional["ReceiverChild"] = None,
        last_data_update: Optional[datetime.datetime] = None,
        is_online: Optional[bool] = None,
        **kwargs
    ):
        super(BaseStationResponse, self).__init__(**kwargs)
        self.id = id
        self.serial_number = serial_number
        self.nickname = nickname
        self.location = location
        self.corporation = corporation
        self.last_status_update = last_status_update
        self.push_to_stage = push_to_stage
        self.release_ring = release_ring
        self.targeted_software_release = targeted_software_release
        self.current_software_release = current_software_release
        self.hardware_revision = hardware_revision
        self.receiver = receiver
        self.last_data_update = last_data_update
        self.is_online = is_online


class BaseStationUpdateRequest(msrest.serialization.Model):
    """BaseStationUpdateRequest.

    :param nickname:
    :type nickname: str
    :param location_id:
    :type location_id: str
    :param release_ring_id:
    :type release_ring_id: str
    :param push_to_stage:
    :type push_to_stage: bool
    """

    _validation = {
        'nickname': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'release_ring_id': {'key': 'ReleaseRingId', 'type': 'str'},
        'push_to_stage': {'key': 'PushToStage', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        nickname: Optional[str] = None,
        location_id: Optional[str] = None,
        release_ring_id: Optional[str] = None,
        push_to_stage: Optional[bool] = None,
        **kwargs
    ):
        super(BaseStationUpdateRequest, self).__init__(**kwargs)
        self.nickname = nickname
        self.location_id = location_id
        self.release_ring_id = release_ring_id
        self.push_to_stage = push_to_stage


class BearingChild(msrest.serialization.Model):
    """BearingChild.

    :param bearing_id:
    :type bearing_id: str
    :param bearing_name:
    :type bearing_name: str
    :param bearing_manufacturer:
    :type bearing_manufacturer: str
    :param bearing_bpfi:
    :type bearing_bpfi: float
    """

    _attribute_map = {
        'bearing_id': {'key': 'BearingId', 'type': 'str'},
        'bearing_name': {'key': 'BearingName', 'type': 'str'},
        'bearing_manufacturer': {'key': 'BearingManufacturer', 'type': 'str'},
        'bearing_bpfi': {'key': 'BearingBpfi', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        bearing_id: Optional[str] = None,
        bearing_name: Optional[str] = None,
        bearing_manufacturer: Optional[str] = None,
        bearing_bpfi: Optional[float] = None,
        **kwargs
    ):
        super(BearingChild, self).__init__(**kwargs)
        self.bearing_id = bearing_id
        self.bearing_name = bearing_name
        self.bearing_manufacturer = bearing_manufacturer
        self.bearing_bpfi = bearing_bpfi


class BearingResponse(msrest.serialization.Model):
    """BearingResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name:
    :type name: str
    :param manufacturer:
    :type manufacturer: str
    :param roller_count:
    :type roller_count: long
    :param ftf:
    :type ftf: float
    :param bsf:
    :type bsf: float
    :param bpfo:
    :type bpfo: float
    :param bpfi:
    :type bpfi: float
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'manufacturer': {'key': 'Manufacturer', 'type': 'str'},
        'roller_count': {'key': 'RollerCount', 'type': 'long'},
        'ftf': {'key': 'Ftf', 'type': 'float'},
        'bsf': {'key': 'Bsf', 'type': 'float'},
        'bpfo': {'key': 'Bpfo', 'type': 'float'},
        'bpfi': {'key': 'Bpfi', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: Optional[str] = None,
        manufacturer: Optional[str] = None,
        roller_count: Optional[int] = None,
        ftf: Optional[float] = None,
        bsf: Optional[float] = None,
        bpfo: Optional[float] = None,
        bpfi: Optional[float] = None,
        **kwargs
    ):
        super(BearingResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.manufacturer = manufacturer
        self.roller_count = roller_count
        self.ftf = ftf
        self.bsf = bsf
        self.bpfo = bpfo
        self.bpfi = bpfi


class CorporationChild(msrest.serialization.Model):
    """CorporationChild.

    All required parameters must be populated in order to send to Azure.

    :param corporation_id: Required.
    :type corporation_id: str
    :param corporation_name: Required.
    :type corporation_name: str
    :param corporation_abbreviation:
    :type corporation_abbreviation: str
    """

    _validation = {
        'corporation_id': {'required': True},
        'corporation_name': {'required': True},
    }

    _attribute_map = {
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'corporation_abbreviation': {'key': 'CorporationAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        corporation_id: str,
        corporation_name: str,
        corporation_abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(CorporationChild, self).__init__(**kwargs)
        self.corporation_id = corporation_id
        self.corporation_name = corporation_name
        self.corporation_abbreviation = corporation_abbreviation


class CorporationCreateRequest(msrest.serialization.Model):
    """CorporationCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param industry_id:
    :type industry_id: int
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'industry_id': {'key': 'IndustryId', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        abbreviation: Optional[str] = None,
        industry_id: Optional[int] = None,
        **kwargs
    ):
        super(CorporationCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.industry_id = industry_id


class CorporationIndustryChild(msrest.serialization.Model):
    """CorporationIndustryChild.

    All required parameters must be populated in order to send to Azure.

    :param industry_id: Required.
    :type industry_id: int
    :param industry_name: Required.
    :type industry_name: str
    """

    _validation = {
        'industry_id': {'required': True},
        'industry_name': {'required': True},
    }

    _attribute_map = {
        'industry_id': {'key': 'IndustryId', 'type': 'int'},
        'industry_name': {'key': 'IndustryName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        industry_id: int,
        industry_name: str,
        **kwargs
    ):
        super(CorporationIndustryChild, self).__init__(**kwargs)
        self.industry_id = industry_id
        self.industry_name = industry_name


class CorporationResponse(msrest.serialization.Model):
    """CorporationResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param icon_url:
    :type icon_url: str
    :param active:
    :type active: bool
    :param created:
    :type created: ~datetime.datetime
    :param industry:
    :type industry: ~smartdiagnostics_sdk.models.CorporationIndustryChild
    :param locations:
    :type locations: list[~smartdiagnostics_sdk.models.LocationChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'icon_url': {'key': 'IconUrl', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'industry': {'key': 'Industry', 'type': 'CorporationIndustryChild'},
        'locations': {'key': 'Locations', 'type': '[LocationChild]'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        abbreviation: Optional[str] = None,
        icon_url: Optional[str] = None,
        active: Optional[bool] = None,
        created: Optional[datetime.datetime] = None,
        industry: Optional["CorporationIndustryChild"] = None,
        locations: Optional[List["LocationChild"]] = None,
        **kwargs
    ):
        super(CorporationResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.icon_url = icon_url
        self.active = active
        self.created = created
        self.industry = industry
        self.locations = locations


class CorporationUpdateRequest(msrest.serialization.Model):
    """CorporationUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param industry_id:
    :type industry_id: int
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'active': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'industry_id': {'key': 'IndustryId', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        active: bool,
        abbreviation: Optional[str] = None,
        industry_id: Optional[int] = None,
        **kwargs
    ):
        super(CorporationUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.industry_id = industry_id


class CurrentSoftwareReleaseChild(msrest.serialization.Model):
    """CurrentSoftwareReleaseChild.

    :param current_software_release_id:
    :type current_software_release_id: int
    :param current_software_release_name:
    :type current_software_release_name: str
    """

    _attribute_map = {
        'current_software_release_id': {'key': 'CurrentSoftwareReleaseId', 'type': 'int'},
        'current_software_release_name': {'key': 'CurrentSoftwareReleaseName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        current_software_release_id: Optional[int] = None,
        current_software_release_name: Optional[str] = None,
        **kwargs
    ):
        super(CurrentSoftwareReleaseChild, self).__init__(**kwargs)
        self.current_software_release_id = current_software_release_id
        self.current_software_release_name = current_software_release_name


class CurrentUserResponse(msrest.serialization.Model):
    """CurrentUserResponse.

    :param id:
    :type id: str
    :param email:
    :type email: str
    :param first_name:
    :type first_name: str
    :param last_name:
    :type last_name: str
    :param phone_number:
    :type phone_number: str
    :param application_role:  Possible values include: "Invalid", "SaasAdmin", "AccountAdmin",
     "ApplicationUser", "Technician", "User", "SystemProcess", "Sentry", "Sales",
     "CorporationAdmin", "CorporationUser", "CorporationNone".
    :type application_role: str or ~smartdiagnostics_sdk.models.CurrentUserResponseApplicationRole
    :param corporations:
    :type corporations: list[~smartdiagnostics_sdk.models.UserCorporationChild]
    :param locations:
    :type locations: list[~smartdiagnostics_sdk.models.UserLocationChild]
    :param profile:
    :type profile: ~smartdiagnostics_sdk.models.ProfileChild
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'email': {'key': 'Email', 'type': 'str'},
        'first_name': {'key': 'FirstName', 'type': 'str'},
        'last_name': {'key': 'LastName', 'type': 'str'},
        'phone_number': {'key': 'PhoneNumber', 'type': 'str'},
        'application_role': {'key': 'ApplicationRole', 'type': 'str'},
        'corporations': {'key': 'Corporations', 'type': '[UserCorporationChild]'},
        'locations': {'key': 'Locations', 'type': '[UserLocationChild]'},
        'profile': {'key': 'Profile', 'type': 'ProfileChild'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        email: Optional[str] = None,
        first_name: Optional[str] = None,
        last_name: Optional[str] = None,
        phone_number: Optional[str] = None,
        application_role: Optional[Union[str, "CurrentUserResponseApplicationRole"]] = None,
        corporations: Optional[List["UserCorporationChild"]] = None,
        locations: Optional[List["UserLocationChild"]] = None,
        profile: Optional["ProfileChild"] = None,
        **kwargs
    ):
        super(CurrentUserResponse, self).__init__(**kwargs)
        self.id = id
        self.email = email
        self.first_name = first_name
        self.last_name = last_name
        self.phone_number = phone_number
        self.application_role = application_role
        self.corporations = corporations
        self.locations = locations
        self.profile = profile


class CustomMarkerChild(msrest.serialization.Model):
    """CustomMarkerChild.

    All required parameters must be populated in order to send to Azure.

    :param custom_marker_id: Required.
    :type custom_marker_id: str
    :param custom_marker_name:
    :type custom_marker_name: str
    :param custom_marker_show_harmonics: Required.
    :type custom_marker_show_harmonics: bool
    :param custom_marker_show_side_bands: Required.
    :type custom_marker_show_side_bands: bool
    :param custom_marker_show_peaks: Required.
    :type custom_marker_show_peaks: bool
    """

    _validation = {
        'custom_marker_id': {'required': True},
        'custom_marker_name': {'max_length': 5, 'min_length': 0},
        'custom_marker_show_harmonics': {'required': True},
        'custom_marker_show_side_bands': {'required': True},
        'custom_marker_show_peaks': {'required': True},
    }

    _attribute_map = {
        'custom_marker_id': {'key': 'CustomMarkerId', 'type': 'str'},
        'custom_marker_name': {'key': 'CustomMarkerName', 'type': 'str'},
        'custom_marker_show_harmonics': {'key': 'CustomMarkerShowHarmonics', 'type': 'bool'},
        'custom_marker_show_side_bands': {'key': 'CustomMarkerShowSideBands', 'type': 'bool'},
        'custom_marker_show_peaks': {'key': 'CustomMarkerShowPeaks', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        custom_marker_id: str,
        custom_marker_show_harmonics: bool,
        custom_marker_show_side_bands: bool,
        custom_marker_show_peaks: bool,
        custom_marker_name: Optional[str] = None,
        **kwargs
    ):
        super(CustomMarkerChild, self).__init__(**kwargs)
        self.custom_marker_id = custom_marker_id
        self.custom_marker_name = custom_marker_name
        self.custom_marker_show_harmonics = custom_marker_show_harmonics
        self.custom_marker_show_side_bands = custom_marker_show_side_bands
        self.custom_marker_show_peaks = custom_marker_show_peaks


class DashboardCreateRequest(msrest.serialization.Model):
    """DashboardCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name:
    :type name: str
    :param description:
    :type description: str
    :param template_id: Required.
    :type template_id: int
    :param corporation_id: Required.
    :type corporation_id: str
    :param location_id:
    :type location_id: str
    :param time_range:  Possible values include: "OneWeek", "EightHours", "OneDay", "OneMonth",
     "OneYear".
    :type time_range: str or ~smartdiagnostics_sdk.models.DashboardCreateRequestTimeRange
    :param power_bi_report_url:
    :type power_bi_report_url: str
    """

    _validation = {
        'name': {'max_length': 128, 'min_length': 0},
        'description': {'max_length': 1000, 'min_length': 0},
        'template_id': {'required': True},
        'corporation_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'template_id': {'key': 'TemplateId', 'type': 'int'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'time_range': {'key': 'TimeRange', 'type': 'str'},
        'power_bi_report_url': {'key': 'PowerBiReportUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        template_id: int,
        corporation_id: str,
        name: Optional[str] = None,
        description: Optional[str] = None,
        location_id: Optional[str] = None,
        time_range: Optional[Union[str, "DashboardCreateRequestTimeRange"]] = None,
        power_bi_report_url: Optional[str] = None,
        **kwargs
    ):
        super(DashboardCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.template_id = template_id
        self.corporation_id = corporation_id
        self.location_id = location_id
        self.time_range = time_range
        self.power_bi_report_url = power_bi_report_url


class DashboardPermissionsUpdateRequest(msrest.serialization.Model):
    """DashboardPermissionsUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param is_sentry_managed: Required.
    :type is_sentry_managed: bool
    :param is_visible_to_customers: Required.
    :type is_visible_to_customers: bool
    """

    _validation = {
        'is_sentry_managed': {'required': True},
        'is_visible_to_customers': {'required': True},
    }

    _attribute_map = {
        'is_sentry_managed': {'key': 'IsSentryManaged', 'type': 'bool'},
        'is_visible_to_customers': {'key': 'IsVisibleToCustomers', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        is_sentry_managed: bool,
        is_visible_to_customers: bool,
        **kwargs
    ):
        super(DashboardPermissionsUpdateRequest, self).__init__(**kwargs)
        self.is_sentry_managed = is_sentry_managed
        self.is_visible_to_customers = is_visible_to_customers


class DashboardResponse(msrest.serialization.Model):
    """DashboardResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param description:
    :type description: str
    :param is_sentry_managed: Required.
    :type is_sentry_managed: bool
    :param is_visible_to_customers: Required.
    :type is_visible_to_customers: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param updated: Required.
    :type updated: ~datetime.datetime
    :param created_by:
    :type created_by: ~smartdiagnostics_sdk.models.UserChild
    :param updated_by:
    :type updated_by: ~smartdiagnostics_sdk.models.UserChild
    :param dashboard_type:
    :type dashboard_type: ~smartdiagnostics_sdk.models.DashboardTypeChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.PrimaryCorporationChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param dashboard_widgets:
    :type dashboard_widgets: list[~smartdiagnostics_sdk.models.DashboardWidgetChild]
    :param power_bi_report:
    :type power_bi_report: ~smartdiagnostics_sdk.models.PowerBiReportChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'is_sentry_managed': {'required': True},
        'is_visible_to_customers': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'is_sentry_managed': {'key': 'IsSentryManaged', 'type': 'bool'},
        'is_visible_to_customers': {'key': 'IsVisibleToCustomers', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'created_by': {'key': 'CreatedBy', 'type': 'UserChild'},
        'updated_by': {'key': 'UpdatedBy', 'type': 'UserChild'},
        'dashboard_type': {'key': 'DashboardType', 'type': 'DashboardTypeChild'},
        'corporation': {'key': 'Corporation', 'type': 'PrimaryCorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'dashboard_widgets': {'key': 'DashboardWidgets', 'type': '[DashboardWidgetChild]'},
        'power_bi_report': {'key': 'PowerBiReport', 'type': 'PowerBiReportChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        is_sentry_managed: bool,
        is_visible_to_customers: bool,
        created: datetime.datetime,
        updated: datetime.datetime,
        description: Optional[str] = None,
        created_by: Optional["UserChild"] = None,
        updated_by: Optional["UserChild"] = None,
        dashboard_type: Optional["DashboardTypeChild"] = None,
        corporation: Optional["PrimaryCorporationChild"] = None,
        location: Optional["LocationChild"] = None,
        dashboard_widgets: Optional[List["DashboardWidgetChild"]] = None,
        power_bi_report: Optional["PowerBiReportChild"] = None,
        **kwargs
    ):
        super(DashboardResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.is_sentry_managed = is_sentry_managed
        self.is_visible_to_customers = is_visible_to_customers
        self.created = created
        self.updated = updated
        self.created_by = created_by
        self.updated_by = updated_by
        self.dashboard_type = dashboard_type
        self.corporation = corporation
        self.location = location
        self.dashboard_widgets = dashboard_widgets
        self.power_bi_report = power_bi_report


class DashboardTemplateResponse(msrest.serialization.Model):
    """DashboardTemplateResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    :param description:
    :type description: str
    :param dashboard_type_id:
    :type dashboard_type_id: int
    :param widget_templates:
    :type widget_templates: list[~smartdiagnostics_sdk.models.WidgetTemplateChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'dashboard_type_id': {'key': 'DashboardTypeId', 'type': 'int'},
        'widget_templates': {'key': 'WidgetTemplates', 'type': '[WidgetTemplateChild]'},
    }

    def __init__(
        self,
        *,
        id: int,
        name: str,
        description: Optional[str] = None,
        dashboard_type_id: Optional[int] = None,
        widget_templates: Optional[List["WidgetTemplateChild"]] = None,
        **kwargs
    ):
        super(DashboardTemplateResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.description = description
        self.dashboard_type_id = dashboard_type_id
        self.widget_templates = widget_templates


class DashboardTypeChild(msrest.serialization.Model):
    """DashboardTypeChild.

    All required parameters must be populated in order to send to Azure.

    :param dashboard_type_id: Required.
    :type dashboard_type_id: int
    :param dashboard_type_name: Required.
    :type dashboard_type_name: str
    """

    _validation = {
        'dashboard_type_id': {'required': True},
        'dashboard_type_name': {'required': True},
    }

    _attribute_map = {
        'dashboard_type_id': {'key': 'DashboardTypeId', 'type': 'int'},
        'dashboard_type_name': {'key': 'DashboardTypeName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        dashboard_type_id: int,
        dashboard_type_name: str,
        **kwargs
    ):
        super(DashboardTypeChild, self).__init__(**kwargs)
        self.dashboard_type_id = dashboard_type_id
        self.dashboard_type_name = dashboard_type_name


class DashboardUpdateRequest(msrest.serialization.Model):
    """DashboardUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param description:
    :type description: str
    :param time_range:  Possible values include: "OneWeek", "EightHours", "OneDay", "OneMonth",
     "OneYear".
    :type time_range: str or ~smartdiagnostics_sdk.models.DashboardUpdateRequestTimeRange
    :param dashboard_widgets:
    :type dashboard_widgets: list[~smartdiagnostics_sdk.models.DashboardWidgetRequestChild]
    """

    _validation = {
        'name': {'required': True, 'max_length': 128, 'min_length': 0},
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'time_range': {'key': 'TimeRange', 'type': 'str'},
        'dashboard_widgets': {'key': 'DashboardWidgets', 'type': '[DashboardWidgetRequestChild]'},
    }

    def __init__(
        self,
        *,
        name: str,
        description: Optional[str] = None,
        time_range: Optional[Union[str, "DashboardUpdateRequestTimeRange"]] = None,
        dashboard_widgets: Optional[List["DashboardWidgetRequestChild"]] = None,
        **kwargs
    ):
        super(DashboardUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.description = description
        self.time_range = time_range
        self.dashboard_widgets = dashboard_widgets


class DashboardWidgetChild(msrest.serialization.Model):
    """DashboardWidgetChild.

    All required parameters must be populated in order to send to Azure.

    :param dashboard_widget_id: Required.
    :type dashboard_widget_id: str
    :param dashboard_widget_name: Required.
    :type dashboard_widget_name: str
    :param dashboard_widget_refresh_interval:
    :type dashboard_widget_refresh_interval: int
    :param dashboard_widget_layout:
    :type dashboard_widget_layout: ~smartdiagnostics_sdk.models.LayoutChild
    :param widget:
    :type widget: ~smartdiagnostics_sdk.models.WidgetChild
    """

    _validation = {
        'dashboard_widget_id': {'required': True},
        'dashboard_widget_name': {'required': True},
    }

    _attribute_map = {
        'dashboard_widget_id': {'key': 'DashboardWidgetId', 'type': 'str'},
        'dashboard_widget_name': {'key': 'DashboardWidgetName', 'type': 'str'},
        'dashboard_widget_refresh_interval': {'key': 'DashboardWidgetRefreshInterval', 'type': 'int'},
        'dashboard_widget_layout': {'key': 'DashboardWidgetLayout', 'type': 'LayoutChild'},
        'widget': {'key': 'Widget', 'type': 'WidgetChild'},
    }

    def __init__(
        self,
        *,
        dashboard_widget_id: str,
        dashboard_widget_name: str,
        dashboard_widget_refresh_interval: Optional[int] = None,
        dashboard_widget_layout: Optional["LayoutChild"] = None,
        widget: Optional["WidgetChild"] = None,
        **kwargs
    ):
        super(DashboardWidgetChild, self).__init__(**kwargs)
        self.dashboard_widget_id = dashboard_widget_id
        self.dashboard_widget_name = dashboard_widget_name
        self.dashboard_widget_refresh_interval = dashboard_widget_refresh_interval
        self.dashboard_widget_layout = dashboard_widget_layout
        self.widget = widget


class DashboardWidgetRequestChild(msrest.serialization.Model):
    """DashboardWidgetRequestChild.

    All required parameters must be populated in order to send to Azure.

    :param dashboard_widget_id: Required.
    :type dashboard_widget_id: str
    :param dashboard_widget_row: Required.
    :type dashboard_widget_row: int
    :param dashboard_widget_column: Required.
    :type dashboard_widget_column: int
    :param dashboard_widget_height: Required.
    :type dashboard_widget_height: int
    :param dashboard_widget_width: Required.
    :type dashboard_widget_width: int
    """

    _validation = {
        'dashboard_widget_id': {'required': True},
        'dashboard_widget_row': {'required': True},
        'dashboard_widget_column': {'required': True},
        'dashboard_widget_height': {'required': True},
        'dashboard_widget_width': {'required': True},
    }

    _attribute_map = {
        'dashboard_widget_id': {'key': 'DashboardWidgetId', 'type': 'str'},
        'dashboard_widget_row': {'key': 'DashboardWidgetRow', 'type': 'int'},
        'dashboard_widget_column': {'key': 'DashboardWidgetColumn', 'type': 'int'},
        'dashboard_widget_height': {'key': 'DashboardWidgetHeight', 'type': 'int'},
        'dashboard_widget_width': {'key': 'DashboardWidgetWidth', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        dashboard_widget_id: str,
        dashboard_widget_row: int,
        dashboard_widget_column: int,
        dashboard_widget_height: int,
        dashboard_widget_width: int,
        **kwargs
    ):
        super(DashboardWidgetRequestChild, self).__init__(**kwargs)
        self.dashboard_widget_id = dashboard_widget_id
        self.dashboard_widget_row = dashboard_widget_row
        self.dashboard_widget_column = dashboard_widget_column
        self.dashboard_widget_height = dashboard_widget_height
        self.dashboard_widget_width = dashboard_widget_width


class DescendantChild(msrest.serialization.Model):
    """DescendantChild.

    :param child_id:
    :type child_id: str
    :param child_name:
    :type child_name: str
    :param child_abbreviation:
    :type child_abbreviation: str
    :param child_type:  Possible values include: "Asset", "MonitoringPoint", "IndicatorGroup",
     "Group", "AnalyticModel".
    :type child_type: str or ~smartdiagnostics_sdk.models.DescendantChildType
    :param child_sort_order:
    :type child_sort_order: int
    :param child_has_children:
    :type child_has_children: bool
    :param child_alarm_severity_level:
    :type child_alarm_severity_level: int
    :param child_is_paused:
    :type child_is_paused: bool
    :param child_is_snoozed:
    :type child_is_snoozed: bool
    """

    _attribute_map = {
        'child_id': {'key': 'ChildId', 'type': 'str'},
        'child_name': {'key': 'ChildName', 'type': 'str'},
        'child_abbreviation': {'key': 'ChildAbbreviation', 'type': 'str'},
        'child_type': {'key': 'ChildType', 'type': 'str'},
        'child_sort_order': {'key': 'ChildSortOrder', 'type': 'int'},
        'child_has_children': {'key': 'ChildHasChildren', 'type': 'bool'},
        'child_alarm_severity_level': {'key': 'ChildAlarmSeverityLevel', 'type': 'int'},
        'child_is_paused': {'key': 'ChildIsPaused', 'type': 'bool'},
        'child_is_snoozed': {'key': 'ChildIsSnoozed', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        child_id: Optional[str] = None,
        child_name: Optional[str] = None,
        child_abbreviation: Optional[str] = None,
        child_type: Optional[Union[str, "DescendantChildType"]] = None,
        child_sort_order: Optional[int] = None,
        child_has_children: Optional[bool] = None,
        child_alarm_severity_level: Optional[int] = None,
        child_is_paused: Optional[bool] = None,
        child_is_snoozed: Optional[bool] = None,
        **kwargs
    ):
        super(DescendantChild, self).__init__(**kwargs)
        self.child_id = child_id
        self.child_name = child_name
        self.child_abbreviation = child_abbreviation
        self.child_type = child_type
        self.child_sort_order = child_sort_order
        self.child_has_children = child_has_children
        self.child_alarm_severity_level = child_alarm_severity_level
        self.child_is_paused = child_is_paused
        self.child_is_snoozed = child_is_snoozed


class EventModelV3(msrest.serialization.Model):
    """EventModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id:
    :type id: str
    :param location_id:
    :type location_id: str
    :param window_id:
    :type window_id: str
    :param date_occurred: Required.
    :type date_occurred: ~datetime.datetime
    :param description:
    :type description: str
    :param reason:
    :type reason: str
    :param content_type: Required.  Possible values include: "Invalid", "OperationalCondition",
     "Fault", "RootCause", "Evidence", "Inspection", "PreventativeMaintenance",
     "CorrectiveMaintenance", "Observation", "Document", "Description", "SamplingFrequencyChange",
     "PendingSamplingFrequencyChange", "AutoInvalidBurstData", "UserInvalidBurstData".
    :type content_type: str or ~smartdiagnostics_sdk.models.EventModelV3ContentType
    :param attachment: Required.
    :type attachment: ~smartdiagnostics_sdk.models.AttachmentModelV3
    :param code_ids:
    :type code_ids: list[str]
    :param tag_details:
    :type tag_details: list[str]
    :param document_url:
    :type document_url: str
    :param document_name:
    :type document_name: str
    :param title:
    :type title: str
    :param evidence_indicator_id:
    :type evidence_indicator_id: str
    :param created:
    :type created: ~datetime.datetime
    :param created_by:
    :type created_by: str
    :param modified:
    :type modified: ~datetime.datetime
    :param modified_by:
    :type modified_by: str
    :param savings:
    :type savings: float
    :param group_name:
    :type group_name: str
    :param group_path:
    :type group_path: str
    :param group_type:  Possible values include: "Invalid", "Group", "Asset", "MonitoringPoint",
     "IndicatorGroup", "AnalyticModel".
    :type group_type: str or ~smartdiagnostics_sdk.models.EventModelV3GroupType
    """

    _validation = {
        'date_occurred': {'required': True},
        'content_type': {'required': True},
        'attachment': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'window_id': {'key': 'WindowId', 'type': 'str'},
        'date_occurred': {'key': 'DateOccurred', 'type': 'iso-8601'},
        'description': {'key': 'Description', 'type': 'str'},
        'reason': {'key': 'Reason', 'type': 'str'},
        'content_type': {'key': 'ContentType', 'type': 'str'},
        'attachment': {'key': 'Attachment', 'type': 'AttachmentModelV3'},
        'code_ids': {'key': 'CodeIds', 'type': '[str]'},
        'tag_details': {'key': 'TagDetails', 'type': '[str]'},
        'document_url': {'key': 'DocumentUrl', 'type': 'str'},
        'document_name': {'key': 'DocumentName', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'evidence_indicator_id': {'key': 'EvidenceIndicatorId', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'created_by': {'key': 'CreatedBy', 'type': 'str'},
        'modified': {'key': 'Modified', 'type': 'iso-8601'},
        'modified_by': {'key': 'ModifiedBy', 'type': 'str'},
        'savings': {'key': 'Savings', 'type': 'float'},
        'group_name': {'key': 'GroupName', 'type': 'str'},
        'group_path': {'key': 'GroupPath', 'type': 'str'},
        'group_type': {'key': 'GroupType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        date_occurred: datetime.datetime,
        content_type: Union[str, "EventModelV3ContentType"],
        attachment: "AttachmentModelV3",
        id: Optional[str] = None,
        location_id: Optional[str] = None,
        window_id: Optional[str] = None,
        description: Optional[str] = None,
        reason: Optional[str] = None,
        code_ids: Optional[List[str]] = None,
        tag_details: Optional[List[str]] = None,
        document_url: Optional[str] = None,
        document_name: Optional[str] = None,
        title: Optional[str] = None,
        evidence_indicator_id: Optional[str] = None,
        created: Optional[datetime.datetime] = None,
        created_by: Optional[str] = None,
        modified: Optional[datetime.datetime] = None,
        modified_by: Optional[str] = None,
        savings: Optional[float] = None,
        group_name: Optional[str] = None,
        group_path: Optional[str] = None,
        group_type: Optional[Union[str, "EventModelV3GroupType"]] = None,
        **kwargs
    ):
        super(EventModelV3, self).__init__(**kwargs)
        self.id = id
        self.location_id = location_id
        self.window_id = window_id
        self.date_occurred = date_occurred
        self.description = description
        self.reason = reason
        self.content_type = content_type
        self.attachment = attachment
        self.code_ids = code_ids
        self.tag_details = tag_details
        self.document_url = document_url
        self.document_name = document_name
        self.title = title
        self.evidence_indicator_id = evidence_indicator_id
        self.created = created
        self.created_by = created_by
        self.modified = modified
        self.modified_by = modified_by
        self.savings = savings
        self.group_name = group_name
        self.group_path = group_path
        self.group_type = group_type


class ExternalNotificationChild(msrest.serialization.Model):
    """ExternalNotificationChild.

    :param external_notification_id:
    :type external_notification_id: str
    :param external_notification_requested_time:
    :type external_notification_requested_time: ~datetime.datetime
    :param external_notification_user:
    :type external_notification_user: ~smartdiagnostics_sdk.models.UserChild
    """

    _attribute_map = {
        'external_notification_id': {'key': 'ExternalNotificationId', 'type': 'str'},
        'external_notification_requested_time': {'key': 'ExternalNotificationRequestedTime', 'type': 'iso-8601'},
        'external_notification_user': {'key': 'ExternalNotificationUser', 'type': 'UserChild'},
    }

    def __init__(
        self,
        *,
        external_notification_id: Optional[str] = None,
        external_notification_requested_time: Optional[datetime.datetime] = None,
        external_notification_user: Optional["UserChild"] = None,
        **kwargs
    ):
        super(ExternalNotificationChild, self).__init__(**kwargs)
        self.external_notification_id = external_notification_id
        self.external_notification_requested_time = external_notification_requested_time
        self.external_notification_user = external_notification_user


class FileResponse(msrest.serialization.Model):
    """FileResponse.

    All required parameters must be populated in order to send to Azure.

    :param type: Required.  Possible values include: "Invalid", "Picture", "Folder".
    :type type: str or ~smartdiagnostics_sdk.models.FileResponseType
    :param display_name:
    :type display_name: str
    :param parent_folder_id: Required.
    :type parent_folder_id: str
    :param description:
    :type description: str
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param group_ids: Ids of groups the file belongs to.
    :type group_ids: list[str]
    :param id:
    :type id: str
    :param file_name:
    :type file_name: str
    :param thumbnail_file_name:
    :type thumbnail_file_name: str
    :param creation_date:
    :type creation_date: ~datetime.datetime
    :param update_date:
    :type update_date: ~datetime.datetime
    :param file_count:
    :type file_count: int
    :param folder_count:
    :type folder_count: int
    :param is_root_folder:
    :type is_root_folder: bool
    :param tags: A set of tags.
    :type tags: list[~smartdiagnostics_sdk.models.TagChild]
    """

    _validation = {
        'type': {'required': True},
        'display_name': {'max_length': 223, 'min_length': 0},
        'parent_folder_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'parent_folder_id': {'key': 'ParentFolderId', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'group_ids': {'key': 'GroupIds', 'type': '[str]'},
        'id': {'key': 'Id', 'type': 'str'},
        'file_name': {'key': 'FileName', 'type': 'str'},
        'thumbnail_file_name': {'key': 'ThumbnailFileName', 'type': 'str'},
        'creation_date': {'key': 'CreationDate', 'type': 'iso-8601'},
        'update_date': {'key': 'UpdateDate', 'type': 'iso-8601'},
        'file_count': {'key': 'FileCount', 'type': 'int'},
        'folder_count': {'key': 'FolderCount', 'type': 'int'},
        'is_root_folder': {'key': 'IsRootFolder', 'type': 'bool'},
        'tags': {'key': 'Tags', 'type': '[TagChild]'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "FileResponseType"],
        parent_folder_id: str,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        location: Optional["LocationChild"] = None,
        corporation: Optional["CorporationChild"] = None,
        group_ids: Optional[List[str]] = None,
        id: Optional[str] = None,
        file_name: Optional[str] = None,
        thumbnail_file_name: Optional[str] = None,
        creation_date: Optional[datetime.datetime] = None,
        update_date: Optional[datetime.datetime] = None,
        file_count: Optional[int] = None,
        folder_count: Optional[int] = None,
        is_root_folder: Optional[bool] = None,
        tags: Optional[List["TagChild"]] = None,
        **kwargs
    ):
        super(FileResponse, self).__init__(**kwargs)
        self.type = type
        self.display_name = display_name
        self.parent_folder_id = parent_folder_id
        self.description = description
        self.location = location
        self.corporation = corporation
        self.group_ids = group_ids
        self.id = id
        self.file_name = file_name
        self.thumbnail_file_name = thumbnail_file_name
        self.creation_date = creation_date
        self.update_date = update_date
        self.file_count = file_count
        self.folder_count = folder_count
        self.is_root_folder = is_root_folder
        self.tags = tags


class FilesError(msrest.serialization.Model):
    """FilesError.

    :param file_id:
    :type file_id: str
    :param display_name:
    :type display_name: str
    :param message:
    :type message: str
    """

    _attribute_map = {
        'file_id': {'key': 'FileId', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'message': {'key': 'Message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_id: Optional[str] = None,
        display_name: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(FilesError, self).__init__(**kwargs)
        self.file_id = file_id
        self.display_name = display_name
        self.message = message


class FilesUpdateRequest(msrest.serialization.Model):
    """FilesUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param display_name:
    :type display_name: str
    :param parent_folder_id: Required.
    :type parent_folder_id: str
    :param description:
    :type description: str
    :param group_ids:
    :type group_ids: list[str]
    """

    _validation = {
        'display_name': {'max_length': 223, 'min_length': 0},
        'parent_folder_id': {'required': True},
    }

    _attribute_map = {
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'parent_folder_id': {'key': 'ParentFolderId', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'group_ids': {'key': 'GroupIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        parent_folder_id: str,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(FilesUpdateRequest, self).__init__(**kwargs)
        self.display_name = display_name
        self.parent_folder_id = parent_folder_id
        self.description = description
        self.group_ids = group_ids


class FrequencyDomainSettingChild(msrest.serialization.Model):
    """FrequencyDomainSettingChild.

    :param markers:
    :type markers: list[~smartdiagnostics_sdk.models.MarkerChild]
    :param custom_markers:
    :type custom_markers: list[~smartdiagnostics_sdk.models.CustomMarkerChild]
    :param selected_bearing:
    :type selected_bearing: str
    :param side_bands:
    :type side_bands: int
    :param side_band_frequency:
    :type side_band_frequency: int
    """

    _attribute_map = {
        'markers': {'key': 'Markers', 'type': '[MarkerChild]'},
        'custom_markers': {'key': 'CustomMarkers', 'type': '[CustomMarkerChild]'},
        'selected_bearing': {'key': 'SelectedBearing', 'type': 'str'},
        'side_bands': {'key': 'SideBands', 'type': 'int'},
        'side_band_frequency': {'key': 'SideBandFrequency', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        markers: Optional[List["MarkerChild"]] = None,
        custom_markers: Optional[List["CustomMarkerChild"]] = None,
        selected_bearing: Optional[str] = None,
        side_bands: Optional[int] = None,
        side_band_frequency: Optional[int] = None,
        **kwargs
    ):
        super(FrequencyDomainSettingChild, self).__init__(**kwargs)
        self.markers = markers
        self.custom_markers = custom_markers
        self.selected_bearing = selected_bearing
        self.side_bands = side_bands
        self.side_band_frequency = side_band_frequency


class GroupAlertsResponse(msrest.serialization.Model):
    """GroupAlertsResponse.

    :param indicator_id:
    :type indicator_id: str
    :param indicator_name:
    :type indicator_name: str
    :param indicator_sort_order:
    :type indicator_sort_order: int
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param time_of_alert:
    :type time_of_alert: ~datetime.datetime
    :param external_notification:
    :type external_notification: ~smartdiagnostics_sdk.models.ExternalNotificationChild
    """

    _attribute_map = {
        'indicator_id': {'key': 'IndicatorId', 'type': 'str'},
        'indicator_name': {'key': 'IndicatorName', 'type': 'str'},
        'indicator_sort_order': {'key': 'IndicatorSortOrder', 'type': 'int'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'time_of_alert': {'key': 'TimeOfAlert', 'type': 'iso-8601'},
        'external_notification': {'key': 'ExternalNotification', 'type': 'ExternalNotificationChild'},
    }

    def __init__(
        self,
        *,
        indicator_id: Optional[str] = None,
        indicator_name: Optional[str] = None,
        indicator_sort_order: Optional[int] = None,
        hierarchy: Optional[List["HierarchyChild"]] = None,
        time_of_alert: Optional[datetime.datetime] = None,
        external_notification: Optional["ExternalNotificationChild"] = None,
        **kwargs
    ):
        super(GroupAlertsResponse, self).__init__(**kwargs)
        self.indicator_id = indicator_id
        self.indicator_name = indicator_name
        self.indicator_sort_order = indicator_sort_order
        self.hierarchy = hierarchy
        self.time_of_alert = time_of_alert
        self.external_notification = external_notification


class GroupMoveRequest(msrest.serialization.Model):
    """GroupMoveRequest.

    All required parameters must be populated in order to send to Azure.

    :param sort_order: Required.
    :type sort_order: int
    :param parent_id: Required.
    :type parent_id: str
    """

    _validation = {
        'sort_order': {'required': True, 'maximum': 2147483647, 'minimum': 0},
        'parent_id': {'required': True},
    }

    _attribute_map = {
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'parent_id': {'key': 'ParentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        sort_order: int,
        parent_id: str,
        **kwargs
    ):
        super(GroupMoveRequest, self).__init__(**kwargs)
        self.sort_order = sort_order
        self.parent_id = parent_id


class GroupStatusResponse(msrest.serialization.Model):
    """GroupStatusResponse.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param id: Required.
    :type id: str
    :param alarm_count: Required.
    :type alarm_count: int
    :param warning_count: Required.
    :type warning_count: int
    :param damage_score:
    :type damage_score: float
    :param alarm_severity:
    :type alarm_severity: int
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    """

    _validation = {
        'name': {'required': True},
        'id': {'required': True},
        'alarm_count': {'required': True},
        'warning_count': {'required': True},
        'is_snoozed': {'required': True},
        'is_paused': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'id': {'key': 'Id', 'type': 'str'},
        'alarm_count': {'key': 'AlarmCount', 'type': 'int'},
        'warning_count': {'key': 'WarningCount', 'type': 'int'},
        'damage_score': {'key': 'DamageScore', 'type': 'float'},
        'alarm_severity': {'key': 'AlarmSeverity', 'type': 'int'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
    }

    def __init__(
        self,
        *,
        name: str,
        id: str,
        alarm_count: int,
        warning_count: int,
        is_snoozed: bool,
        is_paused: bool,
        damage_score: Optional[float] = None,
        alarm_severity: Optional[int] = None,
        hierarchy: Optional[List["HierarchyChild"]] = None,
        **kwargs
    ):
        super(GroupStatusResponse, self).__init__(**kwargs)
        self.name = name
        self.id = id
        self.alarm_count = alarm_count
        self.warning_count = warning_count
        self.damage_score = damage_score
        self.alarm_severity = alarm_severity
        self.is_snoozed = is_snoozed
        self.is_paused = is_paused
        self.hierarchy = hierarchy


class HardwareEventModelV3(msrest.serialization.Model):
    """HardwareEventModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. The Id of the hardware event.
    :type id: long
    :param hardware_type: The type of hardware that caused the event.
    :type hardware_type: str
    :param event_type: The event type that happened.
    :type event_type: str
    :param time_entered: Time hardware enter the event type.
    :type time_entered: ~datetime.datetime
    :param time_notified: Time notifications where sent out.
    :type time_notified: ~datetime.datetime
    :param time_exited: The time the hardware exited the event.
    :type time_exited: ~datetime.datetime
    :param time_acked: Time a user acknowledged the event.
    :type time_acked: ~datetime.datetime
    :param created: Time the log entry was created.
    :type created: ~datetime.datetime
    :param last_modified: Last time the event entry was modified.
    :type last_modified: ~datetime.datetime
    :param node: This class is meant to be used for all hardware Models.
    :type node: ~smartdiagnostics_sdk.models.HardwareModelV3
    :param collector: This class is meant to be used for all hardware Models.
    :type collector: ~smartdiagnostics_sdk.models.HardwareModelV3
    :param repeater: This class is meant to be used for all hardware Models.
    :type repeater: ~smartdiagnostics_sdk.models.HardwareModelV3
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'hardware_type': {'key': 'HardwareType', 'type': 'str'},
        'event_type': {'key': 'EventType', 'type': 'str'},
        'time_entered': {'key': 'TimeEntered', 'type': 'iso-8601'},
        'time_notified': {'key': 'TimeNotified', 'type': 'iso-8601'},
        'time_exited': {'key': 'TimeExited', 'type': 'iso-8601'},
        'time_acked': {'key': 'TimeAcked', 'type': 'iso-8601'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'last_modified': {'key': 'LastModified', 'type': 'iso-8601'},
        'node': {'key': 'Node', 'type': 'HardwareModelV3'},
        'collector': {'key': 'Collector', 'type': 'HardwareModelV3'},
        'repeater': {'key': 'Repeater', 'type': 'HardwareModelV3'},
    }

    def __init__(
        self,
        *,
        id: int,
        hardware_type: Optional[str] = None,
        event_type: Optional[str] = None,
        time_entered: Optional[datetime.datetime] = None,
        time_notified: Optional[datetime.datetime] = None,
        time_exited: Optional[datetime.datetime] = None,
        time_acked: Optional[datetime.datetime] = None,
        created: Optional[datetime.datetime] = None,
        last_modified: Optional[datetime.datetime] = None,
        node: Optional["HardwareModelV3"] = None,
        collector: Optional["HardwareModelV3"] = None,
        repeater: Optional["HardwareModelV3"] = None,
        **kwargs
    ):
        super(HardwareEventModelV3, self).__init__(**kwargs)
        self.id = id
        self.hardware_type = hardware_type
        self.event_type = event_type
        self.time_entered = time_entered
        self.time_notified = time_notified
        self.time_exited = time_exited
        self.time_acked = time_acked
        self.created = created
        self.last_modified = last_modified
        self.node = node
        self.collector = collector
        self.repeater = repeater


class HardwareModelV3(msrest.serialization.Model):
    """This class is meant to be used for all hardware Models.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. Hardware's Id.
    :type id: long
    :param serial_number: Required. Serial Number of hardware.
    :type serial_number: str
    :param nickname: Nickname of the hardware.
    :type nickname: str
    """

    _validation = {
        'id': {'required': True},
        'serial_number': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: int,
        serial_number: str,
        nickname: Optional[str] = None,
        **kwargs
    ):
        super(HardwareModelV3, self).__init__(**kwargs)
        self.id = id
        self.serial_number = serial_number
        self.nickname = nickname


class HardwareRevisionChild(msrest.serialization.Model):
    """HardwareRevisionChild.

    :param hardware_revision_id:
    :type hardware_revision_id: int
    :param hardware_revision_name:
    :type hardware_revision_name: str
    """

    _attribute_map = {
        'hardware_revision_id': {'key': 'HardwareRevisionId', 'type': 'int'},
        'hardware_revision_name': {'key': 'HardwareRevisionName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        hardware_revision_id: Optional[int] = None,
        hardware_revision_name: Optional[str] = None,
        **kwargs
    ):
        super(HardwareRevisionChild, self).__init__(**kwargs)
        self.hardware_revision_id = hardware_revision_id
        self.hardware_revision_name = hardware_revision_name


class HardwareStatusChild(msrest.serialization.Model):
    """HardwareStatusChild.

    :param location_id:
    :type location_id: str
    :param location_name:
    :type location_name: str
    :param location_abbreviation:
    :type location_abbreviation: str
    :param hardware_count:
    :type hardware_count: int
    :param unassigned_count:
    :type unassigned_count: int
    :param online_count:
    :type online_count: int
    :param offline_count:
    :type offline_count: int
    """

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'location_abbreviation': {'key': 'LocationAbbreviation', 'type': 'str'},
        'hardware_count': {'key': 'HardwareCount', 'type': 'int'},
        'unassigned_count': {'key': 'UnassignedCount', 'type': 'int'},
        'online_count': {'key': 'OnlineCount', 'type': 'int'},
        'offline_count': {'key': 'OfflineCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        location_id: Optional[str] = None,
        location_name: Optional[str] = None,
        location_abbreviation: Optional[str] = None,
        hardware_count: Optional[int] = None,
        unassigned_count: Optional[int] = None,
        online_count: Optional[int] = None,
        offline_count: Optional[int] = None,
        **kwargs
    ):
        super(HardwareStatusChild, self).__init__(**kwargs)
        self.location_id = location_id
        self.location_name = location_name
        self.location_abbreviation = location_abbreviation
        self.hardware_count = hardware_count
        self.unassigned_count = unassigned_count
        self.online_count = online_count
        self.offline_count = offline_count


class HardwareStatusResponse(msrest.serialization.Model):
    """HardwareStatusResponse.

    :param location_hardware_statuses:
    :type location_hardware_statuses: list[~smartdiagnostics_sdk.models.HardwareStatusChild]
    :param total_hardware_count:
    :type total_hardware_count: int
    :param total_unassigned_count:
    :type total_unassigned_count: int
    :param total_online_count:
    :type total_online_count: int
    :param total_offline_count:
    :type total_offline_count: int
    """

    _attribute_map = {
        'location_hardware_statuses': {'key': 'LocationHardwareStatuses', 'type': '[HardwareStatusChild]'},
        'total_hardware_count': {'key': 'TotalHardwareCount', 'type': 'int'},
        'total_unassigned_count': {'key': 'TotalUnassignedCount', 'type': 'int'},
        'total_online_count': {'key': 'TotalOnlineCount', 'type': 'int'},
        'total_offline_count': {'key': 'TotalOfflineCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        location_hardware_statuses: Optional[List["HardwareStatusChild"]] = None,
        total_hardware_count: Optional[int] = None,
        total_unassigned_count: Optional[int] = None,
        total_online_count: Optional[int] = None,
        total_offline_count: Optional[int] = None,
        **kwargs
    ):
        super(HardwareStatusResponse, self).__init__(**kwargs)
        self.location_hardware_statuses = location_hardware_statuses
        self.total_hardware_count = total_hardware_count
        self.total_unassigned_count = total_unassigned_count
        self.total_online_count = total_online_count
        self.total_offline_count = total_offline_count


class HeatmapReportRequest(msrest.serialization.Model):
    """HeatmapReportRequest.

    All required parameters must be populated in order to send to Azure.

    :param aggregate_level: Required. The level at which to aggregate the results. Possible values
     include: "Indicator", "MonitoringPoint", "Asset".
    :type aggregate_level: str or ~smartdiagnostics_sdk.models.HeatmapReportRequestAggregateLevel
    :param hours_per_bin: Required. The size (in hours) to use to split the given time range into
     parts.
    :type hours_per_bin: int
    :param filter_id: The filter to use. Optional.
    :type filter_id: str
    :param start_date: Required. The start date of the time range to get the report for. Nullable
     so Required can catch nulls, will not
     be null later.
    :type start_date: ~datetime.datetime
    :param end_date: Required. The end date of the time range to get the values for. Nullable so
     Required can catch nulls, will not
     be null later.
    :type end_date: ~datetime.datetime
    :param file_name: Required. The filename to use for the report.
    :type file_name: str
    """

    _validation = {
        'aggregate_level': {'required': True},
        'hours_per_bin': {'required': True},
        'start_date': {'required': True},
        'end_date': {'required': True},
        'file_name': {'required': True},
    }

    _attribute_map = {
        'aggregate_level': {'key': 'AggregateLevel', 'type': 'str'},
        'hours_per_bin': {'key': 'HoursPerBin', 'type': 'int'},
        'filter_id': {'key': 'FilterId', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
        'file_name': {'key': 'FileName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        aggregate_level: Union[str, "HeatmapReportRequestAggregateLevel"],
        hours_per_bin: int,
        start_date: datetime.datetime,
        end_date: datetime.datetime,
        file_name: str,
        filter_id: Optional[str] = None,
        **kwargs
    ):
        super(HeatmapReportRequest, self).__init__(**kwargs)
        self.aggregate_level = aggregate_level
        self.hours_per_bin = hours_per_bin
        self.filter_id = filter_id
        self.start_date = start_date
        self.end_date = end_date
        self.file_name = file_name


class HierarchyChild(msrest.serialization.Model):
    """HierarchyChild.

    :param hierarchy_id:
    :type hierarchy_id: str
    :param hierarchy_name:
    :type hierarchy_name: str
    :param hierarchy_abbreviation:
    :type hierarchy_abbreviation: str
    :param hierarchy_type:
    :type hierarchy_type: str
    """

    _attribute_map = {
        'hierarchy_id': {'key': 'HierarchyId', 'type': 'str'},
        'hierarchy_name': {'key': 'HierarchyName', 'type': 'str'},
        'hierarchy_abbreviation': {'key': 'HierarchyAbbreviation', 'type': 'str'},
        'hierarchy_type': {'key': 'HierarchyType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        hierarchy_id: Optional[str] = None,
        hierarchy_name: Optional[str] = None,
        hierarchy_abbreviation: Optional[str] = None,
        hierarchy_type: Optional[str] = None,
        **kwargs
    ):
        super(HierarchyChild, self).__init__(**kwargs)
        self.hierarchy_id = hierarchy_id
        self.hierarchy_name = hierarchy_name
        self.hierarchy_abbreviation = hierarchy_abbreviation
        self.hierarchy_type = hierarchy_type


class HubNodeChild(msrest.serialization.Model):
    """HubNodeChild.

    :param node_id:
    :type node_id: long
    :param node_serial_number:
    :type node_serial_number: str
    :param node_nickname:
    :type node_nickname: str
    :param is_online:
    :type is_online: bool
    :param node_settings:
    :type node_settings: list[~smartdiagnostics_sdk.models.NodeSettingChild]
    :param latest_long_burst:
    :type latest_long_burst: ~smartdiagnostics_sdk.models.LongBurstRequestChild
    """

    _attribute_map = {
        'node_id': {'key': 'NodeId', 'type': 'long'},
        'node_serial_number': {'key': 'NodeSerialNumber', 'type': 'str'},
        'node_nickname': {'key': 'NodeNickname', 'type': 'str'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
        'node_settings': {'key': 'NodeSettings', 'type': '[NodeSettingChild]'},
        'latest_long_burst': {'key': 'LatestLongBurst', 'type': 'LongBurstRequestChild'},
    }

    def __init__(
        self,
        *,
        node_id: Optional[int] = None,
        node_serial_number: Optional[str] = None,
        node_nickname: Optional[str] = None,
        is_online: Optional[bool] = None,
        node_settings: Optional[List["NodeSettingChild"]] = None,
        latest_long_burst: Optional["LongBurstRequestChild"] = None,
        **kwargs
    ):
        super(HubNodeChild, self).__init__(**kwargs)
        self.node_id = node_id
        self.node_serial_number = node_serial_number
        self.node_nickname = node_nickname
        self.is_online = is_online
        self.node_settings = node_settings
        self.latest_long_burst = latest_long_burst


class HubPortChild(msrest.serialization.Model):
    """HubPortChild.

    :param hub_port_id:
    :type hub_port_id: long
    :param hub_port_number:
    :type hub_port_number: int
    :param hub_port_node:
    :type hub_port_node: ~smartdiagnostics_sdk.models.HubNodeChild
    """

    _attribute_map = {
        'hub_port_id': {'key': 'HubPortId', 'type': 'long'},
        'hub_port_number': {'key': 'HubPortNumber', 'type': 'int'},
        'hub_port_node': {'key': 'HubPortNode', 'type': 'HubNodeChild'},
    }

    def __init__(
        self,
        *,
        hub_port_id: Optional[int] = None,
        hub_port_number: Optional[int] = None,
        hub_port_node: Optional["HubNodeChild"] = None,
        **kwargs
    ):
        super(HubPortChild, self).__init__(**kwargs)
        self.hub_port_id = hub_port_id
        self.hub_port_number = hub_port_number
        self.hub_port_node = hub_port_node


class HubResponse(msrest.serialization.Model):
    """HubResponse.

    :param id:
    :type id: long
    :param receiver:
    :type receiver: ~smartdiagnostics_sdk.models.ReceiverChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param serial_number:
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param power_type_id:  Possible values include: "Unspecified", "DC (24V)", "Battery", "AC
     (120V)".
    :type power_type_id: str or ~smartdiagnostics_sdk.models.HubResponsePowerTypeId
    :param firmware_version:
    :type firmware_version: str
    :param hub_type_id:  Possible values include: "Unknown", "Version 1 (SevenPort)".
    :type hub_type_id: str or ~smartdiagnostics_sdk.models.HubResponseHubTypeId
    :param created:
    :type created: ~datetime.datetime
    :param updated:
    :type updated: ~datetime.datetime
    :param packet_success_rate:
    :type packet_success_rate: float
    :param wireless_efficiency:
    :type wireless_efficiency: float
    :param is_online:
    :type is_online: bool
    :param triggering_enabled:
    :type triggering_enabled: bool
    :param ports:
    :type ports: list[~smartdiagnostics_sdk.models.HubPortChild]
    """

    _validation = {
        'serial_number': {'max_length': 16, 'min_length': 0},
        'nickname': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'receiver': {'key': 'Receiver', 'type': 'ReceiverChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'power_type_id': {'key': 'PowerTypeId', 'type': 'str'},
        'firmware_version': {'key': 'FirmwareVersion', 'type': 'str'},
        'hub_type_id': {'key': 'HubTypeId', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'packet_success_rate': {'key': 'PacketSuccessRate', 'type': 'float'},
        'wireless_efficiency': {'key': 'WirelessEfficiency', 'type': 'float'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
        'triggering_enabled': {'key': 'TriggeringEnabled', 'type': 'bool'},
        'ports': {'key': 'Ports', 'type': '[HubPortChild]'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        receiver: Optional["ReceiverChild"] = None,
        location: Optional["LocationChild"] = None,
        corporation: Optional["CorporationChild"] = None,
        serial_number: Optional[str] = None,
        nickname: Optional[str] = None,
        power_type_id: Optional[Union[str, "HubResponsePowerTypeId"]] = None,
        firmware_version: Optional[str] = None,
        hub_type_id: Optional[Union[str, "HubResponseHubTypeId"]] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        packet_success_rate: Optional[float] = None,
        wireless_efficiency: Optional[float] = None,
        is_online: Optional[bool] = None,
        triggering_enabled: Optional[bool] = None,
        ports: Optional[List["HubPortChild"]] = None,
        **kwargs
    ):
        super(HubResponse, self).__init__(**kwargs)
        self.id = id
        self.receiver = receiver
        self.location = location
        self.corporation = corporation
        self.serial_number = serial_number
        self.nickname = nickname
        self.power_type_id = power_type_id
        self.firmware_version = firmware_version
        self.hub_type_id = hub_type_id
        self.created = created
        self.updated = updated
        self.packet_success_rate = packet_success_rate
        self.wireless_efficiency = wireless_efficiency
        self.is_online = is_online
        self.triggering_enabled = triggering_enabled
        self.ports = ports


class IndicatorAlarmStateResponse(msrest.serialization.Model):
    """IndicatorAlarmStateResponse.

    All required parameters must be populated in order to send to Azure.

    :param current_value: Current Value of indicator.
    :type current_value: float
    :param last_update: Last time it was updated.
    :type last_update: ~datetime.datetime
    :param id: Required. Id of entity.
    :type id: str
    :param alarm_severity: Alarm severity.
    :type alarm_severity: int
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'current_value': {'key': 'CurrentValue', 'type': 'float'},
        'last_update': {'key': 'LastUpdate', 'type': 'iso-8601'},
        'id': {'key': 'Id', 'type': 'str'},
        'alarm_severity': {'key': 'AlarmSeverity', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        id: str,
        current_value: Optional[float] = None,
        last_update: Optional[datetime.datetime] = None,
        alarm_severity: Optional[int] = None,
        **kwargs
    ):
        super(IndicatorAlarmStateResponse, self).__init__(**kwargs)
        self.current_value = current_value
        self.last_update = last_update
        self.id = id
        self.alarm_severity = alarm_severity


class IndicatorFilterCreateRequest(msrest.serialization.Model):
    """IndicatorFilterCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param indicator_types:
    :type indicator_types: list[str or
     ~smartdiagnostics_sdk.models.IndicatorFilterCreateRequestIndicatorTypesItem]
    :param sort_order:
    :type sort_order: int
    :param tag_ids:
    :type tag_ids: list[str]
    :param location_id:
    :type location_id: str
    :param system_id:
    :type system_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'indicator_types': {'key': 'IndicatorTypes', 'type': '[str]'},
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'tag_ids': {'key': 'TagIds', 'type': '[str]'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'system_id': {'key': 'SystemId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        indicator_types: Optional[List[Union[str, "IndicatorFilterCreateRequestIndicatorTypesItem"]]] = None,
        sort_order: Optional[int] = None,
        tag_ids: Optional[List[str]] = None,
        location_id: Optional[str] = None,
        system_id: Optional[str] = None,
        **kwargs
    ):
        super(IndicatorFilterCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.indicator_types = indicator_types
        self.sort_order = sort_order
        self.tag_ids = tag_ids
        self.location_id = location_id
        self.system_id = system_id


class IndicatorFilterResponse(msrest.serialization.Model):
    """IndicatorFilterResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param is_global: Required.
    :type is_global: bool
    :param indicator_types:
    :type indicator_types: list[str or
     ~smartdiagnostics_sdk.models.IndicatorFilterResponseIndicatorTypesItem]
    :param sort_order:
    :type sort_order: int
    :param tags: A set of tags.
    :type tags: list[~smartdiagnostics_sdk.models.TagChild]
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param system:
    :type system: ~smartdiagnostics_sdk.models.SystemChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'is_global': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'is_global': {'key': 'IsGlobal', 'type': 'bool'},
        'indicator_types': {'key': 'IndicatorTypes', 'type': '[str]'},
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'tags': {'key': 'Tags', 'type': '[TagChild]'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'system': {'key': 'System', 'type': 'SystemChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        is_global: bool,
        indicator_types: Optional[List[Union[str, "IndicatorFilterResponseIndicatorTypesItem"]]] = None,
        sort_order: Optional[int] = None,
        tags: Optional[List["TagChild"]] = None,
        location: Optional["LocationChild"] = None,
        system: Optional["SystemChild"] = None,
        **kwargs
    ):
        super(IndicatorFilterResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.is_global = is_global
        self.indicator_types = indicator_types
        self.sort_order = sort_order
        self.tags = tags
        self.location = location
        self.system = system


class IndicatorFilterUpdateRequest(msrest.serialization.Model):
    """IndicatorFilterUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param indicator_types:
    :type indicator_types: list[str or
     ~smartdiagnostics_sdk.models.IndicatorFilterUpdateRequestIndicatorTypesItem]
    :param sort_order:
    :type sort_order: int
    :param tag_ids:
    :type tag_ids: list[str]
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'indicator_types': {'key': 'IndicatorTypes', 'type': '[str]'},
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'tag_ids': {'key': 'TagIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        name: str,
        indicator_types: Optional[List[Union[str, "IndicatorFilterUpdateRequestIndicatorTypesItem"]]] = None,
        sort_order: Optional[int] = None,
        tag_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(IndicatorFilterUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.indicator_types = indicator_types
        self.sort_order = sort_order
        self.tag_ids = tag_ids


class IndicatorGroupCreateRequest(msrest.serialization.Model):
    """IndicatorGroupCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param parent_id: Required.
    :type parent_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'parent_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'parent_id': {'key': 'ParentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        parent_id: str,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(IndicatorGroupCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.parent_id = parent_id


class IndicatorGroupResponse(msrest.serialization.Model):
    """IndicatorGroupResponse.

    All required parameters must be populated in order to send to Azure.

    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        active: bool,
        is_paused: bool,
        is_snoozed: bool,
        created: datetime.datetime,
        corporation: "CorporationChild",
        location: "LocationChild",
        parent: Optional["ParentChild"] = None,
        hierarchy: Optional[List["HierarchyChild"]] = None,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(IndicatorGroupResponse, self).__init__(**kwargs)
        self.parent = parent
        self.hierarchy = hierarchy
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.is_paused = is_paused
        self.is_snoozed = is_snoozed
        self.created = created
        self.corporation = corporation
        self.location = location


class IndicatorGroupUpdateRequest(msrest.serialization.Model):
    """IndicatorGroupUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param is_paused: Required.
    :type is_paused: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'is_paused': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        is_paused: bool,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(IndicatorGroupUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.is_paused = is_paused


class IndicatorResponse(msrest.serialization.Model):
    """IndicatorResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param system_sort_order:
    :type system_sort_order: int
    :param indicator_type: If creating a new MetricTypeCode be sure to add a Validator attribute
     and update the following classes
     if necessary: DataValidator, DataValidatorFunctions, ValidatorAttributes files. Possible
     values include: "Temperature", "Pressure", "Flow", "Humidity", "Power", "DifferentialPressure",
     "MultiSensorDifferentialPressure", "Voltage", "GeneralizedAtoD", "VibrationBandRms",
     "VibrationBandMax", "VibrationOverallPeak", "VibrationOverallRms", "VibrationOverallSkewness",
     "VibrationOverallKurtosis", "VibrationOverallCrestFactor", "DamageAccumulation",
     "VibrationBandRmsAccel", "VibrationBandMaxAccel", "VibrationOverallPeakAccel",
     "VibrationOverallRmsAccel", "VibrationOverallSkewnessAccel", "VibrationOverallKurtosisAccel",
     "VibrationOverallCrestFactorAccel", "DamageAccumulationAccel", "Group", "VibrationOverall",
     "VibrationOverallAccel", "GeneralTimeSeries", "Math", "OnStatistics", "OffStatistics",
     "AlarmStatistics", "WarningStatistics", "PositivePeakPressure", "NegativePeakPressure",
     "RmsPressure", "BandPressure", "OnPercentStatistics", "OffPercentStatistics",
     "AlarmPercentStatistics", "WarningPercentStatistics", "SignalStrength", "RunningSpeed",
     "DamageAccumulationPressure", "OilHumidity", "OilTemperature", "DamageAccumulationAccelRaw",
     "ThermalRegionOfInterest", "SmartMetric".
    :type indicator_type: str or ~smartdiagnostics_sdk.models.IndicatorResponseIndicatorType
    :param display_units:
    :type display_units: str
    :param base_units:
    :type base_units: str
    :param has_spectrum:
    :type has_spectrum: bool
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param alarm_definition:
    :type alarm_definition: ~smartdiagnostics_sdk.models.AlarmDefinitionChild
    :param band_definition:
    :type band_definition: ~smartdiagnostics_sdk.models.BandDefinitionChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'system_sort_order': {'key': 'SystemSortOrder', 'type': 'int'},
        'indicator_type': {'key': 'IndicatorType', 'type': 'str'},
        'display_units': {'key': 'DisplayUnits', 'type': 'str'},
        'base_units': {'key': 'BaseUnits', 'type': 'str'},
        'has_spectrum': {'key': 'HasSpectrum', 'type': 'bool'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'alarm_definition': {'key': 'AlarmDefinition', 'type': 'AlarmDefinitionChild'},
        'band_definition': {'key': 'BandDefinition', 'type': 'BandDefinitionChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        system_sort_order: Optional[int] = None,
        indicator_type: Optional[Union[str, "IndicatorResponseIndicatorType"]] = None,
        display_units: Optional[str] = None,
        base_units: Optional[str] = None,
        has_spectrum: Optional[bool] = None,
        hierarchy: Optional[List["HierarchyChild"]] = None,
        alarm_definition: Optional["AlarmDefinitionChild"] = None,
        band_definition: Optional["BandDefinitionChild"] = None,
        **kwargs
    ):
        super(IndicatorResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.system_sort_order = system_sort_order
        self.indicator_type = indicator_type
        self.display_units = display_units
        self.base_units = base_units
        self.has_spectrum = has_spectrum
        self.hierarchy = hierarchy
        self.alarm_definition = alarm_definition
        self.band_definition = band_definition


class IndicatorTypesResponse(msrest.serialization.Model):
    """IndicatorTypesResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: int,
        name: str,
        **kwargs
    ):
        super(IndicatorTypesResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name


class InstallAddUserResponse(msrest.serialization.Model):
    """InstallAddUserResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param install_id:
    :type install_id: str
    :ivar success_count:
    :vartype success_count: int
    :ivar error_count:
    :vartype error_count: int
    """

    _validation = {
        'success_count': {'readonly': True},
        'error_count': {'readonly': True},
    }

    _attribute_map = {
        'install_id': {'key': 'InstallId', 'type': 'str'},
        'success_count': {'key': 'SuccessCount', 'type': 'int'},
        'error_count': {'key': 'ErrorCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        install_id: Optional[str] = None,
        **kwargs
    ):
        super(InstallAddUserResponse, self).__init__(**kwargs)
        self.install_id = install_id
        self.success_count = None
        self.error_count = None


class InstallModifyUsersRequest(msrest.serialization.Model):
    """InstallModifyUsersRequest.

    :param user_ids:
    :type user_ids: list[str]
    """

    _attribute_map = {
        'user_ids': {'key': 'UserIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        user_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(InstallModifyUsersRequest, self).__init__(**kwargs)
        self.user_ids = user_ids


class InstallNodeResponse(msrest.serialization.Model):
    """InstallNodeResponse.

    :param node_id:
    :type node_id: long
    :param install_id:
    :type install_id: str
    :param node_serial_number:
    :type node_serial_number: str
    :param node_nickname:
    :type node_nickname: str
    :param install_status:
    :type install_status: ~smartdiagnostics_sdk.models.InstallNodeStatusChild
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _attribute_map = {
        'node_id': {'key': 'NodeId', 'type': 'long'},
        'install_id': {'key': 'InstallId', 'type': 'str'},
        'node_serial_number': {'key': 'NodeSerialNumber', 'type': 'str'},
        'node_nickname': {'key': 'NodeNickname', 'type': 'str'},
        'install_status': {'key': 'InstallStatus', 'type': 'InstallNodeStatusChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        node_id: Optional[int] = None,
        install_id: Optional[str] = None,
        node_serial_number: Optional[str] = None,
        node_nickname: Optional[str] = None,
        install_status: Optional["InstallNodeStatusChild"] = None,
        location: Optional["LocationChild"] = None,
        **kwargs
    ):
        super(InstallNodeResponse, self).__init__(**kwargs)
        self.node_id = node_id
        self.install_id = install_id
        self.node_serial_number = node_serial_number
        self.node_nickname = node_nickname
        self.install_status = install_status
        self.location = location


class InstallNodesStatusChild(msrest.serialization.Model):
    """InstallNodesStatusChild.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar total:
    :vartype total: int
    :param status:
    :type status: ~smartdiagnostics_sdk.models.NodeStatusChild
    """

    _validation = {
        'total': {'readonly': True},
    }

    _attribute_map = {
        'total': {'key': 'Total', 'type': 'int'},
        'status': {'key': 'Status', 'type': 'NodeStatusChild'},
    }

    def __init__(
        self,
        *,
        status: Optional["NodeStatusChild"] = None,
        **kwargs
    ):
        super(InstallNodesStatusChild, self).__init__(**kwargs)
        self.total = None
        self.status = status


class InstallNodeStatusChild(msrest.serialization.Model):
    """InstallNodeStatusChild.

    :param status_id: The corresponding StatusId.
    :type status_id: long
    :param status: The textual description of the Status.
    :type status: str
    :param status_date: The DateTime that the current status was set as part of an install
     activity.
    :type status_date: ~datetime.datetime
    :param status_note: A brief note about the installation of the node, typically used when
     something prevents a node from being installed to keep records.
    :type status_note: str
    :param install_user: The user that set the current install status.
    :type install_user: str
    """

    _attribute_map = {
        'status_id': {'key': 'StatusId', 'type': 'long'},
        'status': {'key': 'Status', 'type': 'str'},
        'status_date': {'key': 'StatusDate', 'type': 'iso-8601'},
        'status_note': {'key': 'StatusNote', 'type': 'str'},
        'install_user': {'key': 'InstallUser', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status_id: Optional[int] = None,
        status: Optional[str] = None,
        status_date: Optional[datetime.datetime] = None,
        status_note: Optional[str] = None,
        install_user: Optional[str] = None,
        **kwargs
    ):
        super(InstallNodeStatusChild, self).__init__(**kwargs)
        self.status_id = status_id
        self.status = status
        self.status_date = status_date
        self.status_note = status_note
        self.install_user = install_user


class InstallNodeUpdateRequest(msrest.serialization.Model):
    """InstallNodeUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param status_id: Required. The Installation status identifier of the nodes at time of install.
    :type status_id: int
    :param status_note: Installations notes typically used when a node is unable to be installed.
    :type status_note: str
    """

    _validation = {
        'status_id': {'required': True},
        'status_note': {'max_length': 200, 'min_length': 0},
    }

    _attribute_map = {
        'status_id': {'key': 'StatusId', 'type': 'int'},
        'status_note': {'key': 'StatusNote', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        status_id: int,
        status_note: Optional[str] = None,
        **kwargs
    ):
        super(InstallNodeUpdateRequest, self).__init__(**kwargs)
        self.status_id = status_id
        self.status_note = status_note


class InstallResponse(msrest.serialization.Model):
    """InstallResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id:
    :type id: str
    :param name:
    :type name: str
    :param start_date:
    :type start_date: ~datetime.datetime
    :param end_date:
    :type end_date: ~datetime.datetime
    :ivar active:
    :vartype active: bool
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param users:
    :type users: list[~smartdiagnostics_sdk.models.UserChild]
    :param node_status:
    :type node_status: ~smartdiagnostics_sdk.models.InstallNodesStatusChild
    """

    _validation = {
        'active': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
        'active': {'key': 'Active', 'type': 'bool'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'users': {'key': 'Users', 'type': '[UserChild]'},
        'node_status': {'key': 'NodeStatus', 'type': 'InstallNodesStatusChild'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        location: Optional["LocationChild"] = None,
        corporation: Optional["CorporationChild"] = None,
        users: Optional[List["UserChild"]] = None,
        node_status: Optional["InstallNodesStatusChild"] = None,
        **kwargs
    ):
        super(InstallResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.start_date = start_date
        self.end_date = end_date
        self.active = None
        self.location = location
        self.corporation = corporation
        self.users = users
        self.node_status = node_status


class InstallUpdateRequest(msrest.serialization.Model):
    """InstallUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param start_date: Required.
    :type start_date: ~datetime.datetime
    :param end_date:
    :type end_date: ~datetime.datetime
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'start_date': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        name: str,
        start_date: datetime.datetime,
        end_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(InstallUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.start_date = start_date
        self.end_date = end_date


class JobModelV3(msrest.serialization.Model):
    """JobModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param location_name:
    :type location_name: str
    :param location_id:
    :type location_id: str
    :param corporation_name:
    :type corporation_name: str
    :param corporation_id:
    :type corporation_id: str
    :param user_name:
    :type user_name: str
    :param type:
    :type type: str
    :param status:  Possible values include: "Queued", "Running", "Finished", "FinishedWithErrors",
     "Errored", "Deferred".
    :type status: str or ~smartdiagnostics_sdk.models.JobModelV3Status
    :param upload_date:
    :type upload_date: ~datetime.datetime
    :param uploaded_file_name:
    :type uploaded_file_name: str
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'user_name': {'key': 'UserName', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'str'},
        'upload_date': {'key': 'UploadDate', 'type': 'iso-8601'},
        'uploaded_file_name': {'key': 'UploadedFileName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: str,
        location_name: Optional[str] = None,
        location_id: Optional[str] = None,
        corporation_name: Optional[str] = None,
        corporation_id: Optional[str] = None,
        user_name: Optional[str] = None,
        type: Optional[str] = None,
        status: Optional[Union[str, "JobModelV3Status"]] = None,
        upload_date: Optional[datetime.datetime] = None,
        uploaded_file_name: Optional[str] = None,
        **kwargs
    ):
        super(JobModelV3, self).__init__(**kwargs)
        self.id = id
        self.location_name = location_name
        self.location_id = location_id
        self.corporation_name = corporation_name
        self.corporation_id = corporation_id
        self.user_name = user_name
        self.type = type
        self.status = status
        self.upload_date = upload_date
        self.uploaded_file_name = uploaded_file_name


class LayoutChild(msrest.serialization.Model):
    """LayoutChild.

    All required parameters must be populated in order to send to Azure.

    :param layout_row: Required.
    :type layout_row: int
    :param layout_column: Required.
    :type layout_column: int
    :param layout_height: Required.
    :type layout_height: int
    :param layout_width: Required.
    :type layout_width: int
    """

    _validation = {
        'layout_row': {'required': True},
        'layout_column': {'required': True},
        'layout_height': {'required': True},
        'layout_width': {'required': True},
    }

    _attribute_map = {
        'layout_row': {'key': 'LayoutRow', 'type': 'int'},
        'layout_column': {'key': 'LayoutColumn', 'type': 'int'},
        'layout_height': {'key': 'LayoutHeight', 'type': 'int'},
        'layout_width': {'key': 'LayoutWidth', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        layout_row: int,
        layout_column: int,
        layout_height: int,
        layout_width: int,
        **kwargs
    ):
        super(LayoutChild, self).__init__(**kwargs)
        self.layout_row = layout_row
        self.layout_column = layout_column
        self.layout_height = layout_height
        self.layout_width = layout_width


class LocationChild(msrest.serialization.Model):
    """LocationChild.

    All required parameters must be populated in order to send to Azure.

    :param location_id: Required.
    :type location_id: str
    :param location_name: Required.
    :type location_name: str
    :param location_abbreviation:
    :type location_abbreviation: str
    """

    _validation = {
        'location_id': {'required': True},
        'location_name': {'required': True},
    }

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'location_abbreviation': {'key': 'LocationAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location_id: str,
        location_name: str,
        location_abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(LocationChild, self).__init__(**kwargs)
        self.location_id = location_id
        self.location_name = location_name
        self.location_abbreviation = location_abbreviation


class LocationCreateRequest(msrest.serialization.Model):
    """LocationCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param corporation_id: Required.
    :type corporation_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'corporation_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        corporation_id: str,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(LocationCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.corporation_id = corporation_id


class LocationResponse(msrest.serialization.Model):
    """LocationResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active:
    :type active: bool
    :param created:
    :type created: ~datetime.datetime
    :param site_ids:
    :type site_ids: list[str]
    :param settings:
    :type settings: ~smartdiagnostics_sdk.models.LocationSettingsChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.PrimaryCorporationChild
    :param systems:
    :type systems: list[~smartdiagnostics_sdk.models.SystemChild]
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'site_ids': {'key': 'SiteIds', 'type': '[str]'},
        'settings': {'key': 'Settings', 'type': 'LocationSettingsChild'},
        'corporation': {'key': 'Corporation', 'type': 'PrimaryCorporationChild'},
        'systems': {'key': 'Systems', 'type': '[SystemChild]'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        abbreviation: Optional[str] = None,
        active: Optional[bool] = None,
        created: Optional[datetime.datetime] = None,
        site_ids: Optional[List[str]] = None,
        settings: Optional["LocationSettingsChild"] = None,
        corporation: Optional["PrimaryCorporationChild"] = None,
        systems: Optional[List["SystemChild"]] = None,
        **kwargs
    ):
        super(LocationResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.created = created
        self.site_ids = site_ids
        self.settings = settings
        self.corporation = corporation
        self.systems = systems


class LocationSettingsChild(msrest.serialization.Model):
    """LocationSettingsChild.

    :param max_transport_interval:
    :type max_transport_interval: int
    :param max_vibration_update_interval:
    :type max_vibration_update_interval: int
    :param max_oil_quality_update_interval:
    :type max_oil_quality_update_interval: int
    :param opc_enabled:
    :type opc_enabled: bool
    :param assign_filters_to_account:
    :type assign_filters_to_account: bool
    :param external_notification_type:  Possible values include: "Disabled", "Automatic", "Manual".
    :type external_notification_type: str or
     ~smartdiagnostics_sdk.models.LocationSettingsChildExternalNotificationType
    """

    _attribute_map = {
        'max_transport_interval': {'key': 'MaxTransportInterval', 'type': 'int'},
        'max_vibration_update_interval': {'key': 'MaxVibrationUpdateInterval', 'type': 'int'},
        'max_oil_quality_update_interval': {'key': 'MaxOilQualityUpdateInterval', 'type': 'int'},
        'opc_enabled': {'key': 'OpcEnabled', 'type': 'bool'},
        'assign_filters_to_account': {'key': 'AssignFiltersToAccount', 'type': 'bool'},
        'external_notification_type': {'key': 'ExternalNotificationType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        max_transport_interval: Optional[int] = None,
        max_vibration_update_interval: Optional[int] = None,
        max_oil_quality_update_interval: Optional[int] = None,
        opc_enabled: Optional[bool] = None,
        assign_filters_to_account: Optional[bool] = None,
        external_notification_type: Optional[Union[str, "LocationSettingsChildExternalNotificationType"]] = None,
        **kwargs
    ):
        super(LocationSettingsChild, self).__init__(**kwargs)
        self.max_transport_interval = max_transport_interval
        self.max_vibration_update_interval = max_vibration_update_interval
        self.max_oil_quality_update_interval = max_oil_quality_update_interval
        self.opc_enabled = opc_enabled
        self.assign_filters_to_account = assign_filters_to_account
        self.external_notification_type = external_notification_type


class LongBurstRequestChild(msrest.serialization.Model):
    """LongBurstRequestChild.

    :param long_burst_request_id:
    :type long_burst_request_id: long
    :param long_burst_request_status:  Possible values include: "Unknown", "Failed", "Canceled",
     "TimedOut", "Initiated", "Enqueued", "Capturing", "Processing", "Completed".
    :type long_burst_request_status: str or
     ~smartdiagnostics_sdk.models.LongBurstRequestChildLongBurstRequestStatus
    :param requested_time:
    :type requested_time: ~datetime.datetime
    :param completed_time:
    :type completed_time: ~datetime.datetime
    :param requested_by_user:
    :type requested_by_user: ~smartdiagnostics_sdk.models.UserChild
    :param x_axis_long_burst_file:
    :type x_axis_long_burst_file: str
    :param y_axis_long_burst_file:
    :type y_axis_long_burst_file: str
    """

    _attribute_map = {
        'long_burst_request_id': {'key': 'LongBurstRequestId', 'type': 'long'},
        'long_burst_request_status': {'key': 'LongBurstRequestStatus', 'type': 'str'},
        'requested_time': {'key': 'RequestedTime', 'type': 'iso-8601'},
        'completed_time': {'key': 'CompletedTime', 'type': 'iso-8601'},
        'requested_by_user': {'key': 'RequestedByUser', 'type': 'UserChild'},
        'x_axis_long_burst_file': {'key': 'XAxisLongBurstFile', 'type': 'str'},
        'y_axis_long_burst_file': {'key': 'YAxisLongBurstFile', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        long_burst_request_id: Optional[int] = None,
        long_burst_request_status: Optional[Union[str, "LongBurstRequestChildLongBurstRequestStatus"]] = None,
        requested_time: Optional[datetime.datetime] = None,
        completed_time: Optional[datetime.datetime] = None,
        requested_by_user: Optional["UserChild"] = None,
        x_axis_long_burst_file: Optional[str] = None,
        y_axis_long_burst_file: Optional[str] = None,
        **kwargs
    ):
        super(LongBurstRequestChild, self).__init__(**kwargs)
        self.long_burst_request_id = long_burst_request_id
        self.long_burst_request_status = long_burst_request_status
        self.requested_time = requested_time
        self.completed_time = completed_time
        self.requested_by_user = requested_by_user
        self.x_axis_long_burst_file = x_axis_long_burst_file
        self.y_axis_long_burst_file = y_axis_long_burst_file


class MarkerChild(msrest.serialization.Model):
    """MarkerChild.

    All required parameters must be populated in order to send to Azure.

    :param marker_name:
    :type marker_name: str
    :param marker_show_harmonics: Required.
    :type marker_show_harmonics: bool
    :param marker_show_side_bands: Required.
    :type marker_show_side_bands: bool
    :param marker_show_peaks: Required.
    :type marker_show_peaks: bool
    """

    _validation = {
        'marker_name': {'max_length': 5, 'min_length': 0},
        'marker_show_harmonics': {'required': True},
        'marker_show_side_bands': {'required': True},
        'marker_show_peaks': {'required': True},
    }

    _attribute_map = {
        'marker_name': {'key': 'MarkerName', 'type': 'str'},
        'marker_show_harmonics': {'key': 'MarkerShowHarmonics', 'type': 'bool'},
        'marker_show_side_bands': {'key': 'MarkerShowSideBands', 'type': 'bool'},
        'marker_show_peaks': {'key': 'MarkerShowPeaks', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        marker_show_harmonics: bool,
        marker_show_side_bands: bool,
        marker_show_peaks: bool,
        marker_name: Optional[str] = None,
        **kwargs
    ):
        super(MarkerChild, self).__init__(**kwargs)
        self.marker_name = marker_name
        self.marker_show_harmonics = marker_show_harmonics
        self.marker_show_side_bands = marker_show_side_bands
        self.marker_show_peaks = marker_show_peaks


class MarkerResponse(msrest.serialization.Model):
    """MarkerResponse.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param marker_type: Required.  Possible values include: "Fixed", "Multiplier".
    :type marker_type: str or ~smartdiagnostics_sdk.models.MarkerResponseMarkerType
    :param value: Required.
    :type value: float
    :param order: Required.
    :type order: int
    """

    _validation = {
        'name': {'required': True},
        'marker_type': {'required': True},
        'value': {'required': True},
        'order': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'marker_type': {'key': 'MarkerType', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'float'},
        'order': {'key': 'Order', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        marker_type: Union[str, "MarkerResponseMarkerType"],
        value: float,
        order: int,
        **kwargs
    ):
        super(MarkerResponse, self).__init__(**kwargs)
        self.name = name
        self.marker_type = marker_type
        self.value = value
        self.order = order


class MarkerUpdateRequest(msrest.serialization.Model):
    """MarkerUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param marker_type: Required.  Possible values include: "Fixed", "Multiplier".
    :type marker_type: str or ~smartdiagnostics_sdk.models.MarkerUpdateRequestMarkerType
    :param value: Required.
    :type value: float
    :param order: Required.
    :type order: int
    """

    _validation = {
        'name': {'required': True, 'max_length': 5, 'min_length': 0},
        'marker_type': {'required': True},
        'value': {'required': True, 'minimum': 0},
        'order': {'required': True, 'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'marker_type': {'key': 'MarkerType', 'type': 'str'},
        'value': {'key': 'Value', 'type': 'float'},
        'order': {'key': 'Order', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: str,
        marker_type: Union[str, "MarkerUpdateRequestMarkerType"],
        value: float,
        order: int,
        **kwargs
    ):
        super(MarkerUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.marker_type = marker_type
        self.value = value
        self.order = order


class MonitoringPointResponse(msrest.serialization.Model):
    """MonitoringPointResponse.

    All required parameters must be populated in order to send to Azure.

    :param note:
    :type note: str
    :param running_speed_multiplier:
    :type running_speed_multiplier: float
    :param monitoring_point_type:  Possible values include: "Invalid", "Custom", "Vibration",
     "Pressure", "OilQuality", "GeneralInput", "IndicatorBased", "GeneralAtoD".
    :type monitoring_point_type: str or
     ~smartdiagnostics_sdk.models.MonitoringPointResponseMonitoringPointType
    :param node:
    :type node: ~smartdiagnostics_sdk.models.NodeChild
    :param bearing:
    :type bearing: ~smartdiagnostics_sdk.models.BearingChild
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'note': {'key': 'Note', 'type': 'str'},
        'running_speed_multiplier': {'key': 'RunningSpeedMultiplier', 'type': 'float'},
        'monitoring_point_type': {'key': 'MonitoringPointType', 'type': 'str'},
        'node': {'key': 'Node', 'type': 'NodeChild'},
        'bearing': {'key': 'Bearing', 'type': 'BearingChild'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        active: bool,
        is_paused: bool,
        is_snoozed: bool,
        created: datetime.datetime,
        corporation: "CorporationChild",
        location: "LocationChild",
        note: Optional[str] = None,
        running_speed_multiplier: Optional[float] = None,
        monitoring_point_type: Optional[Union[str, "MonitoringPointResponseMonitoringPointType"]] = None,
        node: Optional["NodeChild"] = None,
        bearing: Optional["BearingChild"] = None,
        hierarchy: Optional[List["HierarchyChild"]] = None,
        children: Optional[List["DescendantChild"]] = None,
        parent: Optional["ParentChild"] = None,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(MonitoringPointResponse, self).__init__(**kwargs)
        self.note = note
        self.running_speed_multiplier = running_speed_multiplier
        self.monitoring_point_type = monitoring_point_type
        self.node = node
        self.bearing = bearing
        self.hierarchy = hierarchy
        self.children = children
        self.parent = parent
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.is_paused = is_paused
        self.is_snoozed = is_snoozed
        self.created = created
        self.corporation = corporation
        self.location = location


class MonitoringPointTypeCodeModel(msrest.serialization.Model):
    """MonitoringPointTypeCodeModel.

    :param text:
    :type text: str
    :param value:
    :type value: int
    """

    _attribute_map = {
        'text': {'key': 'text', 'type': 'str'},
        'value': {'key': 'value', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        text: Optional[str] = None,
        value: Optional[int] = None,
        **kwargs
    ):
        super(MonitoringPointTypeCodeModel, self).__init__(**kwargs)
        self.text = text
        self.value = value


class MoveFilesRequest(msrest.serialization.Model):
    """MoveFilesRequest.

    All required parameters must be populated in order to send to Azure.

    :param file_ids: Required. File Ids to move.
    :type file_ids: list[str]
    :param destination_folder_id: Required. File to move all files to (Parent Id).
    :type destination_folder_id: str
    """

    _validation = {
        'file_ids': {'required': True},
        'destination_folder_id': {'required': True},
    }

    _attribute_map = {
        'file_ids': {'key': 'FileIds', 'type': '[str]'},
        'destination_folder_id': {'key': 'DestinationFolderId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        file_ids: List[str],
        destination_folder_id: str,
        **kwargs
    ):
        super(MoveFilesRequest, self).__init__(**kwargs)
        self.file_ids = file_ids
        self.destination_folder_id = destination_folder_id


class MoveFilesResponse(msrest.serialization.Model):
    """MoveFilesResponse.

    :param destination_folder_id:
    :type destination_folder_id: str
    :param success_count:
    :type success_count: int
    :param error_count:
    :type error_count: int
    :param errors:
    :type errors: list[~smartdiagnostics_sdk.models.FilesError]
    """

    _attribute_map = {
        'destination_folder_id': {'key': 'DestinationFolderId', 'type': 'str'},
        'success_count': {'key': 'SuccessCount', 'type': 'int'},
        'error_count': {'key': 'ErrorCount', 'type': 'int'},
        'errors': {'key': 'Errors', 'type': '[FilesError]'},
    }

    def __init__(
        self,
        *,
        destination_folder_id: Optional[str] = None,
        success_count: Optional[int] = None,
        error_count: Optional[int] = None,
        errors: Optional[List["FilesError"]] = None,
        **kwargs
    ):
        super(MoveFilesResponse, self).__init__(**kwargs)
        self.destination_folder_id = destination_folder_id
        self.success_count = success_count
        self.error_count = error_count
        self.errors = errors


class NodeChild(msrest.serialization.Model):
    """NodeChild.

    :param node_id:
    :type node_id: long
    :param node_serial_number:
    :type node_serial_number: str
    :param node_nickname:
    :type node_nickname: str
    :param node_type_code:  Possible values include: "Invalid", "KcfFlow", "KcfPressureVoltage",
     "KcfPressureCurrent", "KcfPower", "KcfVibration", "KcfVibrationV1", "KcfVoltage", "KcfCurrent",
     "KcfAtoDVoltage", "KcfAtoDCurrent", "KcfOilQuality", "Generic", "KcfAgnostic", "KcfHumidity",
     "KcfExtendedTemperatureVibration", "KcfHubVibrationV1".
    :type node_type_code: str or ~smartdiagnostics_sdk.models.NodeChildNodeTypeCode
    :param node_sampling_frequency:
    :type node_sampling_frequency: int
    :param node_update_interval:
    :type node_update_interval: int
    """

    _attribute_map = {
        'node_id': {'key': 'NodeId', 'type': 'long'},
        'node_serial_number': {'key': 'NodeSerialNumber', 'type': 'str'},
        'node_nickname': {'key': 'NodeNickname', 'type': 'str'},
        'node_type_code': {'key': 'NodeTypeCode', 'type': 'str'},
        'node_sampling_frequency': {'key': 'NodeSamplingFrequency', 'type': 'int'},
        'node_update_interval': {'key': 'NodeUpdateInterval', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        node_id: Optional[int] = None,
        node_serial_number: Optional[str] = None,
        node_nickname: Optional[str] = None,
        node_type_code: Optional[Union[str, "NodeChildNodeTypeCode"]] = None,
        node_sampling_frequency: Optional[int] = None,
        node_update_interval: Optional[int] = None,
        **kwargs
    ):
        super(NodeChild, self).__init__(**kwargs)
        self.node_id = node_id
        self.node_serial_number = node_serial_number
        self.node_nickname = node_nickname
        self.node_type_code = node_type_code
        self.node_sampling_frequency = node_sampling_frequency
        self.node_update_interval = node_update_interval


class NodeResponse(msrest.serialization.Model):
    """NodeResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: long
    :param receiver:
    :type receiver: ~smartdiagnostics_sdk.models.ReceiverChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param serial_number: Required.
    :type serial_number: str
    :param nickname:
    :type nickname: str
    :param firmware_version:
    :type firmware_version: str
    :param node_type_code: Required.  Possible values include: "Invalid", "KcfFlow",
     "KcfPressureVoltage", "KcfPressureCurrent", "KcfPower", "KcfVibration", "KcfVibrationV1",
     "KcfVoltage", "KcfCurrent", "KcfAtoDVoltage", "KcfAtoDCurrent", "KcfOilQuality", "Generic",
     "KcfAgnostic", "KcfHumidity", "KcfExtendedTemperatureVibration", "KcfHubVibrationV1".
    :type node_type_code: str or ~smartdiagnostics_sdk.models.NodeResponseNodeTypeCode
    :param active: Required.
    :type active: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param updated: Required.
    :type updated: ~datetime.datetime
    :param battery_voltage:
    :type battery_voltage: float
    :param burst_success_rate:
    :type burst_success_rate: float
    :param is_online:
    :type is_online: bool
    :param last_update_time:
    :type last_update_time: ~datetime.datetime
    :param packet_success_rate:
    :type packet_success_rate: float
    :param temperature:
    :type temperature: float
    :param wireless_efficiency:
    :type wireless_efficiency: float
    """

    _validation = {
        'id': {'required': True},
        'location': {'required': True},
        'corporation': {'required': True},
        'serial_number': {'required': True, 'max_length': 8, 'min_length': 0},
        'nickname': {'max_length': 30, 'min_length': 0},
        'node_type_code': {'required': True},
        'active': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'receiver': {'key': 'Receiver', 'type': 'ReceiverChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
        'firmware_version': {'key': 'FirmwareVersion', 'type': 'str'},
        'node_type_code': {'key': 'NodeTypeCode', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'battery_voltage': {'key': 'BatteryVoltage', 'type': 'float'},
        'burst_success_rate': {'key': 'BurstSuccessRate', 'type': 'float'},
        'is_online': {'key': 'IsOnline', 'type': 'bool'},
        'last_update_time': {'key': 'LastUpdateTime', 'type': 'iso-8601'},
        'packet_success_rate': {'key': 'PacketSuccessRate', 'type': 'float'},
        'temperature': {'key': 'Temperature', 'type': 'float'},
        'wireless_efficiency': {'key': 'WirelessEfficiency', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        id: int,
        location: "LocationChild",
        corporation: "CorporationChild",
        serial_number: str,
        node_type_code: Union[str, "NodeResponseNodeTypeCode"],
        active: bool,
        created: datetime.datetime,
        updated: datetime.datetime,
        receiver: Optional["ReceiverChild"] = None,
        nickname: Optional[str] = None,
        firmware_version: Optional[str] = None,
        battery_voltage: Optional[float] = None,
        burst_success_rate: Optional[float] = None,
        is_online: Optional[bool] = None,
        last_update_time: Optional[datetime.datetime] = None,
        packet_success_rate: Optional[float] = None,
        temperature: Optional[float] = None,
        wireless_efficiency: Optional[float] = None,
        **kwargs
    ):
        super(NodeResponse, self).__init__(**kwargs)
        self.id = id
        self.receiver = receiver
        self.location = location
        self.corporation = corporation
        self.serial_number = serial_number
        self.nickname = nickname
        self.firmware_version = firmware_version
        self.node_type_code = node_type_code
        self.active = active
        self.created = created
        self.updated = updated
        self.battery_voltage = battery_voltage
        self.burst_success_rate = burst_success_rate
        self.is_online = is_online
        self.last_update_time = last_update_time
        self.packet_success_rate = packet_success_rate
        self.temperature = temperature
        self.wireless_efficiency = wireless_efficiency


class NodeSettingChild(msrest.serialization.Model):
    """NodeSettingChild.

    :param node_setting_name:
    :type node_setting_name: str
    :param node_setting_current_value:
    :type node_setting_current_value: str
    :param node_setting_pending_value:
    :type node_setting_pending_value: str
    """

    _attribute_map = {
        'node_setting_name': {'key': 'NodeSettingName', 'type': 'str'},
        'node_setting_current_value': {'key': 'NodeSettingCurrentValue', 'type': 'str'},
        'node_setting_pending_value': {'key': 'NodeSettingPendingValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        node_setting_name: Optional[str] = None,
        node_setting_current_value: Optional[str] = None,
        node_setting_pending_value: Optional[str] = None,
        **kwargs
    ):
        super(NodeSettingChild, self).__init__(**kwargs)
        self.node_setting_name = node_setting_name
        self.node_setting_current_value = node_setting_current_value
        self.node_setting_pending_value = node_setting_pending_value


class NodeStatusChild(msrest.serialization.Model):
    """NodeStatusChild.

    :param outstanding:
    :type outstanding: int
    :param deployed:
    :type deployed: int
    :param lock_out_tag_out:
    :type lock_out_tag_out: int
    :param spare_devices:
    :type spare_devices: int
    :param special_access_required:
    :type special_access_required: int
    """

    _attribute_map = {
        'outstanding': {'key': 'Outstanding', 'type': 'int'},
        'deployed': {'key': 'Deployed', 'type': 'int'},
        'lock_out_tag_out': {'key': 'LockOutTagOut', 'type': 'int'},
        'spare_devices': {'key': 'SpareDevices', 'type': 'int'},
        'special_access_required': {'key': 'SpecialAccessRequired', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        outstanding: Optional[int] = None,
        deployed: Optional[int] = None,
        lock_out_tag_out: Optional[int] = None,
        spare_devices: Optional[int] = None,
        special_access_required: Optional[int] = None,
        **kwargs
    ):
        super(NodeStatusChild, self).__init__(**kwargs)
        self.outstanding = outstanding
        self.deployed = deployed
        self.lock_out_tag_out = lock_out_tag_out
        self.spare_devices = spare_devices
        self.special_access_required = special_access_required


class PagedResultsModelAnalyticsModelResponse(msrest.serialization.Model):
    """PagedResultsModelAnalyticsModelResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.AnalyticsModelResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[AnalyticsModelResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["AnalyticsModelResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelAnalyticsModelResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelAssetResponse(msrest.serialization.Model):
    """PagedResultsModelAssetResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.AssetResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[AssetResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["AssetResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelAssetResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelAssetTypeResponse(msrest.serialization.Model):
    """PagedResultsModelAssetTypeResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.AssetTypeResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[AssetTypeResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["AssetTypeResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelAssetTypeResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelBaseStationResponse(msrest.serialization.Model):
    """PagedResultsModelBaseStationResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.BaseStationResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[BaseStationResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["BaseStationResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelBaseStationResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelBearingResponse(msrest.serialization.Model):
    """PagedResultsModelBearingResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.BearingResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[BearingResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["BearingResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelBearingResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelCorporationResponse(msrest.serialization.Model):
    """PagedResultsModelCorporationResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.CorporationResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[CorporationResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["CorporationResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelCorporationResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelDashboardResponse(msrest.serialization.Model):
    """PagedResultsModelDashboardResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.DashboardResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[DashboardResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["DashboardResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelDashboardResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelDashboardTemplateResponse(msrest.serialization.Model):
    """PagedResultsModelDashboardTemplateResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.DashboardTemplateResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[DashboardTemplateResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["DashboardTemplateResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelDashboardTemplateResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelFileResponse(msrest.serialization.Model):
    """PagedResultsModelFileResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.FileResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[FileResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["FileResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelFileResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelGroupAlertsResponse(msrest.serialization.Model):
    """PagedResultsModelGroupAlertsResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.GroupAlertsResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[GroupAlertsResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["GroupAlertsResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelGroupAlertsResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelGroupStatusResponse(msrest.serialization.Model):
    """PagedResultsModelGroupStatusResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.GroupStatusResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[GroupStatusResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["GroupStatusResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelGroupStatusResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelHardwareEventModelV3(msrest.serialization.Model):
    """PagedResultsModelHardwareEventModelV3.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.HardwareEventModelV3]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[HardwareEventModelV3]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["HardwareEventModelV3"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelHardwareEventModelV3, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelHubResponse(msrest.serialization.Model):
    """PagedResultsModelHubResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.HubResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[HubResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["HubResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelHubResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelIndicatorFilterResponse(msrest.serialization.Model):
    """PagedResultsModelIndicatorFilterResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.IndicatorFilterResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[IndicatorFilterResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["IndicatorFilterResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelIndicatorFilterResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelIndicatorGroupResponse(msrest.serialization.Model):
    """PagedResultsModelIndicatorGroupResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.IndicatorGroupResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[IndicatorGroupResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["IndicatorGroupResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelIndicatorGroupResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelIndicatorResponse(msrest.serialization.Model):
    """PagedResultsModelIndicatorResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.IndicatorResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[IndicatorResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["IndicatorResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelIndicatorResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelIndicatorTypesResponse(msrest.serialization.Model):
    """PagedResultsModelIndicatorTypesResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.IndicatorTypesResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[IndicatorTypesResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["IndicatorTypesResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelIndicatorTypesResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelInstallNodeResponse(msrest.serialization.Model):
    """PagedResultsModelInstallNodeResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.InstallNodeResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[InstallNodeResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["InstallNodeResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelInstallNodeResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelInstallResponse(msrest.serialization.Model):
    """PagedResultsModelInstallResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.InstallResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[InstallResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["InstallResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelInstallResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelLocationResponse(msrest.serialization.Model):
    """PagedResultsModelLocationResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.LocationResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[LocationResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["LocationResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelLocationResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelMarkerResponse(msrest.serialization.Model):
    """PagedResultsModelMarkerResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.MarkerResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[MarkerResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["MarkerResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelMarkerResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelMonitoringPointResponse(msrest.serialization.Model):
    """PagedResultsModelMonitoringPointResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.MonitoringPointResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[MonitoringPointResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["MonitoringPointResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelMonitoringPointResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelNodeResponse(msrest.serialization.Model):
    """PagedResultsModelNodeResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.NodeResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[NodeResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["NodeResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelNodeResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelPersonalAccessTokenResponse(msrest.serialization.Model):
    """PagedResultsModelPersonalAccessTokenResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.PersonalAccessTokenResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[PersonalAccessTokenResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["PersonalAccessTokenResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelPersonalAccessTokenResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelPicturesModelV3(msrest.serialization.Model):
    """PagedResultsModelPicturesModelV3.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.PicturesModelV3]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[PicturesModelV3]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["PicturesModelV3"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelPicturesModelV3, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelPropertyResponse(msrest.serialization.Model):
    """PagedResultsModelPropertyResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.PropertyResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[PropertyResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["PropertyResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelPropertyResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelReceiverResponse(msrest.serialization.Model):
    """PagedResultsModelReceiverResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.ReceiverResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[ReceiverResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["ReceiverResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelReceiverResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelRepeaterModelV3(msrest.serialization.Model):
    """PagedResultsModelRepeaterModelV3.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.RepeaterModelV3]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[RepeaterModelV3]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["RepeaterModelV3"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelRepeaterModelV3, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelSubSystemResponse(msrest.serialization.Model):
    """PagedResultsModelSubSystemResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.SubSystemResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[SubSystemResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["SubSystemResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelSubSystemResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelSystemAssetsStatusSummaryResponse(msrest.serialization.Model):
    """PagedResultsModelSystemAssetsStatusSummaryResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.SystemAssetsStatusSummaryResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[SystemAssetsStatusSummaryResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["SystemAssetsStatusSummaryResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelSystemAssetsStatusSummaryResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelSystemResponse(msrest.serialization.Model):
    """PagedResultsModelSystemResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.SystemResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[SystemResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["SystemResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelSystemResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelTagResponse(msrest.serialization.Model):
    """PagedResultsModelTagResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.TagResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[TagResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["TagResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelTagResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelTreeItemAvailableAssetClassResponse(msrest.serialization.Model):
    """PagedResultsModelTreeItemAvailableAssetClassResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.TreeItemAvailableAssetClassResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[TreeItemAvailableAssetClassResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["TreeItemAvailableAssetClassResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelTreeItemAvailableAssetClassResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class PagedResultsModelTreeItemResponse(msrest.serialization.Model):
    """PagedResultsModelTreeItemResponse.

    :param result: Contains a list of paged items.
    :type result: list[~smartdiagnostics_sdk.models.TreeItemResponse]
    :param total: The total number of items returned from a query (not just those in the paged
     results list).
    :type total: int
    :param total_pages: The total number of pages of items that will be returned.
    :type total_pages: int
    """

    _attribute_map = {
        'result': {'key': 'Result', 'type': '[TreeItemResponse]'},
        'total': {'key': 'Total', 'type': 'int'},
        'total_pages': {'key': 'TotalPages', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        result: Optional[List["TreeItemResponse"]] = None,
        total: Optional[int] = None,
        total_pages: Optional[int] = None,
        **kwargs
    ):
        super(PagedResultsModelTreeItemResponse, self).__init__(**kwargs)
        self.result = result
        self.total = total
        self.total_pages = total_pages


class ParentChild(msrest.serialization.Model):
    """ParentChild.

    :param parent_id:
    :type parent_id: str
    :param parent_name:
    :type parent_name: str
    :param parent_abbreviation:
    :type parent_abbreviation: str
    :param parent_type:
    :type parent_type: str
    """

    _attribute_map = {
        'parent_id': {'key': 'ParentId', 'type': 'str'},
        'parent_name': {'key': 'ParentName', 'type': 'str'},
        'parent_abbreviation': {'key': 'ParentAbbreviation', 'type': 'str'},
        'parent_type': {'key': 'ParentType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        parent_id: Optional[str] = None,
        parent_name: Optional[str] = None,
        parent_abbreviation: Optional[str] = None,
        parent_type: Optional[str] = None,
        **kwargs
    ):
        super(ParentChild, self).__init__(**kwargs)
        self.parent_id = parent_id
        self.parent_name = parent_name
        self.parent_abbreviation = parent_abbreviation
        self.parent_type = parent_type


class Paths13L8SxgApiV30CorporationsIdIconPostRequestbodyContentMultipartFormDataSchema(msrest.serialization.Model):
    """Paths13L8SxgApiV30CorporationsIdIconPostRequestbodyContentMultipartFormDataSchema.

    :param file: The image file to upload.
    :type file: IO
    """

    _attribute_map = {
        'file': {'key': 'file', 'type': 'IO'},
    }

    def __init__(
        self,
        *,
        file: Optional[IO] = None,
        **kwargs
    ):
        super(Paths13L8SxgApiV30CorporationsIdIconPostRequestbodyContentMultipartFormDataSchema, self).__init__(**kwargs)
        self.file = file


class Paths1I3IipnApiV30SetuptoolsJobtypePostRequestbodyContentMultipartFormDataSchema(msrest.serialization.Model):
    """Paths1I3IipnApiV30SetuptoolsJobtypePostRequestbodyContentMultipartFormDataSchema.

    :param location_id: The location to run the job for.
    :type location_id: str
    :param file: The file to be processed.
    :type file: IO
    """

    _attribute_map = {
        'location_id': {'key': 'locationId', 'type': 'str'},
        'file': {'key': 'file', 'type': 'IO'},
    }

    def __init__(
        self,
        *,
        location_id: Optional[str] = None,
        file: Optional[IO] = None,
        **kwargs
    ):
        super(Paths1I3IipnApiV30SetuptoolsJobtypePostRequestbodyContentMultipartFormDataSchema, self).__init__(**kwargs)
        self.location_id = location_id
        self.file = file


class PathsVkexhnApiV30FilesPostRequestbodyContentMultipartFormDataSchema(msrest.serialization.Model):
    """PathsVkexhnApiV30FilesPostRequestbodyContentMultipartFormDataSchema.

    All required parameters must be populated in order to send to Azure.

    :param type: Required. Type of file. Possible values include: "Invalid", "Picture", "Folder".
    :type type: str or ~smartdiagnostics_sdk.models.PostContentSchemaType
    :param display_name: Name of file.
    :type display_name: str
    :param parent_folder_id: Required. The id of the folder that the file is inside of.
    :type parent_folder_id: str
    :param description: File Description.
    :type description: str
    :param location_id: Location id of file.
    :type location_id: str
    :param corporation_id: Corporation id of file.
    :type corporation_id: str
    :param group_ids: Ids of groups the file belongs to.
    :type group_ids: list[str]
    :param files: The file that will be associated with the file model object.
    :type files: IO
    """

    _validation = {
        'type': {'required': True},
        'parent_folder_id': {'required': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'display_name': {'key': 'DisplayName', 'type': 'str'},
        'parent_folder_id': {'key': 'ParentFolderId', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'group_ids': {'key': 'GroupIds', 'type': '[str]'},
        'files': {'key': 'files', 'type': 'IO'},
    }

    def __init__(
        self,
        *,
        type: Union[str, "PostContentSchemaType"],
        parent_folder_id: str,
        display_name: Optional[str] = None,
        description: Optional[str] = None,
        location_id: Optional[str] = None,
        corporation_id: Optional[str] = None,
        group_ids: Optional[List[str]] = None,
        files: Optional[IO] = None,
        **kwargs
    ):
        super(PathsVkexhnApiV30FilesPostRequestbodyContentMultipartFormDataSchema, self).__init__(**kwargs)
        self.type = type
        self.display_name = display_name
        self.parent_folder_id = parent_folder_id
        self.description = description
        self.location_id = location_id
        self.corporation_id = corporation_id
        self.group_ids = group_ids
        self.files = files


class PersonalAccessTokenCreateRequest(msrest.serialization.Model):
    """PersonalAccessTokenCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param description: Required.
    :type description: str
    """

    _validation = {
        'description': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: str,
        **kwargs
    ):
        super(PersonalAccessTokenCreateRequest, self).__init__(**kwargs)
        self.description = description


class PersonalAccessTokenCreateResponse(msrest.serialization.Model):
    """PersonalAccessTokenCreateResponse.

    :param id:
    :type id: str
    :param description:
    :type description: str
    :param token:
    :type token: str
    :param note:
    :type note: str
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'token': {'key': 'Token', 'type': 'str'},
        'note': {'key': 'Note', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        description: Optional[str] = None,
        token: Optional[str] = None,
        note: Optional[str] = None,
        **kwargs
    ):
        super(PersonalAccessTokenCreateResponse, self).__init__(**kwargs)
        self.id = id
        self.description = description
        self.token = token
        self.note = note


class PersonalAccessTokenResponse(msrest.serialization.Model):
    """PersonalAccessTokenResponse.

    :param id:
    :type id: str
    :param description:
    :type description: str
    :param created:
    :type created: ~datetime.datetime
    :param updated:
    :type updated: ~datetime.datetime
    :param last_used:
    :type last_used: ~datetime.datetime
    :param active:
    :type active: bool
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'last_used': {'key': 'LastUsed', 'type': 'iso-8601'},
        'active': {'key': 'Active', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        description: Optional[str] = None,
        created: Optional[datetime.datetime] = None,
        updated: Optional[datetime.datetime] = None,
        last_used: Optional[datetime.datetime] = None,
        active: Optional[bool] = None,
        **kwargs
    ):
        super(PersonalAccessTokenResponse, self).__init__(**kwargs)
        self.id = id
        self.description = description
        self.created = created
        self.updated = updated
        self.last_used = last_used
        self.active = active


class PersonalAccessTokenUpdateRequest(msrest.serialization.Model):
    """PersonalAccessTokenUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param description: Required.
    :type description: str
    """

    _validation = {
        'description': {'required': True},
    }

    _attribute_map = {
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        description: str,
        **kwargs
    ):
        super(PersonalAccessTokenUpdateRequest, self).__init__(**kwargs)
        self.description = description


class PicturesModelV3(msrest.serialization.Model):
    """PicturesModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param description:
    :type description: str
    :param name:
    :type name: str
    :param image_file_name:
    :type image_file_name: str
    :param thumbnail_file_name:
    :type thumbnail_file_name: str
    :param attachment:
    :type attachment: ~smartdiagnostics_sdk.models.AttachmentModelV3
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'image_file_name': {'key': 'ImageFileName', 'type': 'str'},
        'thumbnail_file_name': {'key': 'ThumbnailFileName', 'type': 'str'},
        'attachment': {'key': 'Attachment', 'type': 'AttachmentModelV3'},
    }

    def __init__(
        self,
        *,
        id: str,
        description: Optional[str] = None,
        name: Optional[str] = None,
        image_file_name: Optional[str] = None,
        thumbnail_file_name: Optional[str] = None,
        attachment: Optional["AttachmentModelV3"] = None,
        **kwargs
    ):
        super(PicturesModelV3, self).__init__(**kwargs)
        self.id = id
        self.description = description
        self.name = name
        self.image_file_name = image_file_name
        self.thumbnail_file_name = thumbnail_file_name
        self.attachment = attachment


class PowerBiReportChild(msrest.serialization.Model):
    """PowerBiReportChild.

    :param power_bi_report_access_token:
    :type power_bi_report_access_token: str
    :param power_bi_report_name:
    :type power_bi_report_name: str
    :param power_bi_report_url:
    :type power_bi_report_url: str
    :param power_bi_report_embed_url:
    :type power_bi_report_embed_url: str
    :param error:  Possible values include: "None", "ReportNotFound", "Other".
    :type error: str or ~smartdiagnostics_sdk.models.PowerBiReportChildError
    """

    _attribute_map = {
        'power_bi_report_access_token': {'key': 'PowerBiReportAccessToken', 'type': 'str'},
        'power_bi_report_name': {'key': 'PowerBiReportName', 'type': 'str'},
        'power_bi_report_url': {'key': 'PowerBiReportUrl', 'type': 'str'},
        'power_bi_report_embed_url': {'key': 'PowerBiReportEmbedUrl', 'type': 'str'},
        'error': {'key': 'Error', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        power_bi_report_access_token: Optional[str] = None,
        power_bi_report_name: Optional[str] = None,
        power_bi_report_url: Optional[str] = None,
        power_bi_report_embed_url: Optional[str] = None,
        error: Optional[Union[str, "PowerBiReportChildError"]] = None,
        **kwargs
    ):
        super(PowerBiReportChild, self).__init__(**kwargs)
        self.power_bi_report_access_token = power_bi_report_access_token
        self.power_bi_report_name = power_bi_report_name
        self.power_bi_report_url = power_bi_report_url
        self.power_bi_report_embed_url = power_bi_report_embed_url
        self.error = error


class PrimaryCorporationChild(msrest.serialization.Model):
    """PrimaryCorporationChild.

    All required parameters must be populated in order to send to Azure.

    :param corporation_id: Required.
    :type corporation_id: str
    :param corporation_name: Required.
    :type corporation_name: str
    :param corporation_abbreviation:
    :type corporation_abbreviation: str
    """

    _validation = {
        'corporation_id': {'required': True},
        'corporation_name': {'required': True},
    }

    _attribute_map = {
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'corporation_abbreviation': {'key': 'CorporationAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        corporation_id: str,
        corporation_name: str,
        corporation_abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(PrimaryCorporationChild, self).__init__(**kwargs)
        self.corporation_id = corporation_id
        self.corporation_name = corporation_name
        self.corporation_abbreviation = corporation_abbreviation


class ProblemDetails(msrest.serialization.Model):
    """ProblemDetails.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param type:
    :type type: str
    :param title:
    :type title: str
    :param status:
    :type status: int
    :param detail:
    :type detail: str
    :param instance:
    :type instance: str
    :ivar extensions: Dictionary of :code:`<any>`.
    :vartype extensions: dict[str, object]
    """

    _validation = {
        'extensions': {'readonly': True},
    }

    _attribute_map = {
        'type': {'key': 'Type', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'status': {'key': 'Status', 'type': 'int'},
        'detail': {'key': 'Detail', 'type': 'str'},
        'instance': {'key': 'Instance', 'type': 'str'},
        'extensions': {'key': 'Extensions', 'type': '{object}'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        title: Optional[str] = None,
        status: Optional[int] = None,
        detail: Optional[str] = None,
        instance: Optional[str] = None,
        **kwargs
    ):
        super(ProblemDetails, self).__init__(**kwargs)
        self.type = type
        self.title = title
        self.status = status
        self.detail = detail
        self.instance = instance
        self.extensions = None


class ProfileChild(msrest.serialization.Model):
    """ProfileChild.

    :param acceleration_units:
    :type acceleration_units: str
    :param pressure_units:
    :type pressure_units: str
    :param temperature_units:
    :type temperature_units: str
    :param velocity_units:
    :type velocity_units: str
    :param last_updated_time:
    :type last_updated_time: ~datetime.datetime
    :param date_format:
    :type date_format: str
    :param time_format:
    :type time_format: str
    :param time_zones:
    :type time_zones: str
    """

    _attribute_map = {
        'acceleration_units': {'key': 'AccelerationUnits', 'type': 'str'},
        'pressure_units': {'key': 'PressureUnits', 'type': 'str'},
        'temperature_units': {'key': 'TemperatureUnits', 'type': 'str'},
        'velocity_units': {'key': 'VelocityUnits', 'type': 'str'},
        'last_updated_time': {'key': 'LastUpdatedTime', 'type': 'iso-8601'},
        'date_format': {'key': 'DateFormat', 'type': 'str'},
        'time_format': {'key': 'TimeFormat', 'type': 'str'},
        'time_zones': {'key': 'TimeZones', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        acceleration_units: Optional[str] = None,
        pressure_units: Optional[str] = None,
        temperature_units: Optional[str] = None,
        velocity_units: Optional[str] = None,
        last_updated_time: Optional[datetime.datetime] = None,
        date_format: Optional[str] = None,
        time_format: Optional[str] = None,
        time_zones: Optional[str] = None,
        **kwargs
    ):
        super(ProfileChild, self).__init__(**kwargs)
        self.acceleration_units = acceleration_units
        self.pressure_units = pressure_units
        self.temperature_units = temperature_units
        self.velocity_units = velocity_units
        self.last_updated_time = last_updated_time
        self.date_format = date_format
        self.time_format = time_format
        self.time_zones = time_zones


class PropertyChild(msrest.serialization.Model):
    """PropertyChild.

    All required parameters must be populated in order to send to Azure.

    :param property_id: Required.
    :type property_id: int
    :param property_name: Required.
    :type property_name: str
    :param property_value:
    :type property_value: str
    :param property_value_type: Required.  Possible values include: "Boolean", "DateTime",
     "Double", "Float", "Integer", "String".
    :type property_value_type: str or ~smartdiagnostics_sdk.models.PropertyChildPropertyValueType
    :param property_description:
    :type property_description: str
    :param property_required: Required.
    :type property_required: bool
    """

    _validation = {
        'property_id': {'required': True},
        'property_name': {'required': True},
        'property_value_type': {'required': True},
        'property_required': {'required': True},
    }

    _attribute_map = {
        'property_id': {'key': 'PropertyId', 'type': 'int'},
        'property_name': {'key': 'PropertyName', 'type': 'str'},
        'property_value': {'key': 'PropertyValue', 'type': 'str'},
        'property_value_type': {'key': 'PropertyValueType', 'type': 'str'},
        'property_description': {'key': 'PropertyDescription', 'type': 'str'},
        'property_required': {'key': 'PropertyRequired', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        property_id: int,
        property_name: str,
        property_value_type: Union[str, "PropertyChildPropertyValueType"],
        property_required: bool,
        property_value: Optional[str] = None,
        property_description: Optional[str] = None,
        **kwargs
    ):
        super(PropertyChild, self).__init__(**kwargs)
        self.property_id = property_id
        self.property_name = property_name
        self.property_value = property_value
        self.property_value_type = property_value_type
        self.property_description = property_description
        self.property_required = property_required


class PropertyRequestChild(msrest.serialization.Model):
    """PropertyRequestChild.

    All required parameters must be populated in order to send to Azure.

    :param property_id: Required.
    :type property_id: int
    :param property_required: Required.
    :type property_required: bool
    """

    _validation = {
        'property_id': {'required': True},
        'property_required': {'required': True},
    }

    _attribute_map = {
        'property_id': {'key': 'PropertyId', 'type': 'int'},
        'property_required': {'key': 'PropertyRequired', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        property_id: int,
        property_required: bool,
        **kwargs
    ):
        super(PropertyRequestChild, self).__init__(**kwargs)
        self.property_id = property_id
        self.property_required = property_required


class PropertyResponse(msrest.serialization.Model):
    """PropertyResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: int
    :param name: Required.
    :type name: str
    :param value_type: Required.
    :type value_type: str
    :param description:
    :type description: str
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'value_type': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'int'},
        'name': {'key': 'Name', 'type': 'str'},
        'value_type': {'key': 'ValueType', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: int,
        name: str,
        value_type: str,
        description: Optional[str] = None,
        **kwargs
    ):
        super(PropertyResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.value_type = value_type
        self.description = description


class ReceiverChild(msrest.serialization.Model):
    """ReceiverChild.

    All required parameters must be populated in order to send to Azure.

    :param receiver_id: Required.
    :type receiver_id: long
    :param receiver_serial_number: Required.
    :type receiver_serial_number: str
    :param receiver_nickname:
    :type receiver_nickname: str
    :param receiver_firmware_version:
    :type receiver_firmware_version: str
    :param receiver_network_id:
    :type receiver_network_id: str
    :param receiver_rf_channel:
    :type receiver_rf_channel: int
    :param receiver_pending_rf_channel:
    :type receiver_pending_rf_channel: int
    """

    _validation = {
        'receiver_id': {'required': True},
        'receiver_serial_number': {'required': True},
    }

    _attribute_map = {
        'receiver_id': {'key': 'ReceiverId', 'type': 'long'},
        'receiver_serial_number': {'key': 'ReceiverSerialNumber', 'type': 'str'},
        'receiver_nickname': {'key': 'ReceiverNickname', 'type': 'str'},
        'receiver_firmware_version': {'key': 'ReceiverFirmwareVersion', 'type': 'str'},
        'receiver_network_id': {'key': 'ReceiverNetworkId', 'type': 'str'},
        'receiver_rf_channel': {'key': 'ReceiverRfChannel', 'type': 'int'},
        'receiver_pending_rf_channel': {'key': 'ReceiverPendingRfChannel', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        receiver_id: int,
        receiver_serial_number: str,
        receiver_nickname: Optional[str] = None,
        receiver_firmware_version: Optional[str] = None,
        receiver_network_id: Optional[str] = None,
        receiver_rf_channel: Optional[int] = None,
        receiver_pending_rf_channel: Optional[int] = None,
        **kwargs
    ):
        super(ReceiverChild, self).__init__(**kwargs)
        self.receiver_id = receiver_id
        self.receiver_serial_number = receiver_serial_number
        self.receiver_nickname = receiver_nickname
        self.receiver_firmware_version = receiver_firmware_version
        self.receiver_network_id = receiver_network_id
        self.receiver_rf_channel = receiver_rf_channel
        self.receiver_pending_rf_channel = receiver_pending_rf_channel


class ReceiverResponse(msrest.serialization.Model):
    """ReceiverResponse.

    :param id:
    :type id: long
    :param serial_number:
    :type serial_number: str
    :param firmware_version:
    :type firmware_version: str
    :param network_id:
    :type network_id: str
    :param receiver_type:  Possible values include: "BaseStation", "Repeater".
    :type receiver_type: str or ~smartdiagnostics_sdk.models.ReceiverResponseReceiverType
    :param rf_channel:
    :type rf_channel: int
    :param pending_rf_channel:
    :type pending_rf_channel: int
    :param mac_address:
    :type mac_address: str
    :param radio_mac_address:
    :type radio_mac_address: str
    :param location:
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param corporation:
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param nodes:
    :type nodes: list[~smartdiagnostics_sdk.models.NodeChild]
    :param nickname:
    :type nickname: str
    """

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'firmware_version': {'key': 'FirmwareVersion', 'type': 'str'},
        'network_id': {'key': 'NetworkId', 'type': 'str'},
        'receiver_type': {'key': 'ReceiverType', 'type': 'str'},
        'rf_channel': {'key': 'RfChannel', 'type': 'int'},
        'pending_rf_channel': {'key': 'PendingRfChannel', 'type': 'int'},
        'mac_address': {'key': 'MacAddress', 'type': 'str'},
        'radio_mac_address': {'key': 'RadioMacAddress', 'type': 'str'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'nodes': {'key': 'Nodes', 'type': '[NodeChild]'},
        'nickname': {'key': 'Nickname', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[int] = None,
        serial_number: Optional[str] = None,
        firmware_version: Optional[str] = None,
        network_id: Optional[str] = None,
        receiver_type: Optional[Union[str, "ReceiverResponseReceiverType"]] = None,
        rf_channel: Optional[int] = None,
        pending_rf_channel: Optional[int] = None,
        mac_address: Optional[str] = None,
        radio_mac_address: Optional[str] = None,
        location: Optional["LocationChild"] = None,
        corporation: Optional["CorporationChild"] = None,
        nodes: Optional[List["NodeChild"]] = None,
        nickname: Optional[str] = None,
        **kwargs
    ):
        super(ReceiverResponse, self).__init__(**kwargs)
        self.id = id
        self.serial_number = serial_number
        self.firmware_version = firmware_version
        self.network_id = network_id
        self.receiver_type = receiver_type
        self.rf_channel = rf_channel
        self.pending_rf_channel = pending_rf_channel
        self.mac_address = mac_address
        self.radio_mac_address = radio_mac_address
        self.location = location
        self.corporation = corporation
        self.nodes = nodes
        self.nickname = nickname


class ReleaseRingChild(msrest.serialization.Model):
    """ReleaseRingChild.

    :param release_ring_id:
    :type release_ring_id: str
    :param release_ring_name:
    :type release_ring_name: str
    """

    _attribute_map = {
        'release_ring_id': {'key': 'ReleaseRingId', 'type': 'str'},
        'release_ring_name': {'key': 'ReleaseRingName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        release_ring_id: Optional[str] = None,
        release_ring_name: Optional[str] = None,
        **kwargs
    ):
        super(ReleaseRingChild, self).__init__(**kwargs)
        self.release_ring_id = release_ring_id
        self.release_ring_name = release_ring_name


class RepeaterModelV3(msrest.serialization.Model):
    """RepeaterModelV3.

    All required parameters must be populated in order to send to Azure.

    :param id:
    :type id: long
    :param serial_number: Required.
    :type serial_number: str
    :param radio_mac_address:
    :type radio_mac_address: str
    :param location_id:
    :type location_id: str
    :param location_name:
    :type location_name: str
    :param corporation_id:
    :type corporation_id: str
    :param corporation_name:
    :type corporation_name: str
    :param last_status_update:
    :type last_status_update: ~datetime.datetime
    :param active:
    :type active: bool
    :param type:  Possible values include: "Unknown", "BaseStation", "Repeater".
    :type type: str or ~smartdiagnostics_sdk.models.RepeaterModelV3Type
    """

    _validation = {
        'serial_number': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'long'},
        'serial_number': {'key': 'SerialNumber', 'type': 'str'},
        'radio_mac_address': {'key': 'RadioMacAddress', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'last_status_update': {'key': 'LastStatusUpdate', 'type': 'iso-8601'},
        'active': {'key': 'Active', 'type': 'bool'},
        'type': {'key': 'Type', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        serial_number: str,
        id: Optional[int] = None,
        radio_mac_address: Optional[str] = None,
        location_id: Optional[str] = None,
        location_name: Optional[str] = None,
        corporation_id: Optional[str] = None,
        corporation_name: Optional[str] = None,
        last_status_update: Optional[datetime.datetime] = None,
        active: Optional[bool] = None,
        type: Optional[Union[str, "RepeaterModelV3Type"]] = None,
        **kwargs
    ):
        super(RepeaterModelV3, self).__init__(**kwargs)
        self.id = id
        self.serial_number = serial_number
        self.radio_mac_address = radio_mac_address
        self.location_id = location_id
        self.location_name = location_name
        self.corporation_id = corporation_id
        self.corporation_name = corporation_name
        self.last_status_update = last_status_update
        self.active = active
        self.type = type


class RoiResponse(msrest.serialization.Model):
    """RoiResponse.

    :param savings:
    :type savings: float
    :param roi_percentage:
    :type roi_percentage: float
    :param roi_ratio:
    :type roi_ratio: float
    """

    _attribute_map = {
        'savings': {'key': 'Savings', 'type': 'float'},
        'roi_percentage': {'key': 'RoiPercentage', 'type': 'float'},
        'roi_ratio': {'key': 'RoiRatio', 'type': 'float'},
    }

    def __init__(
        self,
        *,
        savings: Optional[float] = None,
        roi_percentage: Optional[float] = None,
        roi_ratio: Optional[float] = None,
        **kwargs
    ):
        super(RoiResponse, self).__init__(**kwargs)
        self.savings = savings
        self.roi_percentage = roi_percentage
        self.roi_ratio = roi_ratio


class SpectrumChartSettingsCreateRequest(msrest.serialization.Model):
    """SpectrumChartSettingsCreateRequest.

    :param frequency_domain_settings:
    :type frequency_domain_settings: ~smartdiagnostics_sdk.models.FrequencyDomainSettingChild
    :param time_domain_settings:
    :type time_domain_settings: ~smartdiagnostics_sdk.models.MarkerChild
    """

    _attribute_map = {
        'frequency_domain_settings': {'key': 'FrequencyDomainSettings', 'type': 'FrequencyDomainSettingChild'},
        'time_domain_settings': {'key': 'TimeDomainSettings', 'type': 'MarkerChild'},
    }

    def __init__(
        self,
        *,
        frequency_domain_settings: Optional["FrequencyDomainSettingChild"] = None,
        time_domain_settings: Optional["MarkerChild"] = None,
        **kwargs
    ):
        super(SpectrumChartSettingsCreateRequest, self).__init__(**kwargs)
        self.frequency_domain_settings = frequency_domain_settings
        self.time_domain_settings = time_domain_settings


class SpectrumChartSettingsResponse(msrest.serialization.Model):
    """SpectrumChartSettingsResponse.

    :param frequency_domain_settings:
    :type frequency_domain_settings: ~smartdiagnostics_sdk.models.FrequencyDomainSettingChild
    :param time_domain_settings:
    :type time_domain_settings: ~smartdiagnostics_sdk.models.MarkerChild
    """

    _attribute_map = {
        'frequency_domain_settings': {'key': 'FrequencyDomainSettings', 'type': 'FrequencyDomainSettingChild'},
        'time_domain_settings': {'key': 'TimeDomainSettings', 'type': 'MarkerChild'},
    }

    def __init__(
        self,
        *,
        frequency_domain_settings: Optional["FrequencyDomainSettingChild"] = None,
        time_domain_settings: Optional["MarkerChild"] = None,
        **kwargs
    ):
        super(SpectrumChartSettingsResponse, self).__init__(**kwargs)
        self.frequency_domain_settings = frequency_domain_settings
        self.time_domain_settings = time_domain_settings


class StatisticsReportRequest(msrest.serialization.Model):
    """StatisticsReportRequest.

    All required parameters must be populated in order to send to Azure.

    :param include_percent_time_in_alarm: Whether or not to include percent time in alarm in the
     calculations.
    :type include_percent_time_in_alarm: bool
    :param include_percent_time_in_warning: Whether or not to include percent time in warning in
     the calculations.
    :type include_percent_time_in_warning: bool
    :param include_percent_on_time: Whether or not to include percent on time in the calculations.
    :type include_percent_on_time: bool
    :param include_seconds_in_alarm: Whether or not to include time in alarm in the calculations.
    :type include_seconds_in_alarm: bool
    :param include_average_value: Whether or not to include the average value in the calculations.
    :type include_average_value: bool
    :param include_max_value: Whether or not to include the max value in the calculations.
    :type include_max_value: bool
    :param filter_id: The filter to use. Optional.
    :type filter_id: str
    :param start_date: Required. The start date of the time range to get the report for. Nullable
     so Required can catch nulls, will not
     be null later.
    :type start_date: ~datetime.datetime
    :param end_date: Required. The end date of the time range to get the values for. Nullable so
     Required can catch nulls, will not
     be null later.
    :type end_date: ~datetime.datetime
    :param file_name: Required. The filename to use for the report.
    :type file_name: str
    """

    _validation = {
        'start_date': {'required': True},
        'end_date': {'required': True},
        'file_name': {'required': True},
    }

    _attribute_map = {
        'include_percent_time_in_alarm': {'key': 'IncludePercentTimeInAlarm', 'type': 'bool'},
        'include_percent_time_in_warning': {'key': 'IncludePercentTimeInWarning', 'type': 'bool'},
        'include_percent_on_time': {'key': 'IncludePercentOnTime', 'type': 'bool'},
        'include_seconds_in_alarm': {'key': 'IncludeSecondsInAlarm', 'type': 'bool'},
        'include_average_value': {'key': 'IncludeAverageValue', 'type': 'bool'},
        'include_max_value': {'key': 'IncludeMaxValue', 'type': 'bool'},
        'filter_id': {'key': 'FilterId', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
        'file_name': {'key': 'FileName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        start_date: datetime.datetime,
        end_date: datetime.datetime,
        file_name: str,
        include_percent_time_in_alarm: Optional[bool] = None,
        include_percent_time_in_warning: Optional[bool] = None,
        include_percent_on_time: Optional[bool] = None,
        include_seconds_in_alarm: Optional[bool] = None,
        include_average_value: Optional[bool] = None,
        include_max_value: Optional[bool] = None,
        filter_id: Optional[str] = None,
        **kwargs
    ):
        super(StatisticsReportRequest, self).__init__(**kwargs)
        self.include_percent_time_in_alarm = include_percent_time_in_alarm
        self.include_percent_time_in_warning = include_percent_time_in_warning
        self.include_percent_on_time = include_percent_on_time
        self.include_seconds_in_alarm = include_seconds_in_alarm
        self.include_average_value = include_average_value
        self.include_max_value = include_max_value
        self.filter_id = filter_id
        self.start_date = start_date
        self.end_date = end_date
        self.file_name = file_name


class SubSystemCreateRequest(msrest.serialization.Model):
    """SubSystemCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param parent_id: Required.
    :type parent_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'parent_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'parent_id': {'key': 'ParentId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        parent_id: str,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(SubSystemCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.parent_id = parent_id


class SubSystemResponse(msrest.serialization.Model):
    """SubSystemResponse.

    All required parameters must be populated in order to send to Azure.

    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        active: bool,
        is_paused: bool,
        is_snoozed: bool,
        created: datetime.datetime,
        corporation: "CorporationChild",
        location: "LocationChild",
        parent: Optional["ParentChild"] = None,
        children: Optional[List["DescendantChild"]] = None,
        hierarchy: Optional[List["HierarchyChild"]] = None,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(SubSystemResponse, self).__init__(**kwargs)
        self.parent = parent
        self.children = children
        self.hierarchy = hierarchy
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.is_paused = is_paused
        self.is_snoozed = is_snoozed
        self.created = created
        self.corporation = corporation
        self.location = location


class SubSystemUpdateRequest(msrest.serialization.Model):
    """SubSystemUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param is_paused: Required.
    :type is_paused: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'is_paused': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        is_paused: bool,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(SubSystemUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.is_paused = is_paused


class SystemAssetsStatusSummaryResponse(msrest.serialization.Model):
    """SystemAssetsStatusSummaryResponse.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param system:
    :type system: ~smartdiagnostics_sdk.models.SystemChild
    :ivar asset_count:
    :vartype asset_count: int
    :param status_count:
    :type status_count: ~smartdiagnostics_sdk.models.AssetsStatusCountChild
    :param status_percentage:
    :type status_percentage: ~smartdiagnostics_sdk.models.AssetsStatusPercentageChild
    """

    _validation = {
        'asset_count': {'readonly': True},
    }

    _attribute_map = {
        'system': {'key': 'System', 'type': 'SystemChild'},
        'asset_count': {'key': 'AssetCount', 'type': 'int'},
        'status_count': {'key': 'StatusCount', 'type': 'AssetsStatusCountChild'},
        'status_percentage': {'key': 'StatusPercentage', 'type': 'AssetsStatusPercentageChild'},
    }

    def __init__(
        self,
        *,
        system: Optional["SystemChild"] = None,
        status_count: Optional["AssetsStatusCountChild"] = None,
        status_percentage: Optional["AssetsStatusPercentageChild"] = None,
        **kwargs
    ):
        super(SystemAssetsStatusSummaryResponse, self).__init__(**kwargs)
        self.system = system
        self.asset_count = None
        self.status_count = status_count
        self.status_percentage = status_percentage


class SystemChild(msrest.serialization.Model):
    """SystemChild.

    All required parameters must be populated in order to send to Azure.

    :param system_id: Required.
    :type system_id: str
    :param system_name: Required.
    :type system_name: str
    :param system_abbreviation:
    :type system_abbreviation: str
    """

    _validation = {
        'system_id': {'required': True},
        'system_name': {'required': True},
    }

    _attribute_map = {
        'system_id': {'key': 'SystemId', 'type': 'str'},
        'system_name': {'key': 'SystemName', 'type': 'str'},
        'system_abbreviation': {'key': 'SystemAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        system_id: str,
        system_name: str,
        system_abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(SystemChild, self).__init__(**kwargs)
        self.system_id = system_id
        self.system_name = system_name
        self.system_abbreviation = system_abbreviation


class SystemCreateRequest(msrest.serialization.Model):
    """SystemCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param location_id: Required.
    :type location_id: str
    :param is_collector_dependent_system:
    :type is_collector_dependent_system: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'location_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'is_collector_dependent_system': {'key': 'IsCollectorDependentSystem', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        location_id: str,
        abbreviation: Optional[str] = None,
        is_collector_dependent_system: Optional[bool] = None,
        **kwargs
    ):
        super(SystemCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.location_id = location_id
        self.is_collector_dependent_system = is_collector_dependent_system


class SystemResponse(msrest.serialization.Model):
    """SystemResponse.

    All required parameters must be populated in order to send to Azure.

    :param is_collector_dependent_system:
    :type is_collector_dependent_system: bool
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'is_collector_dependent_system': {'key': 'IsCollectorDependentSystem', 'type': 'bool'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        active: bool,
        is_paused: bool,
        is_snoozed: bool,
        created: datetime.datetime,
        corporation: "CorporationChild",
        location: "LocationChild",
        is_collector_dependent_system: Optional[bool] = None,
        children: Optional[List["DescendantChild"]] = None,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(SystemResponse, self).__init__(**kwargs)
        self.is_collector_dependent_system = is_collector_dependent_system
        self.children = children
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.is_paused = is_paused
        self.is_snoozed = is_snoozed
        self.created = created
        self.corporation = corporation
        self.location = location


class SystemUpdateRequest(msrest.serialization.Model):
    """SystemUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param is_paused: Required.
    :type is_paused: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 100, 'min_length': 0},
        'abbreviation': {'max_length': 5, 'min_length': 0},
        'is_paused': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        is_paused: bool,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(SystemUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.abbreviation = abbreviation
        self.is_paused = is_paused


class TagChild(msrest.serialization.Model):
    """TagChild.

    :param tag_id:
    :type tag_id: str
    :param tag_name:
    :type tag_name: str
    :param tag_category:  Possible values include: "General", "Components", "Make", "Model",
     "Location", "Orientation", "Asset", "AssetCode", "Picture".
    :type tag_category: str or ~smartdiagnostics_sdk.models.TagChildTagCategory
    """

    _validation = {
        'tag_name': {'max_length': 50, 'min_length': 0},
    }

    _attribute_map = {
        'tag_id': {'key': 'TagId', 'type': 'str'},
        'tag_name': {'key': 'TagName', 'type': 'str'},
        'tag_category': {'key': 'TagCategory', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tag_id: Optional[str] = None,
        tag_name: Optional[str] = None,
        tag_category: Optional[Union[str, "TagChildTagCategory"]] = None,
        **kwargs
    ):
        super(TagChild, self).__init__(**kwargs)
        self.tag_id = tag_id
        self.tag_name = tag_name
        self.tag_category = tag_category


class TagCreateRequest(msrest.serialization.Model):
    """TagCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param type: Required.  Possible values include: "General", "Components", "Make", "Model",
     "Location", "Orientation", "Asset", "AssetCode", "Picture".
    :type type: str or ~smartdiagnostics_sdk.models.TagCreateRequestType
    :param location_id: Required.
    :type location_id: str
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'type': {'required': True},
        'location_id': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'type': {'key': 'Type', 'type': 'str'},
        'location_id': {'key': 'LocationId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: Union[str, "TagCreateRequestType"],
        location_id: str,
        **kwargs
    ):
        super(TagCreateRequest, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.location_id = location_id


class TagResponse(msrest.serialization.Model):
    """TagResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param active: Required.
    :type active: bool
    :param type: Required.  Possible values include: "General", "Components", "Make", "Model",
     "Location", "Orientation", "Asset", "AssetCode", "Picture".
    :type type: str or ~smartdiagnostics_sdk.models.TagResponseType
    :param is_global:
    :type is_global: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param updated: Required.
    :type updated: ~datetime.datetime
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'type': {'required': True},
        'created': {'required': True},
        'updated': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'type': {'key': 'Type', 'type': 'str'},
        'is_global': {'key': 'IsGlobal', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'updated': {'key': 'Updated', 'type': 'iso-8601'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        id: str,
        name: str,
        active: bool,
        type: Union[str, "TagResponseType"],
        created: datetime.datetime,
        updated: datetime.datetime,
        location: "LocationChild",
        is_global: Optional[bool] = None,
        **kwargs
    ):
        super(TagResponse, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.active = active
        self.type = type
        self.is_global = is_global
        self.created = created
        self.updated = updated
        self.location = location


class TagUpdateRequest(msrest.serialization.Model):
    """TagUpdateRequest.

    All required parameters must be populated in order to send to Azure.

    :param name: Required.
    :type name: str
    :param active: Required.
    :type active: bool
    """

    _validation = {
        'name': {'required': True, 'max_length': 50, 'min_length': 0},
        'active': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'Name', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        active: bool,
        **kwargs
    ):
        super(TagUpdateRequest, self).__init__(**kwargs)
        self.name = name
        self.active = active


class TargetedSoftwareReleaseChild(msrest.serialization.Model):
    """TargetedSoftwareReleaseChild.

    :param targeted_software_release_id:
    :type targeted_software_release_id: int
    :param targeted_software_release_name:
    :type targeted_software_release_name: str
    """

    _attribute_map = {
        'targeted_software_release_id': {'key': 'TargetedSoftwareReleaseId', 'type': 'int'},
        'targeted_software_release_name': {'key': 'TargetedSoftwareReleaseName', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        targeted_software_release_id: Optional[int] = None,
        targeted_software_release_name: Optional[str] = None,
        **kwargs
    ):
        super(TargetedSoftwareReleaseChild, self).__init__(**kwargs)
        self.targeted_software_release_id = targeted_software_release_id
        self.targeted_software_release_name = targeted_software_release_name


class TimeRangeModelV3(msrest.serialization.Model):
    """TimeRangeModelV3.

    :param start_date:
    :type start_date: ~datetime.datetime
    :param end_date:
    :type end_date: ~datetime.datetime
    """

    _attribute_map = {
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        start_date: Optional[datetime.datetime] = None,
        end_date: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(TimeRangeModelV3, self).__init__(**kwargs)
        self.start_date = start_date
        self.end_date = end_date


class TokenExchangeRequest(msrest.serialization.Model):
    """TokenExchangeRequest.

    :param token:
    :type token: str
    """

    _attribute_map = {
        'token': {'key': 'Token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        token: Optional[str] = None,
        **kwargs
    ):
        super(TokenExchangeRequest, self).__init__(**kwargs)
        self.token = token


class TokenExchangeResponse(msrest.serialization.Model):
    """TokenExchangeResponse.

    :param token:
    :type token: str
    """

    _attribute_map = {
        'token': {'key': 'Token', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        token: Optional[str] = None,
        **kwargs
    ):
        super(TokenExchangeResponse, self).__init__(**kwargs)
        self.token = token


class TreeItemAvailableAssetClassResponse(msrest.serialization.Model):
    """TreeItemAvailableAssetClassResponse.

    :param tree_item:
    :type tree_item: ~smartdiagnostics_sdk.models.TreeItemChild
    :param asset_class_code:
    :type asset_class_code: str
    :param asset_type:
    :type asset_type: ~smartdiagnostics_sdk.models.AssetTypeChild
    :param asset_category:
    :type asset_category: ~smartdiagnostics_sdk.models.AssetCategoryChild
    :param asset_size:
    :type asset_size: ~smartdiagnostics_sdk.models.AssetSizeChild
    """

    _attribute_map = {
        'tree_item': {'key': 'TreeItem', 'type': 'TreeItemChild'},
        'asset_class_code': {'key': 'AssetClassCode', 'type': 'str'},
        'asset_type': {'key': 'AssetType', 'type': 'AssetTypeChild'},
        'asset_category': {'key': 'AssetCategory', 'type': 'AssetCategoryChild'},
        'asset_size': {'key': 'AssetSize', 'type': 'AssetSizeChild'},
    }

    def __init__(
        self,
        *,
        tree_item: Optional["TreeItemChild"] = None,
        asset_class_code: Optional[str] = None,
        asset_type: Optional["AssetTypeChild"] = None,
        asset_category: Optional["AssetCategoryChild"] = None,
        asset_size: Optional["AssetSizeChild"] = None,
        **kwargs
    ):
        super(TreeItemAvailableAssetClassResponse, self).__init__(**kwargs)
        self.tree_item = tree_item
        self.asset_class_code = asset_class_code
        self.asset_type = asset_type
        self.asset_category = asset_category
        self.asset_size = asset_size


class TreeItemChild(msrest.serialization.Model):
    """TreeItemChild.

    :param tree_item_id:
    :type tree_item_id: str
    :param tree_item_name:
    :type tree_item_name: str
    :param tree_item_abbreviation:
    :type tree_item_abbreviation: str
    """

    _attribute_map = {
        'tree_item_id': {'key': 'TreeItemId', 'type': 'str'},
        'tree_item_name': {'key': 'TreeItemName', 'type': 'str'},
        'tree_item_abbreviation': {'key': 'TreeItemAbbreviation', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tree_item_id: Optional[str] = None,
        tree_item_name: Optional[str] = None,
        tree_item_abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(TreeItemChild, self).__init__(**kwargs)
        self.tree_item_id = tree_item_id
        self.tree_item_name = tree_item_name
        self.tree_item_abbreviation = tree_item_abbreviation


class TreeItemResponse(msrest.serialization.Model):
    """TreeItemResponse.

    All required parameters must be populated in order to send to Azure.

    :param tree_item_type: Required.  Possible values include: "Asset", "MonitoringPoint",
     "IndicatorGroup", "Group", "AnalyticModel".
    :type tree_item_type: str or ~smartdiagnostics_sdk.models.TreeItemResponseTreeItemType
    :param sort_order: Required.
    :type sort_order: int
    :param has_children: Required.
    :type has_children: bool
    :param alarm_severity_level: Required.
    :type alarm_severity_level: int
    :param asset_class_code:
    :type asset_class_code: str
    :param is_collector_dependent_system:
    :type is_collector_dependent_system: bool
    :param asset_type:
    :type asset_type: ~smartdiagnostics_sdk.models.AssetTypeChild
    :param asset_category:
    :type asset_category: ~smartdiagnostics_sdk.models.AssetCategoryChild
    :param asset_size:
    :type asset_size: ~smartdiagnostics_sdk.models.AssetSizeChild
    :param parent:
    :type parent: ~smartdiagnostics_sdk.models.ParentChild
    :param children:
    :type children: list[~smartdiagnostics_sdk.models.DescendantChild]
    :param hierarchy:
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    :param id: Required.
    :type id: str
    :param name: Required.
    :type name: str
    :param abbreviation:
    :type abbreviation: str
    :param active: Required.
    :type active: bool
    :param is_paused: Required.
    :type is_paused: bool
    :param is_snoozed: Required.
    :type is_snoozed: bool
    :param created: Required.
    :type created: ~datetime.datetime
    :param corporation: Required.
    :type corporation: ~smartdiagnostics_sdk.models.CorporationChild
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    """

    _validation = {
        'tree_item_type': {'required': True},
        'sort_order': {'required': True},
        'has_children': {'required': True},
        'alarm_severity_level': {'required': True},
        'id': {'required': True},
        'name': {'required': True},
        'active': {'required': True},
        'is_paused': {'required': True},
        'is_snoozed': {'required': True},
        'created': {'required': True},
        'corporation': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'tree_item_type': {'key': 'TreeItemType', 'type': 'str'},
        'sort_order': {'key': 'SortOrder', 'type': 'int'},
        'has_children': {'key': 'HasChildren', 'type': 'bool'},
        'alarm_severity_level': {'key': 'AlarmSeverityLevel', 'type': 'int'},
        'asset_class_code': {'key': 'AssetClassCode', 'type': 'str'},
        'is_collector_dependent_system': {'key': 'IsCollectorDependentSystem', 'type': 'bool'},
        'asset_type': {'key': 'AssetType', 'type': 'AssetTypeChild'},
        'asset_category': {'key': 'AssetCategory', 'type': 'AssetCategoryChild'},
        'asset_size': {'key': 'AssetSize', 'type': 'AssetSizeChild'},
        'parent': {'key': 'Parent', 'type': 'ParentChild'},
        'children': {'key': 'Children', 'type': '[DescendantChild]'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
        'id': {'key': 'Id', 'type': 'str'},
        'name': {'key': 'Name', 'type': 'str'},
        'abbreviation': {'key': 'Abbreviation', 'type': 'str'},
        'active': {'key': 'Active', 'type': 'bool'},
        'is_paused': {'key': 'IsPaused', 'type': 'bool'},
        'is_snoozed': {'key': 'IsSnoozed', 'type': 'bool'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'corporation': {'key': 'Corporation', 'type': 'CorporationChild'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
    }

    def __init__(
        self,
        *,
        tree_item_type: Union[str, "TreeItemResponseTreeItemType"],
        sort_order: int,
        has_children: bool,
        alarm_severity_level: int,
        id: str,
        name: str,
        active: bool,
        is_paused: bool,
        is_snoozed: bool,
        created: datetime.datetime,
        corporation: "CorporationChild",
        location: "LocationChild",
        asset_class_code: Optional[str] = None,
        is_collector_dependent_system: Optional[bool] = None,
        asset_type: Optional["AssetTypeChild"] = None,
        asset_category: Optional["AssetCategoryChild"] = None,
        asset_size: Optional["AssetSizeChild"] = None,
        parent: Optional["ParentChild"] = None,
        children: Optional[List["DescendantChild"]] = None,
        hierarchy: Optional[List["HierarchyChild"]] = None,
        abbreviation: Optional[str] = None,
        **kwargs
    ):
        super(TreeItemResponse, self).__init__(**kwargs)
        self.tree_item_type = tree_item_type
        self.sort_order = sort_order
        self.has_children = has_children
        self.alarm_severity_level = alarm_severity_level
        self.asset_class_code = asset_class_code
        self.is_collector_dependent_system = is_collector_dependent_system
        self.asset_type = asset_type
        self.asset_category = asset_category
        self.asset_size = asset_size
        self.parent = parent
        self.children = children
        self.hierarchy = hierarchy
        self.id = id
        self.name = name
        self.abbreviation = abbreviation
        self.active = active
        self.is_paused = is_paused
        self.is_snoozed = is_snoozed
        self.created = created
        self.corporation = corporation
        self.location = location


class UpdateBearingsForGroupRequest(msrest.serialization.Model):
    """UpdateBearingsForGroupRequest.

    All required parameters must be populated in order to send to Azure.

    :param bearing_ids: Required.
    :type bearing_ids: list[str]
    """

    _validation = {
        'bearing_ids': {'required': True},
    }

    _attribute_map = {
        'bearing_ids': {'key': 'BearingIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        bearing_ids: List[str],
        **kwargs
    ):
        super(UpdateBearingsForGroupRequest, self).__init__(**kwargs)
        self.bearing_ids = bearing_ids


class UserChild(msrest.serialization.Model):
    """UserChild.

    :param user_id:
    :type user_id: str
    :param user_first_name:
    :type user_first_name: str
    :param user_last_name:
    :type user_last_name: str
    :param user_email:
    :type user_email: str
    """

    _attribute_map = {
        'user_id': {'key': 'UserId', 'type': 'str'},
        'user_first_name': {'key': 'UserFirstName', 'type': 'str'},
        'user_last_name': {'key': 'UserLastName', 'type': 'str'},
        'user_email': {'key': 'UserEmail', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        user_id: Optional[str] = None,
        user_first_name: Optional[str] = None,
        user_last_name: Optional[str] = None,
        user_email: Optional[str] = None,
        **kwargs
    ):
        super(UserChild, self).__init__(**kwargs)
        self.user_id = user_id
        self.user_first_name = user_first_name
        self.user_last_name = user_last_name
        self.user_email = user_email


class UserCorporationChild(msrest.serialization.Model):
    """UserCorporationChild.

    All required parameters must be populated in order to send to Azure.

    :param corporation_id: Required.
    :type corporation_id: str
    :param corporation_name: Required.
    :type corporation_name: str
    :param corporation_abbreviation:
    :type corporation_abbreviation: str
    :param corporation_user_role:  Possible values include: "Invalid", "SaasAdmin", "AccountAdmin",
     "ApplicationUser", "Technician", "User", "SystemProcess", "Sentry", "Sales",
     "CorporationAdmin", "CorporationUser", "CorporationNone".
    :type corporation_user_role: str or
     ~smartdiagnostics_sdk.models.UserCorporationChildCorporationUserRole
    """

    _validation = {
        'corporation_id': {'required': True},
        'corporation_name': {'required': True},
    }

    _attribute_map = {
        'corporation_id': {'key': 'CorporationId', 'type': 'str'},
        'corporation_name': {'key': 'CorporationName', 'type': 'str'},
        'corporation_abbreviation': {'key': 'CorporationAbbreviation', 'type': 'str'},
        'corporation_user_role': {'key': 'CorporationUserRole', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        corporation_id: str,
        corporation_name: str,
        corporation_abbreviation: Optional[str] = None,
        corporation_user_role: Optional[Union[str, "UserCorporationChildCorporationUserRole"]] = None,
        **kwargs
    ):
        super(UserCorporationChild, self).__init__(**kwargs)
        self.corporation_id = corporation_id
        self.corporation_name = corporation_name
        self.corporation_abbreviation = corporation_abbreviation
        self.corporation_user_role = corporation_user_role


class UserLocationChild(msrest.serialization.Model):
    """UserLocationChild.

    All required parameters must be populated in order to send to Azure.

    :param location_id: Required.
    :type location_id: str
    :param location_name: Required.
    :type location_name: str
    :param location_abbreviation:
    :type location_abbreviation: str
    :param location_user_role:  Possible values include: "Invalid", "SaasAdmin", "AccountAdmin",
     "ApplicationUser", "Technician", "User", "SystemProcess", "Sentry", "Sales",
     "CorporationAdmin", "CorporationUser", "CorporationNone".
    :type location_user_role: str or ~smartdiagnostics_sdk.models.UserLocationChildLocationUserRole
    """

    _validation = {
        'location_id': {'required': True},
        'location_name': {'required': True},
    }

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'location_name': {'key': 'LocationName', 'type': 'str'},
        'location_abbreviation': {'key': 'LocationAbbreviation', 'type': 'str'},
        'location_user_role': {'key': 'LocationUserRole', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location_id: str,
        location_name: str,
        location_abbreviation: Optional[str] = None,
        location_user_role: Optional[Union[str, "UserLocationChildLocationUserRole"]] = None,
        **kwargs
    ):
        super(UserLocationChild, self).__init__(**kwargs)
        self.location_id = location_id
        self.location_name = location_name
        self.location_abbreviation = location_abbreviation
        self.location_user_role = location_user_role


class WidgetChild(msrest.serialization.Model):
    """WidgetChild.

    All required parameters must be populated in order to send to Azure.

    :param widget_id: Required.
    :type widget_id: int
    :param widget_code:  Possible values include: "AssetMonitoring", "Alerts", "TimeWarningAlarm",
     "PerformanceOverall", "PerformanceComparison", "PerformanceKpi", "PerformanceScore",
     "PerformanceTrend".
    :type widget_code: str or ~smartdiagnostics_sdk.models.WidgetChildWidgetCode
    :param widget_name: Required.
    :type widget_name: str
    :param widget_description:
    :type widget_description: str
    :param widget_type:
    :type widget_type: ~smartdiagnostics_sdk.models.WidgetTypeChild
    """

    _validation = {
        'widget_id': {'required': True},
        'widget_name': {'required': True},
    }

    _attribute_map = {
        'widget_id': {'key': 'WidgetId', 'type': 'int'},
        'widget_code': {'key': 'WidgetCode', 'type': 'str'},
        'widget_name': {'key': 'WidgetName', 'type': 'str'},
        'widget_description': {'key': 'WidgetDescription', 'type': 'str'},
        'widget_type': {'key': 'WidgetType', 'type': 'WidgetTypeChild'},
    }

    def __init__(
        self,
        *,
        widget_id: int,
        widget_name: str,
        widget_code: Optional[Union[str, "WidgetChildWidgetCode"]] = None,
        widget_description: Optional[str] = None,
        widget_type: Optional["WidgetTypeChild"] = None,
        **kwargs
    ):
        super(WidgetChild, self).__init__(**kwargs)
        self.widget_id = widget_id
        self.widget_code = widget_code
        self.widget_name = widget_name
        self.widget_description = widget_description
        self.widget_type = widget_type


class WidgetTemplateChild(msrest.serialization.Model):
    """WidgetTemplateChild.

    All required parameters must be populated in order to send to Azure.

    :param widget_template_name: Required.
    :type widget_template_name: str
    :param widget_template_description:
    :type widget_template_description: str
    :param widget_template_filters:
    :type widget_template_filters: list[~smartdiagnostics_sdk.models.WidgetTemplateFilterChild]
    """

    _validation = {
        'widget_template_name': {'required': True},
    }

    _attribute_map = {
        'widget_template_name': {'key': 'WidgetTemplateName', 'type': 'str'},
        'widget_template_description': {'key': 'WidgetTemplateDescription', 'type': 'str'},
        'widget_template_filters': {'key': 'WidgetTemplateFilters', 'type': '[WidgetTemplateFilterChild]'},
    }

    def __init__(
        self,
        *,
        widget_template_name: str,
        widget_template_description: Optional[str] = None,
        widget_template_filters: Optional[List["WidgetTemplateFilterChild"]] = None,
        **kwargs
    ):
        super(WidgetTemplateChild, self).__init__(**kwargs)
        self.widget_template_name = widget_template_name
        self.widget_template_description = widget_template_description
        self.widget_template_filters = widget_template_filters


class WidgetTemplateFilterChild(msrest.serialization.Model):
    """WidgetTemplateFilterChild.

    All required parameters must be populated in order to send to Azure.

    :param filter_data_field_code: Required.
    :type filter_data_field_code: str
    :param filter_data_field_name: Required.
    :type filter_data_field_name: str
    :param filter_operator: Required.
    :type filter_operator: str
    :param filter_value: Required.
    :type filter_value: str
    """

    _validation = {
        'filter_data_field_code': {'required': True},
        'filter_data_field_name': {'required': True},
        'filter_operator': {'required': True},
        'filter_value': {'required': True},
    }

    _attribute_map = {
        'filter_data_field_code': {'key': 'FilterDataFieldCode', 'type': 'str'},
        'filter_data_field_name': {'key': 'FilterDataFieldName', 'type': 'str'},
        'filter_operator': {'key': 'FilterOperator', 'type': 'str'},
        'filter_value': {'key': 'FilterValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        filter_data_field_code: str,
        filter_data_field_name: str,
        filter_operator: str,
        filter_value: str,
        **kwargs
    ):
        super(WidgetTemplateFilterChild, self).__init__(**kwargs)
        self.filter_data_field_code = filter_data_field_code
        self.filter_data_field_name = filter_data_field_name
        self.filter_operator = filter_operator
        self.filter_value = filter_value


class WidgetTypeChild(msrest.serialization.Model):
    """WidgetTypeChild.

    All required parameters must be populated in order to send to Azure.

    :param widget_type_id: Required.
    :type widget_type_id: int
    :param widget_type_name: Required.  Possible values include: "Value", "Table", "Kpi", "Series".
    :type widget_type_name: str or ~smartdiagnostics_sdk.models.WidgetTypeChildWidgetTypeName
    :param widget_type_description:
    :type widget_type_description: str
    """

    _validation = {
        'widget_type_id': {'required': True},
        'widget_type_name': {'required': True},
    }

    _attribute_map = {
        'widget_type_id': {'key': 'WidgetTypeId', 'type': 'int'},
        'widget_type_name': {'key': 'WidgetTypeName', 'type': 'str'},
        'widget_type_description': {'key': 'WidgetTypeDescription', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        widget_type_id: int,
        widget_type_name: Union[str, "WidgetTypeChildWidgetTypeName"],
        widget_type_description: Optional[str] = None,
        **kwargs
    ):
        super(WidgetTypeChild, self).__init__(**kwargs)
        self.widget_type_id = widget_type_id
        self.widget_type_name = widget_type_name
        self.widget_type_description = widget_type_description
