# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['commando']

package_data = \
{'': ['*']}

setup_kwargs = {
    'name': 'pycommando',
    'version': '1.0.0',
    'description': 'A framework for batch processing.',
    'long_description': '# Commando\n\nCommando is a framework for batch processing.\n\nVersioning of this repository follows [Semantic Versioning 2.0.0](https://semver.org/)\n\n\xe3\x82\xb3\xe3\x83\x9e\xe3\x83\xb3\xe3\x83\x89\xe3\x83\xa9\xe3\x82\xa4\xe3\x83\xb3\xe3\x83\x84\xe3\x83\xbc\xe3\x83\xab\xe3\x82\x92\xe8\x84\xb3\xe7\xad\x8b\xe3\x81\xa7\xe5\xae\x9f\xe8\xa1\x8c\xe3\x81\x97\xe3\x81\xa6\xe3\x81\x84\xe3\x81\x8f\xe3\x83\x90\xe3\x83\x83\xe3\x83\x81\xe5\x87\xa6\xe7\x90\x86\xe3\x81\xae\xe3\x81\x9f\xe3\x82\x81\xe3\x81\xae\xe3\x83\x95\xe3\x83\xac\xe3\x83\xbc\xe3\x83\xa0\xe3\x83\xaf\xe3\x83\xbc\xe3\x82\xaf\xe3\x80\x82\n\xe5\x9f\xba\xe6\x9c\xac\xe7\x9a\x84\xe3\x81\xabPython\xe3\x81\xae\xe6\xa7\x8b\xe6\x96\x87\xe3\x81\xa7\xe3\x83\xaf\xe3\x83\xbc\xe3\x82\xaf\xe3\x83\x95\xe3\x83\xad\xe3\x83\xbc\xe3\x82\x92\xe6\xa7\x8b\xe7\xaf\x89\xe3\x81\xa7\xe3\x81\x8d\xe3\x82\x8b\xe3\x81\xae\xe3\x81\xa7\xe3\x80\x81\xe3\x83\x90\xe3\x83\x83\xe3\x83\x81\xe5\x87\xa6\xe7\x90\x86\xe3\x81\xa7\xe3\x81\xae\xe5\xa4\x89\xe6\x95\xb0\xe3\x81\xae\xe5\x8f\x96\xe3\x82\x8a\xe5\x9b\x9e\xe3\x81\x97\xe3\x81\xaa\xe3\x81\xa9\xe3\x81\x8c\xe3\x81\x97\xe3\x82\x84\xe3\x81\x99\xe3\x81\x84\xe3\x81\xae\xe3\x81\x8c\xe3\x83\xa1\xe3\x83\xaa\xe3\x83\x83\xe3\x83\x88\xe3\x80\x82\n\nShell Script \xe3\x82\x84 Bat \xe3\x83\x95\xe3\x82\xa1\xe3\x82\xa4\xe3\x83\xab\xe3\x82\x92\xe6\x9b\xb8\xe3\x81\x8b\xe3\x81\xaa\xe3\x81\x8f\xe3\x81\xa6\xe3\x82\x82\xe5\xae\x9f\xe8\xa1\x8c\xe3\x81\x97\xe3\x81\x9f\xe3\x81\x84\xe3\x82\xb3\xe3\x83\x9e\xe3\x83\xb3\xe3\x83\x89\xe3\x81\x95\xe3\x81\x88\xe3\x82\x8f\xe3\x81\x8b\xe3\x81\xa3\xe3\x81\xa6\xe3\x81\x84\xe3\x82\x8c\xe3\x81\xb0\xe3\x83\x90\xe3\x83\x83\xe3\x83\x81\xe5\x87\xa6\xe7\x90\x86\xe3\x81\x8c\xe6\x9b\xb8\xe3\x81\x91\xe3\x82\x8b\xe3\x80\x82\n\n## Concept\n- \xe3\x83\x90\xe3\x83\x83\xe3\x83\x81\xe5\x87\xa6\xe7\x90\x86\xe3\x83\xaf\xe3\x83\xbc\xe3\x82\xaf\xe3\x83\x95\xe3\x83\xad\xe3\x83\xbc\xe3\x82\x92\xe6\xa7\x8b\xe7\xaf\x89\xe3\x81\x99\xe3\x82\x8b\xe3\x81\x9f\xe3\x82\x81\xe3\x81\xae\xe3\x83\x95\xe3\x83\xac\xe3\x83\xbc\xe3\x83\xa0\xe3\x83\xaf\xe3\x83\xbc\xe3\x82\xaf\n- \xe9\x80\x90\xe6\xac\xa1\xe5\x87\xa6\xe7\x90\x86\xe3\x81\xa7\xe6\x9b\xb8\xe3\x81\x8f\n- \xe5\xa4\x96\xe9\x83\xa8\xe3\x82\xb3\xe3\x83\x9e\xe3\x83\xb3\xe3\x83\x89\xe3\x81\xab\xe9\x96\xa2\xe3\x81\x97\xe3\x81\xa6\xe3\x81\xaf subprocess.run()\xe3\x81\x8c\xe8\xb5\xb0\xe3\x82\x8b\n\n\n## Feature\n- `add()`\n    - add command\n- `execute(): `\n    - Execute the added command.\n- Process them in the order they were added.\n- Functions can also be executed as commands\n\n## Usage\n\ninstall\n```shell\npip install pycommando\n```\n\nscript\n```python\nimport logging\n\nfrom commando import commando\n\nlogging.basicConfig(filename="test.log", level=logging.DEBUG)\n\n\ndef zero():\n    1 / 0\n\n\ncommando.add("mkdir test")\ncommando.add("touch test\\\\test.txt")\ncommando.add(zero)\n\ncommando.execute()\n```\n\nlog\n```log\nDEBUG:commando.commando:mkdir test\nDEBUG:commando.commando:touch test\\test.txt\nDEBUG:commando.commando:<function zero at 0x01A177C0>\nERROR:commando.commando:Could not execute function\nTraceback (most recent call last):\n  File "C:\\Users\\test\\dev\\pydev\\venv\\lib\\site-packages\\commando\\commando.py", line 28, in execute\n    cmd()\n  File "main.py", line 10, in zero\n    1 / 0\nZeroDivisionError: division by zero\n```\n',
    'author': 'zztkm',
    'author_email': None,
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
