


from django.db import migrations, models
import djangocms_charts.models


class Migration(migrations.Migration):

    dependencies = [
        ('cms', '0001_initial'),
        ('sites', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='ChartJsBarModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(on_delete=models.CASCADE, parent_link=True, auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(max_length=256, verbose_name='Name')),
                ('table_data', models.TextField(verbose_name='Chart Table data', blank=True)),
                ('labels_top', models.BooleanField(default=True, help_text=b'here is some help', verbose_name='Labels top row')),
                ('labels_left', models.BooleanField(default=True, verbose_name='Labels left column')),
                ('data_series_format', models.CharField(default=b'rows', max_length=10, verbose_name='Data series in Rows or Cols)')),
                ('chart_width', models.IntegerField(default=400, verbose_name='Chart Width')),
                ('chart_height', models.IntegerField(default=400, verbose_name='Chart Height')),
                ('title_display', models.BooleanField(default=True, verbose_name='Display Title')),
                ('legend_display', models.BooleanField(default=True, verbose_name='Display Legend')),
                ('legend_position', models.CharField(max_length=100, verbose_name='Legend Position')),
                ('chart_classes', models.TextField(verbose_name='Additional classes for Chart', blank=True)),
                ('chart_container_classes', models.TextField( verbose_name='Additional classes for Chart Container', blank=True)),
                ('chart_title_classes', models.TextField( verbose_name='Additional classes for Chart Title', blank=True)),
                ('legend_classes', models.TextField( verbose_name='Additional classes for Legend', blank=True)),
                ('option_scaleBeginAtZero', models.BooleanField(default=True, verbose_name='Scale should start at zero, or an order of magnitude down from the lowest value')),
                ('option_scaleShowGridLines', models.BooleanField(default=True, verbose_name='Grid lines are shown across the chart')),
                ('option_scaleGridLineColor', models.CharField(default=b'rgba(0,0,0,.05)', max_length=300, verbose_name='Colour of the grid lines', blank=True)),
                ('option_scaleGridLineWidth', models.IntegerField(default=1, null=True, verbose_name='Width of the grid lines', blank=True)),
                ('option_scaleShowHorizontalLines', models.BooleanField(default=True, verbose_name='Show horizontal lines (except X axis)')),
                ('option_scaleShowVerticalLines', models.BooleanField(default=True, verbose_name='Show vertical lines (except Y axis)')),
                ('option_barShowStroke', models.BooleanField(default=True, verbose_name='Stroke on each bar')),
                ('option_barStrokeWidth', models.IntegerField(default=2, null=True, verbose_name='Pixel width of the bar stroke', blank=True)),
                ('option_barValueSpacing', models.IntegerField(default=5, null=True, verbose_name='Spacing between each of the X value sets', blank=True)),
                ('option_barDatasetSpacing', models.IntegerField(default=1, null=True, verbose_name='Spacing between data sets within X values', blank=True)),
                ('option_legendTemplate', models.CharField(default=b'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].fillColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>', max_length=300, verbose_name='Legend template', blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='ChartJsDoughnutModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(on_delete=models.CASCADE, parent_link=True, auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(max_length=256, verbose_name='Name')),
                ('table_data', models.TextField(verbose_name='Chart Table data', blank=True)),
                ('labels_top', models.BooleanField(default=True, help_text=b'here is some help', verbose_name='Labels top row')),
                ('labels_left', models.BooleanField(default=True, verbose_name='Labels left column')),
                ('data_series_format', models.CharField(default=b'rows', max_length=10, verbose_name='Data series in Rows or Cols)')),
                ('chart_width', models.IntegerField(default=400, verbose_name='Chart Width')),
                ('chart_height', models.IntegerField(default=400, verbose_name='Chart Height')),
                ('title_display', models.BooleanField(default=True, verbose_name='Display Title')),
                ('legend_display', models.BooleanField(default=True, verbose_name='Display Legend')),
                ('legend_position', models.CharField(max_length=100, verbose_name='Legend Position')),
                ('chart_classes', models.TextField(verbose_name='Additional classes for Chart', blank=True)),
                ('chart_container_classes', models.TextField(verbose_name='Additional classes for Chart Container', blank=True)),
                ('chart_title_classes', models.TextField( verbose_name='Additional classes for Chart Title', blank=True)),
                ('legend_classes', models.TextField( verbose_name='Additional classes for Legend', blank=True)),
                ('option_segmentShowStroke', models.BooleanField(default=True, verbose_name='Show a stroke on each segment')),
                ('option_segmentStrokeColor', models.CharField(default=b'#fff', max_length=300, verbose_name='The colour of each segment stroke', blank=True)),
                ('option_segmentStrokeWidth', models.IntegerField(default=2, null=True, verbose_name='The width of each segment stroke', blank=True)),
                ('option_animationSteps', models.IntegerField(default=100, null=True, verbose_name='Amount of animation steps', blank=True)),
                ('option_animationEasing', models.CharField(default=b'easeOutBounce', max_length=300, verbose_name='Animation easing effect', blank=True)),
                ('option_animateRotate', models.BooleanField(default=True, verbose_name='Animate the rotation of the Chart')),
                ('option_animateScale', models.BooleanField(default=False, verbose_name='Animate scaling the Doughnut from the centre')),
                ('option_legendTemplate', models.CharField(default=b'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>', max_length=300, verbose_name='Legend template', blank=True)),
                ('option_percentageInnerCutout', models.IntegerField(default=50, null=True, verbose_name='The percentage of the chart that we cut out of the middle', blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='ChartJsGlobalSettingsModel',
            fields=[
                ('id', models.AutoField(verbose_name='ID', serialize=False, auto_created=True, primary_key=True)),
                ('enable', models.BooleanField(default=True, verbose_name='Enable Global Settings')),
                ('name', models.CharField(default='Global ChartJs Settings', max_length=250, verbose_name='Name')),
                ('animation', models.BooleanField(default=True, verbose_name='Animate the chart')),
                ('animationSteps', models.IntegerField(default=60, null=True, verbose_name='Number of animation steps', blank=True)),
                ('animationEasing', models.CharField(default='easeOutQuart', max_length=300, verbose_name='Animation easing effect', blank=True)),
                ('showScale', models.BooleanField(default=True, verbose_name='Show the scale')),
                ('scaleOverride', models.BooleanField(default=False, verbose_name='Override with a hard coded scale')),
                ('scaleSteps', models.IntegerField(null=True, verbose_name='Number of steps in a hard coded scale', blank=True)),
                ('scaleStepWidth', models.IntegerField(null=True, verbose_name='Value jump in the hard coded scale', blank=True)),
                ('scaleStartValue', models.IntegerField(null=True, verbose_name='Scale starting value', blank=True)),
                ('scaleLineColor', models.CharField(default='rgba(0,0,0,0.1)', max_length=300, verbose_name='Colour of the scale line', blank=True)),
                ('scaleLineWidth', models.IntegerField(default=1, null=True, verbose_name='Pixel width of the scale line', blank=True)),
                ('scaleShowLabels', models.BooleanField(default=True, verbose_name='Show labels on the scale')),
                ('scaleLabel', models.CharField(default='<%=value%>', max_length=300, verbose_name='Display value', blank=True)),
                ('scaleIntegersOnly', models.BooleanField(default=True, verbose_name='Scale should stick to integers, not floats')),
                ('scaleBeginAtZero', models.BooleanField(default=False, verbose_name='Scale should start at zero')),
                ('scaleFontFamily', models.CharField(default="'Helvetica Neue' 'Helvetica' 'Arial' sans-serif", max_length=300, verbose_name='Scale label font declaration for the scale label', blank=True)),
                ('scaleFontSize', models.IntegerField(default=12, null=True, verbose_name='Scale label font size in pixels', blank=True)),
                ('scaleFontStyle', models.CharField(default='normal', max_length=300, verbose_name='Scale label font weight style', blank=True)),
                ('scaleFontColor', models.CharField(default='#666', max_length=300, verbose_name='Scale label font colour', blank=True)),
                ('responsive', models.BooleanField(default=False, verbose_name='Chart should be responsive and resize when the browser does.')),
                ('maintainAspectRatio', models.BooleanField(default=True, verbose_name='Maintain the starting aspect ratio when responsive')),
                ('showTooltips', models.BooleanField(default=True, verbose_name='Draw tooltips on the canvas')),
                ('tooltipFillColor', models.CharField(default='rgba(0,0,0,0.8)', max_length=300, verbose_name='Tooltip background colour', blank=True)),
                ('tooltipFontFamily', models.CharField(default="'Helvetica Neue' 'Helvetica' 'Arial' sans-serif", max_length=300, verbose_name='Tooltip label font declaration for the scale label', blank=True)),
                ('tooltipFontSize', models.IntegerField(default=14, null=True, verbose_name='Tooltip label font size in pixels', blank=True)),
                ('tooltipFontStyle', models.CharField(default='normal', max_length=300, verbose_name='Tooltip font weight style', blank=True)),
                ('tooltipFontColor', models.CharField(default='#fff', max_length=300, verbose_name='Tooltip label font colour', blank=True)),
                ('tooltipTitleFontFamily', models.CharField(default="'Helvetica Neue' 'Helvetica' 'Arial' sans-serif", max_length=300, verbose_name='Tooltip title font declaration for the scale label', blank=True)),
                ('tooltipTitleFontSize', models.IntegerField(default=14, null=True, verbose_name='Tooltip title font size in pixels', blank=True)),
                ('tooltipTitleFontStyle', models.CharField(default='bold', max_length=300, verbose_name='Tooltip title font weight style', blank=True)),
                ('tooltipTitleFontColor', models.CharField(default='#fff', max_length=300, verbose_name='Tooltip title font colour', blank=True)),
                ('tooltipYPadding', models.IntegerField(default=6, null=True, verbose_name='pixel width of padding around tooltip text', blank=True)),
                ('tooltipXPadding', models.IntegerField(default=6, null=True, verbose_name='pixel width of padding around tooltip text', blank=True)),
                ('tooltipCaretSize', models.IntegerField(default=8, null=True, verbose_name='Size of the caret on the tooltip', blank=True)),
                ('tooltipCornerRadius', models.IntegerField(default=6, null=True, verbose_name='Pixel radius of the tooltip border', blank=True)),
                ('tooltipXOffset', models.IntegerField(default=10, null=True, verbose_name='Pixel offset from point x to tooltip edge', blank=True)),
                ('tooltipTemplate', models.CharField(max_length=300, verbose_name='Template string for single tooltips', blank=True)),
                ('multiTooltipTemplate', models.CharField(default='<%= value %>', max_length=300, verbose_name='Template string for multiple tooltips', blank=True)),
                ('site', models.ForeignKey(on_delete=models.CASCADE, to='sites.Site')),
            ],
            options={
                'ordering': ['name'],
                'verbose_name': 'ChartJs Global Settings',
                'verbose_name_plural': 'ChartJs Global Settings',
            },
        ),
        migrations.CreateModel(
            name='ChartJsLineModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(on_delete=models.CASCADE, parent_link=True, auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(max_length=256, verbose_name='Name')),
                ('table_data', models.TextField(verbose_name='Chart Table data', blank=True)),
                ('labels_top', models.BooleanField(default=True, help_text=b'here is some help', verbose_name='Labels top row')),
                ('labels_left', models.BooleanField(default=True, verbose_name='Labels left column')),
                ('data_series_format', models.CharField(default=b'rows', max_length=10, verbose_name='Data series in Rows or Cols)')),
                ('chart_width', models.IntegerField(default=400, verbose_name='Chart Width')),
                ('chart_height', models.IntegerField(default=400, verbose_name='Chart Height')),
                ('title_display', models.BooleanField(default=True, verbose_name='Display Title')),
                ('legend_display', models.BooleanField(default=True, verbose_name='Display Legend')),
                ('legend_position', models.CharField(max_length=100, verbose_name='Legend Position')),
                ('chart_classes', models.TextField(verbose_name='Additional classes for Chart', blank=True)),
                ('chart_container_classes', models.TextField( verbose_name='Additional classes for Chart Container', blank=True)),
                ('chart_title_classes', models.TextField(verbose_name='Additional classes for Chart Title', blank=True)),
                ('legend_classes', models.TextField(verbose_name='Additional classes for Legend', blank=True)),
                ('option_scaleShowGridLines', models.BooleanField(default=True, verbose_name='Grid lines are shown across the chart')),
                ('option_scaleGridLineColor', models.CharField(default=b'rgba(0,0,0,.05)', max_length=300, verbose_name='Colour of the grid lines', blank=True)),
                ('option_scaleGridLineWidth', models.IntegerField(default=1, null=True, verbose_name='Width of the grid lines', blank=True)),
                ('option_scaleShowHorizontalLines', models.BooleanField(default=True, verbose_name='Show horizontal lines (except X axis)')),
                ('option_scaleShowVerticalLines', models.BooleanField(default=True, verbose_name='Show vertical lines (except Y axis)')),
                ('option_bezierCurve', models.BooleanField(default=True, verbose_name='Line is curved between points')),
                ('option_bezierCurveTension', models.FloatField(default=0.4, null=True, verbose_name='Tension of the bezier curve between points', blank=True)),
                ('option_pointDot', models.BooleanField(default=True, verbose_name='Show a dot for each point')),
                ('option_pointDotRadius', models.IntegerField(default=4, null=True, verbose_name='Radius of each point dot in pixels', blank=True)),
                ('option_pointDotStrokeWidth', models.IntegerField(default=1, null=True, verbose_name='Pixel width of point dot stroke', blank=True)),
                ('option_pointHitDetectionRadius', models.IntegerField(default=20, null=True, verbose_name='Amount extra to add to the radius to cater for hit detection outside the drawn point', blank=True)),
                ('option_datasetStroke', models.BooleanField(default=True, verbose_name='Show a stroke for datasets')),
                ('option_datasetStrokeWidth', models.IntegerField(default=2, null=True, verbose_name='Pixel width of dataset stroke', blank=True)),
                ('option_datasetFill', models.BooleanField(default=True, verbose_name='Fill the dataset with a colour')),
                ('option_legendTemplate', models.CharField(default=b'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].strokeColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>', max_length=300, verbose_name='A legend template', blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='ChartJsPieModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(on_delete=models.CASCADE, parent_link=True, auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(max_length=256, verbose_name='Name')),
                ('table_data', models.TextField(verbose_name='Chart Table data', blank=True)),
                ('labels_top', models.BooleanField(default=True, help_text=b'here is some help', verbose_name='Labels top row')),
                ('labels_left', models.BooleanField(default=True, verbose_name='Labels left column')),
                ('data_series_format', models.CharField(default=b'rows', max_length=10, verbose_name='Data series in Rows or Cols)')),
                ('chart_width', models.IntegerField(default=400, verbose_name='Chart Width')),
                ('chart_height', models.IntegerField(default=400, verbose_name='Chart Height')),
                ('title_display', models.BooleanField(default=True, verbose_name='Display Title')),
                ('legend_display', models.BooleanField(default=True, verbose_name='Display Legend')),
                ('legend_position', models.CharField(max_length=100, verbose_name='Legend Position')),
                ('chart_classes', models.TextField( verbose_name='Additional classes for Chart', blank=True)),
                ('chart_container_classes', models.TextField(verbose_name='Additional classes for Chart Container', blank=True)),
                ('chart_title_classes', models.TextField(verbose_name='Additional classes for Chart Title', blank=True)),
                ('legend_classes', models.TextField(verbose_name='Additional classes for Legend', blank=True)),
                ('option_segmentShowStroke', models.BooleanField(default=True, verbose_name='Show a stroke on each segment')),
                ('option_segmentStrokeColor', models.CharField(default=b'#fff', max_length=300, verbose_name='The colour of each segment stroke', blank=True)),
                ('option_segmentStrokeWidth', models.IntegerField(default=2, null=True, verbose_name='The width of each segment stroke', blank=True)),
                ('option_animationSteps', models.IntegerField(default=100, null=True, verbose_name='Amount of animation steps', blank=True)),
                ('option_animationEasing', models.CharField(default=b'easeOutBounce', max_length=300, verbose_name='Animation easing effect', blank=True)),
                ('option_animateRotate', models.BooleanField(default=True, verbose_name='Animate the rotation of the Chart')),
                ('option_animateScale', models.BooleanField(default=False, verbose_name='Animate scaling the Doughnut from the centre')),
                ('option_legendTemplate', models.CharField(default=b'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>', max_length=300, verbose_name='Legend template', blank=True)),
                ('option_percentageInnerCutout', models.IntegerField(default=0, null=True, verbose_name='The percentage of the chart that we cut out of the middle', blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='ChartJsPolarModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(on_delete=models.CASCADE, parent_link=True, auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(max_length=256, verbose_name='Name')),
                ('table_data', models.TextField(verbose_name='Chart Table data', blank=True)),
                ('labels_top', models.BooleanField(default=True, help_text=b'here is some help', verbose_name='Labels top row')),
                ('labels_left', models.BooleanField(default=True, verbose_name='Labels left column')),
                ('data_series_format', models.CharField(default=b'rows', max_length=10, verbose_name='Data series in Rows or Cols)')),
                ('chart_width', models.IntegerField(default=400, verbose_name='Chart Width')),
                ('chart_height', models.IntegerField(default=400, verbose_name='Chart Height')),
                ('title_display', models.BooleanField(default=True, verbose_name='Display Title')),
                ('legend_display', models.BooleanField(default=True, verbose_name='Display Legend')),
                ('legend_position', models.CharField(max_length=100, verbose_name='Legend Position')),
                ('chart_classes', models.TextField( verbose_name='Additional classes for Chart', blank=True)),
                ('chart_container_classes', models.TextField( verbose_name='Additional classes for Chart Container', blank=True)),
                ('chart_title_classes', models.TextField( verbose_name='Additional classes for Chart Title', blank=True)),
                ('legend_classes', models.TextField( verbose_name='Additional classes for Legend', blank=True)),
                ('option_scaleShowLabelBackdrop', models.BooleanField(default=True, verbose_name='Show a backdrop to the scale label')),
                ('option_scaleBackdropColor', models.CharField(default=b'rgba(255,255,255,0.75)', max_length=300, verbose_name='The colour of the label backdrop', blank=True)),
                ('option_scaleBeginAtZero', models.BooleanField(default=True, verbose_name='Scale should begin at zero')),
                ('option_scaleBackdropPaddingY', models.IntegerField(default=2, null=True, verbose_name='The backdrop padding above & below the label in pixels', blank=True)),
                ('option_scaleBackdropPaddingX', models.IntegerField(default=2, null=True, verbose_name='The backdrop padding to the side of the label in pixels', blank=True)),
                ('option_scaleShowLine', models.BooleanField(default=True, verbose_name='Show line for each value in the scale')),
                ('option_segmentShowStroke', models.BooleanField(default=True, verbose_name='Stroke a line around each segment in the chart')),
                ('option_segmentStrokeColor', models.CharField(default=b'#fff', max_length=300, verbose_name='The colour of the stroke on each segement.', blank=True)),
                ('option_segmentStrokeWidth', models.IntegerField(default=2, null=True, verbose_name='The width of the stroke value in pixels', blank=True)),
                ('option_animationSteps', models.IntegerField(default=100, null=True, verbose_name='Amount of animation steps', blank=True)),
                ('option_animationEasing', models.CharField(default=b'easeOutBounce', max_length=300, verbose_name='Animation easing effect.', blank=True)),
                ('option_animateRotate', models.BooleanField(default=True, verbose_name='Animate the rotation of the chart')),
                ('option_animateScale', models.BooleanField(default=False, verbose_name='Animate scaling the chart from the centre')),
                ('option_legendTemplate', models.CharField(default=b'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<segments.length; i++){%><li><span style="background-color:<%=segments[i].fillColor%>"></span><%if(segments[i].label){%><%=segments[i].label%><%}%></li><%}%></ul>', max_length=300, verbose_name='A legend template', blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
        migrations.CreateModel(
            name='ChartJsRadarModel',
            fields=[
                ('cmsplugin_ptr', models.OneToOneField(on_delete=models.CASCADE, parent_link=True, auto_created=True, primary_key=True, serialize=False, to='cms.CMSPlugin')),
                ('name', models.CharField(max_length=256, verbose_name='Name')),
                ('table_data', models.TextField(verbose_name='Chart Table data', blank=True)),
                ('labels_top', models.BooleanField(default=True, help_text=b'here is some help', verbose_name='Labels top row')),
                ('labels_left', models.BooleanField(default=True, verbose_name='Labels left column')),
                ('data_series_format', models.CharField(default=b'rows', max_length=10, verbose_name='Data series in Rows or Cols)')),
                ('chart_width', models.IntegerField(default=400, verbose_name='Chart Width')),
                ('chart_height', models.IntegerField(default=400, verbose_name='Chart Height')),
                ('title_display', models.BooleanField(default=True, verbose_name='Display Title')),
                ('legend_display', models.BooleanField(default=True, verbose_name='Display Legend')),
                ('legend_position', models.CharField(max_length=100, verbose_name='Legend Position')),
                ('chart_classes', models.TextField( verbose_name='Additional classes for Chart', blank=True)),
                ('chart_container_classes', models.TextField( verbose_name='Additional classes for Chart Container', blank=True)),
                ('chart_title_classes', models.TextField( verbose_name='Additional classes for Chart Title', blank=True)),
                ('legend_classes', models.TextField( verbose_name='Additional classes for Legend', blank=True)),
                ('option_scaleShowLine', models.BooleanField(default=True, verbose_name='Show lines for each scale point')),
                ('option_angleShowLineOut', models.BooleanField(default=True, verbose_name='Show the angle lines out of the radar')),
                ('option_scaleShowLabels', models.BooleanField(default=False, verbose_name='Show labels on the scale')),
                ('option_scaleBeginAtZero', models.BooleanField(default=True, verbose_name='Scale should begin at zero')),
                ('option_angleLineColor', models.CharField(default=b'rgba(0,0,0,.1)', max_length=300, verbose_name='Colour of the angle line', blank=True)),
                ('option_angleLineWidth', models.IntegerField(default=1, null=True, verbose_name='Pixel width of the angle line', blank=True)),
                ('option_pointLabelFontFamily', models.CharField(default=b"'Arial'", max_length=300, verbose_name='Point label font declaration', blank=True)),
                ('option_pointLabelFontStyle', models.CharField(default=b'normal', max_length=300, verbose_name='Point label font weight', blank=True)),
                ('option_pointLabelFontSize', models.IntegerField(default=10, null=True, verbose_name='Point label font size in pixels', blank=True)),
                ('option_pointLabelFontColor', models.CharField(default=b'#666', max_length=300, verbose_name='Point label font colour', blank=True)),
                ('option_pointDot', models.BooleanField(default=True, verbose_name='Show a dot for each point')),
                ('option_pointDotRadius', models.IntegerField(default=3, null=True, verbose_name='Radius of each point dot in pixels', blank=True)),
                ('option_pointDotStrokeWidth', models.IntegerField(default=1, null=True, verbose_name='Pixel width of point dot stroke', blank=True)),
                ('option_pointHitDetectionRadius', models.IntegerField(default=20, null=True, verbose_name='amount extra to add to the radius to cater for hit detection outside the drawn point', blank=True)),
                ('option_datasetStroke', models.BooleanField(default=True, verbose_name='Show a stroke for datasets')),
                ('option_datasetStrokeWidth', models.IntegerField(default=2, null=True, verbose_name='Pixel width of dataset stroke', blank=True)),
                ('option_datasetFill', models.BooleanField(default=True, verbose_name='Fill the dataset with a colour')),
                ('option_legendTemplate', models.CharField(default=b'<ul class="<%=name.toLowerCase()%>-legend"><% for (var i=0; i<datasets.length; i++){%><li><span style="background-color:<%=datasets[i].strokeColor%>"></span><%if(datasets[i].label){%><%=datasets[i].label%><%}%></li><%}%></ul>', max_length=300, verbose_name='Legend template', blank=True)),
            ],
            options={
                'abstract': False,
            },
            bases=('cms.cmsplugin',),
        ),
    ]
