/*
 * Decompiled with CFR 0.152.
 */
package nl4py.server;

import bsearch.space.SearchSpace;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import nl4py.server.HeadlessWorkspaceController;
import nl4py.server.NetLogoAppController;
import nl4py.server.NetLogoController;
import py4j.GatewayServer;

public class NetLogoControllerServer {
    ConcurrentHashMap<Integer, NetLogoController> controllerStore = new ConcurrentHashMap();
    static GatewayServer gs;
    long startTime = System.currentTimeMillis();
    static boolean serverOn;
    Thread statusThread = new Thread(new Runnable(){

        @Override
        public void run() {
            while (!Thread.interrupted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                NetLogoControllerServer.this.statusCheck();
            }
        }
    });

    public NetLogoControllerServer() {
        this.statusThread.start();
    }

    public static void main(String[] stringArray) {
        try {
            NetLogoControllerServer netLogoControllerServer = new NetLogoControllerServer();
            gs = new GatewayServer(netLogoControllerServer);
            serverOn = true;
            gs.start();
        }
        catch (Exception exception) {
            System.out.println("NETLOGO_APP not set right!");
            exception.printStackTrace();
            System.exit(1);
        }
    }

    public void shutdownServer() {
        gs.shutdown(true);
        serverOn = false;
        this.statusThread.interrupt();
    }

    public int newHeadlessWorkspaceController() {
        HeadlessWorkspaceController headlessWorkspaceController = new HeadlessWorkspaceController();
        int n = headlessWorkspaceController.hashCode();
        this.controllerStore.put(n, headlessWorkspaceController);
        return n;
    }

    public void openModel(int n, String string) {
        this.controllerStore.get(n).openModel(string);
    }

    public void closeModel(int n) {
        this.getControllerFromStore(n).closeModel();
    }

    public void refresh(int n) {
        this.getControllerFromStore(n).refresh();
    }

    public void exportView(int n, String string) {
        this.getControllerFromStore(n).exportView(string);
    }

    public void command(int n, String string) {
        this.getControllerFromStore(n).command(string);
    }

    public Object report(int n, String string) {
        return this.getControllerFromStore(n).report(string);
    }

    public void scheduleReportersAndRun(int n, String[] stringArray, int n2, int n3, int n4, String string) {
        this.getControllerFromStore(n).scheduleReportersAndRun(stringArray, n2, n3, n4, string);
    }

    public ArrayList<String> getScheduledReporterResults(int n) {
        return this.getControllerFromStore(n).getScheduledReporterResults();
    }

    public SearchSpace getParamList(int n, String string) {
        return this.getControllerFromStore(n).getParamList(string);
    }

    private NetLogoController getControllerFromStore(int n) {
        NetLogoController netLogoController = this.controllerStore.get(n);
        if (netLogoController == null) {
            throw new NullPointerException("No NetLogo HeadlessWorkspace exists for that session id");
        }
        return netLogoController;
    }

    public void removeControllerFromStore(int n) {
        this.controllerStore.get(n).closeModel();
        this.controllerStore.get(n).disposeWorkspace();
        this.controllerStore.remove(n);
        System.gc();
    }

    private void statusCheck() {
        if (!serverOn) {
            GatewayServer.turnLoggingOff();
            gs.shutdown(false);
            System.exit(0);
        }
    }

    public int newNetLogoApp() {
        NetLogoAppController netLogoAppController = new NetLogoAppController();
        int n = netLogoAppController.hashCode();
        this.controllerStore.put(n, netLogoAppController);
        return n;
    }

    static {
        serverOn = false;
    }
}

