/*
 * Decompiled with CFR 0.152.
 */
package nl4py.server;

import bsearch.nlogolink.NetLogoLinkException;
import bsearch.nlogolink.Utils;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import nl4py.server.NL4PySecutiryManager;
import nl4py.server.NetLogoController;
import org.nlogo.app.App;
import org.nlogo.nvm.RuntimePrimitiveException;

public class NetLogoAppController
extends NetLogoController {
    private ArrayBlockingQueue<String> commandQueue;
    private Thread commandThread;
    boolean controllerNeeded = false;
    LinkedBlockingQueue<String> scheduledReporterResults = new LinkedBlockingQueue();

    public NetLogoAppController() {
        App.main((String[])new String[0]);
        this.commandQueue = new ArrayBlockingQueue(100);
        this.commandThread = new Thread(new Runnable(){

            private String safelyGetNextCommand() throws InterruptedException {
                String string = (String)NetLogoAppController.this.commandQueue.take();
                if (string.equalsIgnoreCase("~stop~")) {
                    string = "";
                    NetLogoAppController.this.controllerNeeded = false;
                    Thread.currentThread().interrupt();
                }
                return string;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                NetLogoAppController.this.controllerNeeded = true;
                while (true) {
                    if (!NetLogoAppController.this.controllerNeeded) {
                        Thread.currentThread();
                        if (Thread.interrupted()) return;
                    }
                    try {
                        String string = this.safelyGetNextCommand();
                        if (string.equalsIgnoreCase("~ScheduledReporters~")) {
                            ArrayList<String> arrayList = new ArrayList<String>();
                            string = this.safelyGetNextCommand();
                            while (!string.equalsIgnoreCase("~StartAt~")) {
                                arrayList.add(string);
                                string = this.safelyGetNextCommand();
                                if (string != null) continue;
                                string = "";
                            }
                            int n = Integer.parseInt(this.safelyGetNextCommand());
                            string = this.safelyGetNextCommand();
                            int n2 = Integer.parseInt(this.safelyGetNextCommand());
                            string = this.safelyGetNextCommand();
                            int n3 = Integer.parseInt(this.safelyGetNextCommand());
                            string = this.safelyGetNextCommand();
                            String string2 = this.safelyGetNextCommand();
                            int n4 = ((Double)App.app().report("ticks")).intValue();
                            if (n4 <= n) {
                                int n5 = n4;
                                while (NetLogoAppController.this.controllerNeeded && (n5 < n3 || n3 < 0)) {
                                    App.app().command("repeat " + Integer.toString(n2) + " [" + string2 + "]");
                                    n5 += n2;
                                    ArrayList<String> arrayList2 = new ArrayList<String>();
                                    try {
                                        for (String string3 : arrayList) {
                                            String string4 = App.app().report(string3).toString();
                                            arrayList2.add(string4);
                                        }
                                    }
                                    catch (RuntimePrimitiveException runtimePrimitiveException) {
                                        continue;
                                    }
                                    for (String string3 : arrayList2) {
                                        NetLogoAppController.this.scheduledReporterResults.put(string3);
                                    }
                                }
                            }
                        } else {
                            App.app().command(string);
                        }
                        Thread.sleep(10L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        NetLogoAppController.this.controllerNeeded = false;
                        Thread.currentThread().interrupt();
                        return;
                    }
                    catch (NullPointerException nullPointerException) {
                        if (App.app() == null) return;
                        continue;
                    }
                    break;
                }
            }
        });
        this.commandThread.start();
    }

    @Override
    public void openModel(final String string) {
        NL4PySecutiryManager nL4PySecutiryManager = new NL4PySecutiryManager();
        System.setSecurityManager(nL4PySecutiryManager);
        try {
            EventQueue.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    try {
                        App.app().getLinkParent().setVisible(true);
                        App.app().getLinkParent().setDefaultCloseOperation(2);
                        App.app().open(string);
                    }
                    catch (IOException iOException) {
                        System.out.println("You can only open one model at a time in GUI mode");
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            });
        }
        catch (SecurityException securityException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void closeModel() {
        try {
            App.app().getLinkParent().setVisible(false);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void refresh() {
    }

    @Override
    public void exportView(String string) {
    }

    @Override
    public void command(String string) {
        try {
            this.scheduleCommand(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void scheduleCommand(String string) {
        try {
            this.commandQueue.put(string);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public Object report(String string) {
        Object object = new Double(0.0);
        try {
            Thread.sleep(1L);
            object = App.app().report(string);
        }
        catch (Exception exception) {
            object = new Double(0.0);
        }
        return object;
    }

    @Override
    public void scheduleReportersAndRun(String[] stringArray, int n, int n2, int n3, String string) {
        try {
            this.commandQueue.put("~ScheduledReporters~");
            for (String string2 : stringArray) {
                this.commandQueue.put(string2);
            }
            this.commandQueue.put("~StartAt~");
            this.commandQueue.put(Integer.toString(n));
            this.commandQueue.put("~Interval~");
            this.commandQueue.put(Integer.toString(n2));
            this.commandQueue.put("~StopAt~");
            this.commandQueue.put(Integer.toString(n3));
            this.commandQueue.put("~RunReporters~");
            this.commandQueue.put(string);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public ArrayList<String> getScheduledReporterResults() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            this.scheduledReporterResults.drainTo(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    @Override
    protected void disposeWorkspace() {
        this.closeModel();
        try {
            this.commandQueue.put("~stop~");
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.controllerNeeded = false;
        this.commandThread.interrupt();
        System.gc();
    }

    @Override
    public SearchSpace getParamList(String string) {
        String string2 = "";
        SearchSpace searchSpace = null;
        try {
            string2 = Utils.getDefaultConstraintsText(string);
            searchSpace = new SearchSpace(Arrays.asList(string2.split("\n")));
            for (ParameterSpec parameterSpec : searchSpace.getParamSpecs()) {
            }
        }
        catch (NetLogoLinkException netLogoLinkException) {
            netLogoLinkException.printStackTrace();
        }
        return searchSpace;
    }
}

