/*
 * Decompiled with CFR 0.152.
 */
package nl4py.server;

import bsearch.nlogolink.NetLogoLinkException;
import bsearch.nlogolink.Utils;
import bsearch.space.ParameterSpec;
import bsearch.space.SearchSpace;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.imageio.ImageIO;
import nl4py.server.NetLogoController;
import org.nlogo.core.LogoList;
import org.nlogo.headless.HeadlessWorkspace;
import scala.collection.Iterator;

public class HeadlessWorkspaceController
extends NetLogoController {
    HeadlessWorkspace ws;
    private ArrayBlockingQueue<String> commandQueue;
    private Thread commandThread;
    boolean controllerNeeded = false;
    LinkedBlockingQueue<String> scheduledReporterResults = new LinkedBlockingQueue();
    volatile String mon = new String("wait");
    volatile boolean scheduleDone = true;

    public HeadlessWorkspaceController() {
        this.ws = HeadlessWorkspace.newInstance();
        this.commandQueue = new ArrayBlockingQueue(100);
        this.commandThread = new Thread(new Runnable(){

            private String safelyGetNextCommand() throws InterruptedException {
                String string = (String)HeadlessWorkspaceController.this.commandQueue.take();
                if (string.equalsIgnoreCase("~stop~")) {
                    string = "";
                    HeadlessWorkspaceController.this.controllerNeeded = false;
                    Thread.currentThread().interrupt();
                }
                return string;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HeadlessWorkspaceController.this.controllerNeeded = true;
                while (true) {
                    if (!HeadlessWorkspaceController.this.controllerNeeded) {
                        Thread.currentThread();
                        if (Thread.interrupted()) break;
                    }
                    try {
                        String string = this.safelyGetNextCommand();
                        if (string.equalsIgnoreCase("~ScheduledReporters~")) {
                            HeadlessWorkspaceController.this.scheduleDone = false;
                            ArrayList<String> arrayList = new ArrayList<String>();
                            string = this.safelyGetNextCommand();
                            while (!string.equalsIgnoreCase("~StartAt~")) {
                                arrayList.add(string);
                                string = this.safelyGetNextCommand();
                                if (string != null) continue;
                                string = "";
                            }
                            int n = Integer.parseInt(this.safelyGetNextCommand());
                            string = this.safelyGetNextCommand();
                            int n2 = Integer.parseInt(this.safelyGetNextCommand());
                            string = this.safelyGetNextCommand();
                            int n3 = Integer.parseInt(this.safelyGetNextCommand());
                            string = this.safelyGetNextCommand();
                            String string2 = this.safelyGetNextCommand();
                            int n4 = ((Double)HeadlessWorkspaceController.this.ws.report("ticks")).intValue();
                            if (n4 <= n) {
                                boolean bl = false;
                                if (n4 < n) {
                                    HeadlessWorkspaceController.this.ws.command("repeat " + Double.toString(n - n4) + " [go]");
                                }
                                String string3 = "let nl4pyData (list) repeat " + Integer.toString(n3 - n) + " [ " + string2 + " let resultsThisTick (list ";
                                for (String string4 : arrayList) {
                                    string3 = string3 + "(" + string4 + ") ";
                                }
                                string3 = string3 + ") set nl4pyData lput resultsThisTick nl4pyData ] ask patch 0 0 [set plabel nl4pyData]";
                                HeadlessWorkspaceController.this.ws.command(string3);
                                Iterator iterator = ((LogoList)HeadlessWorkspaceController.this.ws.report("[plabel] of patch 0 0")).toIterator();
                                LinkedBlockingQueue<String> object2 = HeadlessWorkspaceController.this.scheduledReporterResults;
                                synchronized (object2) {
                                    while (iterator.hasNext()) {
                                        LogoList logoList = (LogoList)iterator.next();
                                        Iterator iterator2 = logoList.toIterator();
                                        while (iterator2.hasNext()) {
                                            HeadlessWorkspaceController.this.scheduledReporterResults.put(iterator2.next().toString());
                                        }
                                    }
                                }
                                HeadlessWorkspaceController.this.ws.command("ask patch 0 0 [set plabel 0]");
                            }
                            HeadlessWorkspaceController.this.scheduleDone = true;
                            continue;
                        }
                        HeadlessWorkspaceController.this.ws.command(string);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {
                        HeadlessWorkspaceController.this.controllerNeeded = false;
                        Thread.currentThread().interrupt();
                    }
                    catch (NullPointerException nullPointerException) {
                        if (HeadlessWorkspaceController.this.ws != null) continue;
                    }
                    finally {
                        HeadlessWorkspaceController.this.scheduleDone = true;
                        continue;
                    }
                    break;
                }
            }
        });
        this.commandThread.start();
    }

    @Override
    public void openModel(String string) {
        try {
            this.ws.open(string);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void closeModel() {
        try {
            this.ws.halt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public void refresh() {
        try {
            this.ws.dispose();
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        this.ws = HeadlessWorkspace.newInstance();
    }

    @Override
    public void exportView(String string) {
        try {
            BufferedImage bufferedImage = this.ws.exportView();
            File file = new File(string);
            ImageIO.write((RenderedImage)bufferedImage, "png", file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    @Override
    public void command(String string) {
        try {
            this.scheduleCommand(string);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void scheduleCommand(String string) {
        try {
            this.commandQueue.put(string);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public Object report(String string) {
        Object object = new Double(0.0);
        try {
            object = this.ws.report(string);
        }
        catch (Exception exception) {
            object = "NetLogo Exception";
            return object;
        }
        return object;
    }

    @Override
    public void scheduleReportersAndRun(String[] stringArray, int n, int n2, int n3, String string) {
        try {
            this.commandQueue.put("~ScheduledReporters~");
            for (String string2 : stringArray) {
                this.commandQueue.put(string2);
            }
            this.commandQueue.put("~StartAt~");
            this.commandQueue.put(Integer.toString(n));
            this.commandQueue.put("~Interval~");
            this.commandQueue.put(Integer.toString(n2));
            this.commandQueue.put("~StopAt~");
            this.commandQueue.put(Integer.toString(n3));
            this.commandQueue.put("~RunReporters~");
            this.commandQueue.put(string);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<String> getScheduledReporterResults() {
        ArrayList<String> arrayList;
        block5: {
            arrayList = new ArrayList<String>();
            try {
                if (!this.scheduleDone) break block5;
                LinkedBlockingQueue<String> linkedBlockingQueue = this.scheduledReporterResults;
                synchronized (linkedBlockingQueue) {
                    this.scheduledReporterResults.drainTo(arrayList);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return arrayList;
    }

    @Override
    public SearchSpace getParamList(String string) {
        String string2 = "";
        SearchSpace searchSpace = null;
        try {
            string2 = Utils.getDefaultConstraintsText(string);
            searchSpace = new SearchSpace(Arrays.asList(string2.split("\n")));
            for (ParameterSpec parameterSpec : searchSpace.getParamSpecs()) {
            }
        }
        catch (NetLogoLinkException netLogoLinkException) {
            netLogoLinkException.printStackTrace();
        }
        return searchSpace;
    }

    @Override
    protected void disposeWorkspace() {
        this.closeModel();
        try {
            this.commandQueue.put("~stop~");
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.controllerNeeded = false;
        try {
            this.commandThread.interrupt();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            this.ws.dispose();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.ws = null;
        System.gc();
    }
}

