/*
 * Decompiled with CFR 0.152.
 */
package bsearch.nlogolink;

import bsearch.nlogolink.NetLogoLinkException;
import java.io.IOException;
import org.nlogo.agent.BooleanConstraint;
import org.nlogo.agent.ChooserConstraint;
import org.nlogo.agent.SliderConstraint;
import org.nlogo.api.Dump;
import org.nlogo.api.LogoException;
import org.nlogo.api.ValueConstraint;
import org.nlogo.core.CompilerException;
import org.nlogo.headless.HeadlessWorkspace;

public strictfp class Utils {
    public static final long MIN_EXACT_NETLOGO_INT = -9007199254740992L;
    public static final long MAX_EXACT_NETLOGO_INT = 0x20000000000000L;
    private static HeadlessWorkspace emptyWorkspace;

    public static Object evaluateNetLogoReporterInEmptyWorkspace(String string) throws NetLogoLinkException {
        if (emptyWorkspace == null) {
            emptyWorkspace = HeadlessWorkspace.newInstance();
        }
        try {
            return emptyWorkspace.report(string);
        }
        catch (Exception exception) {
            throw new NetLogoLinkException(exception.getMessage());
        }
    }

    public static HeadlessWorkspace createWorkspace() {
        HeadlessWorkspace headlessWorkspace = HeadlessWorkspace.newInstance();
        return headlessWorkspace;
    }

    public static void fullyShutDownNetLogoLink() throws InterruptedException {
        emptyWorkspace.dispose();
    }

    public static String getDefaultConstraintsText(String string) throws NetLogoLinkException {
        HeadlessWorkspace headlessWorkspace = Utils.createWorkspace();
        try {
            headlessWorkspace.open(string);
        }
        catch (IOException iOException) {
            throw new NetLogoLinkException("I/O Error trying to open model file '" + string + "'\n " + iOException.toString(), iOException);
        }
        catch (CompilerException compilerException) {
            throw new NetLogoLinkException("Model file '" + string + "' didn't compile: " + compilerException.toString(), compilerException);
        }
        catch (LogoException logoException) {
            throw new NetLogoLinkException("Unexpected error loading model: " + logoException.toString(), logoException);
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = headlessWorkspace.world().observer().variables().length;
        for (int i = 0; i < n; ++i) {
            SliderConstraint sliderConstraint;
            ValueConstraint valueConstraint = headlessWorkspace.world().observer().constraint(i);
            if (valueConstraint == null) continue;
            String string2 = headlessWorkspace.world().observerOwnsNameAt(i);
            stringBuilder.append("[\"");
            stringBuilder.append(string2.toLowerCase());
            stringBuilder.append("\" ");
            StringBuilder stringBuilder2 = new StringBuilder();
            if (valueConstraint instanceof SliderConstraint) {
                sliderConstraint = (SliderConstraint)valueConstraint;
                double d = (Double)sliderConstraint.minimum().get();
                double d2 = (Double)sliderConstraint.increment().get();
                double d3 = (Double)sliderConstraint.maximum().get();
                String string3 = Dump.logoObject((Object)d2, (boolean)true, (boolean)false);
                if (d != StrictMath.floor(d) && d2 != StrictMath.floor(d2) && StrictMath.abs((d3 - d) / d2) > 100.0) {
                    string3 = "\"C\"";
                }
                stringBuilder2.append("[");
                stringBuilder2.append(Dump.logoObject((Object)d, (boolean)true, (boolean)false));
                stringBuilder2.append(" ");
                stringBuilder2.append(string3);
                stringBuilder2.append(" ");
                stringBuilder2.append(Dump.logoObject((Object)d3, (boolean)true, (boolean)false));
                stringBuilder2.append("]");
            } else if (valueConstraint instanceof ChooserConstraint) {
                sliderConstraint = (ChooserConstraint)valueConstraint;
                for (Object t : sliderConstraint.acceptedValues().javaIterable()) {
                    stringBuilder2.append(Dump.logoObject(t, (boolean)true, (boolean)false));
                    stringBuilder2.append(" ");
                }
                stringBuilder2.setLength(stringBuilder2.length() - 1);
            } else if (valueConstraint instanceof BooleanConstraint) {
                stringBuilder2.append(Dump.logoObject((Object)Boolean.TRUE, (boolean)true, (boolean)false));
                stringBuilder2.append(" ");
                stringBuilder2.append(Dump.logoObject((Object)Boolean.FALSE, (boolean)true, (boolean)false));
            } else {
                stringBuilder2.append(Dump.logoObject((Object)valueConstraint.defaultValue(), (boolean)true, (boolean)false));
            }
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append("]\n");
        }
        try {
            headlessWorkspace.dispose();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return stringBuilder.toString();
    }
}

