# splitit

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 1.0.0
- Package version: 1.6.10
- Build package: io.swagger.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 or 3.4+

## Installation & Usage

Install the version published on pypi:
```sh
python3 -m pip install splitit
```

Then import the package:
```python
import splitit
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:
```python
from __future__ import print_function
from pprint import pprint

import splitit
from splitit.rest import ApiException

# Configure the API client:
api_client = splitit.ApiClient(splitit.Configuration('YOUR_USERNAME', 'YOUR_PASSWORD', 'YOUR_API_KEY', sandbox=True))
try:
    # Perform request
    api_response = api_client.InstallmentPlanApi.installment_plan_create(
        splitit.CreateInstallmentPlanRequest(
            plan_data=splitit.PlanData(
                auto_capture=True,
                amount=splitit.MoneyWithCurrencyCode(600, "USD"),
                number_of_installments=3,
                ref_order_number="abc123",
            ),
            billing_address=splitit.AddressData2(
                address_line="260 Madison Avenue.",
                city="New York",
                state="NY",
                country="USA",
                zip="10016",
            ),
            consumer_data=splitit.ConsumerData(
                full_name="John Smith",
                email="JohnS@splitit.com",
                phone_number="1-415-775-4848",
                culture_name="en-us",
            ),
            credit_card_details=splitit.CardData(
                card_holder_full_name="John Smith",
                card_number="4111111111111111",
                card_exp_year="2022",
                card_exp_month="8",
                card_cvv="123",
            ),
            plan_approval_evidence=splitit.PlanApprovalEvidence(
                are_terms_and_conditions_approved=True,
            ),
        )
    )

    pprint(api_response)
except ApiException as e:
    print("Exception when calling CreateInstallmentPlanApi->installment_plan_create: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://webapi.production.splitit.com*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CreateInstallmentPlanApi* | [**create_installment_plan_get**](docs/CreateInstallmentPlanApi.md#create_installment_plan_get) | **GET** /api/CreateInstallmentPlan | 
*InfoApi* | [**info_get_learn_more_details**](docs/InfoApi.md#info_get_learn_more_details) | **POST** /api/Merchant/GetLearnMoreDetails | 
*InfrastructureApi* | [**infrastructure_get_resources**](docs/InfrastructureApi.md#infrastructure_get_resources) | **POST** /api/Infrastructure/GetResources | 
*InfrastructureApi* | [**infrastructure_get_resources2**](docs/InfrastructureApi.md#infrastructure_get_resources2) | **GET** /api/Infrastructure/GetResources | 
*InstallmentPlanApi* | [**installment_plan_approve**](docs/InstallmentPlanApi.md#installment_plan_approve) | **POST** /api/InstallmentPlan/Approve | 
*InstallmentPlanApi* | [**installment_plan_cancel**](docs/InstallmentPlanApi.md#installment_plan_cancel) | **POST** /api/InstallmentPlan/Cancel | 
*InstallmentPlanApi* | [**installment_plan_charge_back**](docs/InstallmentPlanApi.md#installment_plan_charge_back) | **POST** /api/InstallmentPlan/ChargeBack | 
*InstallmentPlanApi* | [**installment_plan_create**](docs/InstallmentPlanApi.md#installment_plan_create) | **POST** /api/InstallmentPlan/Create | 
*InstallmentPlanApi* | [**installment_plan_get**](docs/InstallmentPlanApi.md#installment_plan_get) | **POST** /api/InstallmentPlan/Get | 
*InstallmentPlanApi* | [**installment_plan_get3_d_secure_parameters**](docs/InstallmentPlanApi.md#installment_plan_get3_d_secure_parameters) | **POST** /api/InstallmentPlan/Get3DSecureParameters | 
*InstallmentPlanApi* | [**installment_plan_get_extended**](docs/InstallmentPlanApi.md#installment_plan_get_extended) | **POST** /api/InstallmentPlan/GetExtended | 
*InstallmentPlanApi* | [**installment_plan_get_fraud_status_display**](docs/InstallmentPlanApi.md#installment_plan_get_fraud_status_display) | **POST** /api/InstallmentPlan/GetFraudStatusDisplay | 
*InstallmentPlanApi* | [**installment_plan_get_initiated_installment_plan_request**](docs/InstallmentPlanApi.md#installment_plan_get_initiated_installment_plan_request) | **POST** /api/InstallmentPlan/GetInitiatedInstallmentPlanRequest | 
*InstallmentPlanApi* | [**installment_plan_get_initiated_update_payment_data**](docs/InstallmentPlanApi.md#installment_plan_get_initiated_update_payment_data) | **GET** /api/InstallmentPlan/GetInitiatedUpdatePaymentData | 
*InstallmentPlanApi* | [**installment_plan_get_learn_more_details**](docs/InstallmentPlanApi.md#installment_plan_get_learn_more_details) | **POST** /api/InstallmentPlan/GetLearnMoreDetails | 
*InstallmentPlanApi* | [**installment_plan_get_pgtl**](docs/InstallmentPlanApi.md#installment_plan_get_pgtl) | **POST** /api/InstallmentPlan/GetPGTL | 
*InstallmentPlanApi* | [**installment_plan_get_schedules**](docs/InstallmentPlanApi.md#installment_plan_get_schedules) | **POST** /api/InstallmentPlan/GetSchedules | 
*InstallmentPlanApi* | [**installment_plan_initiate**](docs/InstallmentPlanApi.md#installment_plan_initiate) | **POST** /api/InstallmentPlan/Initiate | 
*InstallmentPlanApi* | [**installment_plan_refund**](docs/InstallmentPlanApi.md#installment_plan_refund) | **POST** /api/InstallmentPlan/Refund | 
*InstallmentPlanApi* | [**installment_plan_request_payment**](docs/InstallmentPlanApi.md#installment_plan_request_payment) | **POST** /api/InstallmentPlan/RequestPayment | 
*InstallmentPlanApi* | [**installment_plan_start_installments**](docs/InstallmentPlanApi.md#installment_plan_start_installments) | **POST** /api/InstallmentPlan/StartInstallments | 
*InstallmentPlanApi* | [**installment_plan_terms_and_conditions**](docs/InstallmentPlanApi.md#installment_plan_terms_and_conditions) | **POST** /api/InstallmentPlan/TermsAndConditions | 
*InstallmentPlanApi* | [**installment_plan_test_card**](docs/InstallmentPlanApi.md#installment_plan_test_card) | **POST** /api/InstallmentPlan/TestCard | 
*InstallmentPlanApi* | [**installment_plan_update**](docs/InstallmentPlanApi.md#installment_plan_update) | **POST** /api/InstallmentPlan/Update | 
*InstallmentPlanApi* | [**installment_plan_verify_payment**](docs/InstallmentPlanApi.md#installment_plan_verify_payment) | **POST** /api/InstallmentPlan/Get/VerifyPayment | 
*LoginApi* | [**login_post**](docs/LoginApi.md#login_post) | **POST** /api/Login | 


## Documentation For Models

 - [AddressData2](docs/AddressData2.md)
 - [AmountDetails2](docs/AmountDetails2.md)
 - [ApproveInstallmentPlanRequest](docs/ApproveInstallmentPlanRequest.md)
 - [AuthenticationType](docs/AuthenticationType.md)
 - [CancelInstallmentPlanRequest](docs/CancelInstallmentPlanRequest.md)
 - [CardBrand](docs/CardBrand.md)
 - [CardData](docs/CardData.md)
 - [CardResult](docs/CardResult.md)
 - [CardType](docs/CardType.md)
 - [CartData](docs/CartData.md)
 - [ChargebackRequest](docs/ChargebackRequest.md)
 - [CreateInstallmentPlanLegacyResponse](docs/CreateInstallmentPlanLegacyResponse.md)
 - [CreateInstallmentPlanRequest](docs/CreateInstallmentPlanRequest.md)
 - [DelayResolution](docs/DelayResolution.md)
 - [DisputeStatus](docs/DisputeStatus.md)
 - [Disputes](docs/Disputes.md)
 - [Error](docs/Error.md)
 - [EventsEndpoints](docs/EventsEndpoints.md)
 - [ExternalAuth](docs/ExternalAuth.md)
 - [FraudCheck](docs/FraudCheck.md)
 - [FraudCheckResult](docs/FraudCheckResult.md)
 - [Get3DSecureParametersRequest](docs/Get3DSecureParametersRequest.md)
 - [Get3DSecureParametersResponse](docs/Get3DSecureParametersResponse.md)
 - [GetFraudStatusDisplayRequest](docs/GetFraudStatusDisplayRequest.md)
 - [GetFraudStatusDisplayResponse](docs/GetFraudStatusDisplayResponse.md)
 - [GetInitiatedInstallmentPlanRequest](docs/GetInitiatedInstallmentPlanRequest.md)
 - [GetInitiatedInstallmentPlanResponse](docs/GetInitiatedInstallmentPlanResponse.md)
 - [GetInitiatedUpdatePaymentDataResponse](docs/GetInitiatedUpdatePaymentDataResponse.md)
 - [GetInstallmentSchedulesRequest](docs/GetInstallmentSchedulesRequest.md)
 - [GetInstallmentsPlanResponse](docs/GetInstallmentsPlanResponse.md)
 - [GetInstallmentsPlanSearchCriteriaRequest](docs/GetInstallmentsPlanSearchCriteriaRequest.md)
 - [GetInstallmentsScheduleResponse](docs/GetInstallmentsScheduleResponse.md)
 - [GetPGTLRequest](docs/GetPGTLRequest.md)
 - [GetPGTLResponse](docs/GetPGTLResponse.md)
 - [GetResourcesRequest](docs/GetResourcesRequest.md)
 - [GetResourcesRequestContext](docs/GetResourcesRequestContext.md)
 - [GetResourcesResponse](docs/GetResourcesResponse.md)
 - [InitiateInstallmentPlanRequest](docs/InitiateInstallmentPlanRequest.md)
 - [Installment](docs/Installment.md)
 - [Installment2](docs/Installment2.md)
 - [InstallmentPlan](docs/InstallmentPlan.md)
 - [InstallmentPlanActivityStatus](docs/InstallmentPlanActivityStatus.md)
 - [InstallmentPlanCancelationReason](docs/InstallmentPlanCancelationReason.md)
 - [InstallmentPlanDateInfo](docs/InstallmentPlanDateInfo.md)
 - [InstallmentPlanInitiatedStatuses](docs/InstallmentPlanInitiatedStatuses.md)
 - [InstallmentPlanQueryCriteria](docs/InstallmentPlanQueryCriteria.md)
 - [InstallmentPlanResponse](docs/InstallmentPlanResponse.md)
 - [InstallmentPlanStatus](docs/InstallmentPlanStatus.md)
 - [InstallmentsPlanDateType](docs/InstallmentsPlanDateType.md)
 - [ItemData](docs/ItemData.md)
 - [LearnMoreDetailsRequest](docs/LearnMoreDetailsRequest.md)
 - [LearnMoreDetailsResponse](docs/LearnMoreDetailsResponse.md)
 - [LoginRequest](docs/LoginRequest.md)
 - [LoginResponse](docs/LoginResponse.md)
 - [Money](docs/Money.md)
 - [MoneyFlows](docs/MoneyFlows.md)
 - [MoneyWithCurrencyCode](docs/MoneyWithCurrencyCode.md)
 - [OperationType](docs/OperationType.md)
 - [PagingRequestHeader](docs/PagingRequestHeader.md)
 - [PagingResponseHeader](docs/PagingResponseHeader.md)
 - [PaymentFormMessage](docs/PaymentFormMessage.md)
 - [PaymentFormMessageType](docs/PaymentFormMessageType.md)
 - [PaymentMethods](docs/PaymentMethods.md)
 - [PaymentToken](docs/PaymentToken.md)
 - [PaymentWizardData](docs/PaymentWizardData.md)
 - [PgtlDto](docs/PgtlDto.md)
 - [PlanApprovalEvidence](docs/PlanApprovalEvidence.md)
 - [PlanData](docs/PlanData.md)
 - [PlanStrategy](docs/PlanStrategy.md)
 - [PurchaseMethod](docs/PurchaseMethod.md)
 - [ReAuthorization](docs/ReAuthorization.md)
 - [RedirectUrls](docs/RedirectUrls.md)
 - [ReferenceEntityBase](docs/ReferenceEntityBase.md)
 - [RefundPlanRequest](docs/RefundPlanRequest.md)
 - [RefundStrategy](docs/RefundStrategy.md)
 - [RefundUnderCancelation](docs/RefundUnderCancelation.md)
 - [RelationsLoad](docs/RelationsLoad.md)
 - [RequestHeader](docs/RequestHeader.md)
 - [RequestPaymentRequest](docs/RequestPaymentRequest.md)
 - [RequestPaymentResponse](docs/RequestPaymentResponse.md)
 - [ResponseHeader](docs/ResponseHeader.md)
 - [Schedule](docs/Schedule.md)
 - [ScheduleElements](docs/ScheduleElements.md)
 - [StartInstallmentsRequest](docs/StartInstallmentsRequest.md)
 - [SystemTextCategory](docs/SystemTextCategory.md)
 - [TermsAndConditions](docs/TermsAndConditions.md)
 - [TermsAndConditionsGetRequest](docs/TermsAndConditionsGetRequest.md)
 - [TermsAndConditionsGetResponse](docs/TermsAndConditionsGetResponse.md)
 - [TestCardRequest](docs/TestCardRequest.md)
 - [TestModes](docs/TestModes.md)
 - [TouchPoint](docs/TouchPoint.md)
 - [TransactionInfo](docs/TransactionInfo.md)
 - [TransactionResult](docs/TransactionResult.md)
 - [TransactionStatus](docs/TransactionStatus.md)
 - [TransactionType](docs/TransactionType.md)
 - [User](docs/User.md)
 - [VerifyPaymentRequest](docs/VerifyPaymentRequest.md)
 - [VerifyPaymentResponse](docs/VerifyPaymentResponse.md)
 - [AddressData](docs/AddressData.md)
 - [AmountDetails](docs/AmountDetails.md)
 - [ConsumerData](docs/ConsumerData.md)
 - [CreateInstallmentsPlanResponse](docs/CreateInstallmentsPlanResponse.md)
 - [Currency](docs/Currency.md)
 - [GetInstallmentsPlanExtendedResponse](docs/GetInstallmentsPlanExtendedResponse.md)
 - [InitiateInstallmentsPlanResponse](docs/InitiateInstallmentsPlanResponse.md)
 - [MerchantRef](docs/MerchantRef.md)
 - [PaymentWizardDataResponse](docs/PaymentWizardDataResponse.md)
 - [RefundInstallmentPlanResponse](docs/RefundInstallmentPlanResponse.md)
 - [UpdateInstallmentPlanRequest](docs/UpdateInstallmentPlanRequest.md)
 - [UpdateInstallmentsPlanResponse](docs/UpdateInstallmentsPlanResponse.md)
 - [ExtendedCurrency](docs/ExtendedCurrency.md)


## Documentation For Authorization

 All endpoints do not require authorization.


## Author



