"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PDKPipelinePyProject = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/*********************************************************************************************************************
 Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.

 Licensed under the Apache License, Version 2.0 (the "License").
 You may not use this file except in compliance with the License.
 You may obtain a copy of the License at

 http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
 ******************************************************************************************************************** */
const fs = require("fs");
const path = require("path");
const projen_1 = require("projen");
const awscdk_1 = require("projen/lib/awscdk");
const python_1 = require("projen/lib/python");
/**
 * Synthesizes a Python Project with a CI/CD pipeline.
 *
 * @pjid pdk-pipeline-py
 */
class PDKPipelinePyProject extends awscdk_1.AwsCdkPythonApp {
    constructor(options) {
        super({
            github: false,
            sample: false,
            pytest: false,
            ...options,
            appEntrypoint: options.appEntrypoint || `${options.moduleName}/pipeline.py`,
        });
        ["aws_prototyping_sdk", "pyhumps"].forEach((dep) => this.addDependency(dep));
        new projen_1.SampleDir(this, this.moduleName, {
            sourceDir: path.join(__dirname, "..", "samples", "python", "infra"),
        });
        this.pytest = new python_1.Pytest(this, options.pytestOptions);
        new projen_1.SampleDir(this, this.testdir, {
            files: {
                "__init__.py": "",
                "test_pipeline.py": fs
                    .readFileSync(path.join(__dirname, "..", "samples", "python", "tests", "test_pipeline.py"))
                    .toString()
                    .replace("infra.", `${this.moduleName}.`),
            },
        });
    }
}
exports.PDKPipelinePyProject = PDKPipelinePyProject;
_a = JSII_RTTI_SYMBOL_1;
PDKPipelinePyProject[_a] = { fqn: "@aws-prototyping-sdk/pipeline.PDKPipelinePyProject", version: "0.2.17" };
//# sourceMappingURL=data:application/json;base64,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