from setuptools import setup, find_packages
import codecs
import os

here = os.path.abspath(os.path.dirname(__file__))

with codecs.open(os.path.join(here, "README.md"), encoding="utf-8") as fh:
    long_description = "\n" + fh.read()

VERSION = '0.2'
DESCRIPTION = 'Django lightweight package'
LONG_DESCRIPTION = 'As we know django is not light weighted. So i am going to make it lightweight and pushing it to docker hub.'

# Setting up
setup(
    name="django-lightweight",
    version=VERSION,
    author="Subhransu Das",
    author_email="<subhransud525@gmail.com>",
    description=DESCRIPTION,
    long_description_content_type="text/markdown",
    long_description=long_description,
    packages=find_packages(),
    install_requires=['asgiref', 'sqlparse'],
    keywords=['python', 'django', 'official django', 'light weight',],
    classifiers=[
        "Development Status :: 1 - Planning",
        "Intended Audience :: Developers",
        "Programming Language :: Python :: 3",
        "Operating System :: Unix",
        "Operating System :: MacOS :: MacOS X",
        "Operating System :: Microsoft :: Windows",
    ]
)