import plotly.io as pio

renderer = pio.renderers.default

theme = "simple_white"

# Base is "simple_white", but the color and default appearance of zerolines and ticks are changed.
layout = {
    'annotationdefaults': {'arrowhead': 0, 'arrowwidth': 1},
    'autotypenumbers': 'strict',
    'coloraxis': {'colorbar': {'outlinewidth': 1, 'tickcolor': 'lightgray', 'ticks': ''}},
    'colorscale': {'diverging': [[0.0, 'rgb(103,0,31)'], [0.1, 'rgb(178,24,43)'],
                                 [0.2, 'rgb(214,96,77)'], [0.3,
                                 'rgb(244,165,130)'], [0.4, 'rgb(253,219,199)'],
                                 [0.5, 'rgb(247,247,247)'], [0.6,
                                 'rgb(209,229,240)'], [0.7, 'rgb(146,197,222)'],
                                 [0.8, 'rgb(67,147,195)'], [0.9,
                                 'rgb(33,102,172)'], [1.0, 'rgb(5,48,97)']],
                   'sequential': [[0.0, '#440154'], [0.1111111111111111,
                                  '#482878'], [0.2222222222222222, '#3e4989'],
                                  [0.3333333333333333, '#31688e'],
                                  [0.4444444444444444, '#26828e'],
                                  [0.5555555555555556, '#1f9e89'],
                                  [0.6666666666666666, '#35b779'],
                                  [0.7777777777777778, '#6ece58'],
                                  [0.8888888888888888, '#b5de2b'], [1.0,
                                  '#fde725']],
                   'sequentialminus': [[0.0, '#440154'], [0.1111111111111111,
                                       '#482878'], [0.2222222222222222, '#3e4989'],
                                       [0.3333333333333333, '#31688e'],
                                       [0.4444444444444444, '#26828e'],
                                       [0.5555555555555556, '#1f9e89'],
                                       [0.6666666666666666, '#35b779'],
                                       [0.7777777777777778, '#6ece58'],
                                       [0.8888888888888888, '#b5de2b'], [1.0,
                                       '#fde725']]},
    'colorway': ['orange', 'dodgerblue', 'sienna', 'navy', 'lightseagreen', 'mediumpurple'],
    'font': {'color': 'black', 'family': 'Arial', 'size': 16},
    'legend': {'bordercolor': 'black'},
    'margin': {'b': 10, 'l': 10, 'r': 10, 't': 50},
    'geo': {'bgcolor': 'white',
            'lakecolor': 'white',
            'landcolor': 'white',
            'showlakes': True,
            'showland': True,
            'subunitcolor': 'white'},
    'hoverlabel': {'align': 'left'},
    'hovermode': 'closest',
    'mapbox': {'style': 'light'},
    'paper_bgcolor': 'white',
    'plot_bgcolor': 'white',
    'polar': {'angularaxis': {'gridcolor': 'rgb(232,232,232)',
                              'linecolor': 'lightgray',
                              'showgrid': False,
                              'showline': False,
                              'ticks': ''},
              'bgcolor': 'white',
              'radialaxis': {'gridcolor': 'rgb(232,232,232)',
                             'linecolor': 'lightgray',
                             'showgrid': False,
                             'showline': False,
                             'ticks': ''}},
    'scene': {'xaxis': {'backgroundcolor': 'white',
                        'gridcolor': 'rgb(232,232,232)',
                        'gridwidth': 2,
                        'linecolor': 'lightgray',
                        'showbackground': True,
                        'showgrid': False,
                        'showline': False,
                        'ticks': '',
                        'zeroline': True,
                        'zerolinecolor': 'lightgray'},
              'yaxis': {'backgroundcolor': 'white',
                        'gridcolor': 'rgb(232,232,232)',
                        'gridwidth': 2,
                        'linecolor': 'lightgray',
                        'showbackground': True,
                        'showgrid': False,
                        'showline': False,
                        'ticks': '',
                        'zeroline': True,
                        'zerolinecolor': 'lightgray'},
              'zaxis': {'backgroundcolor': 'white',
                        'gridcolor': 'rgb(232,232,232)',
                        'gridwidth': 2,
                        'linecolor': 'lightgray',
                        'showbackground': True,
                        'showgrid': False,
                        'showline': False,
                        'ticks': '',
                        'zeroline': True,
                        'zerolinecolor': 'lightgray'}},
    'shapedefaults': {'fillcolor': 'black', 'line': {'width': 0}, 'opacity': 0.3},
    'ternary': {'aaxis': {'gridcolor': 'rgb(232,232,232)',
                          'linecolor': 'lightgray',
                          'showgrid': False,
                          'showline': True,
                          'ticks': ''},
                'baxis': {'gridcolor': 'rgb(232,232,232)',
                          'linecolor': 'lightgray',
                          'showgrid': False,
                          'showline': False,
                          'ticks': ''},
                'bgcolor': 'white',
                'caxis': {'gridcolor': 'rgb(232,232,232)',
                          'linecolor': 'lightgray',
                          'showgrid': False,
                          'showline': False,
                          'ticks': ''}},
    'title': {'x': 0.05},
    'xaxis': {'automargin': True,
              'gridcolor': 'rgb(232,232,232)',
              'linecolor': 'lightgray',
              'showgrid': False,
              'showline': False,
              'ticks': '',
              'ticklen': 7,
              'tickwidth': 1.2,
              'tickcolor': 'lightgray',
              'title': {'standoff': 15},
              'zeroline': True,
              'zerolinecolor': 'lightgray'},
    'yaxis': {'automargin': True,
              'gridcolor': 'rgb(232,232,232)',
              'linecolor': 'lightgray',
              'showgrid': False,
              'showline': False,
              'ticks': '',
              'ticklen': 7,
              'tickwidth': 1.2,
              'tickcolor': 'lightgray',
              'title': {'standoff': 15},
              'zeroline': True,
              'zerolinecolor': 'lightgray'}
}

config = dict(showTips=False,
              displaylogo=False,
              modeBarButtonsToAdd=["hoverclosest",
                                   "hovercompare"],
              toImageButtonOptions=dict(format="svg"))
