import setuptools
from setuptools import setup


with open("README.md", "r") as fh:
    long_description = fh.read()

setup(
    name='neuralflow',  # module 이름
    version='0.0.1',
    description='Deep learning framework built with numpy (cupy)',
    long_description=long_description,
    long_description_content_type="text/markdown",
    author='Sangam Lee',
    author_email='2bhambitious@gmail.com',
    url='https://github.com/augustinLib/neuralflow',
    license='MIT',
    packages=setuptools.find_packages(),
    py_modules=['pymodule'],  # 업로드할 module
    python_requires='>=3.8',  # 파이썬 버전
  # module 필요한 다른 module
    install_requires = [
        "anyio==3.6.2",
        "argon2-cffi==21.3.0",
        "argon2-cffi-bindings==21.2.0",
        "arrow==1.2.3",
        "asttokens==2.2.1",
        "attrs==22.2.0",
        "backcall==0.2.0",
        "beautifulsoup4==4.11.1",
        "bleach==5.0.1",
        "cffi==1.15.1",
        "comm==0.1.2",
        "contourpy==1.0.7",
        "cupy-cuda11x==11.5.0",
        "cycler==0.11.0",
        "debugpy==1.6.5",
        "decorator==5.1.1",
        "defusedxml==0.7.1",
        "entrypoints==0.4",
        "executing==1.2.0",
        "fastjsonschema==2.16.2",
        "fastrlock==0.8.1",
        "fonttools==4.38.0",
        "fqdn==1.5.1",
        "idna==3.4",
        "importlib-metadata==6.0.0",
        "importlib-resources==5.10.2",
        "ipykernel==6.20.2",
        "ipython==8.8.0",
        "ipython-genutils==0.2.0",
        "ipywidgets==8.0.4",
        "isoduration==20.11.0",
        "jedi==0.18.2",
        "Jinja2==3.1.2",
        "jsonpointer==2.3",
        "jsonschema==4.17.3",
        "jupyter==1.0.0",
        "jupyter-console==6.4.4",
        "jupyter-events==0.6.3",
        "jupyter_client==7.4.9",
        "jupyter_core==5.1.3",
        'jupyter_server==2.1.0',
        "jupyter_server_terminals==0.4.4",
        "jupyterlab-pygments==0.2.2",
        "jupyterlab-widgets==3.0.5",
        "kiwisolver==1.4.4",
        "MarkupSafe==2.1.2",
        "matplotlib==3.6.3",
        "matplotlib-inline==0.1.6",
        'mistune==2.0.4',
        "nbclassic==0.4.8",
        "nbclient==0.7.2",
        "nbconvert==7.2.8",
        "nbformat==5.7.3",
        "nest-asyncio==1.5.6",
        "notebook==6.5.2",
        "notebook_shim==0.2.2",
        "numpy==1.24.1",
        "packaging==23.0",
        "pandas==1.5.3",
        "pandocfilters==1.5.0",
        "parso==0.8.3",
        "pexpect==4.8.0",
        "pickleshare==0.7.5",
        "Pillow==9.4.0",
        "pkgutil_resolve_name==1.3.10",
        "platformdirs==2.6.2",
        "plotly==5.12.0",
        "prometheus-client==0.15.0",
        "prompt-toolkit==3.0.36",
        "psutil==5.9.4",
        "ptyprocess==0.7.0",
        "pure-eval==0.2.2",
        "pycparser==2.21",
        "Pygments==2.14.0",
        "pyparsing==3.0.9",
        "pyrsistent==0.19.3",
        "python-dateutil==2.8.2",
        "python-json-logger==2.0.4",
        "pytz==2022.7.1",
        "PyYAML==6.0",
        "pyzmq==25.0.0",
        "qtconsole==5.4.0"
        "QtPy==2.3.0",
        "rfc3339-validator==0.1.4",
        "rfc3986-validator==0.1.1",
        "Send2Trash==1.8.0",
        "six==1.16.0",
        "sniffio==1.3.0",
        "soupsieve==2.3.2.post1",
        "stack-data==0.6.2",
        "tenacity==8.1.0",
        "terminado==0.17.1",
        "tinycss2==1.2.1",
        "tornado==6.2",
        "tqdm==4.64.1",
        "traitlets==5.8.1",
        "uri-template==1.2.0",
        "wcwidth==0.2.6",
        "webcolors==1.12",
        "webencodings==0.5.1",
        "websocket-client==1.4.2",
        "widgetsnbextension==4.0.5",
        "zipp==3.11.0"
    ],
    classifiers = [
                      "Programming Language :: Python :: 3",
                      "License :: OSI Approved :: MIT License",
                      "Operating System :: OS Independent"
    ]
)
