from django.db import migrations
from django.db import models

from m3_audit.db_helpers import CreateModelIfNotExist


class Migration(migrations.Migration):
    """Миграция для создания таблиц.

    Полностью создана с помощью Django, однако операция CreateModel заменена
    на m3_audit.db_helpers.CreateModelIfNotExist
    """

    initial = True

    dependencies = []

    operations = [
        CreateModelIfNotExist(
            name='AuthAuditModel',
            fields=[
                ('id',
                 models.AutoField(auto_created=True,
                                  primary_key=True,
                                  serialize=False,
                                  verbose_name='ID')),
                ('username',
                 models.CharField(blank=True,
                                  db_index=True,
                                  default='',
                                  max_length=50,
                                  null=True,
                                  verbose_name='Логин пользователя')),
                ('userid',
                 models.PositiveIntegerField(
                     db_index=True,
                     default=0,
                     verbose_name='Идентификатор пользователя')),
                ('user_fio',
                 models.CharField(blank=True,
                                  db_index=True,
                                  default='',
                                  max_length=70,
                                  null=True,
                                  verbose_name='ФИО пользователя')),
                ('user_info',
                 models.CharField(
                     blank=True,
                     default='',
                     max_length=200,
                     null=True,
                     verbose_name='Дополнительные сведения о пользователе')),
                ('created',
                 models.DateTimeField(auto_now_add=True,
                                      db_index=True,
                                      verbose_name='Дата создания')),
                ('type',
                 models.PositiveIntegerField(choices=[(0, 'Вход в систему'),
                                                      (1, 'Выход из системы')],
                                             db_index=True,
                                             verbose_name='Действие')),
            ],
            options={
                'verbose_name': 'Авторизации пользователей',
                'db_table': 'm3_audit_auth',
            },
        ),
        CreateModelIfNotExist(
            name='DefaultModelChangeAuditModel',
            fields=[
                ('id',
                 models.AutoField(auto_created=True,
                                  primary_key=True,
                                  serialize=False,
                                  verbose_name='ID')),
                ('username',
                 models.CharField(blank=True,
                                  db_index=True,
                                  default='',
                                  max_length=50,
                                  null=True,
                                  verbose_name='Логин пользователя')),
                ('userid',
                 models.PositiveIntegerField(
                     db_index=True,
                     default=0,
                     verbose_name='Идентификатор пользователя')),
                ('user_fio',
                 models.CharField(blank=True,
                                  db_index=True,
                                  default='',
                                  max_length=70,
                                  null=True,
                                  verbose_name='ФИО пользователя')),
                ('user_info',
                 models.CharField(
                     blank=True,
                     default='',
                     max_length=200,
                     null=True,
                     verbose_name='Дополнительные сведения о пользователе')),
                ('created',
                 models.DateTimeField(auto_now_add=True,
                                      db_index=True,
                                      verbose_name='Дата создания')),
                ('object_id',
                 models.PositiveIntegerField(db_index=True,
                                             default=0,
                                             verbose_name='ID записи')),
                ('object_model',
                 models.CharField(db_index=True,
                                  max_length=300,
                                  verbose_name='Модель')),
                ('object_data',
                 models.TextField(verbose_name='Данные модели')),
                ('type',
                 models.PositiveIntegerField(choices=[(0, 'Добавление'),
                                                      (1, 'Изменение'),
                                                      (2, 'Удаление')],
                                             db_index=True,
                                             verbose_name='Действие')),
            ],
            options={
                'verbose_name': 'Изменения таблиц системы',
                'db_table': 'm3_audit_model_changes',
            },
        ),
        CreateModelIfNotExist(
            name='DictChangesAuditModel',
            fields=[
                ('id',
                 models.AutoField(auto_created=True,
                                  primary_key=True,
                                  serialize=False,
                                  verbose_name='ID')),
                ('username',
                 models.CharField(blank=True,
                                  db_index=True,
                                  default='',
                                  max_length=50,
                                  null=True,
                                  verbose_name='Логин пользователя')),
                ('userid',
                 models.PositiveIntegerField(
                     db_index=True,
                     default=0,
                     verbose_name='Идентификатор пользователя')),
                ('user_fio',
                 models.CharField(blank=True,
                                  db_index=True,
                                  default='',
                                  max_length=70,
                                  null=True,
                                  verbose_name='ФИО пользователя')),
                ('user_info',
                 models.CharField(
                     blank=True,
                     default='',
                     max_length=200,
                     null=True,
                     verbose_name='Дополнительные сведения о пользователе')),
                ('created',
                 models.DateTimeField(auto_now_add=True,
                                      db_index=True,
                                      verbose_name='Дата создания')),
                ('object_id',
                 models.PositiveIntegerField(db_index=True,
                                             default=0,
                                             verbose_name='ID записи')),
                ('object_model',
                 models.CharField(db_index=True,
                                  max_length=300,
                                  verbose_name='Модель')),
                ('object_data',
                 models.TextField(verbose_name='Данные модели')),
                ('type',
                 models.PositiveIntegerField(choices=[(0, 'Добавление'),
                                                      (1, 'Изменение'),
                                                      (2, 'Удаление')],
                                             db_index=True,
                                             verbose_name='Действие')),
            ],
            options={
                'verbose_name': 'Изменения в справочниках',
                'db_table': 'm3_audit_dict_changes',
            },
        ),
        CreateModelIfNotExist(
            name='RolesAuditModel',
            fields=[
                ('id',
                 models.AutoField(auto_created=True,
                                  primary_key=True,
                                  serialize=False,
                                  verbose_name='ID')),
                ('username',
                 models.CharField(blank=True,
                                  db_index=True,
                                  default='',
                                  max_length=50,
                                  null=True,
                                  verbose_name='Логин пользователя')),
                ('userid',
                 models.PositiveIntegerField(
                     db_index=True,
                     default=0,
                     verbose_name='Идентификатор пользователя')),
                ('user_fio',
                 models.CharField(blank=True,
                                  db_index=True,
                                  default='',
                                  max_length=70,
                                  null=True,
                                  verbose_name='ФИО пользователя')),
                ('user_info',
                 models.CharField(
                     blank=True,
                     default='',
                     max_length=200,
                     null=True,
                     verbose_name='Дополнительные сведения о пользователе')),
                ('created',
                 models.DateTimeField(auto_now_add=True,
                                      db_index=True,
                                      verbose_name='Дата создания')),
                ('type',
                 models.PositiveIntegerField(choices=[(0, 'Добавление прав'),
                                                      (1, 'Лишение прав'),
                                                      (2, 'Активация права'),
                                                      (3, 'Отключение права')],
                                             verbose_name='Действие')),
                ('role_id',
                 models.PositiveIntegerField(verbose_name='ID роли')),
                ('role_name',
                 models.CharField(max_length=200, verbose_name='Роль')),
                ('permission_code',
                 models.CharField(blank=True,
                                  default='',
                                  max_length=200,
                                  null=True,
                                  verbose_name='Разрешения')),
            ],
            options={
                'verbose_name': 'Изменения ролей пользователей',
                'db_table': 'm3_audit_roles',
            },
        ),
    ]
