# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WfmHistoricalAdherenceResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WfmHistoricalAdherenceResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'download_url': 'str',
            'query_state': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'download_url': 'downloadUrl',
            'query_state': 'queryState'
        }

        self._id = None
        self._download_url = None
        self._query_state = None

    @property
    def id(self):
        """
        Gets the id of this WfmHistoricalAdherenceResponse.
        The query ID to listen for

        :return: The id of this WfmHistoricalAdherenceResponse.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WfmHistoricalAdherenceResponse.
        The query ID to listen for

        :param id: The id of this WfmHistoricalAdherenceResponse.
        :type: str
        """
        
        self._id = id

    @property
    def download_url(self):
        """
        Gets the download_url of this WfmHistoricalAdherenceResponse.
        The uri to query to GET the results of the Historical Adherence query. This will return unpopulated but will be populated in the notification

        :return: The download_url of this WfmHistoricalAdherenceResponse.
        :rtype: str
        """
        return self._download_url

    @download_url.setter
    def download_url(self, download_url):
        """
        Sets the download_url of this WfmHistoricalAdherenceResponse.
        The uri to query to GET the results of the Historical Adherence query. This will return unpopulated but will be populated in the notification

        :param download_url: The download_url of this WfmHistoricalAdherenceResponse.
        :type: str
        """
        
        self._download_url = download_url

    @property
    def query_state(self):
        """
        Gets the query_state of this WfmHistoricalAdherenceResponse.
        The state of the adherence query

        :return: The query_state of this WfmHistoricalAdherenceResponse.
        :rtype: str
        """
        return self._query_state

    @query_state.setter
    def query_state(self, query_state):
        """
        Sets the query_state of this WfmHistoricalAdherenceResponse.
        The state of the adherence query

        :param query_state: The query_state of this WfmHistoricalAdherenceResponse.
        :type: str
        """
        allowed_values = ["Processing", "Complete", "Error"]
        if query_state.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for query_state -> " + query_state
            self._query_state = "outdated_sdk_version"
        else:
            self._query_state = query_state

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

