# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UserExternalIdentifier(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UserExternalIdentifier - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'authority_name': 'str',
            'external_key': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'authority_name': 'authorityName',
            'external_key': 'externalKey',
            'self_uri': 'selfUri'
        }

        self._authority_name = None
        self._external_key = None
        self._self_uri = None

    @property
    def authority_name(self):
        """
        Gets the authority_name of this UserExternalIdentifier.
        Authority or System of Record which owns the External Identifier

        :return: The authority_name of this UserExternalIdentifier.
        :rtype: str
        """
        return self._authority_name

    @authority_name.setter
    def authority_name(self, authority_name):
        """
        Sets the authority_name of this UserExternalIdentifier.
        Authority or System of Record which owns the External Identifier

        :param authority_name: The authority_name of this UserExternalIdentifier.
        :type: str
        """
        
        self._authority_name = authority_name

    @property
    def external_key(self):
        """
        Gets the external_key of this UserExternalIdentifier.
        External Key

        :return: The external_key of this UserExternalIdentifier.
        :rtype: str
        """
        return self._external_key

    @external_key.setter
    def external_key(self, external_key):
        """
        Sets the external_key of this UserExternalIdentifier.
        External Key

        :param external_key: The external_key of this UserExternalIdentifier.
        :type: str
        """
        
        self._external_key = external_key

    @property
    def self_uri(self):
        """
        Gets the self_uri of this UserExternalIdentifier.
        The URI for this object

        :return: The self_uri of this UserExternalIdentifier.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this UserExternalIdentifier.
        The URI for this object

        :param self_uri: The self_uri of this UserExternalIdentifier.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

