# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class TimeZone(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TimeZone - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'display_name': 'str',
            'id': 'str',
            'raw_offset': 'int',
            'dstsavings': 'int'
        }

        self.attribute_map = {
            'display_name': 'displayName',
            'id': 'id',
            'raw_offset': 'rawOffset',
            'dstsavings': 'dstsavings'
        }

        self._display_name = None
        self._id = None
        self._raw_offset = None
        self._dstsavings = None

    @property
    def display_name(self):
        """
        Gets the display_name of this TimeZone.


        :return: The display_name of this TimeZone.
        :rtype: str
        """
        return self._display_name

    @display_name.setter
    def display_name(self, display_name):
        """
        Sets the display_name of this TimeZone.


        :param display_name: The display_name of this TimeZone.
        :type: str
        """
        
        self._display_name = display_name

    @property
    def id(self):
        """
        Gets the id of this TimeZone.


        :return: The id of this TimeZone.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this TimeZone.


        :param id: The id of this TimeZone.
        :type: str
        """
        
        self._id = id

    @property
    def raw_offset(self):
        """
        Gets the raw_offset of this TimeZone.


        :return: The raw_offset of this TimeZone.
        :rtype: int
        """
        return self._raw_offset

    @raw_offset.setter
    def raw_offset(self, raw_offset):
        """
        Sets the raw_offset of this TimeZone.


        :param raw_offset: The raw_offset of this TimeZone.
        :type: int
        """
        
        self._raw_offset = raw_offset

    @property
    def dstsavings(self):
        """
        Gets the dstsavings of this TimeZone.


        :return: The dstsavings of this TimeZone.
        :rtype: int
        """
        return self._dstsavings

    @dstsavings.setter
    def dstsavings(self, dstsavings):
        """
        Sets the dstsavings of this TimeZone.


        :param dstsavings: The dstsavings of this TimeZone.
        :type: int
        """
        
        self._dstsavings = dstsavings

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

