# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ShortTermForecast(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ShortTermForecast - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'week_date': 'str',
            'description': 'str',
            'creation_method': 'str',
            'metadata': 'WfmVersionedEntityMetadata',
            'source_data': 'ListWrapperForecastSourceDayPointer',
            'reference_start_date': 'datetime',
            'modifications': 'ListWrapperWfmForecastModification',
            'generation_results': 'ForecastGenerationResult',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'week_date': 'weekDate',
            'description': 'description',
            'creation_method': 'creationMethod',
            'metadata': 'metadata',
            'source_data': 'sourceData',
            'reference_start_date': 'referenceStartDate',
            'modifications': 'modifications',
            'generation_results': 'generationResults',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._week_date = None
        self._description = None
        self._creation_method = None
        self._metadata = None
        self._source_data = None
        self._reference_start_date = None
        self._modifications = None
        self._generation_results = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this ShortTermForecast.
        The id of the short term forecast

        :return: The id of this ShortTermForecast.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ShortTermForecast.
        The id of the short term forecast

        :param id: The id of this ShortTermForecast.
        :type: str
        """
        
        self._id = id

    @property
    def week_date(self):
        """
        Gets the week_date of this ShortTermForecast.
        The weekDate of the short term forecast in yyyy-MM-dd format

        :return: The week_date of this ShortTermForecast.
        :rtype: str
        """
        return self._week_date

    @week_date.setter
    def week_date(self, week_date):
        """
        Sets the week_date of this ShortTermForecast.
        The weekDate of the short term forecast in yyyy-MM-dd format

        :param week_date: The week_date of this ShortTermForecast.
        :type: str
        """
        
        self._week_date = week_date

    @property
    def description(self):
        """
        Gets the description of this ShortTermForecast.
        The description of the short term forecast

        :return: The description of this ShortTermForecast.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ShortTermForecast.
        The description of the short term forecast

        :param description: The description of this ShortTermForecast.
        :type: str
        """
        
        self._description = description

    @property
    def creation_method(self):
        """
        Gets the creation_method of this ShortTermForecast.
        The method used to create this forecast

        :return: The creation_method of this ShortTermForecast.
        :rtype: str
        """
        return self._creation_method

    @creation_method.setter
    def creation_method(self, creation_method):
        """
        Sets the creation_method of this ShortTermForecast.
        The method used to create this forecast

        :param creation_method: The creation_method of this ShortTermForecast.
        :type: str
        """
        allowed_values = ["Import", "HistoricalWeightedAverage", "Advanced"]
        if creation_method.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for creation_method -> " + creation_method
            self._creation_method = "outdated_sdk_version"
        else:
            self._creation_method = creation_method

    @property
    def metadata(self):
        """
        Gets the metadata of this ShortTermForecast.
        Metadata for this forecast

        :return: The metadata of this ShortTermForecast.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this ShortTermForecast.
        Metadata for this forecast

        :param metadata: The metadata of this ShortTermForecast.
        :type: WfmVersionedEntityMetadata
        """
        
        self._metadata = metadata

    @property
    def source_data(self):
        """
        Gets the source_data of this ShortTermForecast.
        The source data references and metadata for this forecast

        :return: The source_data of this ShortTermForecast.
        :rtype: ListWrapperForecastSourceDayPointer
        """
        return self._source_data

    @source_data.setter
    def source_data(self, source_data):
        """
        Sets the source_data of this ShortTermForecast.
        The source data references and metadata for this forecast

        :param source_data: The source_data of this ShortTermForecast.
        :type: ListWrapperForecastSourceDayPointer
        """
        
        self._source_data = source_data

    @property
    def reference_start_date(self):
        """
        Gets the reference_start_date of this ShortTermForecast.
        ISO-8601 date that serves as the reference date for interval-based modifications

        :return: The reference_start_date of this ShortTermForecast.
        :rtype: datetime
        """
        return self._reference_start_date

    @reference_start_date.setter
    def reference_start_date(self, reference_start_date):
        """
        Sets the reference_start_date of this ShortTermForecast.
        ISO-8601 date that serves as the reference date for interval-based modifications

        :param reference_start_date: The reference_start_date of this ShortTermForecast.
        :type: datetime
        """
        
        self._reference_start_date = reference_start_date

    @property
    def modifications(self):
        """
        Gets the modifications of this ShortTermForecast.
        The modifications that have been applied to this forecast

        :return: The modifications of this ShortTermForecast.
        :rtype: ListWrapperWfmForecastModification
        """
        return self._modifications

    @modifications.setter
    def modifications(self, modifications):
        """
        Sets the modifications of this ShortTermForecast.
        The modifications that have been applied to this forecast

        :param modifications: The modifications of this ShortTermForecast.
        :type: ListWrapperWfmForecastModification
        """
        
        self._modifications = modifications

    @property
    def generation_results(self):
        """
        Gets the generation_results of this ShortTermForecast.
        Forecast generation results, if applicable

        :return: The generation_results of this ShortTermForecast.
        :rtype: ForecastGenerationResult
        """
        return self._generation_results

    @generation_results.setter
    def generation_results(self, generation_results):
        """
        Sets the generation_results of this ShortTermForecast.
        Forecast generation results, if applicable

        :param generation_results: The generation_results of this ShortTermForecast.
        :type: ForecastGenerationResult
        """
        
        self._generation_results = generation_results

    @property
    def self_uri(self):
        """
        Gets the self_uri of this ShortTermForecast.
        The URI for this object

        :return: The self_uri of this ShortTermForecast.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this ShortTermForecast.
        The URI for this object

        :param self_uri: The self_uri of this ShortTermForecast.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

