# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class LocationDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        LocationDefinition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'contact_user': 'AddressableEntityRef',
            'emergency_number': 'LocationEmergencyNumber',
            'address': 'LocationAddress',
            'address_verified': 'bool',
            'state': 'str',
            'notes': 'str',
            'version': 'int',
            'path': 'list[str]',
            'profile_image': 'list[LocationImage]',
            'floorplan_image': 'list[LocationImage]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'contact_user': 'contactUser',
            'emergency_number': 'emergencyNumber',
            'address': 'address',
            'address_verified': 'addressVerified',
            'state': 'state',
            'notes': 'notes',
            'version': 'version',
            'path': 'path',
            'profile_image': 'profileImage',
            'floorplan_image': 'floorplanImage',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._contact_user = None
        self._emergency_number = None
        self._address = None
        self._address_verified = None
        self._state = None
        self._notes = None
        self._version = None
        self._path = None
        self._profile_image = None
        self._floorplan_image = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this LocationDefinition.
        The globally unique identifier for the object.

        :return: The id of this LocationDefinition.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this LocationDefinition.
        The globally unique identifier for the object.

        :param id: The id of this LocationDefinition.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this LocationDefinition.
        The name of the Location.

        :return: The name of this LocationDefinition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LocationDefinition.
        The name of the Location.

        :param name: The name of this LocationDefinition.
        :type: str
        """
        
        self._name = name

    @property
    def contact_user(self):
        """
        Gets the contact_user of this LocationDefinition.
        Site contact for the location

        :return: The contact_user of this LocationDefinition.
        :rtype: AddressableEntityRef
        """
        return self._contact_user

    @contact_user.setter
    def contact_user(self, contact_user):
        """
        Sets the contact_user of this LocationDefinition.
        Site contact for the location

        :param contact_user: The contact_user of this LocationDefinition.
        :type: AddressableEntityRef
        """
        
        self._contact_user = contact_user

    @property
    def emergency_number(self):
        """
        Gets the emergency_number of this LocationDefinition.


        :return: The emergency_number of this LocationDefinition.
        :rtype: LocationEmergencyNumber
        """
        return self._emergency_number

    @emergency_number.setter
    def emergency_number(self, emergency_number):
        """
        Sets the emergency_number of this LocationDefinition.


        :param emergency_number: The emergency_number of this LocationDefinition.
        :type: LocationEmergencyNumber
        """
        
        self._emergency_number = emergency_number

    @property
    def address(self):
        """
        Gets the address of this LocationDefinition.


        :return: The address of this LocationDefinition.
        :rtype: LocationAddress
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this LocationDefinition.


        :param address: The address of this LocationDefinition.
        :type: LocationAddress
        """
        
        self._address = address

    @property
    def address_verified(self):
        """
        Gets the address_verified of this LocationDefinition.


        :return: The address_verified of this LocationDefinition.
        :rtype: bool
        """
        return self._address_verified

    @address_verified.setter
    def address_verified(self, address_verified):
        """
        Sets the address_verified of this LocationDefinition.


        :param address_verified: The address_verified of this LocationDefinition.
        :type: bool
        """
        
        self._address_verified = address_verified

    @property
    def state(self):
        """
        Gets the state of this LocationDefinition.
        Current activity status of the location.

        :return: The state of this LocationDefinition.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this LocationDefinition.
        Current activity status of the location.

        :param state: The state of this LocationDefinition.
        :type: str
        """
        allowed_values = ["active", "deleted"]
        if state.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for state -> " + state
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def notes(self):
        """
        Gets the notes of this LocationDefinition.


        :return: The notes of this LocationDefinition.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this LocationDefinition.


        :param notes: The notes of this LocationDefinition.
        :type: str
        """
        
        self._notes = notes

    @property
    def version(self):
        """
        Gets the version of this LocationDefinition.


        :return: The version of this LocationDefinition.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this LocationDefinition.


        :param version: The version of this LocationDefinition.
        :type: int
        """
        
        self._version = version

    @property
    def path(self):
        """
        Gets the path of this LocationDefinition.
        A list of ancestor IDs in order

        :return: The path of this LocationDefinition.
        :rtype: list[str]
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Sets the path of this LocationDefinition.
        A list of ancestor IDs in order

        :param path: The path of this LocationDefinition.
        :type: list[str]
        """
        
        self._path = path

    @property
    def profile_image(self):
        """
        Gets the profile_image of this LocationDefinition.
        Profile image set for the location

        :return: The profile_image of this LocationDefinition.
        :rtype: list[LocationImage]
        """
        return self._profile_image

    @profile_image.setter
    def profile_image(self, profile_image):
        """
        Sets the profile_image of this LocationDefinition.
        Profile image set for the location

        :param profile_image: The profile_image of this LocationDefinition.
        :type: list[LocationImage]
        """
        
        self._profile_image = profile_image

    @property
    def floorplan_image(self):
        """
        Gets the floorplan_image of this LocationDefinition.


        :return: The floorplan_image of this LocationDefinition.
        :rtype: list[LocationImage]
        """
        return self._floorplan_image

    @floorplan_image.setter
    def floorplan_image(self, floorplan_image):
        """
        Sets the floorplan_image of this LocationDefinition.


        :param floorplan_image: The floorplan_image of this LocationDefinition.
        :type: list[LocationImage]
        """
        
        self._floorplan_image = floorplan_image

    @property
    def self_uri(self):
        """
        Gets the self_uri of this LocationDefinition.
        The URI for this object

        :return: The self_uri of this LocationDefinition.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this LocationDefinition.
        The URI for this object

        :param self_uri: The self_uri of this LocationDefinition.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

