# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class LocationCreateUpdateDefinition(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        LocationCreateUpdateDefinition - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'address': 'LocationAddress',
            'emergency_number': 'LocationEmergencyNumber',
            'version': 'int',
            'state': 'str',
            'notes': 'str',
            'contact_user': 'str',
            'path': 'list[str]',
            'address_verified': 'bool'
        }

        self.attribute_map = {
            'name': 'name',
            'address': 'address',
            'emergency_number': 'emergencyNumber',
            'version': 'version',
            'state': 'state',
            'notes': 'notes',
            'contact_user': 'contactUser',
            'path': 'path',
            'address_verified': 'addressVerified'
        }

        self._name = None
        self._address = None
        self._emergency_number = None
        self._version = None
        self._state = None
        self._notes = None
        self._contact_user = None
        self._path = None
        self._address_verified = None

    @property
    def name(self):
        """
        Gets the name of this LocationCreateUpdateDefinition.
        The name of the Location.

        :return: The name of this LocationCreateUpdateDefinition.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this LocationCreateUpdateDefinition.
        The name of the Location.

        :param name: The name of this LocationCreateUpdateDefinition.
        :type: str
        """
        
        self._name = name

    @property
    def address(self):
        """
        Gets the address of this LocationCreateUpdateDefinition.


        :return: The address of this LocationCreateUpdateDefinition.
        :rtype: LocationAddress
        """
        return self._address

    @address.setter
    def address(self, address):
        """
        Sets the address of this LocationCreateUpdateDefinition.


        :param address: The address of this LocationCreateUpdateDefinition.
        :type: LocationAddress
        """
        
        self._address = address

    @property
    def emergency_number(self):
        """
        Gets the emergency_number of this LocationCreateUpdateDefinition.


        :return: The emergency_number of this LocationCreateUpdateDefinition.
        :rtype: LocationEmergencyNumber
        """
        return self._emergency_number

    @emergency_number.setter
    def emergency_number(self, emergency_number):
        """
        Sets the emergency_number of this LocationCreateUpdateDefinition.


        :param emergency_number: The emergency_number of this LocationCreateUpdateDefinition.
        :type: LocationEmergencyNumber
        """
        
        self._emergency_number = emergency_number

    @property
    def version(self):
        """
        Gets the version of this LocationCreateUpdateDefinition.


        :return: The version of this LocationCreateUpdateDefinition.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this LocationCreateUpdateDefinition.


        :param version: The version of this LocationCreateUpdateDefinition.
        :type: int
        """
        
        self._version = version

    @property
    def state(self):
        """
        Gets the state of this LocationCreateUpdateDefinition.
        Current activity status of the location.

        :return: The state of this LocationCreateUpdateDefinition.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state):
        """
        Sets the state of this LocationCreateUpdateDefinition.
        Current activity status of the location.

        :param state: The state of this LocationCreateUpdateDefinition.
        :type: str
        """
        allowed_values = ["active", "deleted"]
        if state.lower() not in map(str.lower, allowed_values):
            # print "Invalid value for state -> " + state
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def notes(self):
        """
        Gets the notes of this LocationCreateUpdateDefinition.


        :return: The notes of this LocationCreateUpdateDefinition.
        :rtype: str
        """
        return self._notes

    @notes.setter
    def notes(self, notes):
        """
        Sets the notes of this LocationCreateUpdateDefinition.


        :param notes: The notes of this LocationCreateUpdateDefinition.
        :type: str
        """
        
        self._notes = notes

    @property
    def contact_user(self):
        """
        Gets the contact_user of this LocationCreateUpdateDefinition.
        The user id of the location contact

        :return: The contact_user of this LocationCreateUpdateDefinition.
        :rtype: str
        """
        return self._contact_user

    @contact_user.setter
    def contact_user(self, contact_user):
        """
        Sets the contact_user of this LocationCreateUpdateDefinition.
        The user id of the location contact

        :param contact_user: The contact_user of this LocationCreateUpdateDefinition.
        :type: str
        """
        
        self._contact_user = contact_user

    @property
    def path(self):
        """
        Gets the path of this LocationCreateUpdateDefinition.


        :return: The path of this LocationCreateUpdateDefinition.
        :rtype: list[str]
        """
        return self._path

    @path.setter
    def path(self, path):
        """
        Sets the path of this LocationCreateUpdateDefinition.


        :param path: The path of this LocationCreateUpdateDefinition.
        :type: list[str]
        """
        
        self._path = path

    @property
    def address_verified(self):
        """
        Gets the address_verified of this LocationCreateUpdateDefinition.


        :return: The address_verified of this LocationCreateUpdateDefinition.
        :rtype: bool
        """
        return self._address_verified

    @address_verified.setter
    def address_verified(self, address_verified):
        """
        Sets the address_verified of this LocationCreateUpdateDefinition.


        :param address_verified: The address_verified of this LocationCreateUpdateDefinition.
        :type: bool
        """
        
        self._address_verified = address_verified

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

