# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class IntegrationType(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        IntegrationType - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'description': 'str',
            'provider': 'str',
            'category': 'str',
            'images': 'list[UserImage]',
            'config_properties_schema_uri': 'str',
            'config_advanced_schema_uri': 'str',
            'help_uri': 'str',
            'terms_of_service_uri': 'str',
            'vendor_name': 'str',
            'vendor_website_uri': 'str',
            'marketplace_uri': 'str',
            'faq_uri': 'str',
            'privacy_policy_uri': 'str',
            'support_contact_uri': 'str',
            'sales_contact_uri': 'str',
            'help_links': 'list[HelpLink]',
            'credentials': 'dict(str, CredentialSpecification)',
            'non_installable': 'bool',
            'max_instances': 'int',
            'user_permissions': 'list[str]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'description': 'description',
            'provider': 'provider',
            'category': 'category',
            'images': 'images',
            'config_properties_schema_uri': 'configPropertiesSchemaUri',
            'config_advanced_schema_uri': 'configAdvancedSchemaUri',
            'help_uri': 'helpUri',
            'terms_of_service_uri': 'termsOfServiceUri',
            'vendor_name': 'vendorName',
            'vendor_website_uri': 'vendorWebsiteUri',
            'marketplace_uri': 'marketplaceUri',
            'faq_uri': 'faqUri',
            'privacy_policy_uri': 'privacyPolicyUri',
            'support_contact_uri': 'supportContactUri',
            'sales_contact_uri': 'salesContactUri',
            'help_links': 'helpLinks',
            'credentials': 'credentials',
            'non_installable': 'nonInstallable',
            'max_instances': 'maxInstances',
            'user_permissions': 'userPermissions',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._description = None
        self._provider = None
        self._category = None
        self._images = None
        self._config_properties_schema_uri = None
        self._config_advanced_schema_uri = None
        self._help_uri = None
        self._terms_of_service_uri = None
        self._vendor_name = None
        self._vendor_website_uri = None
        self._marketplace_uri = None
        self._faq_uri = None
        self._privacy_policy_uri = None
        self._support_contact_uri = None
        self._sales_contact_uri = None
        self._help_links = None
        self._credentials = None
        self._non_installable = None
        self._max_instances = None
        self._user_permissions = None
        self._self_uri = None

    @property
    def id(self):
        """
        Gets the id of this IntegrationType.
        The ID of the integration type.

        :return: The id of this IntegrationType.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this IntegrationType.
        The ID of the integration type.

        :param id: The id of this IntegrationType.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this IntegrationType.


        :return: The name of this IntegrationType.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this IntegrationType.


        :param name: The name of this IntegrationType.
        :type: str
        """
        
        self._name = name

    @property
    def description(self):
        """
        Gets the description of this IntegrationType.
        Description of the integration type.

        :return: The description of this IntegrationType.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this IntegrationType.
        Description of the integration type.

        :param description: The description of this IntegrationType.
        :type: str
        """
        
        self._description = description

    @property
    def provider(self):
        """
        Gets the provider of this IntegrationType.
        PureCloud provider of the integration type.

        :return: The provider of this IntegrationType.
        :rtype: str
        """
        return self._provider

    @provider.setter
    def provider(self, provider):
        """
        Sets the provider of this IntegrationType.
        PureCloud provider of the integration type.

        :param provider: The provider of this IntegrationType.
        :type: str
        """
        
        self._provider = provider

    @property
    def category(self):
        """
        Gets the category of this IntegrationType.
        Category describing the integration type.

        :return: The category of this IntegrationType.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category):
        """
        Sets the category of this IntegrationType.
        Category describing the integration type.

        :param category: The category of this IntegrationType.
        :type: str
        """
        
        self._category = category

    @property
    def images(self):
        """
        Gets the images of this IntegrationType.
        Collection of logos.

        :return: The images of this IntegrationType.
        :rtype: list[UserImage]
        """
        return self._images

    @images.setter
    def images(self, images):
        """
        Sets the images of this IntegrationType.
        Collection of logos.

        :param images: The images of this IntegrationType.
        :type: list[UserImage]
        """
        
        self._images = images

    @property
    def config_properties_schema_uri(self):
        """
        Gets the config_properties_schema_uri of this IntegrationType.
        URI of the schema describing the key-value properties needed to configure an integration of this type.

        :return: The config_properties_schema_uri of this IntegrationType.
        :rtype: str
        """
        return self._config_properties_schema_uri

    @config_properties_schema_uri.setter
    def config_properties_schema_uri(self, config_properties_schema_uri):
        """
        Sets the config_properties_schema_uri of this IntegrationType.
        URI of the schema describing the key-value properties needed to configure an integration of this type.

        :param config_properties_schema_uri: The config_properties_schema_uri of this IntegrationType.
        :type: str
        """
        
        self._config_properties_schema_uri = config_properties_schema_uri

    @property
    def config_advanced_schema_uri(self):
        """
        Gets the config_advanced_schema_uri of this IntegrationType.
        URI of the schema describing the advanced JSON document needed to configure an integration of this type.

        :return: The config_advanced_schema_uri of this IntegrationType.
        :rtype: str
        """
        return self._config_advanced_schema_uri

    @config_advanced_schema_uri.setter
    def config_advanced_schema_uri(self, config_advanced_schema_uri):
        """
        Sets the config_advanced_schema_uri of this IntegrationType.
        URI of the schema describing the advanced JSON document needed to configure an integration of this type.

        :param config_advanced_schema_uri: The config_advanced_schema_uri of this IntegrationType.
        :type: str
        """
        
        self._config_advanced_schema_uri = config_advanced_schema_uri

    @property
    def help_uri(self):
        """
        Gets the help_uri of this IntegrationType.
        URI of a page with more information about the integration type

        :return: The help_uri of this IntegrationType.
        :rtype: str
        """
        return self._help_uri

    @help_uri.setter
    def help_uri(self, help_uri):
        """
        Sets the help_uri of this IntegrationType.
        URI of a page with more information about the integration type

        :param help_uri: The help_uri of this IntegrationType.
        :type: str
        """
        
        self._help_uri = help_uri

    @property
    def terms_of_service_uri(self):
        """
        Gets the terms_of_service_uri of this IntegrationType.
        URI of a page with terms and conditions for the integration type

        :return: The terms_of_service_uri of this IntegrationType.
        :rtype: str
        """
        return self._terms_of_service_uri

    @terms_of_service_uri.setter
    def terms_of_service_uri(self, terms_of_service_uri):
        """
        Sets the terms_of_service_uri of this IntegrationType.
        URI of a page with terms and conditions for the integration type

        :param terms_of_service_uri: The terms_of_service_uri of this IntegrationType.
        :type: str
        """
        
        self._terms_of_service_uri = terms_of_service_uri

    @property
    def vendor_name(self):
        """
        Gets the vendor_name of this IntegrationType.
        Name of the vendor of this integration type

        :return: The vendor_name of this IntegrationType.
        :rtype: str
        """
        return self._vendor_name

    @vendor_name.setter
    def vendor_name(self, vendor_name):
        """
        Sets the vendor_name of this IntegrationType.
        Name of the vendor of this integration type

        :param vendor_name: The vendor_name of this IntegrationType.
        :type: str
        """
        
        self._vendor_name = vendor_name

    @property
    def vendor_website_uri(self):
        """
        Gets the vendor_website_uri of this IntegrationType.
        URI of the vendor's website

        :return: The vendor_website_uri of this IntegrationType.
        :rtype: str
        """
        return self._vendor_website_uri

    @vendor_website_uri.setter
    def vendor_website_uri(self, vendor_website_uri):
        """
        Sets the vendor_website_uri of this IntegrationType.
        URI of the vendor's website

        :param vendor_website_uri: The vendor_website_uri of this IntegrationType.
        :type: str
        """
        
        self._vendor_website_uri = vendor_website_uri

    @property
    def marketplace_uri(self):
        """
        Gets the marketplace_uri of this IntegrationType.
        URI of the marketplace listing for this integration type

        :return: The marketplace_uri of this IntegrationType.
        :rtype: str
        """
        return self._marketplace_uri

    @marketplace_uri.setter
    def marketplace_uri(self, marketplace_uri):
        """
        Sets the marketplace_uri of this IntegrationType.
        URI of the marketplace listing for this integration type

        :param marketplace_uri: The marketplace_uri of this IntegrationType.
        :type: str
        """
        
        self._marketplace_uri = marketplace_uri

    @property
    def faq_uri(self):
        """
        Gets the faq_uri of this IntegrationType.
        URI of frequently asked questions about the integration type

        :return: The faq_uri of this IntegrationType.
        :rtype: str
        """
        return self._faq_uri

    @faq_uri.setter
    def faq_uri(self, faq_uri):
        """
        Sets the faq_uri of this IntegrationType.
        URI of frequently asked questions about the integration type

        :param faq_uri: The faq_uri of this IntegrationType.
        :type: str
        """
        
        self._faq_uri = faq_uri

    @property
    def privacy_policy_uri(self):
        """
        Gets the privacy_policy_uri of this IntegrationType.
        URI of a privacy policy for users of the integration type

        :return: The privacy_policy_uri of this IntegrationType.
        :rtype: str
        """
        return self._privacy_policy_uri

    @privacy_policy_uri.setter
    def privacy_policy_uri(self, privacy_policy_uri):
        """
        Sets the privacy_policy_uri of this IntegrationType.
        URI of a privacy policy for users of the integration type

        :param privacy_policy_uri: The privacy_policy_uri of this IntegrationType.
        :type: str
        """
        
        self._privacy_policy_uri = privacy_policy_uri

    @property
    def support_contact_uri(self):
        """
        Gets the support_contact_uri of this IntegrationType.
        URI for vendor support

        :return: The support_contact_uri of this IntegrationType.
        :rtype: str
        """
        return self._support_contact_uri

    @support_contact_uri.setter
    def support_contact_uri(self, support_contact_uri):
        """
        Sets the support_contact_uri of this IntegrationType.
        URI for vendor support

        :param support_contact_uri: The support_contact_uri of this IntegrationType.
        :type: str
        """
        
        self._support_contact_uri = support_contact_uri

    @property
    def sales_contact_uri(self):
        """
        Gets the sales_contact_uri of this IntegrationType.
        URI for vendor sales information

        :return: The sales_contact_uri of this IntegrationType.
        :rtype: str
        """
        return self._sales_contact_uri

    @sales_contact_uri.setter
    def sales_contact_uri(self, sales_contact_uri):
        """
        Sets the sales_contact_uri of this IntegrationType.
        URI for vendor sales information

        :param sales_contact_uri: The sales_contact_uri of this IntegrationType.
        :type: str
        """
        
        self._sales_contact_uri = sales_contact_uri

    @property
    def help_links(self):
        """
        Gets the help_links of this IntegrationType.
        List of links to additional help resources

        :return: The help_links of this IntegrationType.
        :rtype: list[HelpLink]
        """
        return self._help_links

    @help_links.setter
    def help_links(self, help_links):
        """
        Sets the help_links of this IntegrationType.
        List of links to additional help resources

        :param help_links: The help_links of this IntegrationType.
        :type: list[HelpLink]
        """
        
        self._help_links = help_links

    @property
    def credentials(self):
        """
        Gets the credentials of this IntegrationType.
        Map of credentials for integrations of this type. The key is the name of a credential that can be provided in the credentials property of the integration configuration.

        :return: The credentials of this IntegrationType.
        :rtype: dict(str, CredentialSpecification)
        """
        return self._credentials

    @credentials.setter
    def credentials(self, credentials):
        """
        Sets the credentials of this IntegrationType.
        Map of credentials for integrations of this type. The key is the name of a credential that can be provided in the credentials property of the integration configuration.

        :param credentials: The credentials of this IntegrationType.
        :type: dict(str, CredentialSpecification)
        """
        
        self._credentials = credentials

    @property
    def non_installable(self):
        """
        Gets the non_installable of this IntegrationType.
        Indicates if the integration type is installable or not.

        :return: The non_installable of this IntegrationType.
        :rtype: bool
        """
        return self._non_installable

    @non_installable.setter
    def non_installable(self, non_installable):
        """
        Sets the non_installable of this IntegrationType.
        Indicates if the integration type is installable or not.

        :param non_installable: The non_installable of this IntegrationType.
        :type: bool
        """
        
        self._non_installable = non_installable

    @property
    def max_instances(self):
        """
        Gets the max_instances of this IntegrationType.
        The maximum number of integration instances allowable for this integration type

        :return: The max_instances of this IntegrationType.
        :rtype: int
        """
        return self._max_instances

    @max_instances.setter
    def max_instances(self, max_instances):
        """
        Sets the max_instances of this IntegrationType.
        The maximum number of integration instances allowable for this integration type

        :param max_instances: The max_instances of this IntegrationType.
        :type: int
        """
        
        self._max_instances = max_instances

    @property
    def user_permissions(self):
        """
        Gets the user_permissions of this IntegrationType.
        List of permissions required to permit user access to the integration type.

        :return: The user_permissions of this IntegrationType.
        :rtype: list[str]
        """
        return self._user_permissions

    @user_permissions.setter
    def user_permissions(self, user_permissions):
        """
        Sets the user_permissions of this IntegrationType.
        List of permissions required to permit user access to the integration type.

        :param user_permissions: The user_permissions of this IntegrationType.
        :type: list[str]
        """
        
        self._user_permissions = user_permissions

    @property
    def self_uri(self):
        """
        Gets the self_uri of this IntegrationType.
        The URI for this object

        :return: The self_uri of this IntegrationType.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri):
        """
        Sets the self_uri of this IntegrationType.
        The URI for this object

        :param self_uri: The self_uri of this IntegrationType.
        :type: str
        """
        
        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

